/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.server;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Timer;
import java.net.SocketAddress;
import java.time.Duration;
import reactor.netty.Metrics;
import reactor.netty.channel.MeterKey;
import reactor.netty.http.MicrometerHttpMetricsRecorder;
import reactor.netty.http.server.HttpServerMetricsRecorder;

final class MicrometerHttpServerMetricsRecorder
extends MicrometerHttpMetricsRecorder
implements HttpServerMetricsRecorder {
    static final MicrometerHttpServerMetricsRecorder INSTANCE = new MicrometerHttpServerMetricsRecorder();

    private MicrometerHttpServerMetricsRecorder() {
        super("reactor.netty.http.server", "http");
    }

    @Override
    public void recordDataReceivedTime(String uri, String method, Duration time) {
        Timer dataReceivedTime = this.dataReceivedTimeCache.computeIfAbsent(new MeterKey(uri, null, method, null), key -> (Timer)MicrometerHttpServerMetricsRecorder.filter((Meter)this.dataReceivedTimeBuilder.tags(new String[]{"uri", uri, "method", method}).register(Metrics.REGISTRY)));
        if (dataReceivedTime != null) {
            dataReceivedTime.record(time);
        }
    }

    @Override
    public void recordDataSentTime(String uri, String method, String status, Duration time) {
        Timer dataSentTime = this.dataSentTimeCache.computeIfAbsent(new MeterKey(uri, null, method, status), key -> (Timer)MicrometerHttpServerMetricsRecorder.filter((Meter)this.dataSentTimeBuilder.tags(new String[]{"uri", uri, "method", method, "status", status}).register(Metrics.REGISTRY)));
        if (dataSentTime != null) {
            dataSentTime.record(time);
        }
    }

    @Override
    public void recordResponseTime(String uri, String method, String status, Duration time) {
        Timer responseTime = this.responseTimeCache.computeIfAbsent(new MeterKey(uri, null, method, status), key -> (Timer)MicrometerHttpServerMetricsRecorder.filter((Meter)this.responseTimeBuilder.tags(new String[]{"uri", uri, "method", method, "status", status}).register(Metrics.REGISTRY)));
        if (responseTime != null) {
            responseTime.record(time);
        }
    }

    @Override
    public void recordDataReceived(SocketAddress remoteAddress, String uri, long bytes) {
        DistributionSummary dataReceived = this.dataReceivedCache.computeIfAbsent(new MeterKey(uri, null, null, null), key -> (DistributionSummary)MicrometerHttpServerMetricsRecorder.filter((Meter)this.dataReceivedBuilder.tags(new String[]{"uri", uri}).register(Metrics.REGISTRY)));
        if (dataReceived != null) {
            dataReceived.record((double)bytes);
        }
    }

    @Override
    public void recordDataSent(SocketAddress remoteAddress, String uri, long bytes) {
        DistributionSummary dataSent = this.dataSentCache.computeIfAbsent(new MeterKey(uri, null, null, null), key -> (DistributionSummary)MicrometerHttpServerMetricsRecorder.filter((Meter)this.dataSentBuilder.tags(new String[]{"uri", uri}).register(Metrics.REGISTRY)));
        if (dataSent != null) {
            dataSent.record((double)bytes);
        }
    }

    @Override
    public void incrementErrorsCount(SocketAddress remoteAddress, String uri) {
        Counter errors = this.errorsCache.computeIfAbsent(new MeterKey(uri, null, null, null), key -> (Counter)MicrometerHttpServerMetricsRecorder.filter((Meter)this.errorsBuilder.tags(new String[]{"uri", uri}).register(Metrics.REGISTRY)));
        if (errors != null) {
            errors.increment();
        }
    }

    public void recordDataReceived(SocketAddress remoteAddress, long bytes) {
    }

    public void recordDataSent(SocketAddress remoteAddress, long bytes) {
    }

    public void incrementErrorsCount(SocketAddress remoteAddress) {
    }

    public void recordTlsHandshakeTime(SocketAddress remoteAddress, Duration time, String status) {
    }

    public void recordConnectTime(SocketAddress remoteAddress, Duration time, String status) {
        throw new UnsupportedOperationException();
    }

    public void recordResolveAddressTime(SocketAddress remoteAddress, Duration time, String status) {
        throw new UnsupportedOperationException();
    }
}

