/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.netty;

import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import org.apache.james.protocols.api.CommandDetectionSession;
import org.apache.james.protocols.netty.CommandInjectionDetectedException;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.handler.codec.frame.LineBasedFrameDecoder;

public class AllButStartTlsLineBasedChannelHandler
extends LineBasedFrameDecoder {
    private static final Boolean FAIL_FAST = true;
    private static final CharMatcher CRLF_MATCHER = CharMatcher.anyOf((CharSequence)"\r\n");
    private static final Splitter CRLF_SPLITTER = Splitter.on((CharMatcher)CRLF_MATCHER).omitEmptyStrings();
    private final ChannelPipeline pipeline;
    private final String pattern;

    public AllButStartTlsLineBasedChannelHandler(ChannelPipeline pipeline, int maxFrameLength, boolean stripDelimiter, String pattern) {
        super(maxFrameLength, stripDelimiter, FAIL_FAST == false);
        this.pipeline = pipeline;
        this.pattern = pattern;
    }

    protected Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer) throws Exception {
        block6: {
            block5: {
                CommandDetectionSession session = this.retrieveSession(ctx, channel);
                if (session == null) break block5;
                if (!session.needsCommandInjectionDetection()) break block6;
            }
            boolean startTlsInFlight = Optional.ofNullable(ctx.getChannel().getAttachment()).filter(Boolean.class::isInstance).map(Boolean.class::cast).orElse(false);
            String trimedLowerCasedInput = this.readAll(buffer).trim().toLowerCase(Locale.US);
            if (this.hasCommandInjection(trimedLowerCasedInput) || startTlsInFlight) {
                throw new CommandInjectionDetectedException();
            }
            if (this.hasStartTLS(trimedLowerCasedInput)) {
                ctx.getChannel().setAttachment((Object)true);
            }
        }
        return super.decode(ctx, channel, buffer);
    }

    protected boolean hasStartTLS(String trimedLowerCasedInput) {
        List parts = CRLF_SPLITTER.splitToList((CharSequence)trimedLowerCasedInput);
        return parts.stream().anyMatch(s -> s.equalsIgnoreCase(this.pattern));
    }

    protected CommandDetectionSession retrieveSession(ChannelHandlerContext ctx, Channel channel) {
        return (CommandDetectionSession)this.pipeline.getContext("coreHandler").getAttachment();
    }

    private String readAll(ChannelBuffer buffer) {
        return buffer.toString(StandardCharsets.US_ASCII);
    }

    private boolean hasCommandInjection(String trimedLowerCasedInput) {
        List parts = CRLF_SPLITTER.splitToList((CharSequence)trimedLowerCasedInput);
        return this.hasInvalidStartTlsPart(parts) || this.multiPartsAndOneStartTls(parts);
    }

    protected boolean multiPartsAndOneStartTls(List<String> parts) {
        return parts.stream().anyMatch(line -> line.startsWith(this.pattern)) && parts.size() > 1;
    }

    protected boolean hasInvalidStartTlsPart(List<String> parts) {
        return parts.stream().anyMatch(line -> line.startsWith(this.pattern) && !line.endsWith(this.pattern));
    }
}

