/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jspf.executor;

import org.apache.james.jspf.core.DNSLookupContinuation;
import org.apache.james.jspf.core.DNSResponse;
import org.apache.james.jspf.core.DNSService;
import org.apache.james.jspf.core.Logger;
import org.apache.james.jspf.core.SPFChecker;
import org.apache.james.jspf.core.SPFCheckerExceptionCatcher;
import org.apache.james.jspf.core.SPFSession;
import org.apache.james.jspf.core.exceptions.SPFResultException;
import org.apache.james.jspf.core.exceptions.TimeoutException;
import org.apache.james.jspf.executor.FutureSPFResult;
import org.apache.james.jspf.executor.SPFExecutor;

public class SynchronousSPFExecutor
implements SPFExecutor {
    private Logger log;
    private DNSService dnsProbe;

    public SynchronousSPFExecutor(Logger log, DNSService service) {
        this.log = log;
        this.dnsProbe = service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(SPFSession session, FutureSPFResult result) {
        SPFChecker checker;
        while ((checker = session.popChecker()) != null) {
            this.log.debug("Executing checker: " + checker);
            try {
                DNSLookupContinuation cont = checker.checkSPF(session);
                while (cont != null) {
                    DNSResponse response;
                    try {
                        response = new DNSResponse(this.dnsProbe.getRecords(cont.getRequest()));
                    }
                    catch (TimeoutException e) {
                        response = new DNSResponse(e);
                    }
                    cont = cont.getListener().onDNSResponse(response, session);
                }
            }
            catch (Exception e2) {
                while (e2 != null) {
                    SPFResultException e2;
                    while (checker == null || !(checker instanceof SPFCheckerExceptionCatcher)) {
                        checker = session.popChecker();
                    }
                    try {
                        ((SPFCheckerExceptionCatcher)((Object)checker)).onException(e2, session);
                        e2 = null;
                    }
                    catch (SPFResultException ex) {
                        e2 = ex;
                    }
                    finally {
                        checker = null;
                    }
                }
            }
        }
        result.setSPFResult(session);
    }
}

