/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.controls;

import com.unboundid.asn1.ASN1Boolean;
import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1Enumerated;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DecodeableControl;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.controls.AssuredReplicationLocalLevel;
import com.unboundid.ldap.sdk.unboundidds.controls.AssuredReplicationRemoteLevel;
import com.unboundid.ldap.sdk.unboundidds.controls.AssuredReplicationServerResult;
import com.unboundid.ldap.sdk.unboundidds.controls.ControlMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class AssuredReplicationResponseControl
extends Control
implements DecodeableControl {
    @NotNull
    public static final String ASSURED_REPLICATION_RESPONSE_OID = "1.3.6.1.4.1.30221.2.5.29";
    private static final byte TYPE_LOCAL_LEVEL = -128;
    private static final byte TYPE_LOCAL_SATISFIED = -127;
    private static final byte TYPE_LOCAL_MESSAGE = -126;
    private static final byte TYPE_REMOTE_LEVEL = -125;
    private static final byte TYPE_REMOTE_SATISFIED = -124;
    private static final byte TYPE_REMOTE_MESSAGE = -123;
    private static final byte TYPE_CSN = -122;
    private static final byte TYPE_SERVER_RESULTS = -89;
    private static final long serialVersionUID = -4521456074629871607L;
    @Nullable
    private final AssuredReplicationLocalLevel localLevel;
    @Nullable
    private final AssuredReplicationRemoteLevel remoteLevel;
    private final boolean localAssuranceSatisfied;
    private final boolean remoteAssuranceSatisfied;
    @NotNull
    private final List<AssuredReplicationServerResult> serverResults;
    @Nullable
    private final String csn;
    @Nullable
    private final String localAssuranceMessage;
    @Nullable
    private final String remoteAssuranceMessage;

    AssuredReplicationResponseControl() {
        this.localLevel = null;
        this.localAssuranceSatisfied = false;
        this.localAssuranceMessage = null;
        this.remoteLevel = null;
        this.remoteAssuranceSatisfied = false;
        this.remoteAssuranceMessage = null;
        this.csn = null;
        this.serverResults = null;
    }

    public AssuredReplicationResponseControl(@Nullable AssuredReplicationLocalLevel localLevel, boolean localAssuranceSatisfied, @Nullable String localAssuranceMessage, @Nullable AssuredReplicationRemoteLevel remoteLevel, boolean remoteAssuranceSatisfied, @Nullable String remoteAssuranceMessage, @Nullable String csn, @Nullable Collection<AssuredReplicationServerResult> serverResults) {
        super(ASSURED_REPLICATION_RESPONSE_OID, false, AssuredReplicationResponseControl.encodeValue(localLevel, localAssuranceSatisfied, localAssuranceMessage, remoteLevel, remoteAssuranceSatisfied, remoteAssuranceMessage, csn, serverResults));
        this.localLevel = localLevel;
        this.localAssuranceSatisfied = localAssuranceSatisfied;
        this.localAssuranceMessage = localAssuranceMessage;
        this.remoteLevel = remoteLevel;
        this.remoteAssuranceSatisfied = remoteAssuranceSatisfied;
        this.remoteAssuranceMessage = remoteAssuranceMessage;
        this.csn = csn;
        this.serverResults = serverResults == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<AssuredReplicationServerResult>(serverResults));
    }

    public AssuredReplicationResponseControl(@NotNull String oid, boolean isCritical, @Nullable ASN1OctetString value) throws LDAPException {
        super(oid, isCritical, value);
        if (value == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_ASSURED_REPLICATION_RESPONSE_NO_VALUE.get());
        }
        AssuredReplicationLocalLevel lLevel = null;
        Boolean lSatisfied = null;
        String lMessage = null;
        AssuredReplicationRemoteLevel rLevel = null;
        Boolean rSatisfied = null;
        String rMessage = null;
        String seqNum = null;
        List<Object> sResults = Collections.emptyList();
        try {
            block15: for (ASN1Element e : ASN1Sequence.decodeAsSequence(value.getValue()).elements()) {
                switch (e.getType()) {
                    case -128: {
                        int intValue = ASN1Enumerated.decodeAsEnumerated(e).intValue();
                        lLevel = AssuredReplicationLocalLevel.valueOf(intValue);
                        if (lLevel != null) continue block15;
                        throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_ASSURED_REPLICATION_RESPONSE_INVALID_LOCAL_LEVEL.get(intValue));
                    }
                    case -127: {
                        lSatisfied = ASN1Boolean.decodeAsBoolean(e).booleanValue();
                        continue block15;
                    }
                    case -126: {
                        lMessage = ASN1OctetString.decodeAsOctetString(e).stringValue();
                        continue block15;
                    }
                    case -125: {
                        int intValue = ASN1Enumerated.decodeAsEnumerated(e).intValue();
                        rLevel = AssuredReplicationRemoteLevel.valueOf(intValue);
                        if (lLevel != null) continue block15;
                        throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_ASSURED_REPLICATION_RESPONSE_INVALID_REMOTE_LEVEL.get(intValue));
                    }
                    case -124: {
                        rSatisfied = ASN1Boolean.decodeAsBoolean(e).booleanValue();
                        continue block15;
                    }
                    case -123: {
                        rMessage = ASN1OctetString.decodeAsOctetString(e).stringValue();
                        continue block15;
                    }
                    case -122: {
                        seqNum = ASN1OctetString.decodeAsOctetString(e).stringValue();
                        continue block15;
                    }
                    case -89: {
                        ASN1Element[] srElements = ASN1Sequence.decodeAsSequence(e).elements();
                        ArrayList<AssuredReplicationServerResult> srList = new ArrayList<AssuredReplicationServerResult>(srElements.length);
                        for (ASN1Element srElement : srElements) {
                            try {
                                srList.add(AssuredReplicationServerResult.decode(srElement));
                            }
                            catch (Exception ex) {
                                Debug.debugException(ex);
                                throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_ASSURED_REPLICATION_RESPONSE_ERROR_DECODING_SR.get(StaticUtils.getExceptionMessage(ex)), ex);
                            }
                        }
                        sResults = Collections.unmodifiableList(srList);
                        continue block15;
                    }
                    default: {
                        throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_ASSURED_REPLICATION_RESPONSE_UNEXPECTED_ELEMENT_TYPE.get(StaticUtils.toHex(e.getType())));
                    }
                }
            }
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw le;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_ASSURED_REPLICATION_RESPONSE_ERROR_DECODING_VALUE.get(StaticUtils.getExceptionMessage(e)), e);
        }
        if (lSatisfied == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_ASSURED_REPLICATION_RESPONSE_NO_LOCAL_SATISFIED.get());
        }
        if (rSatisfied == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_ASSURED_REPLICATION_RESPONSE_NO_REMOTE_SATISFIED.get());
        }
        this.localLevel = lLevel;
        this.localAssuranceSatisfied = lSatisfied;
        this.localAssuranceMessage = lMessage;
        this.remoteLevel = rLevel;
        this.remoteAssuranceSatisfied = rSatisfied;
        this.remoteAssuranceMessage = rMessage;
        this.csn = seqNum;
        this.serverResults = sResults;
    }

    @NotNull
    private static ASN1OctetString encodeValue(@Nullable AssuredReplicationLocalLevel localLevel, boolean localAssuranceSatisfied, @Nullable String localAssuranceMessage, @Nullable AssuredReplicationRemoteLevel remoteLevel, boolean remoteAssuranceSatisfied, @Nullable String remoteAssuranceMessage, @Nullable String csn, @Nullable Collection<AssuredReplicationServerResult> serverResults) {
        ArrayList<ASN1Element> elements = new ArrayList<ASN1Element>(8);
        if (localLevel != null) {
            elements.add(new ASN1Enumerated(-128, localLevel.intValue()));
        }
        elements.add(new ASN1Boolean(-127, localAssuranceSatisfied));
        if (localAssuranceMessage != null) {
            elements.add(new ASN1OctetString(-126, localAssuranceMessage));
        }
        if (remoteLevel != null) {
            elements.add(new ASN1Enumerated(-125, remoteLevel.intValue()));
        }
        elements.add(new ASN1Boolean(-124, remoteAssuranceSatisfied));
        if (remoteAssuranceMessage != null) {
            elements.add(new ASN1OctetString(-123, remoteAssuranceMessage));
        }
        if (csn != null) {
            elements.add(new ASN1OctetString(-122, csn));
        }
        if (serverResults != null && !serverResults.isEmpty()) {
            ArrayList<ASN1Element> srElements = new ArrayList<ASN1Element>(serverResults.size());
            for (AssuredReplicationServerResult r : serverResults) {
                srElements.add(r.encode());
            }
            elements.add(new ASN1Sequence(-89, srElements));
        }
        return new ASN1OctetString(new ASN1Sequence(elements).encode());
    }

    @Override
    @NotNull
    public AssuredReplicationResponseControl decodeControl(@NotNull String oid, boolean isCritical, @Nullable ASN1OctetString value) throws LDAPException {
        return new AssuredReplicationResponseControl(oid, isCritical, value);
    }

    @Nullable
    public static AssuredReplicationResponseControl get(@NotNull LDAPResult result) throws LDAPException {
        Control c = result.getResponseControl(ASSURED_REPLICATION_RESPONSE_OID);
        if (c == null) {
            return null;
        }
        if (c instanceof AssuredReplicationResponseControl) {
            return (AssuredReplicationResponseControl)c;
        }
        return new AssuredReplicationResponseControl(c.getOID(), c.isCritical(), c.getValue());
    }

    @NotNull
    public static List<AssuredReplicationResponseControl> getAll(@NotNull LDAPResult result) throws LDAPException {
        Control[] controls = result.getResponseControls();
        ArrayList<AssuredReplicationResponseControl> decodedControls = new ArrayList<AssuredReplicationResponseControl>(controls.length);
        for (Control c : controls) {
            if (!c.getOID().equals(ASSURED_REPLICATION_RESPONSE_OID)) continue;
            if (c instanceof AssuredReplicationResponseControl) {
                decodedControls.add((AssuredReplicationResponseControl)c);
                continue;
            }
            decodedControls.add(new AssuredReplicationResponseControl(c.getOID(), c.isCritical(), c.getValue()));
        }
        return Collections.unmodifiableList(decodedControls);
    }

    @Nullable
    public AssuredReplicationLocalLevel getLocalLevel() {
        return this.localLevel;
    }

    public boolean localAssuranceSatisfied() {
        return this.localAssuranceSatisfied;
    }

    @Nullable
    public String getLocalAssuranceMessage() {
        return this.localAssuranceMessage;
    }

    @Nullable
    public AssuredReplicationRemoteLevel getRemoteLevel() {
        return this.remoteLevel;
    }

    public boolean remoteAssuranceSatisfied() {
        return this.remoteAssuranceSatisfied;
    }

    @Nullable
    public String getRemoteAssuranceMessage() {
        return this.remoteAssuranceMessage;
    }

    @Nullable
    public String getCSN() {
        return this.csn;
    }

    @NotNull
    public List<AssuredReplicationServerResult> getServerResults() {
        return this.serverResults;
    }

    @Override
    @NotNull
    public String getControlName() {
        return ControlMessages.INFO_CONTROL_NAME_ASSURED_REPLICATION_RESPONSE.get();
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("AssuredReplicationResponseControl(isCritical=");
        buffer.append(this.isCritical());
        if (this.localLevel != null) {
            buffer.append(", localLevel=");
            buffer.append(this.localLevel.name());
        }
        buffer.append(", localAssuranceSatisfied=");
        buffer.append(this.localAssuranceSatisfied);
        if (this.localAssuranceMessage != null) {
            buffer.append(", localMessage='");
            buffer.append(this.localAssuranceMessage);
            buffer.append('\'');
        }
        if (this.remoteLevel != null) {
            buffer.append(", remoteLevel=");
            buffer.append(this.remoteLevel.name());
        }
        buffer.append(", remoteAssuranceSatisfied=");
        buffer.append(this.remoteAssuranceSatisfied);
        if (this.remoteAssuranceMessage != null) {
            buffer.append(", remoteMessage='");
            buffer.append(this.remoteAssuranceMessage);
            buffer.append('\'');
        }
        if (this.csn != null) {
            buffer.append(", csn='");
            buffer.append(this.csn);
            buffer.append('\'');
        }
        if (this.serverResults != null && !this.serverResults.isEmpty()) {
            buffer.append(", serverResults={");
            Iterator<AssuredReplicationServerResult> iterator = this.serverResults.iterator();
            while (iterator.hasNext()) {
                if (!iterator.hasNext()) continue;
                iterator.next().toString(buffer);
                buffer.append(", ");
            }
            buffer.append('}');
        }
        buffer.append(')');
    }
}

