/****************************************************************
 * Licensed to the Apache Software Foundation (ASF) under one   *
 * or more contributor license agreements.  See the NOTICE file *
 * distributed with this work for additional information        *
 * regarding copyright ownership.  The ASF licenses this file   *
 * to you under the Apache License, Version 2.0 (the            *
 * "License"); you may not use this file except in compliance   *
 * with the License.  You may obtain a copy of the License at   *
 *                                                              *
 *   http://www.apache.org/licenses/LICENSE-2.0                 *
 *                                                              *
 * Unless required by applicable law or agreed to in writing,   *
 * software distributed under the License is distributed on an  *
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY       *
 * KIND, either express or implied.  See the License for the    *
 * specific language governing permissions and limitations      *
 * under the License.                                           *
 ****************************************************************/

package org.apache.james.jdkim.exceptions;


import org.apache.james.jdkim.api.SignatureRecord;

public class PermFailException extends FailException {

    private static final long serialVersionUID = 1304736020453821093L;

    public PermFailException(String error) {
        super(error);
    }

    public PermFailException(String string, Exception e) {
        super(string, e);
    }

    public PermFailException(String string, SignatureRecord signatureRecord, Exception e) {
        super(string, e);
        setRelatedRecord(signatureRecord);
    }

    public PermFailException(String string, SignatureRecord signatureRecord) {
        super(string);
        setRelatedRecord(signatureRecord);
    }

}
