/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.source.relational;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.Model;
import org.apache.iotdb.common.rpc.thrift.TAINodeLocation;
import org.apache.iotdb.common.rpc.thrift.TConfigNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.commons.exception.auth.AccessDeniedException;
import org.apache.iotdb.commons.pipe.agent.plugin.builtin.BuiltinPipePlugin;
import org.apache.iotdb.commons.pipe.agent.plugin.meta.PipePluginMeta;
import org.apache.iotdb.commons.schema.SchemaConstant;
import org.apache.iotdb.commons.schema.table.InformationSchema;
import org.apache.iotdb.commons.schema.table.TableNodeStatus;
import org.apache.iotdb.commons.schema.table.TableType;
import org.apache.iotdb.commons.schema.table.TreeViewSchema;
import org.apache.iotdb.commons.schema.table.TsTable;
import org.apache.iotdb.commons.schema.table.TsTableInternalRPCUtil;
import org.apache.iotdb.commons.schema.table.column.TsTableColumnSchema;
import org.apache.iotdb.commons.udf.UDFInformation;
import org.apache.iotdb.commons.udf.builtin.relational.TableBuiltinAggregationFunction;
import org.apache.iotdb.commons.udf.builtin.relational.TableBuiltinScalarFunction;
import org.apache.iotdb.confignode.rpc.thrift.TClusterParameters;
import org.apache.iotdb.confignode.rpc.thrift.TConfigNodeInfo4InformationSchema;
import org.apache.iotdb.confignode.rpc.thrift.TDataNodeInfo4InformationSchema;
import org.apache.iotdb.confignode.rpc.thrift.TDatabaseInfo;
import org.apache.iotdb.confignode.rpc.thrift.TDescTable4InformationSchemaResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetDatabaseReq;
import org.apache.iotdb.confignode.rpc.thrift.TGetUdfTableReq;
import org.apache.iotdb.confignode.rpc.thrift.TNodeVersionInfo;
import org.apache.iotdb.confignode.rpc.thrift.TRegionInfo;
import org.apache.iotdb.confignode.rpc.thrift.TShowClusterResp;
import org.apache.iotdb.confignode.rpc.thrift.TShowModelReq;
import org.apache.iotdb.confignode.rpc.thrift.TShowModelResp;
import org.apache.iotdb.confignode.rpc.thrift.TShowPipeInfo;
import org.apache.iotdb.confignode.rpc.thrift.TShowPipeReq;
import org.apache.iotdb.confignode.rpc.thrift.TShowRegionReq;
import org.apache.iotdb.confignode.rpc.thrift.TShowSubscriptionInfo;
import org.apache.iotdb.confignode.rpc.thrift.TShowSubscriptionReq;
import org.apache.iotdb.confignode.rpc.thrift.TShowTopicInfo;
import org.apache.iotdb.confignode.rpc.thrift.TShowTopicReq;
import org.apache.iotdb.confignode.rpc.thrift.TTableColumnInfo;
import org.apache.iotdb.confignode.rpc.thrift.TTableInfo;
import org.apache.iotdb.db.pipe.metric.overview.PipeDataNodeSinglePipeMetrics;
import org.apache.iotdb.db.protocol.client.ConfigNodeClient;
import org.apache.iotdb.db.protocol.client.ConfigNodeClientManager;
import org.apache.iotdb.db.protocol.client.ConfigNodeInfo;
import org.apache.iotdb.db.protocol.session.IClientSession;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.TableScanOperator;
import org.apache.iotdb.db.queryengine.plan.Coordinator;
import org.apache.iotdb.db.queryengine.plan.execution.IQueryExecution;
import org.apache.iotdb.db.queryengine.plan.execution.config.TableConfigTaskVisitor;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.ShowFunctionsTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.ShowPipePluginsTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.relational.ShowCreateViewTask;
import org.apache.iotdb.db.queryengine.plan.relational.function.TableBuiltinTableFunction;
import org.apache.iotdb.db.queryengine.plan.relational.security.AccessControl;
import org.apache.iotdb.db.queryengine.plan.relational.sql.util.ReservedIdentifiers;
import org.apache.iotdb.db.relational.grammar.sql.RelationalSqlKeywords;
import org.apache.iotdb.db.schemaengine.table.InformationSchemaUtils;
import org.apache.iotdb.db.utils.TimestampPrecisionUtils;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.common.conf.TSFileConfig;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.read.common.block.TsBlockBuilder;
import org.apache.tsfile.read.common.block.column.RunLengthEncodedColumn;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.BytesUtils;
import org.apache.tsfile.utils.Pair;

public class InformationSchemaContentSupplierFactory {
    private static final AccessControl accessControl = Coordinator.getInstance().getAccessControl();

    private InformationSchemaContentSupplierFactory() {
    }

    public static Iterator<TsBlock> getSupplier(String tableName, List<TSDataType> dataTypes, String userName) {
        switch (tableName) {
            case "queries": {
                return new QueriesSupplier(dataTypes, userName);
            }
            case "databases": {
                return new DatabaseSupplier(dataTypes, userName);
            }
            case "tables": {
                return new TableSupplier(dataTypes, userName);
            }
            case "columns": {
                return new ColumnSupplier(dataTypes, userName);
            }
            case "regions": {
                return new RegionSupplier(dataTypes, userName);
            }
            case "pipes": {
                return new PipeSupplier(dataTypes, userName);
            }
            case "pipe_plugins": {
                return new PipePluginSupplier(dataTypes);
            }
            case "topics": {
                return new TopicSupplier(dataTypes, userName);
            }
            case "subscriptions": {
                return new SubscriptionSupplier(dataTypes, userName);
            }
            case "views": {
                return new ViewsSupplier(dataTypes, userName);
            }
            case "models": {
                return new ModelsSupplier(dataTypes);
            }
            case "functions": {
                return new FunctionsSupplier(dataTypes);
            }
            case "configurations": {
                return new ConfigurationsSupplier(dataTypes, userName);
            }
            case "keywords": {
                return new KeywordsSupplier(dataTypes);
            }
            case "nodes": {
                return new NodesSupplier(dataTypes, userName);
            }
            case "config_nodes": {
                return new ConfigNodesSupplier(dataTypes, userName);
            }
            case "data_nodes": {
                return new DataNodesSupplier(dataTypes, userName);
            }
        }
        throw new UnsupportedOperationException("Unknown table: " + tableName);
    }

    private static class QueriesSupplier
    extends TsBlockSupplier {
        private final long currTime = System.currentTimeMillis();
        protected int totalSize;
        protected int nextConsumedIndex;
        private List<IQueryExecution> queryExecutions = Coordinator.getInstance().getAllQueryExecutions();

        private QueriesSupplier(List<TSDataType> dataTypes, String userName) {
            super(dataTypes);
            try {
                accessControl.checkUserIsAdmin(userName);
            }
            catch (AccessDeniedException e) {
                this.queryExecutions = this.queryExecutions.stream().filter(iQueryExecution -> userName.equals(iQueryExecution.getUser())).collect(Collectors.toList());
            }
            this.totalSize = this.queryExecutions.size();
        }

        @Override
        protected void constructLine() {
            IQueryExecution queryExecution = this.queryExecutions.get(this.nextConsumedIndex);
            if (queryExecution.getSQLDialect().equals((Object)IClientSession.SqlDialect.TABLE)) {
                String[] splits = queryExecution.getQueryId().split("_");
                int dataNodeId = Integer.parseInt(splits[splits.length - 1]);
                this.columnBuilders[0].writeBinary(BytesUtils.valueOf((String)queryExecution.getQueryId()));
                this.columnBuilders[1].writeLong(TimestampPrecisionUtils.convertToCurrPrecision(queryExecution.getStartExecutionTime(), TimeUnit.MILLISECONDS));
                this.columnBuilders[2].writeInt(dataNodeId);
                this.columnBuilders[3].writeFloat((float)(this.currTime - queryExecution.getStartExecutionTime()) / 1000.0f);
                this.columnBuilders[4].writeBinary(BytesUtils.valueOf((String)queryExecution.getExecuteSQL().orElse("UNKNOWN")));
                this.columnBuilders[5].writeBinary(BytesUtils.valueOf((String)queryExecution.getUser()));
                this.resultBuilder.declarePosition();
            }
            ++this.nextConsumedIndex;
        }

        @Override
        public boolean hasNext() {
            return this.nextConsumedIndex < this.queryExecutions.size();
        }
    }

    private static class DatabaseSupplier
    extends TsBlockSupplier {
        private Iterator<Map.Entry<String, TDatabaseInfo>> iterator;
        private TDatabaseInfo currentDatabase;
        private boolean hasShownInformationSchema;
        private final String userName;

        private DatabaseSupplier(List<TSDataType> dataTypes, String userName) {
            super(dataTypes);
            this.userName = userName;
            try (ConfigNodeClient client = (ConfigNodeClient)ConfigNodeClientManager.getInstance().borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
                this.iterator = client.showDatabase(new TGetDatabaseReq(Arrays.asList(SchemaConstant.ALL_RESULT_NODES), SchemaConstant.ALL_MATCH_SCOPE.serialize()).setIsTableModel(true)).getDatabaseInfoMap().entrySet().iterator();
            }
            catch (Exception e) {
                this.lastException = e;
            }
        }

        @Override
        protected void constructLine() {
            if (!this.hasShownInformationSchema) {
                InformationSchemaUtils.buildDatabaseTsBlock(this.resultBuilder, true, false);
                this.hasShownInformationSchema = true;
                return;
            }
            this.columnBuilders[0].writeBinary(new Binary(this.currentDatabase.getName(), TSFileConfig.STRING_CHARSET));
            if (Long.MAX_VALUE == this.currentDatabase.getTTL()) {
                this.columnBuilders[1].writeBinary(new Binary("INF", TSFileConfig.STRING_CHARSET));
            } else {
                this.columnBuilders[1].writeBinary(new Binary(String.valueOf(this.currentDatabase.getTTL()), TSFileConfig.STRING_CHARSET));
            }
            this.columnBuilders[2].writeInt(this.currentDatabase.getSchemaReplicationFactor());
            this.columnBuilders[3].writeInt(this.currentDatabase.getDataReplicationFactor());
            this.columnBuilders[4].writeLong(this.currentDatabase.getTimePartitionInterval());
            this.columnBuilders[5].writeInt(this.currentDatabase.getSchemaRegionNum());
            this.columnBuilders[6].writeInt(this.currentDatabase.getDataRegionNum());
            this.resultBuilder.declarePosition();
            this.currentDatabase = null;
        }

        @Override
        public boolean hasNext() {
            if (!this.hasShownInformationSchema) {
                if (!TableConfigTaskVisitor.canShowDB(accessControl, this.userName, "information_schema")) {
                    this.hasShownInformationSchema = true;
                } else {
                    return true;
                }
            }
            while (this.iterator.hasNext()) {
                Map.Entry<String, TDatabaseInfo> result = this.iterator.next();
                if (!TableConfigTaskVisitor.canShowDB(accessControl, this.userName, result.getKey())) continue;
                this.currentDatabase = result.getValue();
                break;
            }
            return Objects.nonNull(this.currentDatabase);
        }
    }

    private static class TableSupplier
    extends TsBlockSupplier {
        private Iterator<Map.Entry<String, List<TTableInfo>>> dbIterator;
        private Iterator<TTableInfo> tableInfoIterator = null;
        private TTableInfo currentTable;
        private String dbName;
        private final String userName;

        private TableSupplier(List<TSDataType> dataTypes, String userName) {
            super(dataTypes);
            this.userName = userName;
            try (ConfigNodeClient client = (ConfigNodeClient)ConfigNodeClientManager.getInstance().borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
                Map databaseTableInfoMap = client.showTables4InformationSchema().getDatabaseTableInfoMap();
                databaseTableInfoMap.put("information_schema", InformationSchema.getSchemaTables().values().stream().map(table -> {
                    TTableInfo info = new TTableInfo(table.getTableName(), table.getPropValue("ttl").orElse("INF"));
                    info.setState(TableNodeStatus.USING.ordinal());
                    return info;
                }).collect(Collectors.toList()));
                this.dbIterator = databaseTableInfoMap.entrySet().iterator();
            }
            catch (Exception e) {
                this.lastException = e;
            }
        }

        @Override
        protected void constructLine() {
            this.columnBuilders[0].writeBinary(new Binary(this.dbName, TSFileConfig.STRING_CHARSET));
            this.columnBuilders[1].writeBinary(new Binary(this.currentTable.getTableName(), TSFileConfig.STRING_CHARSET));
            this.columnBuilders[2].writeBinary(new Binary(this.currentTable.getTTL(), TSFileConfig.STRING_CHARSET));
            this.columnBuilders[3].writeBinary(new Binary(TableNodeStatus.values()[this.currentTable.getState()].toString(), TSFileConfig.STRING_CHARSET));
            if (this.currentTable.isSetComment()) {
                this.columnBuilders[4].writeBinary(new Binary(this.currentTable.getComment(), TSFileConfig.STRING_CHARSET));
            } else {
                this.columnBuilders[4].appendNull();
            }
            if (this.dbName.equals("information_schema")) {
                this.columnBuilders[5].writeBinary(new Binary(TableType.SYSTEM_VIEW.getName(), TSFileConfig.STRING_CHARSET));
            } else if (this.currentTable.isSetType()) {
                this.columnBuilders[5].writeBinary(new Binary(TableType.values()[this.currentTable.getType()].getName(), TSFileConfig.STRING_CHARSET));
            } else {
                this.columnBuilders[5].writeBinary(new Binary(TableType.BASE_TABLE.getName(), TSFileConfig.STRING_CHARSET));
            }
            this.resultBuilder.declarePosition();
            this.currentTable = null;
        }

        @Override
        public boolean hasNext() {
            while (Objects.isNull(this.currentTable)) {
                while (Objects.nonNull(this.tableInfoIterator) && this.tableInfoIterator.hasNext()) {
                    TTableInfo info = this.tableInfoIterator.next();
                    if (!TableConfigTaskVisitor.canShowTable(accessControl, this.userName, this.dbName, info.getTableName())) continue;
                    this.currentTable = info;
                    return true;
                }
                if (!this.dbIterator.hasNext()) {
                    return false;
                }
                Map.Entry<String, List<TTableInfo>> entry = this.dbIterator.next();
                this.dbName = entry.getKey();
                if (!TableConfigTaskVisitor.canShowDB(accessControl, this.userName, this.dbName)) continue;
                this.tableInfoIterator = entry.getValue().iterator();
            }
            return true;
        }
    }

    private static class ColumnSupplier
    extends TsBlockSupplier {
        private Iterator<Map.Entry<String, Map<String, Pair<TsTable, Set<String>>>>> dbIterator;
        private Iterator<Map.Entry<String, Pair<TsTable, Set<String>>>> tableInfoIterator;
        private Iterator<TsTableColumnSchema> columnSchemaIterator;
        private String dbName;
        private String tableName;
        private Set<String> preDeletedColumns;
        private final String userName;

        private ColumnSupplier(List<TSDataType> dataTypes, String userName) {
            super(dataTypes);
            this.userName = userName;
            try (ConfigNodeClient client = (ConfigNodeClient)ConfigNodeClientManager.getInstance().borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
                TDescTable4InformationSchemaResp resp = client.descTables4InformationSchema();
                Map<String, Map> resultMap = resp.getTableColumnInfoMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((Map)entry.getValue()).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, tableEntry -> new Pair((Object)TsTableInternalRPCUtil.deserializeSingleTsTable((byte[])((TTableColumnInfo)tableEntry.getValue()).getTableInfo()), (Object)((TTableColumnInfo)tableEntry.getValue()).getPreDeletedColumns())))));
                resultMap.put("information_schema", InformationSchema.getSchemaTables().values().stream().collect(Collectors.toMap(TsTable::getTableName, table -> new Pair(table, Collections.emptySet()))));
                this.dbIterator = resultMap.entrySet().iterator();
            }
            catch (Exception e) {
                this.lastException = e;
            }
        }

        @Override
        protected void constructLine() {
            TsTableColumnSchema schema = this.columnSchemaIterator.next();
            this.columnBuilders[0].writeBinary(new Binary(this.dbName, TSFileConfig.STRING_CHARSET));
            this.columnBuilders[1].writeBinary(new Binary(this.tableName, TSFileConfig.STRING_CHARSET));
            this.columnBuilders[2].writeBinary(new Binary(schema.getColumnName(), TSFileConfig.STRING_CHARSET));
            this.columnBuilders[3].writeBinary(new Binary(schema.getDataType().name(), TSFileConfig.STRING_CHARSET));
            this.columnBuilders[4].writeBinary(new Binary(schema.getColumnCategory().name(), TSFileConfig.STRING_CHARSET));
            this.columnBuilders[5].writeBinary(new Binary(this.preDeletedColumns.contains(schema.getColumnName()) ? "PRE_DELETE" : "USING", TSFileConfig.STRING_CHARSET));
            if (schema.getProps().containsKey("__comment")) {
                this.columnBuilders[6].writeBinary(new Binary((String)schema.getProps().get("__comment"), TSFileConfig.STRING_CHARSET));
            } else {
                this.columnBuilders[6].appendNull();
            }
            this.resultBuilder.declarePosition();
        }

        @Override
        public boolean hasNext() {
            block0: while (Objects.isNull(this.columnSchemaIterator) || !this.columnSchemaIterator.hasNext()) {
                while (Objects.isNull(this.tableInfoIterator) || !this.tableInfoIterator.hasNext()) {
                    if (!this.dbIterator.hasNext()) {
                        return false;
                    }
                    Map.Entry<String, Map<String, Pair<TsTable, Set<String>>>> entry = this.dbIterator.next();
                    this.dbName = entry.getKey();
                    if (!TableConfigTaskVisitor.canShowDB(accessControl, this.userName, this.dbName)) continue;
                    this.tableInfoIterator = entry.getValue().entrySet().iterator();
                }
                while (this.tableInfoIterator.hasNext()) {
                    Map.Entry<String, Pair<TsTable, Set<String>>> tableEntry = this.tableInfoIterator.next();
                    if (!TableConfigTaskVisitor.canShowTable(accessControl, this.userName, this.dbName, tableEntry.getKey())) continue;
                    this.tableName = tableEntry.getKey();
                    this.preDeletedColumns = (Set)tableEntry.getValue().getRight();
                    this.columnSchemaIterator = ((TsTable)tableEntry.getValue().getLeft()).getColumnList().iterator();
                    continue block0;
                }
            }
            return true;
        }
    }

    private static class RegionSupplier
    extends TsBlockSupplier {
        private Iterator<TRegionInfo> iterator;

        private RegionSupplier(List<TSDataType> dataTypes, String userName) {
            super(dataTypes);
            accessControl.checkUserIsAdmin(userName);
            try (ConfigNodeClient client = (ConfigNodeClient)ConfigNodeClientManager.getInstance().borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
                this.iterator = client.showRegion(new TShowRegionReq().setIsTableModel(true).setDatabases(null)).getRegionInfoListIterator();
            }
            catch (Exception e) {
                this.lastException = e;
            }
        }

        @Override
        protected void constructLine() {
            TRegionInfo regionInfo = this.iterator.next();
            this.columnBuilders[0].writeInt(regionInfo.getConsensusGroupId().getId());
            this.columnBuilders[1].writeInt(regionInfo.getDataNodeId());
            if (regionInfo.getConsensusGroupId().getType().ordinal() == TConsensusGroupType.SchemaRegion.ordinal()) {
                this.columnBuilders[2].writeBinary(BytesUtils.valueOf((String)String.valueOf(TConsensusGroupType.SchemaRegion)));
            } else if (regionInfo.getConsensusGroupId().getType().ordinal() == TConsensusGroupType.DataRegion.ordinal()) {
                this.columnBuilders[2].writeBinary(BytesUtils.valueOf((String)String.valueOf(TConsensusGroupType.DataRegion)));
            }
            this.columnBuilders[3].writeBinary(BytesUtils.valueOf((String)(regionInfo.getStatus() == null ? "" : regionInfo.getStatus())));
            this.columnBuilders[4].writeBinary(BytesUtils.valueOf((String)regionInfo.getDatabase()));
            this.columnBuilders[5].writeInt(regionInfo.getSeriesSlots());
            this.columnBuilders[6].writeLong(regionInfo.getTimeSlots());
            this.columnBuilders[7].writeBinary(BytesUtils.valueOf((String)regionInfo.getClientRpcIp()));
            this.columnBuilders[8].writeInt(regionInfo.getClientRpcPort());
            this.columnBuilders[9].writeBinary(BytesUtils.valueOf((String)regionInfo.getInternalAddress()));
            this.columnBuilders[10].writeBinary(BytesUtils.valueOf((String)regionInfo.getRoleType()));
            this.columnBuilders[11].writeLong(regionInfo.getCreateTime());
            if (regionInfo.getConsensusGroupId().getType().ordinal() == TConsensusGroupType.DataRegion.ordinal()) {
                this.columnBuilders[12].writeLong(regionInfo.getTsFileSize());
            } else {
                this.columnBuilders[12].appendNull();
            }
            this.resultBuilder.declarePosition();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }
    }

    private static class PipeSupplier
    extends TsBlockSupplier {
        private Iterator<TShowPipeInfo> iterator;

        private PipeSupplier(List<TSDataType> dataTypes, String userName) {
            super(dataTypes);
            accessControl.checkUserIsAdmin(userName);
            try (ConfigNodeClient client = (ConfigNodeClient)ConfigNodeClientManager.getInstance().borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
                this.iterator = client.showPipe(new TShowPipeReq().setIsTableModel(true)).getPipeInfoListIterator();
            }
            catch (Exception e) {
                this.lastException = e;
            }
        }

        @Override
        protected void constructLine() {
            TShowPipeInfo tPipeInfo = this.iterator.next();
            this.columnBuilders[0].writeBinary(new Binary(tPipeInfo.getId(), TSFileConfig.STRING_CHARSET));
            this.columnBuilders[1].writeLong(TimestampPrecisionUtils.convertToCurrPrecision(tPipeInfo.getCreationTime(), TimeUnit.MILLISECONDS));
            this.columnBuilders[2].writeBinary(new Binary(tPipeInfo.getState(), TSFileConfig.STRING_CHARSET));
            this.columnBuilders[3].writeBinary(new Binary(tPipeInfo.getPipeExtractor(), TSFileConfig.STRING_CHARSET));
            this.columnBuilders[4].writeBinary(new Binary(tPipeInfo.getPipeProcessor(), TSFileConfig.STRING_CHARSET));
            this.columnBuilders[5].writeBinary(new Binary(tPipeInfo.getPipeConnector(), TSFileConfig.STRING_CHARSET));
            this.columnBuilders[6].writeBinary(new Binary(tPipeInfo.getExceptionMessage(), TSFileConfig.STRING_CHARSET));
            long remainingEventCount = tPipeInfo.getRemainingEventCount();
            double remainingTime = tPipeInfo.getEstimatedRemainingTime();
            if (remainingEventCount == -1L && remainingTime == -1.0) {
                Pair<Long, Double> remainingEventAndTime = PipeDataNodeSinglePipeMetrics.getInstance().getRemainingEventAndTime(tPipeInfo.getId(), tPipeInfo.getCreationTime());
                remainingEventCount = (Long)remainingEventAndTime.getLeft();
                remainingTime = (Double)remainingEventAndTime.getRight();
            }
            this.columnBuilders[7].writeLong(tPipeInfo.isSetRemainingEventCount() ? remainingEventCount : -1L);
            this.columnBuilders[8].writeDouble(tPipeInfo.isSetEstimatedRemainingTime() ? remainingTime : -1.0);
            this.resultBuilder.declarePosition();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }
    }

    private static class PipePluginSupplier
    extends TsBlockSupplier {
        private Iterator<PipePluginMeta> iterator;

        private PipePluginSupplier(List<TSDataType> dataTypes) {
            super(dataTypes);
            try (ConfigNodeClient client = (ConfigNodeClient)ConfigNodeClientManager.getInstance().borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
                this.iterator = client.getPipePluginTable().getAllPipePluginMeta().stream().map(PipePluginMeta::deserialize).filter(pipePluginMeta -> !BuiltinPipePlugin.SHOW_PIPE_PLUGINS_BLACKLIST.contains(pipePluginMeta.getPluginName())).iterator();
            }
            catch (Exception e) {
                this.lastException = e;
            }
        }

        @Override
        protected void constructLine() {
            PipePluginMeta pipePluginMeta = this.iterator.next();
            this.columnBuilders[0].writeBinary(BytesUtils.valueOf((String)pipePluginMeta.getPluginName()));
            this.columnBuilders[1].writeBinary(pipePluginMeta.isBuiltin() ? ShowPipePluginsTask.PIPE_PLUGIN_TYPE_BUILTIN : ShowPipePluginsTask.PIPE_PLUGIN_TYPE_EXTERNAL);
            this.columnBuilders[2].writeBinary(BytesUtils.valueOf((String)pipePluginMeta.getClassName()));
            if (Objects.nonNull(pipePluginMeta.getJarName())) {
                this.columnBuilders[3].writeBinary(BytesUtils.valueOf((String)pipePluginMeta.getJarName()));
            } else {
                this.columnBuilders[3].appendNull();
            }
            this.resultBuilder.declarePosition();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }
    }

    private static class TopicSupplier
    extends TsBlockSupplier {
        private Iterator<TShowTopicInfo> iterator;

        private TopicSupplier(List<TSDataType> dataTypes, String userName) {
            super(dataTypes);
            accessControl.checkUserIsAdmin(userName);
            try (ConfigNodeClient client = (ConfigNodeClient)ConfigNodeClientManager.getInstance().borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
                this.iterator = client.showTopic(new TShowTopicReq().setIsTableModel(true)).getTopicInfoList().iterator();
            }
            catch (Exception e) {
                this.lastException = e;
            }
        }

        @Override
        protected void constructLine() {
            TShowTopicInfo topicInfo = this.iterator.next();
            this.columnBuilders[0].writeBinary(new Binary(topicInfo.getTopicName(), TSFileConfig.STRING_CHARSET));
            this.columnBuilders[1].writeBinary(new Binary(topicInfo.getTopicAttributes(), TSFileConfig.STRING_CHARSET));
            this.resultBuilder.declarePosition();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }
    }

    private static class SubscriptionSupplier
    extends TsBlockSupplier {
        private Iterator<TShowSubscriptionInfo> iterator;

        private SubscriptionSupplier(List<TSDataType> dataTypes, String userName) {
            super(dataTypes);
            accessControl.checkUserIsAdmin(userName);
            try (ConfigNodeClient client = (ConfigNodeClient)ConfigNodeClientManager.getInstance().borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
                this.iterator = client.showSubscription(new TShowSubscriptionReq().setIsTableModel(true)).getSubscriptionInfoList().iterator();
            }
            catch (Exception e) {
                this.lastException = e;
            }
        }

        @Override
        protected void constructLine() {
            TShowSubscriptionInfo tSubscriptionInfo = this.iterator.next();
            this.columnBuilders[0].writeBinary(new Binary(tSubscriptionInfo.getTopicName(), TSFileConfig.STRING_CHARSET));
            this.columnBuilders[1].writeBinary(new Binary(tSubscriptionInfo.getConsumerGroupId(), TSFileConfig.STRING_CHARSET));
            this.columnBuilders[2].writeBinary(new Binary(tSubscriptionInfo.getConsumerIds().toString(), TSFileConfig.STRING_CHARSET));
            this.resultBuilder.declarePosition();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }
    }

    private static class ViewsSupplier
    extends TsBlockSupplier {
        private Iterator<Map.Entry<String, Map<String, Pair<TsTable, Set<String>>>>> dbIterator;
        private Iterator<Map.Entry<String, Pair<TsTable, Set<String>>>> tableInfoIterator;
        private String dbName;
        private TsTable currentTable;
        private final String userName;

        private ViewsSupplier(List<TSDataType> dataTypes, String userName) {
            super(dataTypes);
            this.userName = userName;
            try (ConfigNodeClient client = (ConfigNodeClient)ConfigNodeClientManager.getInstance().borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
                TDescTable4InformationSchemaResp resp = client.descTables4InformationSchema();
                Map<String, Map> resultMap = resp.getTableColumnInfoMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((Map)entry.getValue()).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, tableEntry -> new Pair((Object)TsTableInternalRPCUtil.deserializeSingleTsTable((byte[])((TTableColumnInfo)tableEntry.getValue()).getTableInfo()), (Object)((TTableColumnInfo)tableEntry.getValue()).getPreDeletedColumns())))));
                this.dbIterator = resultMap.entrySet().iterator();
            }
            catch (Exception e) {
                this.lastException = e;
            }
        }

        @Override
        protected void constructLine() {
            this.columnBuilders[0].writeBinary(new Binary(this.dbName, TSFileConfig.STRING_CHARSET));
            this.columnBuilders[1].writeBinary(new Binary(this.currentTable.getTableName(), TSFileConfig.STRING_CHARSET));
            this.columnBuilders[2].writeBinary(new Binary(ShowCreateViewTask.getShowCreateViewSQL(this.currentTable), TSFileConfig.STRING_CHARSET));
            this.resultBuilder.declarePosition();
            this.currentTable = null;
        }

        @Override
        public boolean hasNext() {
            while (Objects.isNull(this.currentTable)) {
                while (Objects.isNull(this.tableInfoIterator) || !this.tableInfoIterator.hasNext()) {
                    if (!this.dbIterator.hasNext()) {
                        return false;
                    }
                    Map.Entry<String, Map<String, Pair<TsTable, Set<String>>>> entry = this.dbIterator.next();
                    this.dbName = entry.getKey();
                    if (!TableConfigTaskVisitor.canShowDB(accessControl, this.userName, this.dbName)) continue;
                    this.tableInfoIterator = entry.getValue().entrySet().iterator();
                }
                while (this.tableInfoIterator.hasNext()) {
                    Map.Entry<String, Pair<TsTable, Set<String>>> tableEntry = this.tableInfoIterator.next();
                    if (!TreeViewSchema.isTreeViewTable((TsTable)((TsTable)tableEntry.getValue().getLeft())) || !TableConfigTaskVisitor.canShowTable(accessControl, this.userName, this.dbName, tableEntry.getKey())) continue;
                    this.currentTable = (TsTable)tableEntry.getValue().getLeft();
                    return true;
                }
            }
            return true;
        }
    }

    private static class ModelsSupplier
    extends TsBlockSupplier {
        private ModelIterator iterator;

        private ModelsSupplier(List<TSDataType> dataTypes) {
            super(dataTypes);
            try (ConfigNodeClient client = (ConfigNodeClient)ConfigNodeClientManager.getInstance().borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
                this.iterator = new ModelIterator(client.showModel(new TShowModelReq()));
            }
            catch (Exception e) {
                this.lastException = e;
            }
        }

        @Override
        protected void constructLine() {
            ModelInfoInString modelInfo = this.iterator.next();
            this.columnBuilders[0].writeBinary(new Binary(modelInfo.getModelId(), TSFileConfig.STRING_CHARSET));
            this.columnBuilders[1].writeBinary(new Binary(modelInfo.getModelType(), TSFileConfig.STRING_CHARSET));
            this.columnBuilders[2].writeBinary(new Binary(modelInfo.getCategory(), TSFileConfig.STRING_CHARSET));
            this.columnBuilders[3].writeBinary(new Binary(modelInfo.getState(), TSFileConfig.STRING_CHARSET));
            this.resultBuilder.declarePosition();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        private static class ModelIterator
        implements Iterator<ModelInfoInString> {
            private int index = 0;
            private final TShowModelResp resp;

            private ModelIterator(TShowModelResp resp) {
                this.resp = resp;
            }

            @Override
            public boolean hasNext() {
                return this.index < this.resp.getModelIdListSize();
            }

            @Override
            public ModelInfoInString next() {
                String modelId = (String)this.resp.getModelIdList().get(this.index++);
                return new ModelInfoInString(modelId, (String)this.resp.getModelTypeMap().get(modelId), (String)this.resp.getCategoryMap().get(modelId), (String)this.resp.getStateMap().get(modelId));
            }
        }

        private static class ModelInfoInString {
            private final String modelId;
            private final String modelType;
            private final String category;
            private final String state;

            public ModelInfoInString(String modelId, String modelType, String category, String state) {
                this.modelId = modelId;
                this.modelType = modelType;
                this.category = category;
                this.state = state;
            }

            public String getModelId() {
                return this.modelId;
            }

            public String getModelType() {
                return this.modelType;
            }

            public String getCategory() {
                return this.category;
            }

            public String getState() {
                return this.state;
            }
        }
    }

    private static class FunctionsSupplier
    extends TsBlockSupplier {
        private Iterator<UDFInformation> udfIterator;
        private Iterator<String> nameIterator;
        private Binary functionType;
        private Binary functionState;

        private FunctionsSupplier(List<TSDataType> dataTypes) {
            super(dataTypes);
            try (ConfigNodeClient client = (ConfigNodeClient)ConfigNodeClientManager.getInstance().borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
                this.udfIterator = client.getUDFTable(new TGetUdfTableReq(Model.TABLE)).getAllUDFInformation().stream().map(UDFInformation::deserialize).sorted(Comparator.comparing(UDFInformation::getFunctionName)).iterator();
                this.nameIterator = TableBuiltinScalarFunction.getBuiltInScalarFunctionName().iterator();
                this.functionType = ShowFunctionsTask.BINARY_MAP.get("built-in scalar function");
                this.functionState = ShowFunctionsTask.BINARY_MAP.get("AVAILABLE");
            }
            catch (Exception e) {
                this.lastException = e;
            }
        }

        @Override
        protected void constructLine() {
            if (this.udfIterator.hasNext()) {
                UDFInformation udfInformation = this.udfIterator.next();
                this.columnBuilders[0].writeBinary(BytesUtils.valueOf((String)udfInformation.getFunctionName()));
                this.columnBuilders[1].writeBinary(ShowFunctionsTask.getFunctionType(udfInformation));
                this.columnBuilders[2].writeBinary(BytesUtils.valueOf((String)udfInformation.getClassName()));
                this.columnBuilders[3].writeBinary(ShowFunctionsTask.getFunctionState(udfInformation));
            } else if (this.nameIterator.hasNext()) {
                String name = this.nameIterator.next();
                this.columnBuilders[0].writeBinary(BytesUtils.valueOf((String)name.toUpperCase()));
                this.columnBuilders[1].writeBinary(this.functionType);
                this.columnBuilders[2].appendNull();
                this.columnBuilders[3].writeBinary(this.functionState);
            }
            this.resultBuilder.declarePosition();
        }

        @Override
        public boolean hasNext() {
            if (this.udfIterator.hasNext()) {
                return true;
            }
            while (!this.nameIterator.hasNext()) {
                if (this.functionType.equals((Object)ShowFunctionsTask.BINARY_MAP.get("built-in scalar function"))) {
                    this.functionType = ShowFunctionsTask.BINARY_MAP.get("built-in aggregate function");
                    this.nameIterator = TableBuiltinAggregationFunction.getBuiltInAggregateFunctionName().iterator();
                    continue;
                }
                if (this.functionType.equals((Object)ShowFunctionsTask.BINARY_MAP.get("built-in aggregate function"))) {
                    this.functionType = ShowFunctionsTask.BINARY_MAP.get("built-in table function");
                    this.nameIterator = TableBuiltinTableFunction.getBuiltInTableFunctionName().iterator();
                    continue;
                }
                return false;
            }
            return true;
        }
    }

    private static class ConfigurationsSupplier
    extends TsBlockSupplier {
        private Iterator<Pair<Binary, Binary>> resultIterator;

        private ConfigurationsSupplier(List<TSDataType> dataTypes, String userName) {
            super(dataTypes);
            accessControl.checkUserIsAdmin(userName);
            try (ConfigNodeClient client = (ConfigNodeClient)ConfigNodeClientManager.getInstance().borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
                TClusterParameters parameters = client.showVariables().getClusterParameters();
                this.resultIterator = Arrays.asList(new Pair((Object)BytesUtils.valueOf((String)"ClusterName"), (Object)BytesUtils.valueOf((String)parameters.getClusterName())), new Pair((Object)BytesUtils.valueOf((String)"DataReplicationFactor"), (Object)BytesUtils.valueOf((String)String.valueOf(parameters.getDataReplicationFactor()))), new Pair((Object)BytesUtils.valueOf((String)"SchemaReplicationFactor"), (Object)BytesUtils.valueOf((String)String.valueOf(parameters.getSchemaReplicationFactor()))), new Pair((Object)BytesUtils.valueOf((String)"DataRegionConsensusProtocolClass"), (Object)BytesUtils.valueOf((String)parameters.getDataRegionConsensusProtocolClass())), new Pair((Object)BytesUtils.valueOf((String)"SchemaRegionConsensusProtocolClass"), (Object)BytesUtils.valueOf((String)parameters.getSchemaRegionConsensusProtocolClass())), new Pair((Object)BytesUtils.valueOf((String)"ConfigNodeConsensusProtocolClass"), (Object)BytesUtils.valueOf((String)parameters.getConfigNodeConsensusProtocolClass())), new Pair((Object)BytesUtils.valueOf((String)"TimePartitionOrigin"), (Object)BytesUtils.valueOf((String)String.valueOf(parameters.getTimePartitionOrigin()))), new Pair((Object)BytesUtils.valueOf((String)"TimePartitionInterval"), (Object)BytesUtils.valueOf((String)String.valueOf(parameters.getTimePartitionInterval()))), new Pair((Object)BytesUtils.valueOf((String)"ReadConsistencyLevel"), (Object)BytesUtils.valueOf((String)parameters.getReadConsistencyLevel())), new Pair((Object)BytesUtils.valueOf((String)"SchemaRegionPerDataNode"), (Object)BytesUtils.valueOf((String)String.valueOf(parameters.getSchemaRegionPerDataNode()))), new Pair((Object)BytesUtils.valueOf((String)"DataRegionPerDataNode"), (Object)BytesUtils.valueOf((String)String.valueOf(parameters.getDataRegionPerDataNode()))), new Pair((Object)BytesUtils.valueOf((String)"SeriesSlotNum"), (Object)BytesUtils.valueOf((String)String.valueOf(parameters.getSeriesPartitionSlotNum()))), new Pair((Object)BytesUtils.valueOf((String)"SeriesSlotExecutorClass"), (Object)BytesUtils.valueOf((String)parameters.getSeriesPartitionExecutorClass())), new Pair((Object)BytesUtils.valueOf((String)"DiskSpaceWarningThreshold"), (Object)BytesUtils.valueOf((String)String.valueOf(parameters.getDiskSpaceWarningThreshold()))), new Pair((Object)BytesUtils.valueOf((String)"TimestampPrecision"), (Object)BytesUtils.valueOf((String)parameters.getTimestampPrecision()))).iterator();
            }
            catch (Exception e) {
                this.lastException = e;
            }
        }

        @Override
        protected void constructLine() {
            Pair<Binary, Binary> currentVariable = this.resultIterator.next();
            this.columnBuilders[0].writeBinary((Binary)currentVariable.getLeft());
            this.columnBuilders[1].writeBinary((Binary)currentVariable.getRight());
            this.resultBuilder.declarePosition();
        }

        @Override
        public boolean hasNext() {
            return this.resultIterator.hasNext();
        }
    }

    private static class KeywordsSupplier
    extends TsBlockSupplier {
        private final Iterator<String> keywordIterator;
        private final Set<String> reserved = ReservedIdentifiers.reservedIdentifiers();

        private KeywordsSupplier(List<TSDataType> dataTypes) {
            super(dataTypes);
            this.keywordIterator = RelationalSqlKeywords.sqlKeywords().iterator();
        }

        @Override
        protected void constructLine() {
            String keyword = this.keywordIterator.next();
            this.columnBuilders[0].writeBinary(BytesUtils.valueOf((String)keyword));
            this.columnBuilders[1].writeInt(this.reserved.contains(keyword) ? 1 : 0);
            this.resultBuilder.declarePosition();
        }

        @Override
        public boolean hasNext() {
            return this.keywordIterator.hasNext();
        }
    }

    private static class NodesSupplier
    extends TsBlockSupplier {
        private TShowClusterResp showClusterResp;
        private Iterator<TConfigNodeLocation> configNodeIterator;
        private Iterator<TDataNodeLocation> dataNodeIterator;
        private Iterator<TAINodeLocation> aiNodeIterator;

        private NodesSupplier(List<TSDataType> dataTypes, String userName) {
            super(dataTypes);
            accessControl.checkUserIsAdmin(userName);
            try (ConfigNodeClient client = (ConfigNodeClient)ConfigNodeClientManager.getInstance().borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
                this.showClusterResp = client.showCluster();
                this.configNodeIterator = this.showClusterResp.getConfigNodeListIterator();
                this.dataNodeIterator = this.showClusterResp.getDataNodeListIterator();
                this.aiNodeIterator = this.showClusterResp.getAiNodeListIterator();
            }
            catch (Exception e) {
                this.lastException = e;
            }
        }

        @Override
        protected void constructLine() {
            if (this.configNodeIterator.hasNext()) {
                TConfigNodeLocation location = this.configNodeIterator.next();
                this.buildNodeTsBlock(location.getConfigNodeId(), "ConfigNode", (String)this.showClusterResp.getNodeStatus().get(location.getConfigNodeId()), location.getInternalEndPoint().getIp(), location.getInternalEndPoint().getPort(), (TNodeVersionInfo)this.showClusterResp.getNodeVersionInfo().get(location.getConfigNodeId()));
                return;
            }
            if (this.dataNodeIterator.hasNext()) {
                TDataNodeLocation location = this.dataNodeIterator.next();
                this.buildNodeTsBlock(location.getDataNodeId(), "DataNode", (String)this.showClusterResp.getNodeStatus().get(location.getDataNodeId()), location.getInternalEndPoint().getIp(), location.getInternalEndPoint().getPort(), (TNodeVersionInfo)this.showClusterResp.getNodeVersionInfo().get(location.getDataNodeId()));
                return;
            }
            if (this.aiNodeIterator.hasNext()) {
                TAINodeLocation location = this.aiNodeIterator.next();
                this.buildNodeTsBlock(location.getAiNodeId(), "AINode", (String)this.showClusterResp.getNodeStatus().get(location.getAiNodeId()), location.getInternalEndPoint().getIp(), location.getInternalEndPoint().getPort(), (TNodeVersionInfo)this.showClusterResp.getNodeVersionInfo().get(location.getAiNodeId()));
            }
        }

        private void buildNodeTsBlock(int nodeId, String nodeType, String nodeStatus, String internalAddress, int internalPort, TNodeVersionInfo versionInfo) {
            this.columnBuilders[0].writeInt(nodeId);
            this.columnBuilders[1].writeBinary(new Binary(nodeType, TSFileConfig.STRING_CHARSET));
            if (nodeStatus == null) {
                this.columnBuilders[2].appendNull();
            } else {
                this.columnBuilders[2].writeBinary(new Binary(nodeStatus, TSFileConfig.STRING_CHARSET));
            }
            if (internalAddress == null) {
                this.columnBuilders[3].appendNull();
            } else {
                this.columnBuilders[3].writeBinary(new Binary(internalAddress, TSFileConfig.STRING_CHARSET));
            }
            this.columnBuilders[4].writeInt(internalPort);
            if (versionInfo == null || versionInfo.getVersion() == null) {
                this.columnBuilders[5].appendNull();
            } else {
                this.columnBuilders[5].writeBinary(new Binary(versionInfo.getVersion(), TSFileConfig.STRING_CHARSET));
            }
            if (versionInfo == null || versionInfo.getBuildInfo() == null) {
                this.columnBuilders[6].appendNull();
            } else {
                this.columnBuilders[6].writeBinary(new Binary(versionInfo.getBuildInfo(), TSFileConfig.STRING_CHARSET));
            }
            this.resultBuilder.declarePosition();
        }

        @Override
        public boolean hasNext() {
            return this.configNodeIterator.hasNext() || this.dataNodeIterator.hasNext() || this.aiNodeIterator.hasNext();
        }
    }

    private static class ConfigNodesSupplier
    extends TsBlockSupplier {
        private Iterator<TConfigNodeInfo4InformationSchema> configNodeIterator;

        private ConfigNodesSupplier(List<TSDataType> dataTypes, String userName) {
            super(dataTypes);
            accessControl.checkUserIsAdmin(userName);
            try (ConfigNodeClient client = (ConfigNodeClient)ConfigNodeClientManager.getInstance().borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
                this.configNodeIterator = client.showConfigNodes4InformationSchema().getConfigNodesInfoListIterator();
            }
            catch (Exception e) {
                this.lastException = e;
            }
        }

        @Override
        protected void constructLine() {
            TConfigNodeInfo4InformationSchema configNodeInfo4InformationSchema = this.configNodeIterator.next();
            this.columnBuilders[0].writeInt(configNodeInfo4InformationSchema.getConfigNodeId());
            this.columnBuilders[1].writeInt(configNodeInfo4InformationSchema.getConsensusPort());
            this.columnBuilders[2].writeBinary(new Binary(configNodeInfo4InformationSchema.getRoleType(), TSFileConfig.STRING_CHARSET));
            this.resultBuilder.declarePosition();
        }

        @Override
        public boolean hasNext() {
            return this.configNodeIterator.hasNext();
        }
    }

    private static class DataNodesSupplier
    extends TsBlockSupplier {
        private Iterator<TDataNodeInfo4InformationSchema> dataNodeIterator;

        private DataNodesSupplier(List<TSDataType> dataTypes, String userName) {
            super(dataTypes);
            accessControl.checkUserIsAdmin(userName);
            try (ConfigNodeClient client = (ConfigNodeClient)ConfigNodeClientManager.getInstance().borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
                this.dataNodeIterator = client.showDataNodes4InformationSchema().getDataNodesInfoListIterator();
            }
            catch (Exception e) {
                this.lastException = e;
            }
        }

        @Override
        protected void constructLine() {
            TDataNodeInfo4InformationSchema dataNodeInfo4InformationSchema = this.dataNodeIterator.next();
            this.columnBuilders[0].writeInt(dataNodeInfo4InformationSchema.getDataNodeId());
            this.columnBuilders[1].writeInt(dataNodeInfo4InformationSchema.getDataRegionNum());
            this.columnBuilders[2].writeInt(dataNodeInfo4InformationSchema.getSchemaRegionNum());
            this.columnBuilders[3].writeBinary(new Binary(dataNodeInfo4InformationSchema.getRpcAddress(), TSFileConfig.STRING_CHARSET));
            this.columnBuilders[4].writeInt(dataNodeInfo4InformationSchema.getRpcPort());
            this.columnBuilders[5].writeInt(dataNodeInfo4InformationSchema.getMppPort());
            this.columnBuilders[6].writeInt(dataNodeInfo4InformationSchema.getDataConsensusPort());
            this.columnBuilders[7].writeInt(dataNodeInfo4InformationSchema.getSchemaConsensusPort());
            this.resultBuilder.declarePosition();
        }

        @Override
        public boolean hasNext() {
            return this.dataNodeIterator.hasNext();
        }
    }

    private static abstract class TsBlockSupplier
    implements Iterator<TsBlock> {
        protected final TsBlockBuilder resultBuilder;
        protected final ColumnBuilder[] columnBuilders;
        protected Exception lastException;

        private TsBlockSupplier(List<TSDataType> dataTypes) {
            this.resultBuilder = new TsBlockBuilder(dataTypes);
            this.columnBuilders = this.resultBuilder.getValueColumnBuilders();
        }

        @Override
        public TsBlock next() {
            if (Objects.nonNull(this.lastException)) {
                throw new NoSuchElementException(this.lastException.getMessage());
            }
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            while (this.hasNext() && !this.resultBuilder.isFull()) {
                this.constructLine();
            }
            TsBlock result = this.resultBuilder.build((Column)new RunLengthEncodedColumn((Column)TableScanOperator.TIME_COLUMN_TEMPLATE, this.resultBuilder.getPositionCount()));
            this.resultBuilder.reset();
            return result;
        }

        protected abstract void constructLine();
    }
}

