/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.jdbc;

import java.nio.charset.Charset;
import java.time.ZoneId;
import java.util.Optional;
import org.apache.iotdb.jdbc.Config;
import org.apache.iotdb.jdbc.Constant;
import org.apache.tsfile.common.conf.TSFileConfig;

public class IoTDBConnectionParams {
    private String host = "localhost";
    private int port = 6667;
    private String jdbcUriString;
    private String seriesName = "default";
    private String username = "user";
    private String password = "password";
    private Constant.Version version = Config.DEFAULT_VERSION;
    private int thriftDefaultBufferSize = 1024;
    private int thriftMaxFrameSize = 0x20000000;
    private int networkTimeout = 0;
    private String timeZone = ZoneId.systemDefault().toString();
    private Charset charset = TSFileConfig.STRING_CHARSET;
    private boolean useSSL = false;
    private String trustStore;
    private String trustStorePwd;
    private String sqlDialect = "tree";
    private String db;

    public IoTDBConnectionParams(String url) {
        this.jdbcUriString = url;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getJdbcUriString() {
        return this.jdbcUriString;
    }

    public void setJdbcUriString(String jdbcUriString) {
        this.jdbcUriString = jdbcUriString;
    }

    public String getSeriesName() {
        return this.seriesName;
    }

    public void setSeriesName(String seriesName) {
        this.seriesName = seriesName;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getThriftDefaultBufferSize() {
        return this.thriftDefaultBufferSize;
    }

    public void setThriftDefaultBufferSize(int thriftDefaultBufferSize) {
        this.thriftDefaultBufferSize = thriftDefaultBufferSize;
    }

    public int getThriftMaxFrameSize() {
        return this.thriftMaxFrameSize;
    }

    public void setThriftMaxFrameSize(int thriftMaxFrameSize) {
        this.thriftMaxFrameSize = thriftMaxFrameSize;
    }

    public Constant.Version getVersion() {
        return this.version;
    }

    public void setVersion(Constant.Version version) {
        this.version = version;
    }

    public void setNetworkTimeout(int networkTimeout) {
        this.networkTimeout = networkTimeout < 0 ? 0 : networkTimeout;
    }

    public int getNetworkTimeout() {
        return this.networkTimeout;
    }

    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public void setCharset(String charsetName) {
        this.charset = Charset.forName(charsetName);
    }

    public Charset getCharset() {
        return this.charset;
    }

    public boolean isUseSSL() {
        return this.useSSL;
    }

    public void setUseSSL(boolean useSSL) {
        this.useSSL = useSSL;
    }

    public String getTrustStore() {
        return this.trustStore;
    }

    public void setTrustStore(String trustStore) {
        this.trustStore = trustStore;
    }

    public String getTrustStorePwd() {
        return this.trustStorePwd;
    }

    public void setTrustStorePwd(String trustStorePwd) {
        this.trustStorePwd = trustStorePwd;
    }

    public String getSqlDialect() {
        return this.sqlDialect;
    }

    public void setSqlDialect(String sqlDialect) {
        this.sqlDialect = sqlDialect;
    }

    public Optional<String> getDb() {
        return Optional.ofNullable(this.db);
    }

    public void setDb(String db) {
        this.db = db;
    }
}

