/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.trigger.executor;

public enum TriggerFireResult {
    SUCCESS(0, "Trigger fires successfully"),
    FAILED_NO_TERMINATION(1, "Exception occurred when firing an trigger with optimistic strategy"),
    TERMINATION(2, "Exception occurred when firing an trigger with pessimistic strategy");

    private final int id;
    private final String event;

    private TriggerFireResult(int id, String event) {
        this.id = id;
        this.event = event;
    }

    public static TriggerFireResult construct(int id) {
        switch (id) {
            case 0: {
                return SUCCESS;
            }
            case 1: {
                return FAILED_NO_TERMINATION;
            }
            case 2: {
                return TERMINATION;
            }
        }
        throw new UnsupportedOperationException("Unsupported TriggerFireResult Type");
    }

    public int getId() {
        return this.id;
    }

    public String getEvent() {
        return this.event;
    }
}

