/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.Rule;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule.Util;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.Measure;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.PatternRecognitionNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.Patterns;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.RowsPerMatch;
import org.apache.iotdb.db.queryengine.plan.relational.planner.rowpattern.ExpressionAndValuePointers;
import org.apache.iotdb.db.queryengine.plan.relational.utils.matching.Captures;
import org.apache.iotdb.db.queryengine.plan.relational.utils.matching.Pattern;

public class PrunePatternRecognitionSourceColumns
implements Rule<PatternRecognitionNode> {
    private static final Pattern<PatternRecognitionNode> PATTERN = Patterns.patternRecognition().with(Patterns.PatternRecognition.rowsPerMatch().matching(rowsPerMatch -> rowsPerMatch == RowsPerMatch.ONE));

    @Override
    public Pattern<PatternRecognitionNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(PatternRecognitionNode node, Captures captures, Rule.Context context) {
        ImmutableSet.Builder referencedInputs = ImmutableSet.builder();
        referencedInputs.addAll(node.getPartitionBy());
        node.getOrderingScheme().ifPresent(orderingScheme -> referencedInputs.addAll(orderingScheme.getOrderBy()));
        node.getHashSymbol().ifPresent(arg_0 -> ((ImmutableSet.Builder)referencedInputs).add(arg_0));
        node.getMeasures().values().stream().map(Measure::getExpressionAndValuePointers).map(ExpressionAndValuePointers::getInputSymbols).forEach(arg_0 -> ((ImmutableSet.Builder)referencedInputs).addAll(arg_0));
        node.getVariableDefinitions().values().stream().map(ExpressionAndValuePointers::getInputSymbols).forEach(arg_0 -> ((ImmutableSet.Builder)referencedInputs).addAll(arg_0));
        return Util.restrictChildOutputs(context.getIdAllocator(), node, new Set[]{referencedInputs.build()}).map(Rule.Result::ofPlanNode).orElse(Rule.Result.empty());
    }
}

