/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.common.schematree.node;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.iotdb.db.queryengine.common.schematree.node.SchemaNode;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class SchemaInternalNode
extends SchemaNode {
    protected Map<String, SchemaNode> children = new HashMap<String, SchemaNode>();

    public SchemaInternalNode(String name) {
        super(name);
    }

    @Override
    public SchemaNode getChild(String name) {
        return this.children.get(name);
    }

    @Override
    public void addChild(String name, SchemaNode child) {
        this.children.put(name, child);
    }

    @Override
    public void replaceChild(String name, SchemaNode newChild) {
        SchemaNode oldChild = this.children.get(name);
        oldChild.copyDataTo(newChild);
        this.children.replace(name, newChild);
    }

    @Override
    public void removeChild(String name) {
        this.children.remove(name);
    }

    @Override
    public void copyDataTo(SchemaNode schemaNode) {
        if (schemaNode.isMeasurement()) {
            return;
        }
        for (SchemaNode child : this.children.values()) {
            schemaNode.addChild(child.getName(), child);
        }
    }

    @Override
    public Map<String, SchemaNode> getChildren() {
        return this.children;
    }

    @Override
    public Iterator<SchemaNode> getChildrenIterator() {
        return this.children.values().iterator();
    }

    @Override
    public byte getType() {
        return 0;
    }

    @Override
    public void serialize(OutputStream outputStream) throws IOException {
        this.serializeChildren(outputStream);
        ReadWriteIOUtils.write((byte)this.getType(), (OutputStream)outputStream);
        ReadWriteIOUtils.write((String)this.name, (OutputStream)outputStream);
        ReadWriteIOUtils.write((int)this.children.size(), (OutputStream)outputStream);
    }

    protected void serializeChildren(OutputStream outputStream) throws IOException {
        for (SchemaNode child : this.children.values()) {
            child.serialize(outputStream);
        }
    }

    public static SchemaInternalNode deserialize(InputStream inputStream) throws IOException {
        String name = ReadWriteIOUtils.readString((InputStream)inputStream);
        return new SchemaInternalNode(name);
    }
}

