/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.expression.unary;

import java.time.ZoneId;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.Validate;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.qp.physical.crud.UDTFPlan;
import org.apache.iotdb.db.qp.utils.WildcardsRemover;
import org.apache.iotdb.db.query.expression.Expression;
import org.apache.iotdb.db.query.udf.core.executor.UDTFExecutor;
import org.apache.iotdb.db.query.udf.core.layer.ConstantIntermediateLayer;
import org.apache.iotdb.db.query.udf.core.layer.IntermediateLayer;
import org.apache.iotdb.db.query.udf.core.layer.LayerMemoryAssigner;
import org.apache.iotdb.db.query.udf.core.layer.RawQueryInputLayer;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;

public class ConstantOperand
extends Expression {
    private final String valueString;
    private final TSDataType dataType;

    public ConstantOperand(TSDataType dataType, String str) throws QueryProcessException {
        this.dataType = (TSDataType)Validate.notNull((Object)dataType);
        this.valueString = (String)Validate.notNull((Object)str);
    }

    public TSDataType getDataType() {
        return this.dataType;
    }

    @Override
    public boolean isConstantOperandInternal() {
        return true;
    }

    @Override
    public void concat(List<PartialPath> prefixPaths, List<Expression> resultExpressions) {
        resultExpressions.add(this);
    }

    @Override
    public void removeWildcards(WildcardsRemover wildcardsRemover, List<Expression> resultExpressions) {
        resultExpressions.add(this);
    }

    @Override
    public void collectPaths(Set<PartialPath> pathSet) {
    }

    @Override
    public List<Expression> getExpressions() {
        return Collections.emptyList();
    }

    @Override
    public void constructUdfExecutors(Map<String, UDTFExecutor> expressionName2Executor, ZoneId zoneId) {
    }

    @Override
    public void updateStatisticsForMemoryAssigner(LayerMemoryAssigner memoryAssigner) {
    }

    @Override
    public IntermediateLayer constructIntermediateLayer(long queryId, UDTFPlan udtfPlan, RawQueryInputLayer rawTimeSeriesInputLayer, Map<Expression, IntermediateLayer> expressionIntermediateLayerMap, Map<Expression, TSDataType> expressionDataTypeMap, LayerMemoryAssigner memoryAssigner) throws QueryProcessException {
        if (!expressionIntermediateLayerMap.containsKey(this)) {
            expressionDataTypeMap.put(this, this.getDataType());
            ConstantIntermediateLayer intermediateLayer = new ConstantIntermediateLayer(this, queryId, memoryAssigner.assign());
            expressionIntermediateLayerMap.put(this, intermediateLayer);
        }
        return expressionIntermediateLayerMap.get(this);
    }

    @Override
    public String getExpressionStringInternal() {
        return this.valueString;
    }
}

