/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.reader.chunk;

import java.io.IOException;
import org.apache.iotdb.db.utils.TimeValuePairUtils;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.read.common.BatchData;
import org.apache.iotdb.tsfile.read.reader.IChunkReader;
import org.apache.iotdb.tsfile.read.reader.IPointReader;

public class ChunkDataIterator
implements IPointReader {
    private IChunkReader chunkReader;
    private BatchData data;

    public ChunkDataIterator(IChunkReader chunkReader) {
        this.chunkReader = chunkReader;
    }

    public boolean hasNextTimeValuePair() throws IOException {
        if (this.data != null && this.data.hasCurrent()) {
            return true;
        }
        while (this.chunkReader.hasNextSatisfiedPage()) {
            this.data = this.chunkReader.nextPageData();
            if (!this.data.hasCurrent()) continue;
            return true;
        }
        return false;
    }

    public TimeValuePair nextTimeValuePair() {
        TimeValuePair timeValuePair = TimeValuePairUtils.getCurrentTimeValuePair(this.data);
        this.data.next();
        return timeValuePair;
    }

    public TimeValuePair currentTimeValuePair() {
        return TimeValuePairUtils.getCurrentTimeValuePair(this.data);
    }

    public void close() throws IOException {
        this.chunkReader.close();
    }
}

