/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.physical.sys;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;

public class ChangeAliasPlan
extends PhysicalPlan {
    private PartialPath path;
    private String alias;

    public ChangeAliasPlan() {
        super(Operator.OperatorType.CHANGE_ALIAS);
    }

    public ChangeAliasPlan(PartialPath path, String alias) {
        super(Operator.OperatorType.CHANGE_ALIAS);
        this.path = path;
        this.alias = alias;
    }

    public PartialPath getPath() {
        return this.path;
    }

    public void setPath(PartialPath path) {
        this.path = path;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public List<PartialPath> getPaths() {
        ArrayList<PartialPath> ret = new ArrayList<PartialPath>();
        if (this.path != null) {
            ret.add(this.path);
        }
        return ret;
    }

    @Override
    public void serializeImpl(ByteBuffer buffer) {
        int type = PhysicalPlan.PhysicalPlanType.CHANGE_ALIAS.ordinal();
        buffer.put((byte)type);
        this.putString(buffer, this.path.getFullPath());
        this.putString(buffer, this.alias);
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        stream.write((byte)PhysicalPlan.PhysicalPlanType.CHANGE_ALIAS.ordinal());
        this.putString(stream, this.path.getFullPath());
        this.putString(stream, this.alias);
    }

    @Override
    public void deserialize(ByteBuffer buffer) throws IllegalPathException {
        this.path = new PartialPath(this.readString(buffer));
        this.alias = this.readString(buffer);
    }

    public String toString() {
        return "ChangeAlias{" + this.path + "," + this.alias + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChangeAliasPlan that = (ChangeAliasPlan)o;
        return Objects.equals(this.path, that.path) && Objects.equals(this.alias, that.alias);
    }

    public int hashCode() {
        return Objects.hash(this.path, this.alias);
    }
}

