/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.server.heartbeat;

import java.util.Collection;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.cluster.ClusterIoTDB;
import org.apache.iotdb.cluster.config.ClusterConstant;
import org.apache.iotdb.cluster.config.ClusterDescriptor;
import org.apache.iotdb.cluster.rpc.thrift.ElectionRequest;
import org.apache.iotdb.cluster.rpc.thrift.HeartBeatRequest;
import org.apache.iotdb.cluster.rpc.thrift.HeartBeatResponse;
import org.apache.iotdb.cluster.rpc.thrift.Node;
import org.apache.iotdb.cluster.rpc.thrift.RaftService;
import org.apache.iotdb.cluster.server.NodeCharacter;
import org.apache.iotdb.cluster.server.handlers.caller.ElectionHandler;
import org.apache.iotdb.cluster.server.handlers.caller.HeartbeatHandler;
import org.apache.iotdb.cluster.server.member.RaftMember;
import org.apache.thrift.TException;
import org.apache.thrift.async.AsyncMethodCallback;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeartbeatThread
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(HeartbeatThread.class);
    private RaftMember localMember;
    private String memberName;
    HeartBeatRequest request = new HeartBeatRequest();
    ElectionRequest electionRequest = new ElectionRequest();
    private Random random = new Random();
    boolean hasHadLeader = false;

    HeartbeatThread(RaftMember localMember) {
        this.localMember = localMember;
        this.memberName = localMember.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        logger.info("{}: Heartbeat thread starts...", (Object)this.memberName);
        long electionWait = this.getElectionRandomWaitMs();
        try {
            logger.info("{}: Sleep {}ms before first election", (Object)this.memberName, (Object)electionWait);
            Thread.sleep(electionWait);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        block15: while (!Thread.interrupted()) {
            try {
                switch (this.localMember.getCharacter()) {
                    case LEADER: {
                        this.sendHeartbeats();
                        Object e = this.localMember.getHeartBeatWaitObject();
                        synchronized (e) {
                            this.localMember.getHeartBeatWaitObject().wait(ClusterConstant.getHeartbeatIntervalMs());
                        }
                        this.hasHadLeader = true;
                        continue block15;
                    }
                    case FOLLOWER: {
                        long heartbeatInterval = System.currentTimeMillis() - this.localMember.getLastHeartbeatReceivedTime();
                        long randomElectionTimeout = ClusterConstant.getElectionTimeoutMs() + this.getElectionRandomWaitMs();
                        if (heartbeatInterval >= randomElectionTimeout) {
                            logger.info("{}: The leader {} timed out", (Object)this.memberName, (Object)this.localMember.getLeader());
                            this.localMember.setCharacter(NodeCharacter.ELECTOR);
                            this.localMember.setLeader(ClusterConstant.EMPTY_NODE);
                        } else {
                            logger.debug("{}: Heartbeat from leader {} is still valid", (Object)this.memberName, (Object)this.localMember.getLeader());
                            Object object = this.localMember.getHeartBeatWaitObject();
                            synchronized (object) {
                                long leastWaitTime = this.localMember.getLastHeartbeatReceivedTime() + randomElectionTimeout - System.currentTimeMillis();
                                this.localMember.getHeartBeatWaitObject().wait(leastWaitTime);
                            }
                        }
                        this.hasHadLeader = true;
                        continue block15;
                    }
                }
                this.onElectionsStart();
                this.startElections();
                this.onElectionsEnd();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
            catch (Exception e) {
                logger.error("{}: Unexpected heartbeat exception:", (Object)this.memberName, (Object)e);
            }
        }
        logger.info("{}: Heartbeat thread exits", (Object)this.memberName);
    }

    protected void onElectionsStart() {
        logger.info("{}: Start elections", (Object)this.memberName);
    }

    protected void onElectionsEnd() {
        logger.info("{}: End elections", (Object)this.memberName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendHeartbeats() {
        AtomicLong atomicLong = this.localMember.getTerm();
        synchronized (atomicLong) {
            this.request.setTerm(this.localMember.getTerm().get());
            this.request.setLeader(this.localMember.getThisNode());
            this.request.setCommitLogIndex(this.localMember.getLogManager().getCommitLogIndex());
            this.request.setCommitLogTerm(this.localMember.getLogManager().getCommitLogTerm());
            this.sendHeartbeats(this.localMember.getAllNodes());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendHeartbeats(Collection<Node> nodes) {
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Send heartbeat to {} followers, commit log index = {}", new Object[]{this.memberName, nodes.size() - 1, this.request.getCommitLogIndex()});
        }
        Collection<Node> collection = nodes;
        synchronized (collection) {
            for (Node node : nodes) {
                if (node.equals(this.localMember.getThisNode())) continue;
                if (Thread.currentThread().isInterrupted()) {
                    Thread.currentThread().interrupt();
                    return;
                }
                if (this.localMember.getCharacter() != NodeCharacter.LEADER) {
                    logger.warn("The leadership of node {} is ended.", (Object)this.localMember.getThisNode());
                    return;
                }
                if (ClusterDescriptor.getInstance().getConfig().isUseAsyncServer()) {
                    this.sendHeartbeatAsync(node);
                    continue;
                }
                this.sendHeartbeatSync(node);
            }
        }
    }

    void sendHeartbeatAsync(Node node) {
        RaftService.AsyncClient client = this.localMember.getAsyncHeartbeatClient(node);
        if (client != null) {
            try {
                logger.debug("{}: Sending heartbeat to {}", (Object)this.memberName, (Object)node);
                client.sendHeartbeat(this.request, (AsyncMethodCallback)new HeartbeatHandler(this.localMember, node));
            }
            catch (Exception e) {
                logger.warn("{}: Cannot send heart beat to node {}", new Object[]{this.memberName, node, e});
            }
        }
    }

    void sendHeartbeatSync(Node node) {
        HeartbeatHandler heartbeatHandler = new HeartbeatHandler(this.localMember, node);
        HeartBeatRequest req = new HeartBeatRequest();
        req.setCommitLogTerm(this.request.commitLogTerm);
        req.setCommitLogIndex(this.request.commitLogIndex);
        req.setRegenerateIdentifier(this.request.regenerateIdentifier);
        req.setRequireIdentifier(this.request.requireIdentifier);
        req.setTerm(this.request.term);
        req.setLeader(this.localMember.getThisNode());
        if (this.request.isSetHeader()) {
            req.setHeader(this.request.header);
        }
        if (this.request.isSetPartitionTableBytes()) {
            req.partitionTableBytes = this.request.partitionTableBytes;
            req.setPartitionTableBytesIsSet(true);
        }
        this.localMember.getSerialToParallelPool().submit(() -> {
            RaftService.Client client = this.localMember.getSyncHeartbeatClient(node);
            if (client != null) {
                try {
                    logger.debug("{}: Sending heartbeat to {}", (Object)this.memberName, (Object)node);
                    HeartBeatResponse heartBeatResponse = client.sendHeartbeat(req);
                    heartbeatHandler.onComplete(heartBeatResponse);
                }
                catch (TTransportException e) {
                    if (ClusterIoTDB.getInstance().shouldPrintClientConnectionErrorStack()) {
                        logger.warn("{}: Cannot send heartbeat to node {} due to network", new Object[]{this.memberName, node, e});
                    } else {
                        logger.warn("{}: Cannot send heartbeat to node {} due to network", (Object)this.memberName, (Object)node);
                    }
                    client.getInputProtocol().getTransport().close();
                }
                catch (Exception e) {
                    logger.warn(this.memberName + ": Cannot send heart beat to node " + node.toString(), (Throwable)e);
                }
                finally {
                    this.localMember.returnSyncClient(client);
                }
            }
        });
    }

    private void startElections() throws InterruptedException {
        if (this.localMember.getAllNodes().size() == 1) {
            this.localMember.setCharacter(NodeCharacter.LEADER);
            this.localMember.setLeader(this.localMember.getThisNode());
            logger.info("{}: Winning the election because the node is the only node.", (Object)this.memberName);
        }
        while (this.localMember.getCharacter() == NodeCharacter.ELECTOR) {
            this.startElection();
            if (this.localMember.getCharacter() != NodeCharacter.ELECTOR) continue;
            long electionWait = this.getElectionRandomWaitMs();
            logger.info("{}: Sleep {}ms until next election", (Object)this.memberName, (Object)electionWait);
            Thread.sleep(electionWait);
        }
        this.localMember.setLastHeartbeatReceivedTime(System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startElection() {
        if (this.localMember.isSkipElection()) {
            logger.info("{}: Skip election because this node has stopped.", (Object)this.memberName);
            return;
        }
        AtomicLong atomicLong = this.localMember.getTerm();
        synchronized (atomicLong) {
            long nextTerm = this.localMember.getTerm().incrementAndGet();
            this.localMember.setVoteFor(this.localMember.getThisNode());
            this.localMember.updateHardState(nextTerm, this.localMember.getVoteFor());
            int quorumNum = this.localMember.getAllNodes().size() / 2;
            logger.info("{}: Election {} starts, quorum: {}", new Object[]{this.memberName, nextTerm, quorumNum});
            AtomicBoolean electionTerminated = new AtomicBoolean(false);
            AtomicBoolean electionValid = new AtomicBoolean(false);
            AtomicInteger quorum = new AtomicInteger(quorumNum);
            AtomicInteger failingVoteCounter = new AtomicInteger(quorumNum + 1);
            this.electionRequest.setTerm(nextTerm);
            this.electionRequest.setElector(this.localMember.getThisNode());
            this.electionRequest.setLastLogTerm(this.localMember.getLogManager().getLastLogTerm());
            this.electionRequest.setLastLogIndex(this.localMember.getLogManager().getLastLogIndex());
            this.requestVote(this.localMember.getAllNodes(), this.electionRequest, nextTerm, quorum, electionTerminated, electionValid, failingVoteCounter);
            this.electionRequest.unsetLastLogIndex();
            try {
                logger.info("{}: Wait for {}ms until election time out", (Object)this.memberName, (Object)ClusterConstant.getElectionTimeoutMs());
                this.localMember.getTerm().wait(ClusterConstant.getElectionTimeoutMs());
            }
            catch (InterruptedException e) {
                logger.info("{}: Unexpected interruption when waiting the result of election {}", (Object)this.memberName, (Object)nextTerm);
                Thread.currentThread().interrupt();
            }
            electionTerminated.set(true);
            if (electionValid.get()) {
                logger.info("{}: Election {} accepted", (Object)this.memberName, (Object)nextTerm);
                this.localMember.setCharacter(NodeCharacter.LEADER);
                this.localMember.setLeader(this.localMember.getThisNode());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestVote(Collection<Node> nodes, ElectionRequest request, long nextTerm, AtomicInteger quorum, AtomicBoolean electionTerminated, AtomicBoolean electionValid, AtomicInteger failingVoteCounter) {
        Collection<Node> collection = nodes;
        synchronized (collection) {
            for (Node node : nodes) {
                if (node.equals(this.localMember.getThisNode())) continue;
                ElectionHandler handler = new ElectionHandler(this.localMember, node, nextTerm, quorum, electionTerminated, electionValid, failingVoteCounter);
                if (ClusterDescriptor.getInstance().getConfig().isUseAsyncServer()) {
                    this.requestVoteAsync(node, handler, request);
                    continue;
                }
                this.requestVoteSync(node, handler, request);
            }
        }
    }

    private void requestVoteAsync(Node node, ElectionHandler handler, ElectionRequest request) {
        RaftService.AsyncClient client = this.localMember.getAsyncHeartbeatClient(node);
        if (client != null) {
            logger.info("{}: Requesting a vote from {}", (Object)this.memberName, (Object)node);
            try {
                client.startElection(request, (AsyncMethodCallback)handler);
            }
            catch (Exception e) {
                logger.error("{}: Cannot request a vote from {}", new Object[]{this.memberName, node, e});
            }
        }
    }

    private void requestVoteSync(Node node, ElectionHandler handler, ElectionRequest request) {
        this.localMember.getSerialToParallelPool().submit(() -> {
            RaftService.Client client = this.localMember.getSyncHeartbeatClient(node);
            if (client != null) {
                logger.info("{}: Requesting a vote from {}", (Object)this.memberName, (Object)node);
                try {
                    long result = client.startElection(request);
                    handler.onComplete(result);
                }
                catch (TException e) {
                    client.getInputProtocol().getTransport().close();
                    logger.warn(this.memberName + ": Cannot request a vote from " + node.toString() + " due to network", (Throwable)e);
                    handler.onError((Exception)((Object)e));
                }
                catch (Exception e) {
                    handler.onError(e);
                }
                finally {
                    this.localMember.returnSyncClient(client);
                }
            }
        });
    }

    private long getElectionRandomWaitMs() {
        return Math.abs(this.random.nextLong() % ClusterConstant.getElectionMaxWaitMs());
    }
}

