/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.service.thrift.handler;

import java.net.Socket;
import java.util.ServiceLoader;
import org.apache.iotdb.db.query.control.SessionManager;
import org.apache.iotdb.db.query.control.clientsession.ClientSession;
import org.apache.iotdb.external.api.thrift.JudgableServerContext;
import org.apache.iotdb.external.api.thrift.ServerContextFactory;
import org.apache.iotdb.rpc.TElasticFramedTransport;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.server.ServerContext;
import org.apache.thrift.transport.TSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseServerContextHandler {
    private static ServerContextFactory factory = null;
    private static final Logger logger = LoggerFactory.getLogger(BaseServerContextHandler.class);

    public ServerContext createContext(TProtocol in, TProtocol out) {
        Socket socket = ((TSocket)((TElasticFramedTransport)out.getTransport()).getSocket()).getSocket();
        JudgableServerContext context = null;
        this.getSessionManager().registerSession(new ClientSession(socket));
        if (factory != null && !(context = factory.newServerContext(out, socket)).whenConnecte()) {
            return context;
        }
        return context;
    }

    public void deleteContext(ServerContext context, TProtocol in, TProtocol out) {
        this.getSessionManager().removeCurrSession();
        if (context != null && factory != null) {
            ((JudgableServerContext)context).whenDisconnect();
        }
    }

    protected SessionManager getSessionManager() {
        return SessionManager.getInstance();
    }

    static {
        ServiceLoader<ServerContextFactory> contextFactoryLoader = ServiceLoader.load(ServerContextFactory.class);
        for (ServerContextFactory loader : contextFactoryLoader) {
            if (factory != null) {
                logger.warn("There are more than one ServerContextFactory implementation. pls check.");
            }
            logger.info("Will set ServerContextFactory from {} ", (Object)loader.getClass().getName());
            factory = loader;
        }
    }
}

