/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.externalsort.serialize.impl;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.iotdb.db.query.externalsort.serialize.IExternalSortFileSerializer;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.utils.BytesUtils;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class FixLengthTimeValuePairSerializer
implements IExternalSortFileSerializer {
    private TimeValuePairWriter writer;
    private OutputStream outputStream;
    private boolean dataTypeDefined;

    public FixLengthTimeValuePairSerializer(String tmpFilePath) throws IOException {
        this.checkPath(tmpFilePath);
        this.outputStream = new BufferedOutputStream(new FileOutputStream(tmpFilePath));
    }

    @Override
    public void write(TimeValuePair timeValuePair) throws IOException {
        if (!this.dataTypeDefined) {
            this.setWriter(timeValuePair.getValue().getDataType());
            this.writeHeader(timeValuePair.getValue().getDataType());
            this.dataTypeDefined = true;
        }
        this.writer.write(timeValuePair, this.outputStream);
    }

    @Override
    public void close() throws IOException {
        this.outputStream.close();
    }

    private void writeHeader(TSDataType dataType) throws IOException {
        ReadWriteIOUtils.write((TSDataType)dataType, (OutputStream)this.outputStream);
    }

    private void checkPath(String tmpFilePath) throws IOException {
        File file = new File(tmpFilePath);
        if (file.exists()) {
            file.delete();
        }
        if (file.getParentFile() != null) {
            file.getParentFile().mkdirs();
        }
        file.createNewFile();
    }

    private void setWriter(TSDataType type) {
        switch (type) {
            case BOOLEAN: {
                this.writer = new TimeValuePairWriter.BooleanWriter();
                break;
            }
            case INT32: {
                this.writer = new TimeValuePairWriter.IntWriter();
                break;
            }
            case INT64: {
                this.writer = new TimeValuePairWriter.LongWriter();
                break;
            }
            case FLOAT: {
                this.writer = new TimeValuePairWriter.FloatWriter();
                break;
            }
            case DOUBLE: {
                this.writer = new TimeValuePairWriter.DoubleWriter();
                break;
            }
            case TEXT: {
                this.writer = new TimeValuePairWriter.BinaryWriter();
                break;
            }
            default: {
                throw new RuntimeException("Unknown TSDataType in FixLengthTimeValuePairSerializer:" + type);
            }
        }
    }

    private static abstract class TimeValuePairWriter {
        private TimeValuePairWriter() {
        }

        public abstract void write(TimeValuePair var1, OutputStream var2) throws IOException;

        private static class BinaryWriter
        extends TimeValuePairWriter {
            private BinaryWriter() {
            }

            @Override
            public void write(TimeValuePair tvPair, OutputStream outputStream) throws IOException {
                outputStream.write(BytesUtils.longToBytes((long)tvPair.getTimestamp()));
                outputStream.write(BytesUtils.intToBytes((int)tvPair.getValue().getBinary().getLength()));
                outputStream.write(BytesUtils.stringToBytes((String)tvPair.getValue().getBinary().getStringValue()));
            }
        }

        private static class DoubleWriter
        extends TimeValuePairWriter {
            private DoubleWriter() {
            }

            @Override
            public void write(TimeValuePair tvPair, OutputStream outputStream) throws IOException {
                outputStream.write(BytesUtils.longToBytes((long)tvPair.getTimestamp()));
                outputStream.write(BytesUtils.doubleToBytes((double)tvPair.getValue().getDouble()));
            }
        }

        private static class FloatWriter
        extends TimeValuePairWriter {
            private FloatWriter() {
            }

            @Override
            public void write(TimeValuePair tvPair, OutputStream outputStream) throws IOException {
                outputStream.write(BytesUtils.longToBytes((long)tvPair.getTimestamp()));
                outputStream.write(BytesUtils.floatToBytes((float)tvPair.getValue().getFloat()));
            }
        }

        private static class LongWriter
        extends TimeValuePairWriter {
            private LongWriter() {
            }

            @Override
            public void write(TimeValuePair tvPair, OutputStream outputStream) throws IOException {
                outputStream.write(BytesUtils.longToBytes((long)tvPair.getTimestamp()));
                outputStream.write(BytesUtils.longToBytes((long)tvPair.getValue().getLong()));
            }
        }

        private static class IntWriter
        extends TimeValuePairWriter {
            private IntWriter() {
            }

            @Override
            public void write(TimeValuePair tvPair, OutputStream outputStream) throws IOException {
                outputStream.write(BytesUtils.longToBytes((long)tvPair.getTimestamp()));
                outputStream.write(BytesUtils.intToBytes((int)tvPair.getValue().getInt()));
            }
        }

        private static class BooleanWriter
        extends TimeValuePairWriter {
            private BooleanWriter() {
            }

            @Override
            public void write(TimeValuePair tvPair, OutputStream outputStream) throws IOException {
                outputStream.write(BytesUtils.longToBytes((long)tvPair.getTimestamp()));
                outputStream.write(BytesUtils.boolToBytes((boolean)tvPair.getValue().getBoolean()));
            }
        }
    }
}

