/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.strategy;

import java.util.List;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.metadata.utils.MetaUtils;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.logical.sys.LoadConfigurationOperator;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.sys.LoadConfigurationPlan;

public class PhysicalGenerator {
    public PhysicalPlan transformToPhysicalPlan(Operator operator) throws QueryProcessException {
        PhysicalPlan physicalPlan = operator.generatePhysicalPlan(this);
        physicalPlan.setDebug(operator.isDebug());
        physicalPlan.setPrefixMatch(operator.isPrefixMatchPath());
        return physicalPlan;
    }

    public PhysicalPlan generateLoadConfigurationPlan(LoadConfigurationOperator.LoadConfigurationOperatorType type) throws QueryProcessException {
        switch (type) {
            case GLOBAL: {
                return new LoadConfigurationPlan(LoadConfigurationPlan.LoadConfigurationPlanType.GLOBAL);
            }
            case LOCAL: {
                return new LoadConfigurationPlan(LoadConfigurationPlan.LoadConfigurationPlanType.LOCAL);
            }
        }
        throw new QueryProcessException(String.format("Unrecognized load configuration operator type, %s", type.name()));
    }

    public List<PartialPath> groupVectorPaths(List<PartialPath> paths) throws MetadataException {
        return MetaUtils.groupAlignedPaths(paths);
    }
}

