/*
 * Decompiled with CFR 0.152.
 */
package org.schwering.irc.lib;

import java.util.Vector;
import org.schwering.irc.lib.IRCConstants;

public class IRCUtil
implements IRCConstants {
    public static char colorIndicator = (char)3;
    public static char boldIndicator = (char)31;
    public static char underlinedIndicator = (char)2;
    public static char colorEndIndicator = (char)15;
    public static char colorReverseIndicator = (char)22;
    public static char actionIndicator = '\u0001';

    private IRCUtil() {
    }

    public static boolean isChan(String str) {
        char c;
        return str.length() >= 2 && ((c = str.charAt(0)) == '#' || c == '&' || c == '!' || c == '+');
    }

    public static int parseInt(String str) {
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException exc) {
            return -1;
        }
    }

    public static String parseColors(String str) {
        return IRCUtil.parseColors(new StringBuffer(str)).toString();
    }

    public static StringBuffer parseColors(StringBuffer buf) {
        int len = buf.length();
        int i = 0;
        int j = 0;
        while (i < len) {
            char c = buf.charAt(i);
            try {
                if (c == '\u0003') {
                    if ('0' <= (c = buf.charAt(++j)) && c <= '9' && '0' <= (c = buf.charAt(++j)) && c <= '9') {
                        c = buf.charAt(++j);
                    }
                    if (c == ',') {
                        c = buf.charAt(++j);
                    }
                    if ('0' <= c && c <= '9' && '0' <= (c = buf.charAt(++j)) && c <= '9') {
                        c = buf.charAt(++j);
                    }
                } else if (c == '\u0001' || c == '\u001f' || c == '\u0002' || c == '\u000f' || c == '\u0016') {
                    ++j;
                }
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                // empty catch block
            }
            if (j > i) {
                buf = buf.delete(i, j);
                len -= j - i;
                i -= j - i;
            }
            j = ++i;
        }
        return buf;
    }

    public static String[] split(String str, int delim, String trailing) {
        Vector<String> items = new Vector<String>(15);
        int last = 0;
        int index = 0;
        int len = str.length();
        while (index < len) {
            if (str.charAt(index) == delim) {
                items.add(str.substring(last, index));
                last = index + 1;
            }
            ++index;
        }
        if (last != len) {
            items.add(str.substring(last));
        }
        if (trailing != null && trailing.length() != 0) {
            items.add(trailing);
        }
        Object[] result = new String[items.size()];
        items.copyInto(result);
        return result;
    }

    public static String[] split(String str, int delim) {
        return IRCUtil.split(str, delim, null);
    }
}

