/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.formats.inlongmsgcsv;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.descriptors.DescriptorProperties;
import org.apache.flink.types.Row;
import org.apache.inlong.sort.formats.base.TableFormatConstants;
import org.apache.inlong.sort.formats.inlongmsg.FailureHandler;
import org.apache.inlong.sort.formats.inlongmsg.InLongMsgBody;
import org.apache.inlong.sort.formats.inlongmsg.InLongMsgHead;
import org.apache.inlong.sort.formats.inlongmsg.row.AbstractInLongMsgMixedFormatDeserializer;
import org.apache.inlong.sort.formats.inlongmsg.row.InLongMsgTextMixedFormatDeserializerBuilder;
import org.apache.inlong.sort.formats.inlongmsg.row.InLongMsgUtils;
import org.apache.inlong.sort.formats.inlongmsgcsv.InLongMsgCsvUtils;

public final class InLongMsgCsvMixedFormatDeserializer
extends AbstractInLongMsgMixedFormatDeserializer {
    private static final long serialVersionUID = 1L;
    @Nonnull
    private final Character delimiter;
    @Nullable
    private final Character lineDelimiter;
    @Nonnull
    private final String charset;
    @Nullable
    private final Character escapeChar;
    @Nullable
    private final Character quoteChar;
    private final boolean deleteHeadDelimiter;

    public InLongMsgCsvMixedFormatDeserializer(@Nonnull String charset, @Nonnull Character delimiter, @Nullable Character lineDelimiter, @Nullable Character escapeChar, @Nullable Character quoteChar, boolean deleteHeadDelimiter, boolean ignoreErrors) {
        this(charset, delimiter, lineDelimiter, escapeChar, quoteChar, deleteHeadDelimiter, InLongMsgUtils.getDefaultExceptionHandler(ignoreErrors));
    }

    public InLongMsgCsvMixedFormatDeserializer(@Nonnull String charset, @Nonnull Character delimiter, @Nullable Character lineDelimiter, @Nullable Character escapeChar, @Nullable Character quoteChar, boolean deleteHeadDelimiter, @Nonnull FailureHandler failureHandler) {
        super(failureHandler);
        this.charset = charset;
        this.delimiter = delimiter;
        this.lineDelimiter = lineDelimiter;
        this.escapeChar = escapeChar;
        this.quoteChar = quoteChar;
        this.deleteHeadDelimiter = deleteHeadDelimiter;
    }

    public TypeInformation<Row> getProducedType() {
        return InLongMsgUtils.MIXED_ROW_TYPE;
    }

    @Override
    protected InLongMsgHead parseHead(String attr) {
        return InLongMsgCsvUtils.parseHead(attr);
    }

    @Override
    protected List<InLongMsgBody> parseBodyList(byte[] bytes) {
        return InLongMsgCsvUtils.parseBodyList(bytes, this.charset, this.delimiter.charValue(), this.lineDelimiter, this.escapeChar, this.quoteChar, this.deleteHeadDelimiter);
    }

    @Override
    protected List<Row> convertRows(InLongMsgHead head, InLongMsgBody body) {
        Row row = InLongMsgUtils.buildMixedRow(head, body, head.getStreamId());
        return Collections.singletonList(row);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || ((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        InLongMsgCsvMixedFormatDeserializer that = (InLongMsgCsvMixedFormatDeserializer)((Object)object);
        return this.charset.equals(that.charset) && this.delimiter.equals(that.delimiter) && Objects.equals(this.lineDelimiter, that.lineDelimiter) && Objects.equals(this.escapeChar, that.escapeChar) && Objects.equals(this.quoteChar, that.quoteChar) && this.deleteHeadDelimiter == that.deleteHeadDelimiter;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.delimiter, this.lineDelimiter, this.charset, this.escapeChar, this.quoteChar, this.deleteHeadDelimiter);
    }

    public static class Builder
    extends InLongMsgTextMixedFormatDeserializerBuilder<Builder> {
        private Character delimiter = Character.valueOf(',');
        private Character lineDelimiter = TableFormatConstants.DEFAULT_LINE_DELIMITER;
        private Boolean deleteHeadDelimiter = true;

        public Builder setDelimiter(char delimiter) {
            this.delimiter = Character.valueOf(delimiter);
            return this;
        }

        public Builder setLineDelimiter(char lineDelimiter) {
            this.lineDelimiter = Character.valueOf(lineDelimiter);
            return this;
        }

        public Builder setDeleteHeadDelimiter(boolean deleteHeadDelimiter) {
            this.deleteHeadDelimiter = deleteHeadDelimiter;
            return this;
        }

        @Override
        public Builder configure(DescriptorProperties descriptorProperties) {
            super.configure(descriptorProperties);
            descriptorProperties.getOptionalCharacter("format.delimiter").ifPresent(this::setDelimiter);
            descriptorProperties.getOptionalCharacter("format.line-delimiter").ifPresent(this::setLineDelimiter);
            descriptorProperties.getOptionalBoolean("format.delete-head-delimiter").ifPresent(this::setDeleteHeadDelimiter);
            return this;
        }

        public InLongMsgCsvMixedFormatDeserializer build() {
            return new InLongMsgCsvMixedFormatDeserializer(this.charset, this.delimiter, this.lineDelimiter, this.escapeChar, this.quoteChar, (boolean)this.deleteHeadDelimiter, this.ignoreErrors);
        }
    }
}

