/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.formats.csv;

import java.nio.charset.Charset;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.types.Row;
import org.apache.inlong.common.pojo.sort.dataflow.field.format.FormatInfo;
import org.apache.inlong.common.pojo.sort.dataflow.field.format.RowFormatInfo;
import org.apache.inlong.sort.formats.base.DefaultDeserializationSchema;
import org.apache.inlong.sort.formats.base.TableFormatForRowUtils;
import org.apache.inlong.sort.formats.base.TableFormatUtils;
import org.apache.inlong.sort.formats.base.util.LogCounter;
import org.apache.inlong.sort.formats.csv.CsvFormatBuilder;
import org.apache.inlong.sort.formats.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CsvDeserializationSchema
extends DefaultDeserializationSchema<Row> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(CsvDeserializationSchema.class);
    @Nonnull
    private final RowFormatInfo rowFormatInfo;
    @Nonnull
    private final String charset;
    @Nonnull
    private final Character delimiter;
    @Nullable
    private final Character escapeChar;
    @Nullable
    private final Character quoteChar;
    @Nullable
    private final String nullLiteral;
    private long failureCount = 0L;
    private LogCounter logCounter = new LogCounter(10, 1000, 60000);

    public CsvDeserializationSchema(@Nonnull RowFormatInfo rowFormatInfo, @Nonnull String charset, @Nonnull Character delimiter, @Nullable Character escapeChar, @Nullable Character quoteChar, @Nullable String nullLiteral, boolean ignoreErrors) {
        super(ignoreErrors);
        this.rowFormatInfo = rowFormatInfo;
        this.charset = charset;
        this.delimiter = delimiter;
        this.escapeChar = escapeChar;
        this.quoteChar = quoteChar;
        this.nullLiteral = nullLiteral;
    }

    public CsvDeserializationSchema(@Nonnull RowFormatInfo rowFormatInfo) {
        this(rowFormatInfo, "UTF-8", Character.valueOf(','), null, null, null, false);
    }

    public TypeInformation<Row> getProducedType() {
        return TableFormatForRowUtils.getType(this.rowFormatInfo.getTypeInfo());
    }

    public boolean isEndOfStream(Row t2) {
        return false;
    }

    @Override
    protected Row deserializeInternal(byte[] bytes) {
        String text = new String(bytes, Charset.forName(this.charset));
        try {
            String[] fieldNames = this.rowFormatInfo.getFieldNames();
            FormatInfo[] fieldFormatInfos = this.rowFormatInfo.getFieldFormatInfos();
            String[] fieldTexts = StringUtils.splitCsv(text, this.delimiter, this.escapeChar, this.quoteChar);
            if (fieldTexts.length != fieldNames.length) {
                this.failureCount = this.logCounter.increment();
                if (this.logCounter.shouldPrint()) {
                    LOG.warn("The number of fields mismatches: expected=[{}], actual=[{}]. The total mismatched data has accumulated to [{}].", fieldNames.length, fieldTexts.length, this.failureCount);
                }
            }
            Row row = new Row(fieldNames.length);
            for (int i = 0; i < fieldNames.length; ++i) {
                if (i >= fieldTexts.length) {
                    row.setField(i, null);
                    continue;
                }
                Object field = TableFormatUtils.deserializeBasicField(fieldNames[i], fieldFormatInfos[i], fieldTexts[i], this.nullLiteral, null);
                row.setField(i, field);
            }
            return row;
        }
        catch (Throwable t2) {
            throw new RuntimeException(String.format("Could not properly deserialize csv. Text=[%s].", text), t2);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CsvDeserializationSchema that = (CsvDeserializationSchema)o;
        return this.rowFormatInfo.equals(that.rowFormatInfo) && Objects.equals(this.charset, that.charset) && Objects.equals(this.delimiter, that.delimiter) && Objects.equals(this.escapeChar, that.escapeChar) && Objects.equals(this.quoteChar, that.quoteChar) && Objects.equals(this.nullLiteral, that.nullLiteral) && this.ignoreErrors == that.ignoreErrors;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.rowFormatInfo, this.charset, this.delimiter, this.escapeChar, this.quoteChar, this.nullLiteral, this.ignoreErrors);
    }

    public static class Builder
    extends CsvFormatBuilder<Builder> {
        public Builder(RowFormatInfo rowFormatInfo) {
            super(rowFormatInfo);
        }

        public CsvDeserializationSchema build() {
            return new CsvDeserializationSchema(this.rowFormatInfo, this.charset, Character.valueOf(this.delimiter), this.escapeChar, this.quoteChar, this.nullLiteral, this.ignoreErrors);
        }
    }
}

