/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.formats.base.util;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;

public class LogCounter
implements Serializable {
    private AtomicInteger counter = new AtomicInteger(0);
    private int start;
    private int control;
    private int reset;
    private long lastLogTime = System.currentTimeMillis();

    public LogCounter(int start, int control, int reset) {
        this.start = start;
        this.control = control;
        this.reset = reset;
    }

    public boolean shouldPrint() {
        if (this.start == this.control) {
            return true;
        }
        if (System.currentTimeMillis() - this.lastLogTime > (long)this.reset) {
            this.counter.set(0);
            this.lastLogTime = System.currentTimeMillis();
        }
        return this.counter.get() <= this.start || this.counter.get() % this.control == 0;
    }

    public int increment() {
        return this.counter.incrementAndGet();
    }
}

