/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.json.debezium;

import java.util.Objects;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.formats.common.TimestampFormat;
import org.apache.flink.formats.json.JsonFormatOptions;
import org.apache.flink.formats.json.JsonRowDataSerializationSchema;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.utils.TypeConversions;

public class DebeziumJsonSerializationSchema
implements SerializationSchema<RowData> {
    private static final long serialVersionUID = 1L;
    private static final StringData OP_INSERT = StringData.fromString((String)"c");
    private static final StringData OP_DELETE = StringData.fromString((String)"d");
    private final JsonRowDataSerializationSchema jsonSerializer;
    private transient GenericRowData genericRowData;

    public DebeziumJsonSerializationSchema(RowType rowType, TimestampFormat timestampFormat, JsonFormatOptions.MapNullKeyMode mapNullKeyMode, String mapNullKeyLiteral, boolean encodeDecimalAsPlainNumber) {
        this.jsonSerializer = new JsonRowDataSerializationSchema(DebeziumJsonSerializationSchema.createJsonRowType(TypeConversions.fromLogicalToDataType((LogicalType)rowType)), timestampFormat, mapNullKeyMode, mapNullKeyLiteral, encodeDecimalAsPlainNumber);
    }

    public void open(SerializationSchema.InitializationContext context) {
        this.genericRowData = new GenericRowData(3);
    }

    public byte[] serialize(RowData rowData) {
        try {
            switch (rowData.getRowKind()) {
                case INSERT: 
                case UPDATE_AFTER: {
                    this.genericRowData.setField(0, null);
                    this.genericRowData.setField(1, (Object)rowData);
                    this.genericRowData.setField(2, (Object)OP_INSERT);
                    return this.jsonSerializer.serialize((RowData)this.genericRowData);
                }
                case UPDATE_BEFORE: 
                case DELETE: {
                    this.genericRowData.setField(0, (Object)rowData);
                    this.genericRowData.setField(1, null);
                    this.genericRowData.setField(2, (Object)OP_DELETE);
                    return this.jsonSerializer.serialize((RowData)this.genericRowData);
                }
            }
            throw new UnsupportedOperationException(String.format("Unsupported operation '%s' for row kind.", rowData.getRowKind()));
        }
        catch (Throwable t2) {
            throw new RuntimeException(String.format("Could not serialize row '%s'.", rowData), t2);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DebeziumJsonSerializationSchema that = (DebeziumJsonSerializationSchema)o;
        return Objects.equals(this.jsonSerializer, that.jsonSerializer);
    }

    public int hashCode() {
        return Objects.hash(this.jsonSerializer);
    }

    private static RowType createJsonRowType(DataType databaseSchema) {
        return (RowType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"before", (DataType)databaseSchema), DataTypes.FIELD((String)"after", (DataType)databaseSchema), DataTypes.FIELD((String)"op", (DataType)DataTypes.STRING())}).getLogicalType();
    }
}

