/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.dataproxy.sink.common;

import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.flume.Channel;
import org.apache.flume.Context;
import org.apache.inlong.common.metric.MetricItemSet;
import org.apache.inlong.common.metric.MetricRegister;
import org.apache.inlong.dataproxy.config.CommonConfigHolder;
import org.apache.inlong.dataproxy.config.pojo.CacheClusterConfig;
import org.apache.inlong.dataproxy.metrics.DataProxyMetricItemSet;
import org.apache.inlong.dataproxy.metrics.stats.MonitorIndex;
import org.apache.inlong.dataproxy.metrics.stats.MonitorStats;
import org.apache.inlong.dataproxy.sink.common.EventHandler;
import org.apache.inlong.dataproxy.sink.mq.MessageQueueHandler;
import org.apache.inlong.dataproxy.sink.mq.PackProfile;
import org.apache.inlong.dataproxy.sink.mq.SimplePackProfile;
import org.apache.inlong.dataproxy.sink.mq.pulsar.PulsarHandler;
import org.apache.inlong.dataproxy.utils.DateTimeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SinkContext {
    public static final String KEY_MAX_THREADS = "maxThreads";
    public static final String KEY_PROCESSINTERVAL = "processInterval";
    public static final String KEY_RELOADINTERVAL = "reloadInterval";
    public static final String KEY_MESSAGE_QUEUE_HANDLER = "messageQueueHandler";
    protected static final Logger logger = LoggerFactory.getLogger(SinkContext.class);
    protected final String clusterId;
    protected final String sinkName;
    protected final Context sinkContext;
    protected final Channel channel;
    protected final int maxThreads;
    protected final long processInterval;
    protected final long reloadInterval;
    protected final DataProxyMetricItemSet metricItemSet;
    protected MonitorIndex monitorIndex = null;
    private MonitorStats monitorStats = null;
    private final boolean enableFileMetric;

    public SinkContext(String sinkName, Context context, Channel channel) {
        this.sinkName = sinkName;
        this.sinkContext = context;
        this.channel = channel;
        this.clusterId = CommonConfigHolder.getInstance().getClusterName();
        this.maxThreads = this.sinkContext.getInteger(KEY_MAX_THREADS, Integer.valueOf(10));
        this.processInterval = this.sinkContext.getInteger(KEY_PROCESSINTERVAL, Integer.valueOf(100)).intValue();
        this.reloadInterval = this.sinkContext.getLong(KEY_RELOADINTERVAL, Long.valueOf(60000L));
        this.enableFileMetric = CommonConfigHolder.getInstance().isEnableFileMetric();
        this.metricItemSet = new DataProxyMetricItemSet(sinkName);
        MetricRegister.register((MetricItemSet)this.metricItemSet);
    }

    public void start() {
        if (this.enableFileMetric) {
            this.monitorIndex = new MonitorIndex(CommonConfigHolder.getInstance().getFileMetricSinkOutName(), (long)CommonConfigHolder.getInstance().getFileMetricStatInvlSec() * 1000L, CommonConfigHolder.getInstance().getFileMetricStatCacheCnt());
            this.monitorStats = new MonitorStats(CommonConfigHolder.getInstance().getFileMetricEventOutName() + "#" + this.getSinkName(), (long)CommonConfigHolder.getInstance().getFileMetricStatInvlSec() * 1000L, CommonConfigHolder.getInstance().getFileMetricStatCacheCnt());
            this.monitorIndex.start();
            this.monitorStats.start();
        }
    }

    public void close() {
        if (this.enableFileMetric) {
            if (this.monitorIndex != null) {
                this.monitorIndex.stop();
            }
            if (this.monitorStats != null) {
                this.monitorStats.stop();
            }
        }
    }

    public void fileMetricIncSumStats(String eventKey) {
        if (this.enableFileMetric) {
            this.monitorStats.incSumStats(eventKey);
        }
    }

    public void fileMetricIncWithDetailStats(String eventKey, String detailInfoKey) {
        if (this.enableFileMetric) {
            this.monitorStats.incSumStats(eventKey);
            this.monitorStats.incDetailStats(eventKey + "#" + detailInfoKey);
        }
    }

    public void fileMetricAddSuccStats(PackProfile profile, String topic, String brokerIP) {
        if (!this.enableFileMetric || !(profile instanceof SimplePackProfile)) {
            return;
        }
        this.fileMetricIncStats((SimplePackProfile)profile, true, topic, brokerIP, "sink.success", "");
    }

    public void fileMetricAddFailStats(PackProfile profile, String topic, String brokerIP, String detailKey) {
        if (!this.enableFileMetric || !(profile instanceof SimplePackProfile)) {
            return;
        }
        this.fileMetricIncStats((SimplePackProfile)profile, false, topic, brokerIP, "sink.failure", detailKey);
    }

    public void fileMetricAddExceptStats(PackProfile profile, String topic, String brokerIP, String detailKey) {
        if (!this.enableFileMetric || !(profile instanceof SimplePackProfile)) {
            return;
        }
        this.fileMetricIncStats((SimplePackProfile)profile, false, topic, brokerIP, "sink.rcvexcept", detailKey);
    }

    private void fileMetricIncStats(SimplePackProfile profile, boolean isSucc, String topic, String brokerIP, String eventKey, String detailInfoKey) {
        long dtL = Long.parseLong(profile.getProperties().get("dt"));
        long pkgTimeL = Long.parseLong(profile.getProperties().get("msg.pkg.time"));
        StringBuilder statsKey = new StringBuilder(512).append(this.sinkName).append("#").append(profile.getInlongGroupId()).append("#").append(profile.getInlongStreamId()).append("#").append(topic).append("#").append(profile.getProperties().get("dpIp")).append("#").append(brokerIP).append("#").append(DateTimeUtils.ms2yyyyMMddHHmmTenMins(dtL)).append("#").append(DateTimeUtils.ms2yyyyMMddHHmm(pkgTimeL));
        if (isSucc) {
            this.monitorIndex.addSuccStats(statsKey.toString(), NumberUtils.toInt((String)profile.getProperties().get("msgcnt"), (int)1), 1, profile.getSize());
            this.monitorStats.incSumStats(eventKey);
        } else {
            this.monitorIndex.addFailStats(statsKey.toString(), 1);
            this.monitorStats.incSumStats(eventKey);
            this.monitorStats.incDetailStats(eventKey + "#" + detailInfoKey);
        }
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public String getSinkName() {
        return this.sinkName;
    }

    public Context getSinkContext() {
        return this.sinkContext;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public int getMaxThreads() {
        return this.maxThreads;
    }

    public long getProcessInterval() {
        return this.processInterval;
    }

    public long getReloadInterval() {
        return this.reloadInterval;
    }

    public DataProxyMetricItemSet getMetricItemSet() {
        return this.metricItemSet;
    }

    public EventHandler createEventHandler() {
        String eventHandlerClass = CommonConfigHolder.getInstance().getEventHandler();
        try {
            Class handlerClass = ClassUtils.getClass((String)eventHandlerClass);
            Object handlerObject = handlerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (handlerObject instanceof EventHandler) {
                return (EventHandler)handlerObject;
            }
        }
        catch (Throwable t) {
            logger.error("{} fail to init EventHandler,handlerClass:{},error:{}", new Object[]{this.sinkName, eventHandlerClass, t.getMessage(), t});
        }
        return null;
    }

    public MessageQueueHandler createMessageQueueHandler(CacheClusterConfig config) {
        String strHandlerClass = config.getParams().getOrDefault(KEY_MESSAGE_QUEUE_HANDLER, PulsarHandler.class.getName());
        logger.info("{}'s mq handler class = {}", (Object)this.sinkName, (Object)strHandlerClass);
        try {
            Class handlerClass = ClassUtils.getClass((String)strHandlerClass);
            Object handlerObject = handlerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (handlerObject instanceof MessageQueueHandler) {
                return (MessageQueueHandler)handlerObject;
            }
        }
        catch (Throwable t) {
            logger.error("{} fail to init MessageQueueHandler,handlerClass:{},error:{}", new Object[]{this.sinkName, strHandlerClass, t.getMessage(), t});
        }
        return null;
    }
}

