/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.collection;

import java.util.ArrayList;
import java.util.Collections;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;

@TransformFunction(type="collection", names={"array_reverse"}, parameter="(Array array)", descriptions={"- Return \"\" if 'array' is null;", "- Return an array in reverse order."}, examples={"array_reverse(array('he',7,'xxd')) = [xxd, 7, he]"})
public class ArrayReverseFunction
implements ValueParser {
    private final ValueParser arrayParser;

    public ArrayReverseFunction(Function expr) {
        this.arrayParser = OperatorTools.buildParser((Expression)expr.getParameters().getExpressions().get(0));
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        Object arrayObj = this.arrayParser.parse(sourceData, rowIndex, context);
        if (arrayObj == null) {
            return null;
        }
        if (arrayObj instanceof ArrayList) {
            ArrayList array = (ArrayList)arrayObj;
            if (array.isEmpty()) {
                return null;
            }
            Collections.reverse(array);
            return array;
        }
        return null;
    }
}

