/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.conf;

import com.google.common.base.Preconditions;
import java.util.Locale;
import org.apache.flume.FlumeException;
import org.apache.flume.conf.configfilter.ConfigFilterType;
import org.apache.flume.configfilter.ConfigFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigFilterFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigFilterFactory.class);

    public static ConfigFilter create(String name, String type) throws FlumeException {
        Preconditions.checkNotNull((Object)name, (Object)"name");
        Preconditions.checkNotNull((Object)type, (Object)"type");
        LOGGER.info("Creating instance of configfilter {}, type {}", (Object)name, (Object)type);
        Class<? extends ConfigFilter> aClass = ConfigFilterFactory.getClass(type);
        try {
            ConfigFilter configFilter = aClass.newInstance();
            configFilter.setName(name);
            return configFilter;
        }
        catch (Exception ex) {
            throw new FlumeException("Unable to create configfilter: " + name + ", type: " + type + ", class: " + aClass.getName(), (Throwable)ex);
        }
    }

    public static Class<? extends ConfigFilter> getClass(String type) throws FlumeException {
        String classname = type;
        ConfigFilterType srcType = ConfigFilterType.OTHER;
        try {
            srcType = ConfigFilterType.valueOf(type.toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException ex) {
            LOGGER.debug("Configfilter type {} is a custom type", (Object)type);
        }
        if (srcType != ConfigFilterType.OTHER) {
            classname = srcType.getClassName();
        }
        try {
            return Class.forName(classname);
        }
        catch (Exception ex) {
            throw new FlumeException("Unable to load configfilter type: " + type + ", class: " + classname, (Throwable)ex);
        }
    }
}

