/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.annotation.NotThreadSafe;
import io.debezium.connector.mysql.GtidSet;
import io.debezium.connector.mysql.signal.ExecuteSnapshotKafkaSignal;
import io.debezium.pipeline.source.snapshot.incremental.AbstractIncrementalSnapshotContext;
import io.debezium.pipeline.source.snapshot.incremental.IncrementalSnapshotContext;
import io.debezium.pipeline.spi.OffsetContext;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class MySqlReadOnlyIncrementalSnapshotContext<T>
extends AbstractIncrementalSnapshotContext<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MySqlReadOnlyIncrementalSnapshotContext.class);
    private GtidSet lowWatermark = null;
    private GtidSet highWatermark = null;
    private Long signalOffset;
    private final Queue<ExecuteSnapshotKafkaSignal> executeSnapshotSignals = new ConcurrentLinkedQueue<ExecuteSnapshotKafkaSignal>();
    public static final String SIGNAL_OFFSET = "incremental_snapshot_signal_offset";

    public MySqlReadOnlyIncrementalSnapshotContext() {
        this(true);
    }

    public MySqlReadOnlyIncrementalSnapshotContext(boolean useCatalogBeforeSchema) {
        super(useCatalogBeforeSchema);
    }

    protected static <U> IncrementalSnapshotContext<U> init(MySqlReadOnlyIncrementalSnapshotContext<U> context, Map<String, ?> offsets) {
        AbstractIncrementalSnapshotContext.init(context, offsets);
        Long signalOffset = (Long)offsets.get(SIGNAL_OFFSET);
        context.setSignalOffset(signalOffset);
        return context;
    }

    public static <U> MySqlReadOnlyIncrementalSnapshotContext<U> load(Map<String, ?> offsets) {
        return MySqlReadOnlyIncrementalSnapshotContext.load(offsets, true);
    }

    public static <U> MySqlReadOnlyIncrementalSnapshotContext<U> load(Map<String, ?> offsets, boolean useCatalogBeforeSchema) {
        MySqlReadOnlyIncrementalSnapshotContext context = new MySqlReadOnlyIncrementalSnapshotContext(useCatalogBeforeSchema);
        MySqlReadOnlyIncrementalSnapshotContext.init(context, offsets);
        return context;
    }

    public void setLowWatermark(GtidSet lowWatermark) {
        this.lowWatermark = lowWatermark;
    }

    public void setHighWatermark(GtidSet highWatermark) {
        this.highWatermark = highWatermark.subtract(this.lowWatermark);
    }

    public boolean updateWindowState(OffsetContext offsetContext) {
        String currentGtid = offsetContext.getSourceInfo().getString("gtid");
        if (!this.windowOpened && this.lowWatermark != null) {
            boolean pastLowWatermark;
            boolean bl = pastLowWatermark = !this.lowWatermark.contains(currentGtid);
            if (pastLowWatermark) {
                LOGGER.debug("Current gtid {}, low watermark {}", (Object)currentGtid, (Object)this.lowWatermark);
                this.windowOpened = true;
                this.lowWatermark = null;
            }
        }
        if (this.windowOpened && this.highWatermark != null) {
            boolean pastHighWatermark;
            boolean bl = pastHighWatermark = !this.highWatermark.contains(currentGtid);
            if (pastHighWatermark) {
                LOGGER.debug("Current gtid {}, high watermark {}", (Object)currentGtid, (Object)this.highWatermark);
                this.windowOpened = false;
                this.highWatermark = null;
                return true;
            }
        }
        return false;
    }

    public boolean reachedHighWatermark(OffsetContext offsetContext) {
        long maxTransactionId;
        String currentGtid = offsetContext.getSourceInfo().getString("gtid");
        if (this.highWatermark == null) {
            return false;
        }
        if (currentGtid == null) {
            return true;
        }
        String[] gtid = GtidSet.GTID_DELIMITER.split(currentGtid);
        GtidSet.UUIDSet uuidSet = this.getUuidSet(gtid[0]);
        if (uuidSet != null && (maxTransactionId = uuidSet.getIntervals().stream().mapToLong(GtidSet.Interval::getEnd).max().getAsLong()) <= Long.parseLong(gtid[1])) {
            LOGGER.debug("Heartbeat {} reached high watermark {}", (Object)currentGtid, (Object)this.highWatermark);
            this.windowOpened = false;
            this.highWatermark = null;
            this.lowWatermark = null;
            return true;
        }
        return false;
    }

    private GtidSet.UUIDSet getUuidSet(String serverId) {
        return this.highWatermark.getUUIDSets().isEmpty() ? this.lowWatermark.forServerWithId(serverId) : this.highWatermark.forServerWithId(serverId);
    }

    public boolean serverUuidChanged() {
        return this.highWatermark.getUUIDSets().size() > 1;
    }

    public Long getSignalOffset() {
        return this.signalOffset;
    }

    public void setSignalOffset(Long signalOffset) {
        this.signalOffset = signalOffset;
    }

    public Map<String, Object> store(Map<String, Object> offset) {
        Map snapshotOffset = super.store(offset);
        snapshotOffset.put(SIGNAL_OFFSET, this.signalOffset);
        return snapshotOffset;
    }

    public void enqueueDataCollectionsToSnapshot(List<String> dataCollectionIds, long signalOffset) {
        this.executeSnapshotSignals.add(new ExecuteSnapshotKafkaSignal(dataCollectionIds, signalOffset));
    }

    public ExecuteSnapshotKafkaSignal getExecuteSnapshotSignals() {
        return this.executeSnapshotSignals.poll();
    }

    public boolean hasExecuteSnapshotSignals() {
        return !this.executeSnapshotSignals.isEmpty();
    }
}

