/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.common.validation;

import com.google.common.base.Joiner;
import java.util.Collections;
import java.util.List;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.apache.inlong.manager.common.enums.StringListValuable;
import org.apache.inlong.manager.common.validation.InEnumString;

public class InEnumStringValidator
implements ConstraintValidator<InEnumString, String> {
    private List<String> values;

    public void initialize(InEnumString annotation) {
        StringListValuable[] values = annotation.value().getEnumConstants();
        this.values = values.length == 0 ? Collections.emptyList() : values[0].valueList();
    }

    public boolean isValid(String value, ConstraintValidatorContext context) {
        if (value == null || this.values.contains(value)) {
            return true;
        }
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate(context.getDefaultConstraintMessageTemplate().replace("{value}", Joiner.on((String)",").join(this.values))).addConstraintViolation();
        return false;
    }
}

