/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.client.api.impl;

import org.apache.inlong.manager.client.api.ClientConfiguration;
import org.apache.inlong.manager.client.api.User;
import org.apache.inlong.manager.client.api.inner.client.ClientFactory;
import org.apache.inlong.manager.client.api.inner.client.UserClient;
import org.apache.inlong.manager.client.api.util.ClientUtils;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.pojo.common.PageResult;
import org.apache.inlong.manager.pojo.user.UserInfo;
import org.apache.inlong.manager.pojo.user.UserRequest;

public class UserImpl
implements User {
    private final UserClient userClient;

    public UserImpl(ClientConfiguration configuration) {
        ClientFactory clientFactory = ClientUtils.getClientFactory(configuration);
        this.userClient = clientFactory.getUserClient();
    }

    @Override
    public UserInfo currentUser() {
        return this.userClient.currentUser();
    }

    @Override
    public Integer register(UserRequest userInfo) {
        Preconditions.expectNotBlank((String)userInfo.getName(), (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"username cannot be empty");
        Preconditions.expectNotBlank((String)userInfo.getPassword(), (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"password cannot be empty");
        return this.userClient.register(userInfo);
    }

    @Override
    public UserInfo getById(Integer id) {
        Preconditions.expectNotNull((Object)id, (String)"user id cannot be null");
        return this.userClient.getById(id);
    }

    @Override
    public UserInfo getByName(String name) {
        Preconditions.expectNotBlank((String)name, (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"username cannot be null");
        return this.userClient.getByName(name);
    }

    @Override
    public PageResult<UserInfo> list(UserRequest request) {
        Preconditions.expectNotNull((Object)request, (String)"request cannot be null");
        return this.userClient.list(request);
    }

    @Override
    public Integer update(UserRequest userInfo) {
        Preconditions.expectNotNull((Object)userInfo, (String)"userinfo cannot be null");
        Preconditions.expectNotNull((Object)userInfo.getId(), (String)"user id cannot be null");
        return this.userClient.update(userInfo);
    }

    @Override
    public Boolean delete(Integer id) {
        Preconditions.expectNotNull((Object)id, (String)"user id cannot be null");
        return this.userClient.delete(id);
    }
}

