/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle;

import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.pipeline.spi.Partition;
import io.debezium.util.Collect;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class OraclePartition
implements Partition {
    private static final String SERVER_PARTITION_KEY = "server";
    private final String serverName;

    public OraclePartition(String serverName) {
        this.serverName = serverName;
    }

    public Map<String, String> getSourcePartition() {
        return Collect.hashMapOf((Object)SERVER_PARTITION_KEY, (Object)this.serverName);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        OraclePartition other = (OraclePartition)obj;
        return Objects.equals(this.serverName, other.serverName);
    }

    public int hashCode() {
        return this.serverName.hashCode();
    }

    static class Provider
    implements Partition.Provider<OraclePartition> {
        private final OracleConnectorConfig connectorConfig;

        Provider(OracleConnectorConfig connectorConfig) {
            this.connectorConfig = connectorConfig;
        }

        public Set<OraclePartition> getPartitions() {
            return Collections.singleton(new OraclePartition(this.connectorConfig.getLogicalName()));
        }
    }
}

