/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.stream;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.parser.CCJSqlParserManager;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.create.table.ColDataType;
import net.sf.jsqlparser.statement.create.table.ColumnDefinition;
import net.sf.jsqlparser.statement.create.table.CreateTable;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.consts.InlongConstants;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.enums.GroupStatus;
import org.apache.inlong.manager.common.enums.OperationTarget;
import org.apache.inlong.manager.common.enums.StreamStatus;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.tool.excel.ExcelTool;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.dao.entity.InlongGroupEntity;
import org.apache.inlong.manager.dao.entity.InlongStreamEntity;
import org.apache.inlong.manager.dao.entity.InlongStreamExtEntity;
import org.apache.inlong.manager.dao.entity.InlongStreamFieldEntity;
import org.apache.inlong.manager.dao.entity.StreamSinkEntity;
import org.apache.inlong.manager.dao.mapper.InlongGroupEntityMapper;
import org.apache.inlong.manager.dao.mapper.InlongStreamEntityMapper;
import org.apache.inlong.manager.dao.mapper.InlongStreamExtEntityMapper;
import org.apache.inlong.manager.dao.mapper.InlongStreamFieldEntityMapper;
import org.apache.inlong.manager.dao.mapper.StreamSinkEntityMapper;
import org.apache.inlong.manager.pojo.common.BatchResult;
import org.apache.inlong.manager.pojo.common.OrderFieldEnum;
import org.apache.inlong.manager.pojo.common.OrderTypeEnum;
import org.apache.inlong.manager.pojo.common.PageRequest;
import org.apache.inlong.manager.pojo.common.PageResult;
import org.apache.inlong.manager.pojo.consume.BriefMQMessage;
import org.apache.inlong.manager.pojo.group.InlongGroupInfo;
import org.apache.inlong.manager.pojo.sink.AddFieldRequest;
import org.apache.inlong.manager.pojo.sink.ParseFieldRequest;
import org.apache.inlong.manager.pojo.sink.SinkBriefInfo;
import org.apache.inlong.manager.pojo.sink.SinkField;
import org.apache.inlong.manager.pojo.sink.StreamSink;
import org.apache.inlong.manager.pojo.sort.util.FieldInfoUtils;
import org.apache.inlong.manager.pojo.source.StreamSource;
import org.apache.inlong.manager.pojo.stream.InlongStreamApproveRequest;
import org.apache.inlong.manager.pojo.stream.InlongStreamBriefInfo;
import org.apache.inlong.manager.pojo.stream.InlongStreamExtInfo;
import org.apache.inlong.manager.pojo.stream.InlongStreamExtParam;
import org.apache.inlong.manager.pojo.stream.InlongStreamInfo;
import org.apache.inlong.manager.pojo.stream.InlongStreamPageRequest;
import org.apache.inlong.manager.pojo.stream.InlongStreamRequest;
import org.apache.inlong.manager.pojo.stream.QueryMessageRequest;
import org.apache.inlong.manager.pojo.stream.StreamField;
import org.apache.inlong.manager.pojo.user.UserInfo;
import org.apache.inlong.manager.service.group.InlongGroupOperator;
import org.apache.inlong.manager.service.group.InlongGroupOperatorFactory;
import org.apache.inlong.manager.service.resource.queue.QueueResourceOperator;
import org.apache.inlong.manager.service.resource.queue.QueueResourceOperatorFactory;
import org.apache.inlong.manager.service.sink.SinkOperatorFactory;
import org.apache.inlong.manager.service.sink.StreamSinkOperator;
import org.apache.inlong.manager.service.sink.StreamSinkService;
import org.apache.inlong.manager.service.source.StreamSourceService;
import org.apache.inlong.manager.service.stream.InlongStreamService;
import org.apache.inlong.manager.service.user.UserService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class InlongStreamServiceImpl
implements InlongStreamService {
    private static final Logger LOGGER = LoggerFactory.getLogger(InlongStreamServiceImpl.class);
    private static final String PARSE_FIELD_CSV_SPLITTER = "\t|\\s|,";
    private static final int PARSE_FIELD_CSV_MAX_COLUMNS = 3;
    private static final int PARSE_FIELD_CSV_MIN_COLUMNS = 2;
    @Autowired
    private InlongStreamEntityMapper streamMapper;
    @Autowired
    private InlongStreamFieldEntityMapper streamFieldMapper;
    @Autowired
    private InlongStreamExtEntityMapper streamExtMapper;
    @Autowired
    private InlongGroupEntityMapper groupMapper;
    @Autowired
    private StreamSourceService sourceService;
    @Autowired
    private StreamSinkService sinkService;
    @Autowired
    private StreamSinkEntityMapper sinkMapper;
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    @Lazy
    private QueueResourceOperatorFactory queueOperatorFactory;
    @Autowired
    @Lazy
    private InlongGroupOperatorFactory groupOperatorFactory;
    @Autowired
    @Lazy
    private SinkOperatorFactory sinkOperatorFactory;
    @Autowired
    private UserService userService;

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public Integer save(InlongStreamRequest request, String operator) {
        LOGGER.debug("begin to save inlong stream info={}", (Object)request);
        Preconditions.expectNotNull((Object)request, (String)"inlong stream info is empty");
        String groupId = request.getInlongGroupId();
        String streamId = request.getInlongStreamId();
        Preconditions.expectNotBlank((String)groupId, (ErrorCodeEnum)ErrorCodeEnum.GROUP_ID_IS_EMPTY);
        Preconditions.expectNotBlank((String)streamId, (ErrorCodeEnum)ErrorCodeEnum.STREAM_ID_IS_EMPTY);
        this.checkGroupStatusIsTemp(groupId);
        InlongGroupEntity groupEntity = this.groupMapper.selectByGroupId(groupId);
        if (groupEntity == null) {
            throw new BusinessException(String.format("InlongGroup does not exist with InlongGroupId=%s", groupId));
        }
        this.userService.checkUser(groupEntity.getInCharges(), operator, "Current user does not have permission to create stream info");
        Integer count = this.streamMapper.selectExistByIdentifier(groupId, streamId);
        if (count >= 1) {
            LOGGER.error("inlong stream id [{}] has already exists", (Object)streamId);
            throw new BusinessException(ErrorCodeEnum.STREAM_ID_DUPLICATE);
        }
        if (StringUtils.isEmpty((CharSequence)request.getMqResource())) {
            request.setMqResource(streamId);
        }
        InlongStreamEntity streamEntity = (InlongStreamEntity)CommonBeanUtils.copyProperties((Object)request, InlongStreamEntity::new);
        streamEntity.setStatus(StreamStatus.NEW.getCode());
        streamEntity.setCreator(operator);
        streamEntity.setModifier(operator);
        String extParam = InlongStreamExtParam.packExtParams((InlongStreamRequest)request);
        streamEntity.setExtParams(extParam);
        this.streamMapper.insertSelective(streamEntity);
        this.saveField(groupId, streamId, request.getFieldList());
        List extList = request.getExtList();
        if (CollectionUtils.isNotEmpty((Collection)extList)) {
            this.saveOrUpdateExt(groupId, streamId, extList);
        }
        LOGGER.info("success to save inlong stream info for groupId={}", (Object)groupId);
        return streamEntity.getId();
    }

    @Override
    public List<BatchResult> batchSave(List<InlongStreamRequest> requestList, String operator) {
        ArrayList<BatchResult> resultList = new ArrayList<BatchResult>();
        for (InlongStreamRequest request : requestList) {
            BatchResult result = BatchResult.builder().uniqueKey(request.getInlongGroupId() + "-" + request.getInlongStreamId()).operationTarget(OperationTarget.STREAM).build();
            try {
                this.save(request, operator);
                result.setSuccess(true);
            }
            catch (Exception e) {
                LOGGER.error("failed to save inlong stream for groupId={}, streamId={}", new Object[]{request.getInlongGroupId(), request.getInlongStreamId(), e});
                result.setSuccess(false);
                result.setErrMsg(e.getMessage());
            }
            resultList.add(result);
        }
        return resultList;
    }

    @Override
    public Boolean exist(String groupId, String streamId) {
        Preconditions.expectNotBlank((String)groupId, (ErrorCodeEnum)ErrorCodeEnum.GROUP_ID_IS_EMPTY);
        Preconditions.expectNotBlank((String)streamId, (ErrorCodeEnum)ErrorCodeEnum.STREAM_ID_IS_EMPTY);
        InlongStreamEntity streamEntity = this.streamMapper.selectByIdentifier(groupId, streamId);
        return streamEntity != null;
    }

    @Override
    public InlongStreamInfo get(String groupId, String streamId) {
        LOGGER.debug("begin to get inlong stream by groupId={}, streamId={}", (Object)groupId, (Object)streamId);
        Preconditions.expectNotBlank((String)groupId, (ErrorCodeEnum)ErrorCodeEnum.GROUP_ID_IS_EMPTY);
        Preconditions.expectNotBlank((String)streamId, (ErrorCodeEnum)ErrorCodeEnum.STREAM_ID_IS_EMPTY);
        InlongStreamEntity streamEntity = this.streamMapper.selectByIdentifier(groupId, streamId);
        if (streamEntity == null) {
            LOGGER.error("inlong stream not found by groupId={}, streamId={}", (Object)groupId, (Object)streamId);
            throw new BusinessException(ErrorCodeEnum.STREAM_NOT_FOUND);
        }
        InlongStreamInfo streamInfo = (InlongStreamInfo)CommonBeanUtils.copyProperties((Object)streamEntity, InlongStreamInfo::new);
        List<StreamField> streamFields = this.getStreamFields(groupId, streamId);
        streamInfo.setFieldList(streamFields);
        List extEntities = this.streamExtMapper.selectByRelatedId(groupId, streamId);
        List extInfos = CommonBeanUtils.copyListProperties((List)extEntities, InlongStreamExtInfo::new);
        streamInfo.setExtList(extInfos);
        InlongStreamExtParam.unpackExtParams((String)streamEntity.getExtParams(), (Object)streamInfo);
        List<StreamSink> sinkList = this.sinkService.listSink(groupId, streamId);
        streamInfo.setSinkList(sinkList);
        List<StreamSource> sourceList = this.sourceService.listSource(groupId, streamId);
        streamInfo.setSourceList(sourceList);
        return streamInfo;
    }

    @Override
    public InlongStreamBriefInfo getBrief(String groupId, String streamId, String operator) {
        InlongGroupEntity entity = this.groupMapper.selectByGroupId(groupId);
        if (entity == null) {
            throw new BusinessException(ErrorCodeEnum.GROUP_NOT_FOUND);
        }
        InlongStreamEntity streamEntity = this.streamMapper.selectByIdentifier(groupId, streamId);
        if (streamEntity == null) {
            throw new BusinessException(ErrorCodeEnum.STREAM_NOT_FOUND);
        }
        InlongStreamBriefInfo streamInfo = (InlongStreamBriefInfo)CommonBeanUtils.copyProperties((Object)streamEntity, InlongStreamBriefInfo::new);
        InlongStreamExtParam.unpackExtParams((String)streamEntity.getExtParams(), (Object)streamInfo);
        List<StreamField> streamFields = this.getStreamFields(groupId, streamId);
        streamInfo.setFieldList(streamFields);
        List extEntities = this.streamExtMapper.selectByRelatedId(groupId, streamId);
        List extInfos = CommonBeanUtils.copyListProperties((List)extEntities, InlongStreamExtInfo::new);
        streamInfo.setExtList(extInfos);
        return streamInfo;
    }

    @Override
    public List<InlongStreamInfo> list(String groupId) {
        LOGGER.debug("begin to list inlong streams by groupId={}", (Object)groupId);
        List inlongStreamEntityList = this.streamMapper.selectByGroupId(groupId);
        List streamList = CommonBeanUtils.copyListProperties((List)inlongStreamEntityList, InlongStreamInfo::new);
        List<StreamField> streamFields = this.getStreamFields(groupId, null);
        Map streamFieldMap = streamFields.stream().collect(Collectors.groupingBy(StreamField::getInlongStreamId, HashMap::new, Collectors.toCollection(ArrayList::new)));
        List extEntities = this.streamExtMapper.selectByRelatedId(groupId, null);
        Map extInfoMap = extEntities.stream().map(extEntity -> (InlongStreamExtInfo)CommonBeanUtils.copyProperties((Object)extEntity, InlongStreamExtInfo::new)).collect(Collectors.groupingBy(InlongStreamExtInfo::getInlongStreamId, HashMap::new, Collectors.toCollection(ArrayList::new)));
        streamList.forEach(streamInfo -> {
            String streamId = streamInfo.getInlongStreamId();
            InlongStreamExtParam.unpackExtParams((String)streamInfo.getExtParams(), (Object)streamInfo);
            List fieldInfos = (List)streamFieldMap.get(streamId);
            streamInfo.setFieldList(fieldInfos);
            List extInfos = (List)extInfoMap.get(streamId);
            streamInfo.setExtList(extInfos);
            List<StreamSink> sinkList = this.sinkService.listSink(groupId, streamId);
            streamInfo.setSinkList(sinkList);
            List<StreamSource> sourceList = this.sourceService.listSource(groupId, streamId);
            streamInfo.setSourceList(sourceList);
        });
        return streamList;
    }

    @Override
    public List<InlongStreamInfo> listBackUp(String groupId) {
        LOGGER.debug("begin to list inlong streams by groupId={}", (Object)groupId);
        List inlongStreamEntityList = this.streamMapper.selectByGroupId(groupId);
        List streamList = CommonBeanUtils.copyListProperties((List)inlongStreamEntityList, InlongStreamInfo::new);
        for (InlongStreamInfo streamInfo2 : streamList) {
            this.streamExtMapper.selectByKey(streamInfo2.getInlongGroupId(), streamInfo2.getInlongStreamId(), "backup_mq_resource");
        }
        List<StreamField> streamFields = this.getStreamFields(groupId, null);
        Map streamFieldMap = streamFields.stream().collect(Collectors.groupingBy(StreamField::getInlongStreamId, HashMap::new, Collectors.toCollection(ArrayList::new)));
        List extEntities = this.streamExtMapper.selectByRelatedId(groupId, null);
        Map extInfoMap = extEntities.stream().map(extEntity -> (InlongStreamExtInfo)CommonBeanUtils.copyProperties((Object)extEntity, InlongStreamExtInfo::new)).collect(Collectors.groupingBy(InlongStreamExtInfo::getInlongStreamId, HashMap::new, Collectors.toCollection(ArrayList::new)));
        streamList.forEach(streamInfo -> {
            String streamId = streamInfo.getInlongStreamId();
            InlongStreamExtParam.unpackExtParams((String)streamInfo.getExtParams(), (Object)streamInfo);
            List fieldInfos = (List)streamFieldMap.get(streamId);
            streamInfo.setFieldList(fieldInfos);
            List extInfos = (List)extInfoMap.get(streamId);
            streamInfo.setExtList(extInfos);
            List<StreamSink> sinkList = this.sinkService.listSink(groupId, streamId);
            streamInfo.setSinkList(sinkList);
            List<StreamSource> sourceList = this.sourceService.listSource(groupId, streamId);
            streamInfo.setSourceList(sourceList);
        });
        return streamList;
    }

    private List<StreamField> getStreamFields(String groupId, String streamId) {
        List fieldEntityList = this.streamFieldMapper.selectByIdentifier(groupId, streamId);
        if (CollectionUtils.isEmpty((Collection)fieldEntityList)) {
            return Collections.emptyList();
        }
        return CommonBeanUtils.copyListProperties((List)fieldEntityList, StreamField::new);
    }

    @Override
    public PageResult<InlongStreamBriefInfo> listBrief(InlongStreamPageRequest request) {
        LOGGER.debug("begin to list inlong stream page by {}", (Object)request);
        PageHelper.startPage((int)request.getPageNum(), (int)request.getPageSize());
        OrderFieldEnum.checkOrderField((PageRequest)request);
        OrderTypeEnum.checkOrderType((PageRequest)request);
        Page entityPage = (Page)this.streamMapper.selectByCondition(request);
        PageResult pageResult = PageResult.fromPage((Page)entityPage).map(entity -> (InlongStreamBriefInfo)CommonBeanUtils.copyProperties((Object)entity, InlongStreamBriefInfo::new));
        LOGGER.debug("success to list inlong stream info for groupId={}", (Object)request.getInlongGroupId());
        return pageResult;
    }

    @Override
    public List<InlongStreamBriefInfo> listBrief(InlongStreamPageRequest request, UserInfo opInfo) {
        request.setCurrentUser(opInfo.getName());
        request.setIsAdminRole(Boolean.valueOf(opInfo.getRoles().contains("TENANT_ADMIN")));
        OrderFieldEnum.checkOrderField((PageRequest)request);
        OrderTypeEnum.checkOrderType((PageRequest)request);
        return CommonBeanUtils.copyListProperties((List)this.streamMapper.selectByCondition(request), InlongStreamBriefInfo::new);
    }

    @Override
    public PageResult<InlongStreamInfo> listAll(InlongStreamPageRequest request) {
        LOGGER.debug("begin to list full inlong stream page by {}", (Object)request);
        Preconditions.expectNotNull((Object)request, (String)"request is empty");
        String groupId = request.getInlongGroupId();
        Preconditions.expectNotBlank((String)groupId, (ErrorCodeEnum)ErrorCodeEnum.GROUP_ID_IS_EMPTY);
        InlongGroupEntity groupEntity = this.groupMapper.selectByGroupId(groupId);
        Preconditions.expectNotNull((Object)groupEntity, (String)("inlong group not found by groupId=" + groupId));
        PageHelper.startPage((int)request.getPageNum(), (int)request.getPageSize());
        OrderFieldEnum.checkOrderField((PageRequest)request);
        OrderTypeEnum.checkOrderType((PageRequest)request);
        Page page = (Page)this.streamMapper.selectByCondition(request);
        PageResult pageResult = PageResult.fromPage((Page)page).map(entity -> (InlongStreamInfo)CommonBeanUtils.copyProperties((Object)entity, InlongStreamInfo::new)).foreach(streamInfo -> {
            String streamId = streamInfo.getInlongStreamId();
            InlongStreamExtParam.unpackExtParams((InlongStreamInfo)streamInfo);
            List<StreamField> streamFields = this.getStreamFields(groupId, streamId);
            streamInfo.setFieldList(streamFields);
            List extEntities = this.streamExtMapper.selectByRelatedId(groupId, streamId);
            List streamExtInfos = CommonBeanUtils.copyListProperties((List)extEntities, InlongStreamExtInfo::new);
            streamInfo.setExtList(streamExtInfos);
            List<StreamSource> sourceList = this.sourceService.listSource(groupId, streamId);
            streamInfo.setSourceList(sourceList);
            List<StreamSink> sinkList = this.sinkService.listSink(groupId, streamId);
            streamInfo.setSinkList(sinkList);
        });
        LOGGER.debug("success to list full inlong stream info by {}", (Object)request);
        return pageResult;
    }

    @Override
    public List<InlongStreamBriefInfo> listBriefWithSink(String groupId) {
        LOGGER.debug("begin to get inlong stream brief list by groupId={}", (Object)groupId);
        Preconditions.expectNotBlank((String)groupId, (ErrorCodeEnum)ErrorCodeEnum.GROUP_ID_IS_EMPTY);
        List entityList = this.streamMapper.selectByGroupId(groupId);
        List briefInfoList = CommonBeanUtils.copyListProperties((List)entityList, InlongStreamBriefInfo::new);
        for (InlongStreamBriefInfo briefInfo : briefInfoList) {
            String streamId = briefInfo.getInlongStreamId();
            List<SinkBriefInfo> sinkList = this.sinkService.listBrief(groupId, streamId);
            briefInfo.setSinkList(sinkList);
        }
        LOGGER.info("success to get inlong stream brief list for groupId={}", (Object)groupId);
        return briefInfoList;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public Boolean update(InlongStreamRequest request, String operator) {
        LOGGER.debug("begin to update inlong stream info={}", (Object)request);
        Preconditions.expectNotNull((Object)request, (String)"inlong stream request is empty");
        String groupId = request.getInlongGroupId();
        Preconditions.expectNotBlank((String)groupId, (ErrorCodeEnum)ErrorCodeEnum.GROUP_ID_IS_EMPTY);
        InlongGroupEntity groupEntity = this.groupMapper.selectByGroupIdWithoutTenant(groupId);
        if (groupEntity == null) {
            throw new BusinessException(String.format("InlongGroup does not exist with InlongGroupId=%s", groupId));
        }
        this.userService.checkUser(groupEntity.getInCharges(), operator, "Current user does not have permission to update stream info");
        String streamId = request.getInlongStreamId();
        Preconditions.expectNotBlank((String)streamId, (ErrorCodeEnum)ErrorCodeEnum.STREAM_ID_IS_EMPTY);
        this.checkGroupStatusIsTemp(groupId);
        return this.updateWithoutCheck(request, operator);
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public Boolean updateWithoutCheck(InlongStreamRequest request, String operator) {
        LOGGER.debug("begin to update inlong stream without check, request={}", (Object)request);
        String groupId = request.getInlongGroupId();
        String streamId = request.getInlongStreamId();
        InlongStreamEntity streamEntity = this.streamMapper.selectByIdentifier(groupId, streamId);
        if (streamEntity == null) {
            LOGGER.error("inlong stream not found by groupId={}, streamId={}", (Object)groupId, (Object)streamId);
            throw new BusinessException(ErrorCodeEnum.STREAM_NOT_FOUND);
        }
        String errMsg = String.format("stream has already updated with groupId=%s, streamId=%s, curVersion=%s", streamEntity.getInlongGroupId(), streamEntity.getInlongStreamId(), request.getVersion());
        if (!Objects.equals(streamEntity.getVersion(), request.getVersion())) {
            LOGGER.error(errMsg);
            throw new BusinessException(ErrorCodeEnum.CONFIG_EXPIRED);
        }
        String extParams = InlongStreamExtParam.packExtParams((InlongStreamRequest)request);
        request.setExtParams(extParams);
        CommonBeanUtils.copyProperties((Object)request, (Object)streamEntity, (boolean)true);
        streamEntity.setModifier(operator);
        int rowCount = this.streamMapper.updateByIdentifierSelective(streamEntity);
        if (rowCount != InlongConstants.AFFECTED_ONE_ROW) {
            LOGGER.error(errMsg);
            throw new BusinessException(ErrorCodeEnum.CONFIG_EXPIRED);
        }
        this.updateField(groupId, streamId, request.getFieldList());
        List extList = request.getExtList();
        this.saveOrUpdateExt(groupId, streamId, extList);
        if (request.getSyncField().booleanValue()) {
            List sinkEntityList = this.sinkMapper.selectByRelatedId(groupId, streamId);
            for (StreamSinkEntity sinkEntity : sinkEntityList) {
                StreamSinkOperator sinkOperator = this.sinkOperatorFactory.getInstance(sinkEntity.getSinkType());
                sinkOperator.syncField(sinkOperator.getFromEntity(sinkEntity).genSinkRequest(), request.getFieldList());
            }
        }
        LOGGER.info("success to update inlong stream without check for groupId={} streamId={}", (Object)groupId, (Object)streamId);
        return true;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public Boolean delete(String groupId, String streamId, String operator) {
        LOGGER.debug("begin to delete inlong stream, groupId={}, streamId={}", (Object)groupId, (Object)streamId);
        Preconditions.expectNotBlank((String)groupId, (ErrorCodeEnum)ErrorCodeEnum.GROUP_ID_IS_EMPTY);
        Preconditions.expectNotBlank((String)streamId, (ErrorCodeEnum)ErrorCodeEnum.STREAM_ID_IS_EMPTY);
        this.checkGroupStatusIsTemp(groupId);
        InlongGroupEntity groupEntity = this.groupMapper.selectByGroupIdWithoutTenant(groupId);
        if (groupEntity == null) {
            throw new BusinessException(String.format("InlongGroup does not exist with InlongGroupId=%s", groupId));
        }
        this.userService.checkUser(groupEntity.getInCharges(), operator, "Current user does not have permission to delete stream info");
        InlongStreamEntity entity = this.streamMapper.selectByIdentifier(groupId, streamId);
        if (entity == null) {
            LOGGER.error("inlong stream not found by groupId={}, streamId={}", (Object)groupId, (Object)streamId);
            throw new BusinessException(ErrorCodeEnum.STREAM_NOT_FOUND);
        }
        Integer sourceCount = this.sourceService.getCount(groupId, streamId);
        if (sourceCount > 0) {
            LOGGER.error("inlong stream has undeleted sources, delete failed");
            throw new BusinessException(ErrorCodeEnum.STREAM_DELETE_HAS_SOURCE);
        }
        int sinkCount = this.sinkService.getCount(groupId, streamId);
        if (sinkCount > 0) {
            LOGGER.error("inlong stream has undeleted sinks, delete failed");
            throw new BusinessException(ErrorCodeEnum.STREAM_DELETE_HAS_SINK);
        }
        entity.setIsDeleted(entity.getId());
        entity.setModifier(operator);
        int rowCount = this.streamMapper.updateByPrimaryKey(entity);
        if (rowCount != InlongConstants.AFFECTED_ONE_ROW) {
            LOGGER.error("stream has already updated with group id={}, stream id={}, curVersion={}", new Object[]{entity.getInlongGroupId(), entity.getInlongStreamId(), entity.getVersion()});
            throw new BusinessException(ErrorCodeEnum.CONFIG_EXPIRED);
        }
        LOGGER.debug("begin to delete inlong stream field, streamId={}", (Object)streamId);
        this.streamFieldMapper.logicDeleteAllByIdentifier(groupId, streamId);
        this.streamExtMapper.logicDeleteAllByRelatedId(groupId, streamId);
        LOGGER.info("success to delete inlong stream, ext property and fields for groupId={}", (Object)groupId);
        return true;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public Boolean logicDeleteAll(String groupId, String operator) {
        LOGGER.debug("begin to delete all inlong stream by groupId={}", (Object)groupId);
        Preconditions.expectNotBlank((String)groupId, (ErrorCodeEnum)ErrorCodeEnum.GROUP_ID_IS_EMPTY);
        this.checkGroupStatusIsTemp(groupId);
        List entityList = this.streamMapper.selectByGroupId(groupId);
        if (CollectionUtils.isEmpty((Collection)entityList)) {
            LOGGER.info("inlong stream not found by groupId={}", (Object)groupId);
            return true;
        }
        for (InlongStreamEntity entity : entityList) {
            entity.setIsDeleted(entity.getId());
            entity.setModifier(operator);
            int rowCount = this.streamMapper.updateByIdentifierSelective(entity);
            if (rowCount != InlongConstants.AFFECTED_ONE_ROW) {
                LOGGER.error("stream has already updated with group id={}, stream id={}, curVersion={}", new Object[]{entity.getInlongGroupId(), entity.getInlongStreamId(), entity.getVersion()});
                throw new BusinessException(ErrorCodeEnum.CONFIG_EXPIRED);
            }
            String streamId = entity.getInlongStreamId();
            this.streamFieldMapper.logicDeleteAllByIdentifier(groupId, streamId);
            this.streamExtMapper.logicDeleteAllByRelatedId(groupId, streamId);
            this.sourceService.logicDeleteAll(groupId, streamId, operator);
            this.sinkService.logicDeleteAll(groupId, streamId, operator);
        }
        LOGGER.info("success to delete all inlong stream, ext property and fields by groupId={}", (Object)groupId);
        return true;
    }

    @Override
    public int selectCountByGroupId(String groupId) {
        LOGGER.debug("begin to get count by groupId={}", (Object)groupId);
        if (StringUtils.isEmpty((CharSequence)groupId)) {
            return 0;
        }
        int count = this.streamMapper.selectCountByGroupId(groupId);
        LOGGER.info("success to get count");
        return count;
    }

    @Override
    public List<InlongStreamBriefInfo> getTopicList(String groupId) {
        LOGGER.debug("begin bo get topic list by group id={}", (Object)groupId);
        Preconditions.expectNotBlank((String)groupId, (ErrorCodeEnum)ErrorCodeEnum.GROUP_ID_IS_EMPTY);
        List topicList = this.streamMapper.selectBriefList(groupId);
        LOGGER.debug("success to get topic list by groupId={}, result size={}", (Object)groupId, (Object)topicList.size());
        return topicList;
    }

    @Override
    public boolean updateAfterApprove(List<InlongStreamApproveRequest> streamApproveList, String operator) {
        if (CollectionUtils.isEmpty(streamApproveList)) {
            return true;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("begin to update stream after approve={}", streamApproveList);
        }
        String groupId = null;
        for (InlongStreamApproveRequest info : streamApproveList) {
            groupId = info.getInlongGroupId();
            InlongStreamEntity streamEntity = this.streamMapper.selectByIdentifier(groupId, info.getInlongStreamId());
            streamEntity.setStatus(StreamStatus.CONFIG_ING.getCode());
            int rowCount = this.streamMapper.updateByIdentifierSelective(streamEntity);
            if (rowCount != InlongConstants.AFFECTED_ONE_ROW) {
                LOGGER.error("stream has already updated with group id={}, stream id={}, curVersion={}", new Object[]{streamEntity.getInlongGroupId(), streamEntity.getInlongStreamId(), streamEntity.getVersion()});
                throw new BusinessException(ErrorCodeEnum.CONFIG_EXPIRED);
            }
            this.sinkService.updateAfterApprove(info.getSinkList(), operator);
        }
        LOGGER.info("success to update stream after approve for groupId={}", groupId);
        return true;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public boolean updateStatus(String groupId, String streamId, Integer status, String operator) {
        this.streamMapper.updateStatusByIdentifier(groupId, streamId, status, operator);
        LOGGER.info("success to update stream after approve for groupId=" + groupId + ", streamId=" + streamId);
        return true;
    }

    @Override
    public void insertDlqOrRlq(String groupId, String topicName, String operator) {
        Integer count = this.streamMapper.selectExistByIdentifier(groupId, topicName);
        if (count >= 1) {
            LOGGER.error("DLQ/RLQ topic already exists with name={}", (Object)topicName);
            throw new BusinessException(ErrorCodeEnum.STREAM_ID_DUPLICATE, "DLQ/RLQ topic already exists");
        }
        InlongStreamEntity streamEntity = new InlongStreamEntity();
        streamEntity.setInlongGroupId(groupId);
        streamEntity.setInlongStreamId(topicName);
        streamEntity.setMqResource(topicName);
        streamEntity.setDescription("This is DLQ / RLQ topic created by SYSTEM");
        streamEntity.setDailyRecords(Integer.valueOf(1000));
        streamEntity.setDailyStorage(Integer.valueOf(1000));
        streamEntity.setPeakRecords(Integer.valueOf(1000));
        streamEntity.setMaxLength(Integer.valueOf(1000));
        streamEntity.setStatus(StreamStatus.CONFIG_SUCCESSFUL.getCode());
        streamEntity.setCreator(operator);
        streamEntity.setModifier(operator);
        this.streamMapper.insert(streamEntity);
    }

    @Override
    public void logicDeleteDlqOrRlq(String groupId, String topicName, String operator) {
        this.streamMapper.logicDeleteDlqOrRlq(groupId, topicName, operator);
        LOGGER.info("success to logic delete dlq or rlq by groupId={}, topicName={}", (Object)groupId, (Object)topicName);
    }

    @Override
    public boolean addFields(AddFieldRequest addFieldsRequest) {
        String groupId = addFieldsRequest.getInlongGroupId();
        String streamId = addFieldsRequest.getInlongStreamId();
        try {
            LOGGER.info("begin to add inlong stream fields ={}", (Object)addFieldsRequest.getSinkFieldList());
            Set existFieldList = this.streamFieldMapper.selectByIdentifier(groupId, streamId).stream().map(InlongStreamFieldEntity::getFieldName).collect(Collectors.toSet());
            ArrayList<InlongStreamFieldEntity> needAddFieldList = new ArrayList<InlongStreamFieldEntity>();
            for (SinkField sinkField : addFieldsRequest.getSinkFieldList()) {
                if (existFieldList.contains(sinkField.getSourceFieldName())) {
                    LOGGER.info("current stream field={} is exist for groupId={}, streamId={}", new Object[]{sinkField.getSourceFieldName(), groupId, streamId});
                    continue;
                }
                InlongStreamFieldEntity entity = new InlongStreamFieldEntity();
                entity.setFieldName(sinkField.getSourceFieldName());
                entity.setFieldType(sinkField.getSourceFieldType());
                entity.setFieldComment(sinkField.getFieldComment());
                entity.setInlongGroupId(groupId);
                entity.setInlongStreamId(streamId);
                entity.setIsDeleted(InlongConstants.UN_DELETED);
                needAddFieldList.add(entity);
            }
            if (CollectionUtils.isNotEmpty(needAddFieldList)) {
                this.streamFieldMapper.insertAll(needAddFieldList);
            }
            List sinkEntityList = this.sinkMapper.selectByRelatedId(groupId, streamId);
            for (StreamSinkEntity sink : sinkEntityList) {
                this.sinkService.addFields(sink, addFieldsRequest.getSinkFieldList());
            }
            LOGGER.debug("success add inlong stream fields={}", needAddFieldList);
        }
        catch (Exception e) {
            LOGGER.error("add inlong stream fields error for groupId={}, streamId={}", new Object[]{groupId, streamId, e});
            throw new BusinessException(ErrorCodeEnum.INVALID_PARAMETER, String.format("add stream fields error : %s", e.getMessage()));
        }
        return true;
    }

    @Override
    public List<StreamField> parseFields(ParseFieldRequest parseFieldRequest) {
        try {
            String method = parseFieldRequest.getMethod();
            String statement = parseFieldRequest.getStatement();
            switch (method) {
                case "json": {
                    return this.parseFieldsByJson(statement);
                }
                case "sql": {
                    return this.parseFieldsBySql(statement);
                }
                case "csv": {
                    return this.parseFieldsByCsv(statement);
                }
            }
            throw new BusinessException(ErrorCodeEnum.INVALID_PARAMETER, String.format("Unsupported parse field mode: %s", method));
        }
        catch (Exception e) {
            LOGGER.error("parse inlong stream fields error", (Throwable)e);
            throw new BusinessException(ErrorCodeEnum.INVALID_PARAMETER, String.format("parse stream fields error : %s", e.getMessage()));
        }
    }

    @Override
    public List<StreamField> parseFields(MultipartFile file) {
        InputStream inputStream;
        try {
            inputStream = file.getInputStream();
        }
        catch (IOException e) {
            throw new BusinessException(ErrorCodeEnum.INVALID_PARAMETER, "Can not properly read update file");
        }
        List data = null;
        try {
            data = ExcelTool.read((InputStream)inputStream, StreamField.class);
        }
        catch (IOException | IllegalAccessException | InstantiationException | NoSuchMethodException e) {
            throw new BusinessException(ErrorCodeEnum.INVALID_PARAMETER, "Can not properly parse excel, message: " + e.getClass().getName() + ":" + e.getMessage());
        }
        if (CollectionUtils.isEmpty((Collection)data)) {
            throw new BusinessException(ErrorCodeEnum.INVALID_PARAMETER, "The content of uploaded Excel file is empty, please check!");
        }
        return data;
    }

    private List<StreamField> parseFieldsByCsv(String statement) {
        String[] lines = statement.split("\n");
        ArrayList<StreamField> fields = new ArrayList<StreamField>();
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            if (StringUtils.isBlank((CharSequence)line)) continue;
            String[] cols = line.split(PARSE_FIELD_CSV_SPLITTER, 3);
            if (cols.length < 2) {
                throw new BusinessException(ErrorCodeEnum.INVALID_PARAMETER, "At least two fields are required, line number is " + (i + 1));
            }
            String fieldName = cols[0];
            if (!InlongConstants.PATTERN_NORMAL_CHARACTERS.matcher(fieldName).matches()) {
                throw new BusinessException(ErrorCodeEnum.INVALID_PARAMETER, "Field names in line " + (i + 1) + " can only contain letters, underscores or numbers");
            }
            String fieldType = cols[1];
            if (!InlongConstants.STREAM_FIELD_TYPES.contains(fieldType)) {
                throw new BusinessException(ErrorCodeEnum.INVALID_PARAMETER, "The field type in line" + (i + 1) + " must be one of " + InlongConstants.STREAM_FIELD_TYPES);
            }
            String comment = null;
            if (cols.length == 3) {
                comment = cols[2];
            }
            StreamField field = new StreamField();
            field.setFieldName(fieldName);
            field.setFieldType(fieldType);
            field.setFieldComment(comment);
            fields.add(field);
        }
        return fields;
    }

    private List<StreamField> parseFieldsBySql(String sql) throws JSQLParserException {
        CCJSqlParserManager pm = new CCJSqlParserManager();
        Statement statement = pm.parse((Reader)new StringReader(sql));
        ArrayList<StreamField> fields = new ArrayList<StreamField>();
        if (!(statement instanceof CreateTable)) {
            throw new BusinessException(ErrorCodeEnum.INVALID_PARAMETER, "The SQL statement must be a table creation statement");
        }
        CreateTable createTable = (CreateTable)statement;
        List columnDefinitions = createTable.getColumnDefinitions();
        for (int i = 0; i < columnDefinitions.size(); ++i) {
            ColumnDefinition definition = (ColumnDefinition)columnDefinitions.get(i);
            StreamField streamField = new StreamField();
            String columnName = definition.getColumnName();
            streamField.setFieldName(columnName);
            ColDataType colDataType = definition.getColDataType();
            String sqlDataType = colDataType.getDataType();
            Class clazz = FieldInfoUtils.sqlTypeToJavaType((String)sqlDataType);
            if (clazz == Object.class) {
                throw new BusinessException(ErrorCodeEnum.INVALID_PARAMETER, "Unrecognized SQL field type, line: " + (i + 1) + ", type: " + sqlDataType);
            }
            String type = clazz.getSimpleName().toLowerCase();
            streamField.setFieldType(type);
            List columnSpecs = definition.getColumnSpecs();
            if (CollectionUtils.isNotEmpty((Collection)columnSpecs)) {
                int commentIndex = -1;
                for (int csIndex = 0; csIndex < columnSpecs.size(); ++csIndex) {
                    String spec = (String)columnSpecs.get(csIndex);
                    if (!spec.toUpperCase().startsWith("COMMENT")) continue;
                    commentIndex = csIndex;
                    break;
                }
                String comment = null;
                if (-1 != commentIndex && columnSpecs.size() > commentIndex + 1) {
                    comment = ((String)columnSpecs.get(commentIndex + 1)).replaceAll("['\"]", "");
                }
                streamField.setFieldComment(comment);
            }
            fields.add(streamField);
        }
        return fields;
    }

    private List<StreamField> parseFieldsByJson(String statement) throws JsonProcessingException {
        return ((List)this.objectMapper.readValue(statement, (TypeReference)new TypeReference<List<Map<String, String>>>(){})).stream().map(line -> {
            String name = (String)line.get("name");
            String type = (String)line.get("type");
            String desc = (String)line.get("desc");
            StreamField streamField = new StreamField();
            streamField.setFieldName(name);
            streamField.setFieldType(type);
            streamField.setFieldComment(desc);
            return streamField;
        }).collect(Collectors.toList());
    }

    @Transactional(rollbackFor={Throwable.class})
    public void updateField(String groupId, String streamId, List<StreamField> fieldList) {
        LOGGER.debug("begin to update inlong stream field, groupId={}, streamId={}, field={}", new Object[]{groupId, streamId, fieldList});
        try {
            this.streamFieldMapper.deleteAllByIdentifier(groupId, streamId);
            this.saveField(groupId, streamId, fieldList);
            LOGGER.info("success to update inlong stream field for groupId={}", (Object)groupId);
        }
        catch (Exception e) {
            LOGGER.error("failed to update inlong stream field: ", (Throwable)e);
            throw new BusinessException(ErrorCodeEnum.STREAM_FIELD_SAVE_FAILED);
        }
    }

    @Transactional(rollbackFor={Throwable.class})
    public void saveField(String groupId, String streamId, List<StreamField> infoList) {
        if (CollectionUtils.isEmpty(infoList)) {
            return;
        }
        infoList.forEach(streamField -> streamField.setId(null));
        List list = CommonBeanUtils.copyListProperties(infoList, InlongStreamFieldEntity::new);
        for (InlongStreamFieldEntity entity : list) {
            entity.setInlongGroupId(groupId);
            entity.setInlongStreamId(streamId);
            entity.setIsDeleted(InlongConstants.UN_DELETED);
        }
        this.streamFieldMapper.insertAll(list);
    }

    @Transactional(rollbackFor={Throwable.class})
    public void saveOrUpdateExt(String groupId, String streamId, List<InlongStreamExtInfo> extInfos) {
        LOGGER.info("begin to save or update inlong stream ext info, groupId={}, streamId={}, ext={}", new Object[]{groupId, streamId, extInfos});
        if (CollectionUtils.isEmpty(extInfos)) {
            return;
        }
        List entityList = CommonBeanUtils.copyListProperties(extInfos, InlongStreamExtEntity::new);
        entityList.forEach(streamEntity -> {
            streamEntity.setInlongGroupId(groupId);
            streamEntity.setInlongStreamId(streamId);
        });
        this.streamExtMapper.insertOnDuplicateKeyUpdate(entityList);
        LOGGER.info("success to save or update inlong stream ext for groupId={}", (Object)groupId);
    }

    private InlongGroupEntity checkGroupStatusIsTemp(String groupId) {
        InlongGroupEntity entity = this.groupMapper.selectByGroupId(groupId);
        Preconditions.expectNotNull((Object)entity, (String)"groupId is invalid");
        GroupStatus curState = GroupStatus.forCode((int)entity.getStatus());
        if (GroupStatus.isTempStatus((GroupStatus)curState)) {
            LOGGER.error("inlong groupId={} status={} was not allowed to add/update/delete stream", (Object)groupId, (Object)curState);
            throw new BusinessException(ErrorCodeEnum.STREAM_OPT_NOT_ALLOWED);
        }
        return entity;
    }

    @Override
    public List<BriefMQMessage> listMessages(QueryMessageRequest request, String operator) {
        InlongGroupEntity groupEntity = this.groupMapper.selectByGroupId(request.getGroupId());
        if (groupEntity == null) {
            throw new BusinessException(String.format("InlongGroup does not exist with InlongGroupId=%s", request.getGroupId()));
        }
        this.userService.checkUser(groupEntity.getInCharges(), operator, String.format("Current user does not have permission to query message for groupId=%s", request.getGroupId()));
        InlongGroupOperator instance = this.groupOperatorFactory.getInstance(groupEntity.getMqType());
        InlongGroupInfo groupInfo = instance.getFromEntity(groupEntity);
        InlongStreamInfo inlongStreamInfo = this.get(request.getGroupId(), request.getStreamId());
        ArrayList<BriefMQMessage> messageList = new ArrayList();
        QueueResourceOperator queueOperator = this.queueOperatorFactory.getInstance(groupEntity.getMqType());
        try {
            messageList = queueOperator.queryLatestMessages(groupInfo, inlongStreamInfo, request);
        }
        catch (Exception e) {
            LOGGER.error("query message error ", (Throwable)e);
        }
        return messageList;
    }
}

