/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.source.sql;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.common.pojo.agent.DataConfig;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.JsonUtils;
import org.apache.inlong.manager.dao.entity.InlongStreamEntity;
import org.apache.inlong.manager.dao.entity.StreamSourceEntity;
import org.apache.inlong.manager.dao.mapper.InlongStreamEntityMapper;
import org.apache.inlong.manager.dao.mapper.StreamSourceEntityMapper;
import org.apache.inlong.manager.pojo.node.sql.SqlDataNodeInfo;
import org.apache.inlong.manager.pojo.source.DataAddTaskDTO;
import org.apache.inlong.manager.pojo.source.DataAddTaskRequest;
import org.apache.inlong.manager.pojo.source.SourceRequest;
import org.apache.inlong.manager.pojo.source.StreamSource;
import org.apache.inlong.manager.pojo.source.sql.SqlDataAddTaskRequest;
import org.apache.inlong.manager.pojo.source.sql.SqlSource;
import org.apache.inlong.manager.pojo.source.sql.SqlSourceDTO;
import org.apache.inlong.manager.pojo.source.sql.SqlSourceRequest;
import org.apache.inlong.manager.pojo.stream.StreamField;
import org.apache.inlong.manager.service.source.AbstractSourceOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SqlSourceOperator
extends AbstractSourceOperator {
    private static final Logger LOGGER = LoggerFactory.getLogger(SqlSourceOperator.class);
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private StreamSourceEntityMapper sourceMapper;
    @Autowired
    private InlongStreamEntityMapper streamEntityMapper;

    @Override
    public Boolean accept(String sourceType) {
        return "SQL".equals(sourceType);
    }

    @Override
    protected String getSourceType() {
        return "SQL";
    }

    @Override
    protected void setTargetEntity(SourceRequest request, StreamSourceEntity targetEntity) {
        SqlSourceRequest sourceRequest = (SqlSourceRequest)request;
        try {
            CommonBeanUtils.copyProperties((Object)sourceRequest, (Object)targetEntity, (boolean)true);
            SqlSourceDTO dto = SqlSourceDTO.getFromRequest((SqlSourceRequest)sourceRequest, (String)targetEntity.getExtParams());
            targetEntity.setExtParams(this.objectMapper.writeValueAsString((Object)dto));
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.SOURCE_INFO_INCORRECT, String.format("serialize extParams of Sql SourceDTO failure: %s", e.getMessage()));
        }
    }

    @Override
    public StreamSource getFromEntity(StreamSourceEntity entity) {
        SqlSource source = new SqlSource();
        if (entity == null) {
            return source;
        }
        SqlSourceDTO dto = SqlSourceDTO.getFromJson((String)entity.getExtParams());
        CommonBeanUtils.copyProperties((Object)entity, (Object)source, (boolean)true);
        CommonBeanUtils.copyProperties((Object)dto, (Object)source, (boolean)true);
        List<StreamField> sourceFields = super.getSourceFields(entity.getId());
        source.setFieldList(sourceFields);
        List dataAddTaskList = this.sourceMapper.selectByTaskMapId(entity.getId());
        source.setDataAddTaskList(dataAddTaskList.stream().map(subEntity -> DataAddTaskDTO.builder().id(subEntity.getId()).taskMapId(entity.getId()).agentIp(subEntity.getAgentIp()).status(subEntity.getStatus()).build()).collect(Collectors.toList()));
        return source;
    }

    @Override
    public String getExtParams(StreamSourceEntity sourceEntity) {
        SqlSourceDTO sqlSourceDTO = SqlSourceDTO.getFromJson((String)sourceEntity.getExtParams());
        if (Objects.nonNull(sqlSourceDTO) && StringUtils.isNotBlank((CharSequence)sourceEntity.getDataNodeName())) {
            SqlDataNodeInfo dataNodeInfo = (SqlDataNodeInfo)this.dataNodeService.getByKeyWithoutTenant(sourceEntity.getDataNodeName(), "SQL");
            sqlSourceDTO.setJdbcUrl(dataNodeInfo.getUrl());
            sqlSourceDTO.setUsername(dataNodeInfo.getUsername());
            sqlSourceDTO.setJdbcPassword(dataNodeInfo.getToken());
            return JsonUtils.toJsonString((Object)sqlSourceDTO);
        }
        return sourceEntity.getExtParams();
    }

    @Override
    @Transactional(rollbackFor={Throwable.class}, isolation=Isolation.REPEATABLE_READ)
    public Integer addDataAddTask(DataAddTaskRequest request, String operator) {
        try {
            SqlDataAddTaskRequest sourceRequest = (SqlDataAddTaskRequest)request;
            StreamSourceEntity sourceEntity = this.sourceMapper.selectById(request.getSourceId());
            SqlSourceDTO dto = SqlSourceDTO.getFromJson((String)sourceEntity.getExtParams());
            dto.setDataTimeFrom(sourceRequest.getDataTimeFrom());
            dto.setDataTimeTo(sourceRequest.getDataTimeTo());
            dto.setRetry(Boolean.valueOf(true));
            if (request.getIncreaseAuditVersion().booleanValue()) {
                dto.setAuditVersion(request.getAuditVersion());
            }
            StreamSourceEntity dataAddTaskEntity = (StreamSourceEntity)CommonBeanUtils.copyProperties((Object)sourceEntity, StreamSourceEntity::new);
            dataAddTaskEntity.setId(null);
            dataAddTaskEntity.setSourceName(sourceEntity.getSourceName() + "-" + request.getAuditVersion() + "-" + sourceEntity.getId());
            dataAddTaskEntity.setExtParams(this.objectMapper.writeValueAsString((Object)dto));
            dataAddTaskEntity.setTaskMapId(sourceEntity.getId());
            Integer id = this.sourceMapper.insert(dataAddTaskEntity);
            SourceRequest dataAddTaskRequest = (SourceRequest)CommonBeanUtils.copyProperties((Object)dataAddTaskEntity, SourceRequest::new, (boolean)true);
            this.updateAgentTaskConfig(dataAddTaskRequest, operator);
            return id;
        }
        catch (Exception e) {
            LOGGER.error("serialize extParams of Sql SourceDTO failure: ", (Throwable)e);
            throw new BusinessException(ErrorCodeEnum.SOURCE_INFO_INCORRECT, String.format("serialize extParams of Sql SourceDTO failure: %s", e.getMessage()));
        }
    }

    @Override
    public String updateDataConfig(String extParams, InlongStreamEntity streamEntity, DataConfig dataConfig) {
        String dataSeparator = String.valueOf((char)Integer.parseInt(streamEntity.getDataSeparator()));
        SqlSourceDTO sqlSourceDTO = (SqlSourceDTO)JsonUtils.parseObject((String)extParams, SqlSourceDTO.class);
        if (Objects.nonNull(sqlSourceDTO)) {
            sqlSourceDTO.setDataSeparator(dataSeparator);
            dataConfig.setAuditVersion(sqlSourceDTO.getAuditVersion());
            extParams = JsonUtils.toJsonString((Object)sqlSourceDTO);
        }
        return extParams;
    }
}

