/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.core.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.enums.NotifyType;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.dao.entity.AuditAlertRuleEntity;
import org.apache.inlong.manager.dao.mapper.AuditAlertRuleEntityMapper;
import org.apache.inlong.manager.pojo.audit.AuditAlertCondition;
import org.apache.inlong.manager.pojo.audit.AuditAlertRule;
import org.apache.inlong.manager.pojo.audit.AuditAlertRulePageRequest;
import org.apache.inlong.manager.pojo.audit.AuditAlertRuleRequest;
import org.apache.inlong.manager.pojo.common.PageResult;
import org.apache.inlong.manager.service.core.AuditAlertRuleService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AuditAlertRuleServiceImpl
implements AuditAlertRuleService {
    private static final Logger log = LoggerFactory.getLogger(AuditAlertRuleServiceImpl.class);
    private static final ObjectMapper objectMapper = new ObjectMapper();
    @Autowired
    private AuditAlertRuleEntityMapper alertRuleMapper;

    @Override
    public Integer create(AuditAlertRuleRequest request, String operator) {
        log.info("begin to create audit alert rule from request, request={}, operator={}", (Object)request, (Object)operator);
        Preconditions.expectNotNull((Object)request, (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"request cannot be null");
        AuditAlertRuleEntity entity = (AuditAlertRuleEntity)CommonBeanUtils.copyPropertiesWithEnumSupport((Object)request, AuditAlertRuleEntity::new);
        entity.setCreator(operator);
        entity.setModifier(operator);
        try {
            String conditionJson = objectMapper.writeValueAsString((Object)request.getCondition());
            entity.setCondition(conditionJson);
        }
        catch (JsonProcessingException e) {
            log.error("Failed to serialize condition to JSON: {}", (Object)request.getCondition(), (Object)e);
            throw new BusinessException(ErrorCodeEnum.INVALID_PARAMETER, "Invalid condition format");
        }
        int result = this.alertRuleMapper.insert(entity);
        if (result <= 0) {
            log.error("Failed to create audit alert rule, entity={}", (Object)entity);
            throw new BusinessException(ErrorCodeEnum.GROUP_SAVE_FAILED, "Failed to create audit alert rule");
        }
        return entity.getId();
    }

    @Override
    public AuditAlertRule get(Integer id) {
        log.info("begin to get audit alert rule by id={}", (Object)id);
        Preconditions.expectNotNull((Object)id, (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"id cannot be null");
        AuditAlertRuleEntity entity = this.alertRuleMapper.selectById(id);
        if (entity == null) {
            log.warn("Audit alert rule not found with id: {}", (Object)id);
            throw new BusinessException(ErrorCodeEnum.RECORD_NOT_FOUND, "Audit alert rule not found with id: " + id);
        }
        AuditAlertRule rule = (AuditAlertRule)CommonBeanUtils.copyPropertiesWithEnumSupport((Object)entity, AuditAlertRule::new);
        if (StringUtils.isNotBlank((CharSequence)entity.getCondition())) {
            try {
                AuditAlertCondition condition = (AuditAlertCondition)objectMapper.readValue(entity.getCondition(), AuditAlertCondition.class);
                rule.setCondition(condition);
            }
            catch (JsonProcessingException e) {
                log.error("Failed to parse condition JSON: {}", (Object)entity.getCondition(), (Object)e);
                throw new BusinessException(ErrorCodeEnum.INVALID_PARAMETER, "Invalid condition format");
            }
        }
        log.info("success to get audit alert rule by id={}", (Object)id);
        return rule;
    }

    @Override
    public Boolean update(AuditAlertRuleRequest request, String operator) {
        log.info("begin to update audit alert rule from request, request={}, operator={}", (Object)request, (Object)operator);
        Preconditions.expectNotNull((Object)request, (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"request cannot be null");
        Preconditions.expectNotNull((Object)request.getId(), (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"rule id cannot be null");
        AuditAlertRuleEntity existingEntity = this.alertRuleMapper.selectById(request.getId());
        if (existingEntity == null) {
            log.warn("Audit alert rule not found with id: {}", (Object)request.getId());
            throw new BusinessException(ErrorCodeEnum.RECORD_NOT_FOUND, "Audit alert rule not found with id: " + request.getId());
        }
        log.debug("Existing entity version: {}, Incoming rule version: {}", (Object)existingEntity.getVersion(), (Object)request.getVersion());
        if (!Objects.equals(request.getVersion(), existingEntity.getVersion())) {
            log.warn("Audit alert rule config has been modified, please refresh and try again. Existing version: {}, Incoming version: {}", (Object)existingEntity.getVersion(), (Object)request.getVersion());
            throw new BusinessException(ErrorCodeEnum.CONFIG_EXPIRED, "Audit alert rule config has been modified, please refresh and try again. Existing version: " + existingEntity.getVersion() + ", Incoming version: " + request.getVersion());
        }
        AuditAlertRuleEntity entity = (AuditAlertRuleEntity)CommonBeanUtils.copyPropertiesWithEnumSupport((Object)request, AuditAlertRuleEntity::new);
        entity.setModifier(operator);
        log.debug("Updating entity with current version: {}", (Object)existingEntity.getVersion());
        if (request.getCondition() != null) {
            try {
                String conditionJson = objectMapper.writeValueAsString((Object)request.getCondition());
                entity.setCondition(conditionJson);
            }
            catch (JsonProcessingException e) {
                log.error("Failed to serialize condition to JSON: {}", (Object)request.getCondition(), (Object)e);
                throw new BusinessException(ErrorCodeEnum.INVALID_PARAMETER, "Invalid condition format");
            }
        } else {
            entity.setCondition(existingEntity.getCondition());
        }
        int result = this.alertRuleMapper.updateById(entity);
        if (result <= 0) {
            log.error("Failed to update audit alert rule, entity={}", (Object)entity);
            throw new BusinessException(ErrorCodeEnum.GROUP_SAVE_FAILED, "Failed to update audit alert rule");
        }
        log.info("success to update audit alert rule from request, request={}, operator={}", (Object)request, (Object)operator);
        return true;
    }

    @Override
    public Boolean delete(Integer id) {
        log.info("begin to delete audit alert rule by id={}", (Object)id);
        Preconditions.expectNotNull((Object)id, (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"id cannot be null");
        AuditAlertRuleEntity existingEntity = this.alertRuleMapper.selectById(id);
        if (existingEntity == null) {
            log.warn("Audit alert rule not found with id: {}", (Object)id);
            throw new BusinessException(ErrorCodeEnum.RECORD_NOT_FOUND, "Audit alert rule not found with id: " + id);
        }
        existingEntity.setIsDeleted(id);
        int result = this.alertRuleMapper.updateById(existingEntity);
        if (result <= 0) {
            log.error("Failed to delete audit alert rule by id={}", (Object)id);
            throw new BusinessException(ErrorCodeEnum.GROUP_DELETE_NOT_ALLOWED, "Failed to delete audit alert rule");
        }
        log.info("success to delete audit alert rule by id={}", (Object)id);
        return true;
    }

    @Override
    public PageResult<AuditAlertRule> selectByCondition(AuditAlertRulePageRequest request) {
        log.info("begin to select audit alert rules by condition with pagination, request={}", (Object)request);
        PageHelper.startPage((int)request.getPageNum(), (int)request.getPageSize());
        Page entityPage = (Page)this.alertRuleMapper.selectByCondition(request);
        List rules = entityPage.stream().map(e -> {
            AuditAlertRule rule = (AuditAlertRule)CommonBeanUtils.copyProperties((Object)e, AuditAlertRule::new);
            if (StringUtils.isNotBlank((CharSequence)e.getCondition())) {
                try {
                    AuditAlertCondition condition = (AuditAlertCondition)objectMapper.readValue(e.getCondition(), AuditAlertCondition.class);
                    rule.setCondition(condition);
                }
                catch (JsonProcessingException ex) {
                    log.error("Failed to parse condition JSON: {}", (Object)e.getCondition(), (Object)ex);
                }
            }
            if (StringUtils.isNotBlank((CharSequence)e.getNotifyType())) {
                try {
                    rule.setNotifyType(NotifyType.valueOf((String)e.getNotifyType()));
                }
                catch (IllegalArgumentException ex) {
                    log.warn("Invalid notifyType value in database: {}", (Object)e.getNotifyType());
                }
            }
            return rule;
        }).collect(Collectors.toList());
        PageResult pageResult = new PageResult(rules, Long.valueOf(entityPage.getTotal()), Integer.valueOf(entityPage.getPageNum()), Integer.valueOf(entityPage.getPageSize()));
        log.info("success to select audit alert rules by condition with pagination, count={}", (Object)pageResult.getList().size());
        return pageResult;
    }
}

