/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.commons.protocol;

import com.google.protobuf.ByteString;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.inlong.sdk.commons.protocol.ProxyEvent;
import org.apache.inlong.sdk.commons.protocol.ProxySdk;
import org.apache.inlong.sdk.commons.protocol.SdkEvent;
import org.apache.inlong.sdk.commons.protocol.SortEvent;
import org.apache.inlong.sdk.commons.utils.GzipUtils;
import org.xerial.snappy.Snappy;

public class EventUtils {
    public static ProxySdk.MessagePack encodeSdkEvents(String inlongGroupId, String inlongStreamId, ProxySdk.INLONG_COMPRESSED_TYPE compressedType, List<SdkEvent> events) throws IOException {
        ProxySdk.MessageObjs.Builder objsBuilder = ProxySdk.MessageObjs.newBuilder();
        for (SdkEvent event : events) {
            ProxySdk.MessageObj.Builder objBuilder = ProxySdk.MessageObj.newBuilder();
            objBuilder.setMsgTime(event.getMsgTime());
            objBuilder.setSourceIp(event.getSourceIp());
            objBuilder.setBody(ByteString.copyFrom((byte[])event.getBody()));
            objsBuilder.addMsgs(objBuilder.build());
        }
        ProxySdk.MessageObjs objs = objsBuilder.build();
        byte[] srcBytes = objs.toByteArray();
        byte[] compressedBytes = null;
        switch (compressedType) {
            case INLONG_SNAPPY: {
                compressedBytes = Snappy.compress((byte[])srcBytes);
                break;
            }
            case INLONG_GZ: {
                compressedBytes = GzipUtils.compress(srcBytes);
                break;
            }
            default: {
                compressedBytes = srcBytes;
            }
        }
        ProxySdk.MessagePack.Builder packBuilder = ProxySdk.MessagePack.newBuilder();
        packBuilder.setCompressBytes(ByteString.copyFrom((byte[])compressedBytes));
        ProxySdk.MessagePackHeader.Builder headerBuilder = ProxySdk.MessagePackHeader.newBuilder();
        headerBuilder.setInlongGroupId(inlongGroupId);
        headerBuilder.setInlongStreamId(inlongStreamId);
        headerBuilder.setPackId(0L);
        headerBuilder.setPackTime(System.currentTimeMillis());
        headerBuilder.setMsgCount(events.size());
        headerBuilder.setSrcLength(srcBytes.length);
        headerBuilder.setCompressLen(compressedBytes.length);
        headerBuilder.setCompressType(compressedType);
        packBuilder.setHeader(headerBuilder.build());
        return packBuilder.build();
    }

    public static List<ProxyEvent> decodeSdkPack(ProxySdk.MessagePack packObject) throws IOException {
        ProxySdk.MessagePackHeader header = packObject.getHeader();
        byte[] compressBytes = packObject.getCompressBytes().toByteArray();
        byte[] srcBytes = null;
        switch (header.getCompressType()) {
            case INLONG_SNAPPY: {
                srcBytes = Snappy.uncompress((byte[])compressBytes);
                break;
            }
            case INLONG_GZ: {
                srcBytes = GzipUtils.decompress(compressBytes);
                break;
            }
            default: {
                srcBytes = compressBytes;
            }
        }
        ProxySdk.MessageObjs msgObjs = ProxySdk.MessageObjs.parseFrom(srcBytes);
        ArrayList<ProxyEvent> events = new ArrayList<ProxyEvent>(msgObjs.getMsgsList().size());
        String inlongGroupId = header.getInlongGroupId();
        String inlongStreamId = header.getInlongStreamId();
        for (ProxySdk.MessageObj msgObj : msgObjs.getMsgsList()) {
            ProxyEvent event = new ProxyEvent(inlongGroupId, inlongStreamId, msgObj);
            events.add(event);
        }
        return events;
    }

    public static byte[] encodeCacheMessageBody(ProxySdk.INLONG_COMPRESSED_TYPE compressedType, List<ProxyEvent> events) throws IOException {
        ProxySdk.MessageObjs.Builder objs = ProxySdk.MessageObjs.newBuilder();
        for (ProxyEvent event : events) {
            ProxySdk.MessageObj.Builder builder = ProxySdk.MessageObj.newBuilder();
            builder.setMsgTime(event.getMsgTime());
            builder.setSourceIp(event.getSourceIp());
            event.getHeaders().forEach((key, value) -> builder.addParams(ProxySdk.MapFieldEntry.newBuilder().setKey((String)key).setValue((String)value)));
            builder.setBody(ByteString.copyFrom((byte[])event.getBody()));
            objs.addMsgs(builder.build());
        }
        byte[] srcBytes = objs.build().toByteArray();
        byte[] compressBytes = null;
        switch (compressedType) {
            case INLONG_SNAPPY: {
                compressBytes = Snappy.compress((byte[])srcBytes);
                break;
            }
            case INLONG_GZ: {
                compressBytes = GzipUtils.compress(srcBytes);
                break;
            }
            default: {
                compressBytes = srcBytes;
            }
        }
        return compressBytes;
    }

    public static List<SortEvent> decodeCacheMessageBody(String inlongGroupId, String inlongStreamId, ProxySdk.INLONG_COMPRESSED_TYPE compressedType, byte[] msgBody) throws IOException {
        byte[] srcBytes = null;
        switch (compressedType) {
            case INLONG_SNAPPY: {
                srcBytes = Snappy.uncompress((byte[])msgBody);
                break;
            }
            case INLONG_GZ: {
                srcBytes = GzipUtils.decompress(msgBody);
                break;
            }
            default: {
                srcBytes = msgBody;
            }
        }
        ProxySdk.MessageObjs msgObjs = ProxySdk.MessageObjs.parseFrom(srcBytes);
        ArrayList<SortEvent> events = new ArrayList<SortEvent>(msgObjs.getMsgsList().size());
        for (ProxySdk.MessageObj msgObj : msgObjs.getMsgsList()) {
            SortEvent event = new SortEvent(inlongGroupId, inlongStreamId, msgObj);
            events.add(event);
        }
        return events;
    }
}

