/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class OffsetFetchRequestData
implements ApiMessage {
    String groupId;
    List<OffsetFetchRequestTopic> topics;
    List<OffsetFetchRequestGroup> groups;
    boolean requireStable;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0;
    public static final Schema SCHEMA_1;
    public static final Schema SCHEMA_2;
    public static final Schema SCHEMA_3;
    public static final Schema SCHEMA_4;
    public static final Schema SCHEMA_5;
    public static final Schema SCHEMA_6;
    public static final Schema SCHEMA_7;
    public static final Schema SCHEMA_8;
    public static final Schema[] SCHEMAS;
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 8;

    public OffsetFetchRequestData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public OffsetFetchRequestData() {
        this.groupId = "";
        this.topics = new ArrayList<OffsetFetchRequestTopic>(0);
        this.groups = new ArrayList<OffsetFetchRequestGroup>(0);
        this.requireStable = false;
    }

    @Override
    public short apiKey() {
        return 9;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 8;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void read(Readable _readable, short _version) {
        int i;
        ArrayList<OffsetFetchRequestTopic> newCollection;
        int arrayLength;
        if (_version <= 7) {
            int length = _version >= 6 ? _readable.readUnsignedVarint() - 1 : _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field groupId was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field groupId had invalid length " + length);
            }
            this.groupId = _readable.readString(length);
        } else {
            this.groupId = "";
        }
        if (_version <= 7) {
            if (_version >= 6) {
                arrayLength = _readable.readUnsignedVarint() - 1;
                if (arrayLength < 0) {
                    this.topics = null;
                } else {
                    newCollection = new ArrayList(arrayLength);
                    for (i = 0; i < arrayLength; ++i) {
                        newCollection.add(new OffsetFetchRequestTopic(_readable, _version));
                    }
                    this.topics = newCollection;
                }
            } else {
                arrayLength = _readable.readInt();
                if (arrayLength < 0) {
                    if (_version < 2) throw new RuntimeException("non-nullable field topics was serialized as null");
                    this.topics = null;
                } else {
                    newCollection = new ArrayList<OffsetFetchRequestTopic>(arrayLength);
                    for (i = 0; i < arrayLength; ++i) {
                        newCollection.add(new OffsetFetchRequestTopic(_readable, _version));
                    }
                    this.topics = newCollection;
                }
            }
        } else {
            this.topics = new ArrayList<OffsetFetchRequestTopic>(0);
        }
        if (_version >= 8) {
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field groups was serialized as null");
            }
            newCollection = new ArrayList(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add((OffsetFetchRequestTopic)((Object)new OffsetFetchRequestGroup(_readable, _version)));
            }
            this.groups = newCollection;
        } else {
            this.groups = new ArrayList<OffsetFetchRequestGroup>(0);
        }
        this.requireStable = _version >= 7 ? _readable.readByte() != 0 : false;
        this._unknownTaggedFields = null;
        if (_version < 6) return;
        int _numTaggedFields = _readable.readUnsignedVarint();
        for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                default: 
            }
            this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        Object _stringBytes;
        int _numTaggedFields = 0;
        if (_version <= 7) {
            _stringBytes = _cache.getSerializedValue(this.groupId);
            if (_version >= 6) {
                _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            } else {
                _writable.writeShort((short)((byte[])_stringBytes).length);
            }
            _writable.writeByteArray((byte[])_stringBytes);
        } else if (!this.groupId.equals("")) {
            throw new UnsupportedVersionException("Attempted to write a non-default groupId at version " + _version);
        }
        if (_version <= 7) {
            OffsetFetchRequestTopic topicsElement;
            if (_version >= 6) {
                if (this.topics == null) {
                    _writable.writeUnsignedVarint(0);
                } else {
                    _writable.writeUnsignedVarint(this.topics.size() + 1);
                    _stringBytes = this.topics.iterator();
                    while (_stringBytes.hasNext()) {
                        topicsElement = (OffsetFetchRequestTopic)_stringBytes.next();
                        topicsElement.write(_writable, _cache, _version);
                    }
                }
            } else if (this.topics == null) {
                if (_version < 2) throw new NullPointerException();
                _writable.writeInt(-1);
            } else {
                _writable.writeInt(this.topics.size());
                _stringBytes = this.topics.iterator();
                while (_stringBytes.hasNext()) {
                    topicsElement = (OffsetFetchRequestTopic)_stringBytes.next();
                    topicsElement.write(_writable, _cache, _version);
                }
            }
        } else if (this.topics == null || !this.topics.isEmpty()) {
            throw new UnsupportedVersionException("Attempted to write a non-default topics at version " + _version);
        }
        if (_version >= 8) {
            _writable.writeUnsignedVarint(this.groups.size() + 1);
            for (OffsetFetchRequestGroup groupsElement : this.groups) {
                groupsElement.write(_writable, _cache, _version);
            }
        } else if (!this.groups.isEmpty()) {
            throw new UnsupportedVersionException("Attempted to write a non-default groups at version " + _version);
        }
        if (_version >= 7) {
            _writable.writeByte(this.requireStable ? (byte)1 : 0);
        } else if (this.requireStable) {
            throw new UnsupportedVersionException("Attempted to write a non-default requireStable at version " + _version);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _numTaggedFields += _rawWriter.numFields();
        if (_version >= 6) {
            _writable.writeUnsignedVarint(_numTaggedFields);
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            return;
        } else {
            if (_numTaggedFields <= 0) return;
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        if (_version <= 7) {
            byte[] _stringBytes = this.groupId.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'groupId' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.groupId, _stringBytes);
            if (_version >= 6) {
                _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            } else {
                _size.addBytes(_stringBytes.length + 2);
            }
        }
        if (_version <= 7) {
            if (this.topics == null) {
                if (_version >= 6) {
                    _size.addBytes(1);
                } else {
                    _size.addBytes(4);
                }
            } else {
                if (_version >= 6) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.topics.size() + 1));
                } else {
                    _size.addBytes(4);
                }
                for (OffsetFetchRequestTopic topicsElement : this.topics) {
                    topicsElement.addSize(_size, _cache, _version);
                }
            }
        }
        if (_version >= 8) {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.groups.size() + 1));
            for (OffsetFetchRequestGroup groupsElement : this.groups) {
                groupsElement.addSize(_size, _cache, _version);
            }
        }
        if (_version >= 7) {
            _size.addBytes(1);
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        if (_version >= 6) {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof OffsetFetchRequestData)) {
            return false;
        }
        OffsetFetchRequestData other = (OffsetFetchRequestData)obj;
        if (this.groupId == null ? other.groupId != null : !this.groupId.equals(other.groupId)) {
            return false;
        }
        if (this.topics == null ? other.topics != null : !this.topics.equals(other.topics)) {
            return false;
        }
        if (this.groups == null ? other.groups != null : !this.groups.equals(other.groups)) {
            return false;
        }
        if (this.requireStable != other.requireStable) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.groupId == null ? 0 : this.groupId.hashCode());
        hashCode = 31 * hashCode + (this.topics == null ? 0 : this.topics.hashCode());
        hashCode = 31 * hashCode + (this.groups == null ? 0 : this.groups.hashCode());
        hashCode = 31 * hashCode + (this.requireStable ? 1231 : 1237);
        return hashCode;
    }

    @Override
    public OffsetFetchRequestData duplicate() {
        OffsetFetchRequestData _duplicate = new OffsetFetchRequestData();
        _duplicate.groupId = this.groupId;
        if (this.topics == null) {
            _duplicate.topics = null;
        } else {
            ArrayList<OffsetFetchRequestTopic> newTopics = new ArrayList<OffsetFetchRequestTopic>(this.topics.size());
            for (OffsetFetchRequestTopic offsetFetchRequestTopic : this.topics) {
                newTopics.add(offsetFetchRequestTopic.duplicate());
            }
            _duplicate.topics = newTopics;
        }
        ArrayList<OffsetFetchRequestGroup> newGroups = new ArrayList<OffsetFetchRequestGroup>(this.groups.size());
        for (OffsetFetchRequestGroup offsetFetchRequestGroup : this.groups) {
            newGroups.add(offsetFetchRequestGroup.duplicate());
        }
        _duplicate.groups = newGroups;
        _duplicate.requireStable = this.requireStable;
        return _duplicate;
    }

    public String toString() {
        return "OffsetFetchRequestData(groupId=" + (this.groupId == null ? "null" : "'" + this.groupId.toString() + "'") + ", topics=" + (this.topics == null ? "null" : MessageUtil.deepToString(this.topics.iterator())) + ", groups=" + MessageUtil.deepToString(this.groups.iterator()) + ", requireStable=" + (this.requireStable ? "true" : "false") + ")";
    }

    public String groupId() {
        return this.groupId;
    }

    public List<OffsetFetchRequestTopic> topics() {
        return this.topics;
    }

    public List<OffsetFetchRequestGroup> groups() {
        return this.groups;
    }

    public boolean requireStable() {
        return this.requireStable;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public OffsetFetchRequestData setGroupId(String v) {
        this.groupId = v;
        return this;
    }

    public OffsetFetchRequestData setTopics(List<OffsetFetchRequestTopic> v) {
        this.topics = v;
        return this;
    }

    public OffsetFetchRequestData setGroups(List<OffsetFetchRequestGroup> v) {
        this.groups = v;
        return this;
    }

    public OffsetFetchRequestData setRequireStable(boolean v) {
        this.requireStable = v;
        return this;
    }

    static {
        SCHEMA_1 = SCHEMA_0 = new Schema(new Field("group_id", Type.STRING, "The group to fetch offsets for."), new Field("topics", new ArrayOf(OffsetFetchRequestTopic.SCHEMA_0), "Each topic we would like to fetch offsets for, or null to fetch offsets for all topics."));
        SCHEMA_5 = SCHEMA_4 = (SCHEMA_3 = (SCHEMA_2 = new Schema(new Field("group_id", Type.STRING, "The group to fetch offsets for."), new Field("topics", ArrayOf.nullable(OffsetFetchRequestTopic.SCHEMA_0), "Each topic we would like to fetch offsets for, or null to fetch offsets for all topics."))));
        SCHEMA_6 = new Schema(new Field("group_id", Type.COMPACT_STRING, "The group to fetch offsets for."), new Field("topics", CompactArrayOf.nullable(OffsetFetchRequestTopic.SCHEMA_6), "Each topic we would like to fetch offsets for, or null to fetch offsets for all topics."), Field.TaggedFieldsSection.of(new Object[0]));
        SCHEMA_7 = new Schema(new Field("group_id", Type.COMPACT_STRING, "The group to fetch offsets for."), new Field("topics", CompactArrayOf.nullable(OffsetFetchRequestTopic.SCHEMA_6), "Each topic we would like to fetch offsets for, or null to fetch offsets for all topics."), new Field("require_stable", Type.BOOLEAN, "Whether broker should hold on returning unstable offsets but set a retriable error code for the partitions."), Field.TaggedFieldsSection.of(new Object[0]));
        SCHEMA_8 = new Schema(new Field("groups", new CompactArrayOf(OffsetFetchRequestGroup.SCHEMA_8), "Each group we would like to fetch offsets for"), new Field("require_stable", Type.BOOLEAN, "Whether broker should hold on returning unstable offsets but set a retriable error code for the partitions."), Field.TaggedFieldsSection.of(new Object[0]));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5, SCHEMA_6, SCHEMA_7, SCHEMA_8};
    }

    public static class OffsetFetchRequestTopics
    implements Message {
        String name;
        List<Integer> partitionIndexes;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_8 = new Schema(new Field("name", Type.COMPACT_STRING, "The topic name."), new Field("partition_indexes", new CompactArrayOf(Type.INT32), "The partition indexes we would like to fetch offsets for."), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{null, null, null, null, null, null, null, null, SCHEMA_8};
        public static final short LOWEST_SUPPORTED_VERSION = 8;
        public static final short HIGHEST_SUPPORTED_VERSION = 8;

        public OffsetFetchRequestTopics(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public OffsetFetchRequestTopics() {
            this.name = "";
            this.partitionIndexes = new ArrayList<Integer>(0);
        }

        @Override
        public short lowestSupportedVersion() {
            return 8;
        }

        @Override
        public short highestSupportedVersion() {
            return 8;
        }

        @Override
        public void read(Readable _readable, short _version) {
            if (_version > 8) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of OffsetFetchRequestTopics");
            }
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field name was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field name had invalid length " + length);
            }
            this.name = _readable.readString(length);
            int arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field partitionIndexes was serialized as null");
            }
            ArrayList<Integer> newCollection = new ArrayList<Integer>(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                newCollection.add(_readable.readInt());
            }
            this.partitionIndexes = newCollection;
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            Object _stringBytes = _cache.getSerializedValue(this.name);
            _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            _writable.writeByteArray((byte[])_stringBytes);
            _writable.writeUnsignedVarint(this.partitionIndexes.size() + 1);
            _stringBytes = this.partitionIndexes.iterator();
            while (_stringBytes.hasNext()) {
                Integer partitionIndexesElement = (Integer)_stringBytes.next();
                _writable.writeInt(partitionIndexesElement);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            if (_version > 8) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of OffsetFetchRequestTopics");
            }
            byte[] _stringBytes = this.name.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'name' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.name, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.partitionIndexes.size() + 1));
            _size.addBytes(this.partitionIndexes.size() * 4);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof OffsetFetchRequestTopics)) {
                return false;
            }
            OffsetFetchRequestTopics other = (OffsetFetchRequestTopics)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.partitionIndexes == null ? other.partitionIndexes != null : !this.partitionIndexes.equals(other.partitionIndexes)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            hashCode = 31 * hashCode + (this.partitionIndexes == null ? 0 : this.partitionIndexes.hashCode());
            return hashCode;
        }

        @Override
        public OffsetFetchRequestTopics duplicate() {
            OffsetFetchRequestTopics _duplicate = new OffsetFetchRequestTopics();
            _duplicate.name = this.name;
            ArrayList<Integer> newPartitionIndexes = new ArrayList<Integer>(this.partitionIndexes.size());
            for (Integer _element : this.partitionIndexes) {
                newPartitionIndexes.add(_element);
            }
            _duplicate.partitionIndexes = newPartitionIndexes;
            return _duplicate;
        }

        public String toString() {
            return "OffsetFetchRequestTopics(name=" + (this.name == null ? "null" : "'" + this.name.toString() + "'") + ", partitionIndexes=" + MessageUtil.deepToString(this.partitionIndexes.iterator()) + ")";
        }

        public String name() {
            return this.name;
        }

        public List<Integer> partitionIndexes() {
            return this.partitionIndexes;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public OffsetFetchRequestTopics setName(String v) {
            this.name = v;
            return this;
        }

        public OffsetFetchRequestTopics setPartitionIndexes(List<Integer> v) {
            this.partitionIndexes = v;
            return this;
        }
    }

    public static class OffsetFetchRequestGroup
    implements Message {
        String groupId;
        List<OffsetFetchRequestTopics> topics;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_8 = new Schema(new Field("group_id", Type.COMPACT_STRING, "The group ID."), new Field("topics", CompactArrayOf.nullable(OffsetFetchRequestTopics.SCHEMA_8), "Each topic we would like to fetch offsets for, or null to fetch offsets for all topics."), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{null, null, null, null, null, null, null, null, SCHEMA_8};
        public static final short LOWEST_SUPPORTED_VERSION = 8;
        public static final short HIGHEST_SUPPORTED_VERSION = 8;

        public OffsetFetchRequestGroup(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public OffsetFetchRequestGroup() {
            this.groupId = "";
            this.topics = new ArrayList<OffsetFetchRequestTopics>(0);
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 8;
        }

        @Override
        public void read(Readable _readable, short _version) {
            if (_version > 8) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of OffsetFetchRequestGroup");
            }
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field groupId was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field groupId had invalid length " + length);
            }
            this.groupId = _readable.readString(length);
            int arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                this.topics = null;
            } else {
                ArrayList<OffsetFetchRequestTopics> newCollection = new ArrayList<OffsetFetchRequestTopics>(arrayLength);
                for (int i = 0; i < arrayLength; ++i) {
                    newCollection.add(new OffsetFetchRequestTopics(_readable, _version));
                }
                this.topics = newCollection;
            }
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            if (_version < 8) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of OffsetFetchRequestGroup");
            }
            int _numTaggedFields = 0;
            Object _stringBytes = _cache.getSerializedValue(this.groupId);
            _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            _writable.writeByteArray((byte[])_stringBytes);
            if (this.topics == null) {
                _writable.writeUnsignedVarint(0);
            } else {
                _writable.writeUnsignedVarint(this.topics.size() + 1);
                _stringBytes = this.topics.iterator();
                while (_stringBytes.hasNext()) {
                    OffsetFetchRequestTopics topicsElement = (OffsetFetchRequestTopics)_stringBytes.next();
                    topicsElement.write(_writable, _cache, _version);
                }
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            if (_version > 8) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of OffsetFetchRequestGroup");
            }
            byte[] _stringBytes = this.groupId.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'groupId' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.groupId, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            if (this.topics == null) {
                _size.addBytes(1);
            } else {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.topics.size() + 1));
                for (OffsetFetchRequestTopics topicsElement : this.topics) {
                    topicsElement.addSize(_size, _cache, _version);
                }
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof OffsetFetchRequestGroup)) {
                return false;
            }
            OffsetFetchRequestGroup other = (OffsetFetchRequestGroup)obj;
            if (this.groupId == null ? other.groupId != null : !this.groupId.equals(other.groupId)) {
                return false;
            }
            if (this.topics == null ? other.topics != null : !this.topics.equals(other.topics)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.groupId == null ? 0 : this.groupId.hashCode());
            hashCode = 31 * hashCode + (this.topics == null ? 0 : this.topics.hashCode());
            return hashCode;
        }

        @Override
        public OffsetFetchRequestGroup duplicate() {
            OffsetFetchRequestGroup _duplicate = new OffsetFetchRequestGroup();
            _duplicate.groupId = this.groupId;
            if (this.topics == null) {
                _duplicate.topics = null;
            } else {
                ArrayList<OffsetFetchRequestTopics> newTopics = new ArrayList<OffsetFetchRequestTopics>(this.topics.size());
                for (OffsetFetchRequestTopics _element : this.topics) {
                    newTopics.add(_element.duplicate());
                }
                _duplicate.topics = newTopics;
            }
            return _duplicate;
        }

        public String toString() {
            return "OffsetFetchRequestGroup(groupId=" + (this.groupId == null ? "null" : "'" + this.groupId.toString() + "'") + ", topics=" + (this.topics == null ? "null" : MessageUtil.deepToString(this.topics.iterator())) + ")";
        }

        public String groupId() {
            return this.groupId;
        }

        public List<OffsetFetchRequestTopics> topics() {
            return this.topics;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public OffsetFetchRequestGroup setGroupId(String v) {
            this.groupId = v;
            return this;
        }

        public OffsetFetchRequestGroup setTopics(List<OffsetFetchRequestTopics> v) {
            this.topics = v;
            return this;
        }
    }

    public static class OffsetFetchRequestTopic
    implements Message {
        String name;
        List<Integer> partitionIndexes;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema SCHEMA_4;
        public static final Schema SCHEMA_5;
        public static final Schema SCHEMA_6;
        public static final Schema SCHEMA_7;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 7;

        public OffsetFetchRequestTopic(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public OffsetFetchRequestTopic() {
            this.name = "";
            this.partitionIndexes = new ArrayList<Integer>(0);
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 8;
        }

        @Override
        public void read(Readable _readable, short _version) {
            int length = _version >= 6 ? _readable.readUnsignedVarint() - 1 : _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field name was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field name had invalid length " + length);
            }
            this.name = _readable.readString(length);
            int arrayLength = _version >= 6 ? _readable.readUnsignedVarint() - 1 : _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field partitionIndexes was serialized as null");
            }
            ArrayList<Integer> newCollection = new ArrayList<Integer>(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                newCollection.add(_readable.readInt());
            }
            this.partitionIndexes = newCollection;
            this._unknownTaggedFields = null;
            if (_version >= 6) {
                int _numTaggedFields = _readable.readUnsignedVarint();
                for (int _i = 0; _i < _numTaggedFields; ++_i) {
                    int _tag = _readable.readUnsignedVarint();
                    int _size = _readable.readUnsignedVarint();
                    switch (_tag) {
                        default: 
                    }
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            if (_version > 7) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of OffsetFetchRequestTopic");
            }
            int _numTaggedFields = 0;
            Object _stringBytes = _cache.getSerializedValue(this.name);
            if (_version >= 6) {
                _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            } else {
                _writable.writeShort((short)((byte[])_stringBytes).length);
            }
            _writable.writeByteArray((byte[])_stringBytes);
            if (_version >= 6) {
                _writable.writeUnsignedVarint(this.partitionIndexes.size() + 1);
            } else {
                _writable.writeInt(this.partitionIndexes.size());
            }
            _stringBytes = this.partitionIndexes.iterator();
            while (_stringBytes.hasNext()) {
                Integer partitionIndexesElement = (Integer)_stringBytes.next();
                _writable.writeInt(partitionIndexesElement);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 6) {
                _writable.writeUnsignedVarint(_numTaggedFields);
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            byte[] _stringBytes = this.name.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'name' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.name, _stringBytes);
            if (_version >= 6) {
                _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            } else {
                _size.addBytes(_stringBytes.length + 2);
            }
            if (_version >= 6) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.partitionIndexes.size() + 1));
            } else {
                _size.addBytes(4);
            }
            _size.addBytes(this.partitionIndexes.size() * 4);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            if (_version >= 6) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof OffsetFetchRequestTopic)) {
                return false;
            }
            OffsetFetchRequestTopic other = (OffsetFetchRequestTopic)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.partitionIndexes == null ? other.partitionIndexes != null : !this.partitionIndexes.equals(other.partitionIndexes)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            hashCode = 31 * hashCode + (this.partitionIndexes == null ? 0 : this.partitionIndexes.hashCode());
            return hashCode;
        }

        @Override
        public OffsetFetchRequestTopic duplicate() {
            OffsetFetchRequestTopic _duplicate = new OffsetFetchRequestTopic();
            _duplicate.name = this.name;
            ArrayList<Integer> newPartitionIndexes = new ArrayList<Integer>(this.partitionIndexes.size());
            for (Integer _element : this.partitionIndexes) {
                newPartitionIndexes.add(_element);
            }
            _duplicate.partitionIndexes = newPartitionIndexes;
            return _duplicate;
        }

        public String toString() {
            return "OffsetFetchRequestTopic(name=" + (this.name == null ? "null" : "'" + this.name.toString() + "'") + ", partitionIndexes=" + MessageUtil.deepToString(this.partitionIndexes.iterator()) + ")";
        }

        public String name() {
            return this.name;
        }

        public List<Integer> partitionIndexes() {
            return this.partitionIndexes;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public OffsetFetchRequestTopic setName(String v) {
            this.name = v;
            return this;
        }

        public OffsetFetchRequestTopic setPartitionIndexes(List<Integer> v) {
            this.partitionIndexes = v;
            return this;
        }

        static {
            SCHEMA_5 = SCHEMA_4 = (SCHEMA_3 = (SCHEMA_2 = (SCHEMA_1 = (SCHEMA_0 = new Schema(new Field("name", Type.STRING, "The topic name."), new Field("partition_indexes", new ArrayOf(Type.INT32), "The partition indexes we would like to fetch offsets for."))))));
            SCHEMA_7 = SCHEMA_6 = new Schema(new Field("name", Type.COMPACT_STRING, "The topic name."), new Field("partition_indexes", new CompactArrayOf(Type.INT32), "The partition indexes we would like to fetch offsets for."), Field.TaggedFieldsSection.of(new Object[0]));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5, SCHEMA_6, SCHEMA_7};
        }
    }
}

