/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.manager.service;

import java.util.Date;
import java.util.List;
import javax.transaction.Transactional;
import org.apache.inlong.tubemq.manager.controller.TubeMQResult;
import org.apache.inlong.tubemq.manager.controller.cluster.dto.ClusterDto;
import org.apache.inlong.tubemq.manager.controller.cluster.request.AddClusterReq;
import org.apache.inlong.tubemq.manager.entry.ClusterEntry;
import org.apache.inlong.tubemq.manager.entry.MasterEntry;
import org.apache.inlong.tubemq.manager.repository.ClusterRepository;
import org.apache.inlong.tubemq.manager.service.TubeConst;
import org.apache.inlong.tubemq.manager.service.interfaces.ClusterService;
import org.apache.inlong.tubemq.manager.service.interfaces.MasterService;
import org.apache.inlong.tubemq.manager.service.interfaces.NodeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ClusterServiceImpl
implements ClusterService {
    private static final Logger log = LoggerFactory.getLogger(ClusterServiceImpl.class);
    @Autowired
    ClusterRepository clusterRepository;
    @Autowired
    NodeService nodeService;
    @Autowired
    MasterService masterService;

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void addClusterAndMasterNode(AddClusterReq req) {
        ClusterEntry entry = new ClusterEntry();
        if (req.getId() != null) {
            entry.setClusterId(req.getId().intValue());
        }
        entry.setCreateTime(new Date());
        entry.setCreateUser(req.getCreateUser());
        entry.setClusterName(req.getClusterName());
        entry.setReloadBrokerSize(req.getReloadBrokerSize());
        ClusterEntry retEntry = (ClusterEntry)this.clusterRepository.saveAndFlush(entry);
        this.addMasterNode(req, retEntry);
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void deleteCluster(Long clusterId) {
        this.masterService.deleteMaster(clusterId);
        Integer successCode = this.clusterRepository.deleteByClusterId(clusterId);
        if (successCode.equals(TubeConst.DELETE_FAIL)) {
            throw new RuntimeException("no such cluster with clusterId = " + clusterId);
        }
    }

    @Override
    public ClusterEntry getOneCluster(long clusterId) {
        return this.clusterRepository.findClusterEntryByClusterId(clusterId);
    }

    @Override
    public ClusterEntry getOneCluster(String clusterName) {
        return this.clusterRepository.findClusterEntryByClusterName(clusterName);
    }

    @Override
    public List<ClusterEntry> getAllClusters() {
        return this.clusterRepository.findAll();
    }

    @Override
    public TubeMQResult modifyCluster(ClusterDto clusterDto) {
        try {
            ClusterEntry cluster = this.clusterRepository.findClusterEntryByClusterId(clusterDto.getClusterId());
            cluster.setClusterName(clusterDto.getClusterName());
            cluster.setReloadBrokerSize(clusterDto.getReloadBrokerSize());
            this.clusterRepository.save(cluster);
        }
        catch (Exception e) {
            return TubeMQResult.errorResult(e.getMessage());
        }
        return TubeMQResult.successResult();
    }

    @Transactional(rollbackOn={Exception.class})
    public void addMasterNode(AddClusterReq req, ClusterEntry clusterEntry) {
        if (clusterEntry == null) {
            return;
        }
        for (MasterEntry masterEntry : req.getMasterEntries()) {
            masterEntry.setPort(masterEntry.getPort());
            masterEntry.setClusterId(req.getId().intValue());
            masterEntry.setWebPort(masterEntry.getWebPort());
            masterEntry.setIp(masterEntry.getIp());
            masterEntry.setToken(req.getToken());
            this.nodeService.addNode(masterEntry);
        }
    }
}

