/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.source.http;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.flume.ChannelException;
import org.apache.flume.Context;
import org.apache.flume.EventDrivenSource;
import org.apache.flume.conf.Configurable;
import org.apache.flume.instrumentation.SourceCounter;
import org.apache.flume.source.SslContextAwareAbstractSource;
import org.apache.flume.source.http.HTTPBadRequestException;
import org.apache.flume.source.http.HTTPSourceHandler;
import org.apache.flume.tools.FlumeBeanConfigurator;
import org.apache.flume.tools.HTTPServerConstraintUtil;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.jmx.MBeanContainer;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.component.Container;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPSource
extends SslContextAwareAbstractSource
implements EventDrivenSource,
Configurable {
    private static final Logger LOG = LoggerFactory.getLogger(HTTPSource.class);
    private volatile Integer port;
    private volatile Server srv;
    private volatile String host;
    private HTTPSourceHandler handler;
    private SourceCounter sourceCounter;
    private Context sourceContext;

    @Override
    public void configure(Context context) {
        this.configureSsl(context);
        this.sourceContext = context;
        try {
            this.port = context.getInteger("port");
            this.host = context.getString("bind", "0.0.0.0");
            Preconditions.checkState((this.host != null && !this.host.isEmpty() ? 1 : 0) != 0, (Object)"HTTPSource hostname specified is empty");
            Preconditions.checkNotNull((Object)this.port, (Object)"HTTPSource requires a port number to be specified");
            String handlerClassName = context.getString("handler", "org.apache.flume.source.http.JSONHandler").trim();
            Class<?> clazz = Class.forName(handlerClassName);
            this.handler = (HTTPSourceHandler)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            Map subProps = context.getSubProperties("handler.");
            this.handler.configure(new Context(subProps));
        }
        catch (ClassNotFoundException ex) {
            LOG.error("Error while configuring HTTPSource. Exception follows.", (Throwable)ex);
            Throwables.propagate((Throwable)ex);
        }
        catch (ClassCastException ex) {
            LOG.error("Deserializer is not an instance of HTTPSourceHandler.Deserializer must implement HTTPSourceHandler.");
            Throwables.propagate((Throwable)ex);
        }
        catch (Exception ex) {
            LOG.error("Error configuring HTTPSource!", (Throwable)ex);
            Throwables.propagate((Throwable)ex);
        }
        if (this.sourceCounter == null) {
            this.sourceCounter = new SourceCounter(this.getName());
        }
    }

    @Override
    public void start() {
        Preconditions.checkState((this.srv == null ? 1 : 0) != 0, (Object)("Running HTTP Server found in source: " + this.getName() + " before I started one.Will not attempt to start."));
        QueuedThreadPool threadPool = new QueuedThreadPool();
        if (this.sourceContext.getSubProperties("QueuedThreadPool.").size() > 0) {
            FlumeBeanConfigurator.setConfigurationFields((Object)threadPool, this.sourceContext);
        }
        this.srv = new Server((ThreadPool)threadPool);
        MBeanContainer mbContainer = new MBeanContainer(ManagementFactory.getPlatformMBeanServer());
        this.srv.addEventListener((Container.Listener)mbContainer);
        this.srv.addBean((Object)mbContainer);
        HttpConfiguration httpConfiguration = new HttpConfiguration();
        httpConfiguration.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
        FlumeBeanConfigurator.setConfigurationFields((Object)httpConfiguration, this.sourceContext);
        ServerConnector connector = this.getSslContextSupplier().get().map(sslContext -> {
            SslContextFactory sslCtxFactory = new SslContextFactory();
            sslCtxFactory.setSslContext(sslContext);
            sslCtxFactory.setExcludeProtocols(this.getExcludeProtocols().toArray(new String[0]));
            sslCtxFactory.setIncludeProtocols(this.getIncludeProtocols().toArray(new String[0]));
            sslCtxFactory.setExcludeCipherSuites(this.getExcludeCipherSuites().toArray(new String[0]));
            sslCtxFactory.setIncludeCipherSuites(this.getIncludeCipherSuites().toArray(new String[0]));
            FlumeBeanConfigurator.setConfigurationFields((Object)sslCtxFactory, this.sourceContext);
            httpConfiguration.setSecurePort(this.port.intValue());
            httpConfiguration.setSecureScheme("https");
            return new ServerConnector(this.srv, new ConnectionFactory[]{new SslConnectionFactory(sslCtxFactory, HttpVersion.HTTP_1_1.asString()), new HttpConnectionFactory(httpConfiguration)});
        }).orElse(new ServerConnector(this.srv, new ConnectionFactory[]{new HttpConnectionFactory(httpConfiguration)}));
        connector.setPort(this.port.intValue());
        connector.setHost(this.host);
        connector.setReuseAddress(true);
        FlumeBeanConfigurator.setConfigurationFields((Object)connector, this.sourceContext);
        this.srv.addConnector((Connector)connector);
        try {
            ServletContextHandler context = new ServletContextHandler(1);
            context.setContextPath("/");
            this.srv.setHandler((Handler)context);
            context.addServlet(new ServletHolder((Servlet)new FlumeHTTPServlet()), "/");
            context.setSecurityHandler((SecurityHandler)HTTPServerConstraintUtil.enforceConstraints());
            this.srv.start();
        }
        catch (Exception ex) {
            LOG.error("Error while starting HTTPSource. Exception follows.", (Throwable)ex);
            Throwables.propagate((Throwable)ex);
        }
        Preconditions.checkArgument((boolean)this.srv.isRunning());
        this.sourceCounter.start();
        super.start();
    }

    @Override
    public void stop() {
        try {
            this.srv.stop();
            this.srv.join();
            this.srv = null;
        }
        catch (Exception ex) {
            LOG.error("Error while stopping HTTPSource. Exception follows.", (Throwable)ex);
        }
        this.sourceCounter.stop();
        LOG.info("Http source {} stopped. Metrics: {}", (Object)this.getName(), (Object)this.sourceCounter);
    }

    @Override
    protected void configureSsl(Context context) {
        this.handleDeprecatedParameter(context, "ssl", "enableSSL");
        this.handleDeprecatedParameter(context, "exclude-protocols", "excludeProtocols");
        this.handleDeprecatedParameter(context, "keystore-password", "keystorePassword");
        super.configureSsl(context);
    }

    private void handleDeprecatedParameter(Context context, String newParam, String oldParam) {
        if (!context.containsKey(newParam) && context.containsKey(oldParam)) {
            context.put(newParam, context.getString(oldParam));
        }
    }

    private class FlumeHTTPServlet
    extends HttpServlet {
        private static final long serialVersionUID = 4891924863218790344L;

        private FlumeHTTPServlet() {
        }

        public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
            List<Object> events = Collections.emptyList();
            try {
                events = HTTPSource.this.handler.getEvents(request);
            }
            catch (HTTPBadRequestException ex) {
                LOG.warn("Received bad request from client. ", (Throwable)((Object)ex));
                HTTPSource.this.sourceCounter.incrementEventReadFail();
                response.sendError(400, "Bad request from client. " + ex.getMessage());
                return;
            }
            catch (Exception ex) {
                LOG.warn("Deserializer threw unexpected exception. ", (Throwable)ex);
                HTTPSource.this.sourceCounter.incrementEventReadFail();
                response.sendError(500, "Deserializer threw unexpected exception. " + ex.getMessage());
                return;
            }
            HTTPSource.this.sourceCounter.incrementAppendBatchReceivedCount();
            HTTPSource.this.sourceCounter.addToEventReceivedCount(events.size());
            try {
                HTTPSource.this.getChannelProcessor().processEventBatch(events);
            }
            catch (ChannelException ex) {
                LOG.warn("Error appending event to channel. Channel might be full. Consider increasing the channel capacity or make sure the sinks perform faster.", (Throwable)ex);
                HTTPSource.this.sourceCounter.incrementChannelWriteFail();
                response.sendError(503, "Error appending event to channel. Channel might be full." + ex.getMessage());
                return;
            }
            catch (Exception ex) {
                LOG.warn("Unexpected error appending event to channel. ", (Throwable)ex);
                HTTPSource.this.sourceCounter.incrementGenericProcessingFail();
                response.sendError(500, "Unexpected error while appending event to channel. " + ex.getMessage());
                return;
            }
            response.setCharacterEncoding(request.getCharacterEncoding());
            response.setStatus(200);
            response.flushBuffer();
            HTTPSource.this.sourceCounter.incrementAppendBatchAcceptedCount();
            HTTPSource.this.sourceCounter.addToEventAcceptedCount(events.size());
        }

        public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
            this.doPost(request, response);
        }
    }
}

