/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.master.web.handler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.inlong.tubemq.corebase.cluster.Partition;
import org.apache.inlong.tubemq.corebase.rv.ProcessResult;
import org.apache.inlong.tubemq.corebase.utils.DateTimeConvertUtils;
import org.apache.inlong.tubemq.corebase.utils.Tuple2;
import org.apache.inlong.tubemq.server.broker.stats.BrokerStatsType;
import org.apache.inlong.tubemq.server.common.fielddef.WebFieldDef;
import org.apache.inlong.tubemq.server.common.utils.WebParameterUtils;
import org.apache.inlong.tubemq.server.common.webbase.WebCallStatsHolder;
import org.apache.inlong.tubemq.server.master.TMaster;
import org.apache.inlong.tubemq.server.master.nodemanage.nodebroker.TopicPSInfoManager;
import org.apache.inlong.tubemq.server.master.nodemanage.nodeconsumer.ConsumeGroupInfo;
import org.apache.inlong.tubemq.server.master.nodemanage.nodeconsumer.ConsumeType;
import org.apache.inlong.tubemq.server.master.nodemanage.nodeconsumer.ConsumerInfo;
import org.apache.inlong.tubemq.server.master.nodemanage.nodeconsumer.ConsumerInfoHolder;
import org.apache.inlong.tubemq.server.master.nodemanage.nodeconsumer.NodeRebInfo;
import org.apache.inlong.tubemq.server.master.stats.MasterSrvStatsHolder;
import org.apache.inlong.tubemq.server.master.stats.MasterStatsType;
import org.apache.inlong.tubemq.server.master.web.handler.AbstractWebHandler;

public class WebOtherInfoHandler
extends AbstractWebHandler {
    public WebOtherInfoHandler(TMaster master) {
        super(master);
    }

    @Override
    public void registerWebApiMethod() {
        this.registerQueryWebMethod("admin_get_methods", "adminQueryAllMethods");
        this.registerQueryWebMethod("admin_query_sub_info", "getSubscribeInfo");
        this.registerQueryWebMethod("admin_query_consume_group_detail", "getConsumeGroupDetailInfo");
        this.registerQueryWebMethod("admin_query_server_version", "adminQueryMasterVersion");
        this.registerQueryWebMethod("admin_get_metrics_info", "adminGetMetricsInfo");
        this.registerModifyWebMethod("admin_enable_stats", "adminEnableMetricsStats");
        this.registerModifyWebMethod("admin_disable_stats", "adminDisableMetricsStats");
        this.registerModifyWebMethod("admin_disable_all_stats", "adminDisableAllStats");
    }

    public StringBuilder adminQueryAllMethods(HttpServletRequest req, StringBuilder sBuffer, ProcessResult result) {
        WebParameterUtils.buildSuccessWithDataRetBegin(sBuffer);
        int totalCnt = this.getRegisteredMethods(sBuffer);
        WebParameterUtils.buildSuccessWithDataRetEnd(sBuffer, totalCnt);
        return sBuffer;
    }

    public StringBuilder getSubscribeInfo(HttpServletRequest req, StringBuilder sBuffer, ProcessResult result) {
        if (!WebParameterUtils.getStringParamValue(req, WebFieldDef.COMPSGROUPNAME, false, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        Set inGroupNameSet = (Set)result.getRetData();
        if (inGroupNameSet.isEmpty()) {
            if (!WebParameterUtils.getStringParamValue(req, WebFieldDef.COMPSCONSUMEGROUP, false, null, sBuffer, result)) {
                WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
                return sBuffer;
            }
            inGroupNameSet = (Set)result.getRetData();
        }
        if (!WebParameterUtils.getStringParamValue(req, WebFieldDef.COMPSTOPICNAME, false, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        Set topicNameSet = (Set)result.getRetData();
        TopicPSInfoManager topicPSInfoManager = this.master.getTopicPSInfoManager();
        Set<String> queryGroupSet = topicPSInfoManager.getGroupSetWithSubTopic(inGroupNameSet, topicNameSet);
        int totalCnt = 0;
        int topicCnt = 0;
        ConsumerInfoHolder consumerHolder = this.master.getConsumerHolder();
        WebParameterUtils.buildSuccessWithDataRetBegin(sBuffer);
        for (String group : queryGroupSet) {
            if (totalCnt++ > 0) {
                sBuffer.append(",");
            }
            sBuffer.append("{\"consumeGroup\":\"").append(group).append("\",\"topicSet\":[");
            topicCnt = 0;
            Set<String> topicSet = consumerHolder.getGroupTopicSet(group);
            int consumerCnt = consumerHolder.getConsumerCnt(group);
            for (String tmpTopic : topicSet) {
                if (topicCnt++ > 0) {
                    sBuffer.append(",");
                }
                sBuffer.append("\"").append(tmpTopic).append("\"");
            }
            sBuffer.append("],\"consumerNum\":").append(consumerCnt).append("}");
        }
        WebParameterUtils.buildSuccessWithDataRetEnd(sBuffer, totalCnt);
        return sBuffer;
    }

    public StringBuilder adminQueryMasterVersion(HttpServletRequest req, StringBuilder strBuff, ProcessResult result) {
        WebParameterUtils.buildSuccessWithDataRetBegin(strBuff);
        strBuff.append("{\"version\":\"").append("2.3.0").append("\"}");
        WebParameterUtils.buildSuccessWithDataRetEnd(strBuff, 1);
        return strBuff;
    }

    public StringBuilder getConsumeGroupDetailInfo(HttpServletRequest req, StringBuilder sBuffer, ProcessResult result) {
        if (!WebParameterUtils.getStringParamValue(req, WebFieldDef.GROUPNAME, true, null, sBuffer, result) && !WebParameterUtils.getStringParamValue(req, WebFieldDef.CONSUMEGROUP, true, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        String strConsumeGroup = (String)result.getRetData();
        try {
            ConsumeType consumeType = ConsumeType.CONSUME_NORMAL;
            boolean isNotAllocate = false;
            boolean isSelectBig = true;
            String sessionKey = "";
            int reqSourceCount = -1;
            int curSourceCount = -1;
            long rebalanceCheckTime = -1L;
            int defBClientRate = -2;
            int confBClientRate = -2;
            int curBClientRate = -2;
            int minRequireClientCnt = -2;
            int balanceStatus = -2;
            Set<Object> topicSet = new HashSet();
            ArrayList<ConsumerInfo> consumerList = new ArrayList();
            Map<Object, Object> nodeRebInfoMap = new ConcurrentHashMap();
            Map<Object, Object> existedTopicConditions = new HashMap();
            ConsumerInfoHolder consumerHolder = this.master.getConsumerHolder();
            ConsumeGroupInfo consumeGroupInfo = consumerHolder.getConsumeGroupInfo(strConsumeGroup);
            if (consumeGroupInfo != null) {
                if (consumeGroupInfo.getTopicSet() != null) {
                    topicSet = consumeGroupInfo.getTopicSet();
                }
                if (consumeGroupInfo.getConsumerInfoList() != null) {
                    consumerList = consumeGroupInfo.getConsumerInfoList();
                }
                if (consumeGroupInfo.getTopicConditions() != null) {
                    existedTopicConditions = consumeGroupInfo.getTopicConditions();
                }
                nodeRebInfoMap = consumeGroupInfo.getBalanceMap();
                consumeType = consumeGroupInfo.getConsumeType();
                balanceStatus = consumeGroupInfo.getBalanceChkStatus();
                defBClientRate = consumerHolder.getDefResourceRate();
                confBClientRate = consumeGroupInfo.getConfResourceRate();
                curBClientRate = consumeGroupInfo.getCurResourceRate();
                minRequireClientCnt = consumeGroupInfo.getMinReqClientCnt();
                if (consumeType == ConsumeType.CONSUME_BAND) {
                    isNotAllocate = consumeGroupInfo.isNotAllocate();
                    isSelectBig = consumeGroupInfo.isSelectedBig();
                    sessionKey = consumeGroupInfo.getSessionKey();
                    reqSourceCount = consumeGroupInfo.getSourceCount();
                    curSourceCount = consumeGroupInfo.getGroupCnt();
                    rebalanceCheckTime = consumeGroupInfo.getCurCheckCycle();
                }
            }
            sBuffer.append("{\"result\":true,\"errCode\":0,\"errMsg\":\"OK\"").append(",\"count\":").append(consumerList.size()).append(",\"topicSet\":[");
            int itemCnt = 0;
            for (String string : topicSet) {
                if (itemCnt++ > 0) {
                    sBuffer.append(",");
                }
                sBuffer.append("\"").append(string).append("\"");
            }
            sBuffer.append("],\"consumeGroup\":\"").append(strConsumeGroup).append("\",\"re-rebalance\":{");
            itemCnt = 0;
            for (Map.Entry entry : nodeRebInfoMap.entrySet()) {
                if (itemCnt++ > 0) {
                    sBuffer.append(",");
                }
                sBuffer.append("\"").append((String)entry.getKey()).append("\":");
                sBuffer = ((NodeRebInfo)entry.getValue()).toJsonString(sBuffer);
            }
            sBuffer.append("},\"isBandConsume\":\"").append(consumeType.getName()).append("\"");
            if (consumeType == ConsumeType.CONSUME_BAND) {
                sBuffer.append(",\"isNotAllocate\":").append(isNotAllocate).append(",\"sessionKey\":\"").append(sessionKey).append("\",\"isSelectBig\":").append(isSelectBig).append(",\"reqSourceCount\":").append(reqSourceCount).append(",\"curSourceCount\":").append(curSourceCount).append(",\"rebalanceCheckTime\":").append(rebalanceCheckTime);
            } else if (consumeType == ConsumeType.CONSUME_CLIENT_REB) {
                Tuple2<Long, List<String>> metaInfoTuple = consumeGroupInfo.getTopicMetaInfo();
                sBuffer.append(",\"topicMetaId\":").append(metaInfoTuple.getF0()).append(",\"metaDetails\":[");
                for (String string : (List)metaInfoTuple.getF1()) {
                    if (itemCnt++ > 0) {
                        sBuffer.append(",");
                    }
                    sBuffer.append("\"").append(string).append("\"");
                }
                sBuffer.append("]");
            }
            sBuffer.append(",\"rebInfo\":{");
            if (balanceStatus == -2) {
                sBuffer.append("\"isRebalanced\":false");
            } else if (balanceStatus == 0) {
                sBuffer.append("\"isRebalanced\":true,\"checkPasted\":false").append(",\"defBClientRate\":").append(defBClientRate).append(",\"confBClientRate\":").append(confBClientRate).append(",\"curBClientRate\":").append(curBClientRate).append(",\"minRequireClientCnt\":").append(minRequireClientCnt);
            } else {
                sBuffer.append("\"isRebalanced\":true,\"checkPasted\":true").append(",\"defBClientRate\":").append(defBClientRate).append(",\"confBClientRate\":").append(confBClientRate).append(",\"curBClientRate\":").append(curBClientRate);
            }
            sBuffer.append("},\"filterConds\":{");
            if (existedTopicConditions != null) {
                int keyCount = 0;
                for (Map.Entry<Object, Object> entry : existedTopicConditions.entrySet()) {
                    if (keyCount++ > 0) {
                        sBuffer.append(",");
                    }
                    sBuffer.append("\"").append((String)entry.getKey()).append("\":[");
                    if (entry.getValue() != null) {
                        int itemCount = 0;
                        for (String filterCond : (TreeSet)entry.getValue()) {
                            if (itemCount++ > 0) {
                                sBuffer.append(",");
                            }
                            sBuffer.append("\"").append(filterCond).append("\"");
                        }
                    }
                    sBuffer.append("]");
                }
            }
            sBuffer.append("}");
            this.getConsumerInfoList(consumerList, consumeType, sBuffer);
            sBuffer.append("}");
        }
        catch (Exception e) {
            sBuffer.append("{\"result\":false,\"errCode\":400,\"errMsg\":\"").append(e.getMessage()).append("\",\"count\":0,\"data\":[]}");
        }
        return sBuffer;
    }

    public StringBuilder adminQueryBrokerVersion(HttpServletRequest req, StringBuilder sBuffer, ProcessResult result) {
        WebParameterUtils.buildSuccessWithDataRetBegin(sBuffer);
        sBuffer.append("{\"version\":\"").append("2.3.0").append("\"}");
        WebParameterUtils.buildSuccessWithDataRetEnd(sBuffer, 1);
        return sBuffer;
    }

    public StringBuilder adminGetMetricsInfo(HttpServletRequest req, StringBuilder sBuffer, ProcessResult result) {
        if (!WebParameterUtils.getBooleanParamValue(req, WebFieldDef.NEEDREFRESH, false, false, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        boolean needRefresh = (Boolean)result.getRetData();
        WebParameterUtils.buildSuccessWithDataRetBegin(sBuffer);
        sBuffer.append("{\"probeTime\":\"").append(DateTimeConvertUtils.ms2yyyyMMddHHmmss((long)System.currentTimeMillis())).append("\",\"nodeName\":\"").append(this.master.getMasterConfig().getHostName()).append("\",\"nodeRole\":\"Master\",\"metrics\":{\"serviceStatus\":");
        if (needRefresh) {
            MasterSrvStatsHolder.snapShort(sBuffer);
            sBuffer.append(",\"webAPI\":");
            WebCallStatsHolder.snapShort(sBuffer);
        } else {
            MasterSrvStatsHolder.getValue(sBuffer);
            sBuffer.append(",\"webAPI\":");
            WebCallStatsHolder.getValue(sBuffer);
        }
        sBuffer.append("},\"count\":2}");
        WebParameterUtils.buildSuccessWithDataRetEnd(sBuffer, 1);
        return sBuffer;
    }

    public StringBuilder adminEnableMetricsStats(HttpServletRequest req, StringBuilder sBuffer, ProcessResult result) {
        if (!WebParameterUtils.getStringParamValue(req, WebFieldDef.STATSTYPE, true, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        String statsType = (String)result.getRetData();
        return this.innEnableOrDisableMetricsStats(true, statsType, req, sBuffer, result);
    }

    public StringBuilder adminDisableMetricsStats(HttpServletRequest req, StringBuilder sBuffer, ProcessResult result) {
        if (!WebParameterUtils.getStringParamValue(req, WebFieldDef.STATSTYPE, true, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        String statsType = (String)result.getRetData();
        this.innEnableOrDisableMetricsStats(false, statsType, req, sBuffer, result);
        return sBuffer;
    }

    public StringBuilder adminDisableAllStats(HttpServletRequest req, StringBuilder sBuffer, ProcessResult result) {
        this.innEnableOrDisableMetricsStats(false, BrokerStatsType.ALL.getName(), req, sBuffer, result);
        return sBuffer;
    }

    private StringBuilder innEnableOrDisableMetricsStats(boolean enable, String statsType, HttpServletRequest req, StringBuilder sBuffer, ProcessResult result) {
        MasterStatsType inMetricType = null;
        for (MasterStatsType metricType : MasterStatsType.values()) {
            if (!metricType.getName().equalsIgnoreCase(statsType)) continue;
            inMetricType = metricType;
            break;
        }
        if (inMetricType == null) {
            sBuffer.append("{\"result\":false,\"errCode\":400,\"errMsg\":").append("\"Unmatched stat type, allowed stat type are : [");
            int count = 0;
            for (MasterStatsType metricType : MasterStatsType.values()) {
                if (count++ > 0) {
                    sBuffer.append(",");
                }
                sBuffer.append(metricType.getName());
            }
            sBuffer.append("]\"}");
            return sBuffer;
        }
        if (inMetricType == MasterStatsType.WEBAPI || inMetricType == MasterStatsType.ALL) {
            WebCallStatsHolder.setStatsStatus(enable);
        }
        WebParameterUtils.buildSuccessResult(sBuffer);
        return sBuffer;
    }

    private void getConsumerInfoList(List<ConsumerInfo> consumerList, ConsumeType consumeType, StringBuilder strBuffer) {
        strBuffer.append(",\"data\":[");
        if (!consumerList.isEmpty()) {
            Collections.sort(consumerList);
            ConcurrentHashMap<String, Map<String, Map<String, Partition>>> currentSubInfoMap = this.master.getCurrentSubInfoMap();
            for (int i = 0; i < consumerList.size(); ++i) {
                ConsumerInfo consumer = consumerList.get(i);
                if (consumer == null) continue;
                if (i > 0) {
                    strBuffer.append(",");
                }
                strBuffer.append("{\"consumerId\":\"").append(consumer.getConsumerId()).append("\",\"receivedFrom\":\"").append(consumer.getAddrRcvFrom()).append("\",\"isOverTLS\":").append(consumer.isOverTLS());
                if (consumeType == ConsumeType.CONSUME_BAND) {
                    Map<String, Long> requiredPartition = consumer.getRequiredPartition();
                    if (requiredPartition == null || requiredPartition.isEmpty()) {
                        strBuffer.append(",\"initReSetPartCount\":0,\"initReSetPartInfo\":[]");
                    } else {
                        strBuffer.append(",\"initReSetPartCount\":").append(requiredPartition.size()).append(",\"initReSetPartInfo\":[");
                        int totalPart = 0;
                        for (Map.Entry<Object, Object> entry : requiredPartition.entrySet()) {
                            if (totalPart++ > 0) {
                                strBuffer.append(",");
                            }
                            strBuffer.append("{\"partitionKey\":\"").append((String)entry.getKey()).append("\",\"Offset\":").append(entry.getValue()).append("}");
                        }
                        strBuffer.append("]");
                    }
                } else if (consumeType == ConsumeType.CONSUME_CLIENT_REB) {
                    strBuffer.append(",\"sourceCount\":").append(consumer.getSourceCount()).append(",\"nodeId\":").append(consumer.getNodeId());
                }
                Map topicSubMap = (Map)currentSubInfoMap.get(consumer.getConsumerId());
                if (topicSubMap == null || topicSubMap.isEmpty()) {
                    strBuffer.append(",\"parCount\":0,\"parInfo\":[]}");
                    continue;
                }
                int totalSize = 0;
                for (Map.Entry<Object, Object> entry : topicSubMap.entrySet()) {
                    totalSize += ((Map)entry.getValue()).size();
                }
                strBuffer.append(",\"parCount\":").append(totalSize).append(",\"parInfo\":[");
                int totalPart = 0;
                for (Map.Entry entry : topicSubMap.entrySet()) {
                    Map partMap = (Map)entry.getValue();
                    if (partMap == null) continue;
                    for (Partition part : partMap.values()) {
                        if (totalPart++ > 0) {
                            strBuffer.append(",");
                        }
                        strBuffer.append("{\"partId\":").append(part.getPartitionId()).append(",\"brokerAddr\":\"").append(part.getBroker().toString()).append("\",\"topicName\":\"").append(part.getTopic()).append("\"}");
                    }
                }
                strBuffer.append("]}");
            }
        }
        strBuffer.append("]");
    }
}

