/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.master.stats.prometheus;

import io.prometheus.client.Collector;
import io.prometheus.client.CounterMetricFamily;
import io.prometheus.client.exporter.HTTPServer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.inlong.tubemq.server.common.fileconfig.PrometheusConfig;
import org.apache.inlong.tubemq.server.common.webbase.WebCallStatsHolder;
import org.apache.inlong.tubemq.server.master.stats.MasterSrvStatsHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MasterPromMetricService
extends Collector {
    private static final Logger logger = LoggerFactory.getLogger(MasterPromMetricService.class);
    private PrometheusConfig promConfig = new PrometheusConfig();
    private HTTPServer httpServer;
    private volatile boolean started = false;

    public MasterPromMetricService(PrometheusConfig prometheusConfig) {
        if (prometheusConfig == null || !prometheusConfig.isPromEnable()) {
            return;
        }
        this.promConfig = prometheusConfig;
    }

    public void start() {
        try {
            this.httpServer = new HTTPServer(this.promConfig.getPromHttpPort());
            this.register();
            this.started = true;
        }
        catch (IOException e) {
            logger.error("exception while register Master prometheus http server, error:{}", (Object)e.getMessage());
        }
    }

    public List<Collector.MetricFamilySamples> collect() {
        ArrayList<Collector.MetricFamilySamples> mfs = new ArrayList<Collector.MetricFamilySamples>();
        if (!this.started) {
            return mfs;
        }
        LinkedHashMap<String, Long> statsMap = new LinkedHashMap<String, Long>();
        StringBuilder strBuff = new StringBuilder(512);
        CounterMetricFamily srvStatusCounter = new CounterMetricFamily(strBuff.append(this.promConfig.getPromClusterName()).append("&group=serviceStatus").toString(), "The service status metrics of TubeMQ-Master node.", Arrays.asList("serviceStatus"));
        strBuff.delete(0, strBuff.length());
        MasterSrvStatsHolder.snapShort(statsMap);
        for (Map.Entry entry : statsMap.entrySet()) {
            srvStatusCounter.addMetric(Arrays.asList((String)entry.getKey()), (double)((Long)entry.getValue()).longValue());
        }
        mfs.add((Collector.MetricFamilySamples)srvStatusCounter);
        CounterMetricFamily webAPICounter = new CounterMetricFamily(strBuff.append(this.promConfig.getPromClusterName()).append("&group=webAPI").toString(), "The web api call metrics of TubeMQ-Master node.", Arrays.asList("webAPI"));
        strBuff.delete(0, strBuff.length());
        statsMap.clear();
        WebCallStatsHolder.snapShort(statsMap);
        for (Map.Entry entry : statsMap.entrySet()) {
            webAPICounter.addMetric(Arrays.asList((String)entry.getKey()), (double)((Long)entry.getValue()).longValue());
        }
        mfs.add((Collector.MetricFamilySamples)webAPICounter);
        return mfs;
    }
}

