/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.master.bdbstore.bdbentitys;

import com.sleepycat.persist.model.Entity;
import com.sleepycat.persist.model.PrimaryKey;
import java.io.Serializable;
import java.util.Date;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.inlong.tubemq.corebase.utils.DateTimeConvertUtils;
import org.apache.inlong.tubemq.corebase.utils.TStringUtils;
import org.apache.inlong.tubemq.server.common.statusdef.EnableStatus;

@Entity
public class BdbGroupFilterCondEntity
implements Serializable {
    private static final long serialVersionUID = 5305233169489425210L;
    @PrimaryKey
    private String recordKey;
    private String topicName;
    private String consumerGroupName;
    private int controlStatus = -2;
    private String attributes;
    private String createUser;
    private Date createDate;

    public BdbGroupFilterCondEntity() {
    }

    public BdbGroupFilterCondEntity(String topicName, String consumerGroupName, int controlStatus, String filterCondStr, String modifyUser, Date modifyDate) {
        this.recordKey = new StringBuilder(512).append(topicName).append(":").append(consumerGroupName).toString();
        this.topicName = topicName;
        this.consumerGroupName = consumerGroupName;
        this.controlStatus = controlStatus;
        this.setFilterCondStr(filterCondStr);
        this.createUser = modifyUser;
        this.createDate = modifyDate;
    }

    public BdbGroupFilterCondEntity(String topicName, String consumerGroupName, int controlStatus, String filterCondStr, String attributes, String modifyUser, Date modifyDate) {
        this.recordKey = new StringBuilder(512).append(topicName).append(":").append(consumerGroupName).toString();
        this.topicName = topicName;
        this.consumerGroupName = consumerGroupName;
        this.controlStatus = controlStatus;
        this.createUser = modifyUser;
        this.createDate = modifyDate;
        this.attributes = attributes;
        this.setFilterCondStr(filterCondStr);
    }

    public String getFilterCondStr() {
        if (TStringUtils.isNotBlank((String)this.attributes) && this.attributes.contains("=")) {
            return TStringUtils.getAttrValFrmAttributes((String)this.attributes, (String)"filterCondStr");
        }
        return this.attributes;
    }

    public void setFilterCondStr(String filterCondStr) {
        this.attributes = TStringUtils.setAttrValToAttributes((String)this.attributes, (String)"filterCondStr", (String)filterCondStr);
    }

    public EnableStatus getConsumeEnable() {
        String atrVal = TStringUtils.getAttrValFrmAttributes((String)this.attributes, (String)"enbConsume");
        if (atrVal != null) {
            return EnableStatus.valueOf(Integer.parseInt(atrVal));
        }
        return EnableStatus.STATUS_ENABLE;
    }

    public void setConsumeEnable(EnableStatus enableConsume) {
        this.attributes = TStringUtils.setAttrValToAttributes((String)this.attributes, (String)"enbConsume", (String)String.valueOf(enableConsume.getCode()));
    }

    public String getDisableConsumeReason() {
        if (TStringUtils.isNotBlank((String)this.attributes) && this.attributes.contains("=")) {
            return TStringUtils.getAttrValFrmAttributes((String)this.attributes, (String)"reason");
        }
        return "";
    }

    public void setDisableConsumeReason(String disableConsumeReason) {
        this.attributes = TStringUtils.setAttrValToAttributes((String)this.attributes, (String)"reason", (String)disableConsumeReason);
    }

    public String getRecordKey() {
        return this.recordKey;
    }

    public String getTopicName() {
        return this.topicName;
    }

    public void setTopicName(String topicName) {
        this.topicName = topicName;
    }

    public String getConsumerGroupName() {
        return this.consumerGroupName;
    }

    public void setConsumerGroupName(String consumerGroupName) {
        this.consumerGroupName = consumerGroupName;
    }

    public int getControlStatus() {
        return this.controlStatus;
    }

    public void setControlStatus(int controlStatus) {
        this.controlStatus = controlStatus;
    }

    public String getModifyUser() {
        return this.createUser;
    }

    public Date getModifyDate() {
        return this.createDate;
    }

    public String getAttributes() {
        if (TStringUtils.isNotBlank((String)this.attributes) && !this.attributes.contains("=")) {
            return this.attributes;
        }
        return "";
    }

    public void setAttributes(String attributes) {
        this.attributes = attributes;
    }

    public long getDataVerId() {
        String atrVal;
        if (TStringUtils.isNotBlank((String)this.attributes) && this.attributes.contains("=") && (atrVal = TStringUtils.getAttrValFrmAttributes((String)this.attributes, (String)"dataVerId")) != null) {
            return Long.parseLong(atrVal);
        }
        return -2L;
    }

    public void setDataVerId(long dataVerId) {
        if (TStringUtils.isNotBlank((String)this.attributes) && !this.attributes.contains("=")) {
            this.setFilterCondStr(this.attributes);
        }
        this.attributes = TStringUtils.setAttrValToAttributes((String)this.attributes, (String)"dataVerId", (String)String.valueOf(dataVerId));
    }

    public void setCreateInfo(String createUser, Date createDate) {
        if (TStringUtils.isNotBlank((String)createUser)) {
            this.attributes = TStringUtils.setAttrValToAttributes((String)this.attributes, (String)"creater", (String)createUser);
        }
        if (createDate != null) {
            String dataStr = DateTimeConvertUtils.date2yyyyMMddHHmmss((Date)createDate);
            this.attributes = TStringUtils.setAttrValToAttributes((String)this.attributes, (String)"createDate", (String)dataStr);
        }
    }

    public String getCreateUser() {
        String tmpUser = TStringUtils.getAttrValFrmAttributes((String)this.attributes, (String)"creater");
        if (TStringUtils.isEmpty((String)tmpUser)) {
            tmpUser = this.createUser;
        }
        return tmpUser;
    }

    public Date getCreateDate() {
        String dateStr = TStringUtils.getAttrValFrmAttributes((String)this.attributes, (String)"createDate");
        if (TStringUtils.isNotEmpty((String)dateStr)) {
            return DateTimeConvertUtils.yyyyMMddHHmmss2date((String)dateStr);
        }
        return this.createDate;
    }

    public String getStrModifyDate() {
        return DateTimeConvertUtils.date2yyyyMMddHHmmss((Date)this.createDate);
    }

    public String getStrCreateDate() {
        String dateStr = TStringUtils.getAttrValFrmAttributes((String)this.attributes, (String)"createDate");
        if (TStringUtils.isEmpty((String)dateStr)) {
            dateStr = DateTimeConvertUtils.date2yyyyMMddHHmmss((Date)this.createDate);
        }
        return dateStr;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("recordKey", (Object)this.recordKey).append("topicName", (Object)this.topicName).append("consumerGroupName", (Object)this.consumerGroupName).append("controlStatus", this.controlStatus).append("attributes", (Object)this.attributes).append("createUser", (Object)this.getCreateUser()).append("createDate", (Object)this.getStrCreateDate()).append("modifyUser", (Object)this.getModifyUser()).append("modifyDate", (Object)this.getStrModifyDate()).toString();
    }

    public StringBuilder toJsonString(StringBuilder sBuilder) {
        return sBuilder.append("{\"type\":\"BdbGroupFilterCondEntity\",").append("\"recordKey\":\"").append(this.recordKey).append("\",\"topicName\":\"").append(this.topicName).append("\",\"consumerGroupName\":\"").append(this.consumerGroupName).append("\",\"filterConds\":\"").append(this.attributes).append("\",\"condStatus\":").append(this.controlStatus).append(",\"createUser\":\"").append(this.getCreateUser()).append("\",\"createDate\":\"").append(this.getStrCreateDate()).append("\",\"modifyUser\":\"").append(this.getModifyUser()).append("\",\"modifyDate\":\"").append(this.getStrModifyDate()).append("\"}");
    }
}

