/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.master;

import com.google.protobuf.ProtocolStringList;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.codec.binary.StringUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.inlong.tubemq.corebase.balance.ConsumerEvent;
import org.apache.inlong.tubemq.corebase.balance.EventStatus;
import org.apache.inlong.tubemq.corebase.balance.EventType;
import org.apache.inlong.tubemq.corebase.cluster.BrokerInfo;
import org.apache.inlong.tubemq.corebase.cluster.NodeAddrInfo;
import org.apache.inlong.tubemq.corebase.cluster.Partition;
import org.apache.inlong.tubemq.corebase.cluster.ProducerInfo;
import org.apache.inlong.tubemq.corebase.cluster.SubscribeInfo;
import org.apache.inlong.tubemq.corebase.cluster.TopicInfo;
import org.apache.inlong.tubemq.corebase.config.TLSConfig;
import org.apache.inlong.tubemq.corebase.protobuf.generated.ClientMaster;
import org.apache.inlong.tubemq.corebase.rv.ProcessResult;
import org.apache.inlong.tubemq.corebase.utils.DataConverterUtil;
import org.apache.inlong.tubemq.corebase.utils.OpsSyncInfo;
import org.apache.inlong.tubemq.corebase.utils.TStringUtils;
import org.apache.inlong.tubemq.corebase.utils.ThreadUtils;
import org.apache.inlong.tubemq.corebase.utils.Tuple2;
import org.apache.inlong.tubemq.corebase.utils.Tuple3;
import org.apache.inlong.tubemq.corerpc.RpcConfig;
import org.apache.inlong.tubemq.corerpc.RpcServiceFactory;
import org.apache.inlong.tubemq.corerpc.exception.StandbyException;
import org.apache.inlong.tubemq.corerpc.service.MasterService;
import org.apache.inlong.tubemq.server.Stoppable;
import org.apache.inlong.tubemq.server.common.aaaserver.CertificateMasterHandler;
import org.apache.inlong.tubemq.server.common.aaaserver.CertifiedInfo;
import org.apache.inlong.tubemq.server.common.aaaserver.SimpleCertificateMasterHandler;
import org.apache.inlong.tubemq.server.common.exception.HeartbeatException;
import org.apache.inlong.tubemq.server.common.heartbeat.HeartbeatManager;
import org.apache.inlong.tubemq.server.common.heartbeat.TimeoutInfo;
import org.apache.inlong.tubemq.server.common.heartbeat.TimeoutListener;
import org.apache.inlong.tubemq.server.common.paramcheck.PBParameterUtils;
import org.apache.inlong.tubemq.server.common.utils.ClientSyncInfo;
import org.apache.inlong.tubemq.server.common.utils.HasThread;
import org.apache.inlong.tubemq.server.common.utils.RowLock;
import org.apache.inlong.tubemq.server.common.utils.Sleeper;
import org.apache.inlong.tubemq.server.master.MasterConfig;
import org.apache.inlong.tubemq.server.master.balance.DefaultLoadBalancer;
import org.apache.inlong.tubemq.server.master.balance.LoadBalancer;
import org.apache.inlong.tubemq.server.master.metamanage.DefaultMetaDataService;
import org.apache.inlong.tubemq.server.master.metamanage.MetaDataService;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.dao.entity.BrokerConfEntity;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.dao.entity.ClusterSettingEntity;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.dao.entity.GroupResCtrlEntity;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.dao.entity.TopicDeployEntity;
import org.apache.inlong.tubemq.server.master.nodemanage.nodebroker.BrokerAbnHolder;
import org.apache.inlong.tubemq.server.master.nodemanage.nodebroker.BrokerRunManager;
import org.apache.inlong.tubemq.server.master.nodemanage.nodebroker.DefBrokerRunManager;
import org.apache.inlong.tubemq.server.master.nodemanage.nodebroker.TopicPSInfoManager;
import org.apache.inlong.tubemq.server.master.nodemanage.nodeconsumer.ConsumeGroupInfo;
import org.apache.inlong.tubemq.server.master.nodemanage.nodeconsumer.ConsumeType;
import org.apache.inlong.tubemq.server.master.nodemanage.nodeconsumer.ConsumerEventManager;
import org.apache.inlong.tubemq.server.master.nodemanage.nodeconsumer.ConsumerInfo;
import org.apache.inlong.tubemq.server.master.nodemanage.nodeconsumer.ConsumerInfoHolder;
import org.apache.inlong.tubemq.server.master.nodemanage.nodeproducer.ProducerInfoHolder;
import org.apache.inlong.tubemq.server.master.stats.MasterJMXHolder;
import org.apache.inlong.tubemq.server.master.stats.MasterSrvStatsHolder;
import org.apache.inlong.tubemq.server.master.stats.prometheus.MasterPromMetricService;
import org.apache.inlong.tubemq.server.master.utils.Chore;
import org.apache.inlong.tubemq.server.master.utils.SimpleVisitTokenManager;
import org.apache.inlong.tubemq.server.master.web.WebServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TMaster
extends HasThread
implements MasterService,
Stoppable {
    private static final Logger logger = LoggerFactory.getLogger(TMaster.class);
    private static final int MAX_BALANCE_DELAY_TIME = 10;
    private final ConcurrentHashMap<String, Map<String, Map<String, Partition>>> currentSubInfo = new ConcurrentHashMap();
    private final RpcServiceFactory rpcServiceFactory = new RpcServiceFactory();
    private final MetaDataService defMetaDataService;
    private final BrokerRunManager brokerRunManager;
    private final ConsumerEventManager consumerEventManager;
    private final TopicPSInfoManager topicPSInfoManager;
    private final ExecutorService svrExecutor;
    private final ExecutorService cltExecutor;
    private final ProducerInfoHolder producerHolder;
    private final ConsumerInfoHolder consumerHolder;
    private final RowLock masterRowLock;
    private final WebServer webServer;
    private final LoadBalancer loadBalancer;
    private final MasterConfig masterConfig;
    private final NodeAddrInfo masterAddInfo;
    private final HeartbeatManager heartbeatManager;
    private final MasterPromMetricService promMetricService;
    private final ShutdownHook shutdownHook;
    private final CertificateMasterHandler serverAuthHandler;
    private AtomicBoolean shutdownHooked = new AtomicBoolean(false);
    private AtomicLong idGenerator = new AtomicLong(0L);
    private volatile boolean stopped = false;
    private Thread balancerChore;
    private boolean initialized = false;
    private boolean startupBalance = true;
    private int balanceDelayTimes = 0;
    private AtomicInteger curSvrBalanceParal = new AtomicInteger(0);
    private AtomicInteger curCltBalanceParal = new AtomicInteger(0);
    private Sleeper stopSleeper = new Sleeper(1000, this);
    private SimpleVisitTokenManager visitTokenManager;

    public TMaster(MasterConfig masterConfig) throws Exception {
        if (!masterConfig.isUseBdbStoreMetaData() && masterConfig.getZkMetaConfig() != null && masterConfig.getZkMetaConfig().getZkRequestTimeoutMs() > 0) {
            System.setProperty("zookeeper.request.timeout", Integer.toString(masterConfig.getZkMetaConfig().getZkRequestTimeoutMs()));
        }
        this.masterConfig = masterConfig;
        this.masterRowLock = new RowLock("Master-RowLock", this.masterConfig.getRowLockWaitDurMs());
        if (this.masterConfig.isUseBdbStoreMetaData()) {
            this.chkAndCreateBdbMetaDataPath();
        }
        this.masterAddInfo = new NodeAddrInfo(masterConfig.getHostName(), masterConfig.getPort());
        MasterJMXHolder.registerMXBean();
        this.svrExecutor = Executors.newFixedThreadPool(this.masterConfig.getRebalanceParallel());
        this.cltExecutor = Executors.newFixedThreadPool(this.masterConfig.getRebalanceParallel());
        this.visitTokenManager = new SimpleVisitTokenManager(this.masterConfig);
        this.serverAuthHandler = new SimpleCertificateMasterHandler(this.masterConfig);
        this.heartbeatManager = new HeartbeatManager();
        this.producerHolder = new ProducerInfoHolder();
        this.consumerHolder = new ConsumerInfoHolder(this);
        this.consumerEventManager = new ConsumerEventManager(this.consumerHolder);
        this.topicPSInfoManager = new TopicPSInfoManager(this);
        this.loadBalancer = new DefaultLoadBalancer();
        this.heartbeatManager.regConsumerCheckBusiness(masterConfig.getConsumerHeartbeatTimeoutMs(), new TimeoutListener(){

            @Override
            public void onTimeout(String nodeId, TimeoutInfo nodeInfo) {
                logger.info(new StringBuilder(512).append("[Consumer Timeout] ").append(nodeId).toString());
                new ReleaseConsumer().run(nodeId, true);
            }
        });
        this.heartbeatManager.regProducerCheckBusiness(masterConfig.getProducerHeartbeatTimeoutMs(), new TimeoutListener(){

            @Override
            public void onTimeout(String nodeId, TimeoutInfo nodeInfo) {
                logger.info(new StringBuilder(512).append("[Producer Timeout] ").append(nodeId).toString());
                new ReleaseProducer().run(nodeId, true);
            }
        });
        this.defMetaDataService = new DefaultMetaDataService(this);
        this.brokerRunManager = new DefBrokerRunManager(this);
        this.defMetaDataService.start();
        this.promMetricService = new MasterPromMetricService(this.masterConfig.getPromConfig());
        this.promMetricService.start();
        RpcConfig rpcTcpConfig = new RpcConfig();
        rpcTcpConfig.put("rpc.request.timeout", (Object)masterConfig.getRpcReadTimeoutMs());
        rpcTcpConfig.put("rpc.netty.write.highmark", (Object)masterConfig.getNettyWriteBufferHighWaterMark());
        rpcTcpConfig.put("rpc.netty.write.lowmark", (Object)masterConfig.getNettyWriteBufferLowWaterMark());
        rpcTcpConfig.put("rpc.netty.send.buffer", (Object)masterConfig.getSocketSendBuffer());
        rpcTcpConfig.put("rpc.netty.receive.buffer", (Object)masterConfig.getSocketRecvBuffer());
        this.rpcServiceFactory.publishService(MasterService.class, (Object)this, masterConfig.getPort(), rpcTcpConfig);
        if (masterConfig.isTlsEnable()) {
            TLSConfig tlsConfig = masterConfig.getTlsConfig();
            RpcConfig rpcTlsConfig = new RpcConfig();
            rpcTlsConfig.put("tcp.tls", (Object)true);
            rpcTlsConfig.put("tls.keystore.path", (Object)tlsConfig.getTlsKeyStorePath());
            rpcTlsConfig.put("tls.keystore.password", (Object)tlsConfig.getTlsKeyStorePassword());
            rpcTlsConfig.put("tls.twoway.authentic", (Object)tlsConfig.isTlsTwoWayAuthEnable());
            if (tlsConfig.isTlsTwoWayAuthEnable()) {
                rpcTlsConfig.put("tls.truststore.path", (Object)tlsConfig.getTlsTrustStorePath());
                rpcTlsConfig.put("tls.truststore.password", (Object)tlsConfig.getTlsTrustStorePassword());
            }
            rpcTlsConfig.put("rpc.request.timeout", (Object)masterConfig.getRpcReadTimeoutMs());
            rpcTlsConfig.put("rpc.netty.write.highmark", (Object)masterConfig.getNettyWriteBufferHighWaterMark());
            rpcTlsConfig.put("rpc.netty.write.lowmark", (Object)masterConfig.getNettyWriteBufferLowWaterMark());
            rpcTlsConfig.put("rpc.netty.send.buffer", (Object)masterConfig.getSocketSendBuffer());
            rpcTlsConfig.put("rpc.netty.receive.buffer", (Object)masterConfig.getSocketRecvBuffer());
            this.rpcServiceFactory.publishService(MasterService.class, (Object)this, tlsConfig.getTlsPort(), rpcTlsConfig);
        }
        this.webServer = new WebServer(masterConfig, this);
        this.webServer.start();
        this.shutdownHook = new ShutdownHook();
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
    }

    public MasterConfig getMasterConfig() {
        return this.masterConfig;
    }

    public MetaDataService getMetaDataService() {
        return this.defMetaDataService;
    }

    public HeartbeatManager getHeartbeatManager() {
        return this.heartbeatManager;
    }

    public BrokerRunManager getBrokerRunManager() {
        return this.brokerRunManager;
    }

    public ClientMaster.RegisterResponseM2P producerRegisterP2M(ClientMaster.RegisterRequestP2M request, String rmtAddress, boolean overtls) throws Exception {
        ProcessResult result = new ProcessResult();
        StringBuilder strBuff = new StringBuilder(512);
        ClientMaster.RegisterResponseM2P.Builder builder = ClientMaster.RegisterResponseM2P.newBuilder();
        builder.setSuccess(false);
        builder.setBrokerCheckSum(-1L);
        if (!this.serverAuthHandler.identityValidUserInfo(request.getAuthInfo(), true, result)) {
            builder.setErrCode(result.getErrCode());
            builder.setErrMsg(result.getErrMsg());
            return builder.build();
        }
        CertifiedInfo certifiedInfo = (CertifiedInfo)result.getRetData();
        if (!PBParameterUtils.checkClientId(request.getClientId(), strBuff, result)) {
            builder.setErrCode(result.getErrCode());
            builder.setErrMsg(result.getErrMsg());
            return builder.build();
        }
        String producerId = (String)result.getRetData();
        if (!PBParameterUtils.checkHostName(request.getHostName(), strBuff, result)) {
            builder.setErrCode(result.getErrCode());
            builder.setErrMsg(result.getErrMsg());
            return builder.build();
        }
        String hostName = (String)result.getRetData();
        if (!PBParameterUtils.checkProducerTopicList((List<String>)request.getTopicListList(), strBuff, result)) {
            builder.setErrCode(result.getErrCode());
            builder.setErrMsg(result.getErrMsg());
            return builder.build();
        }
        Set transTopicSet = (Set)result.getRetData();
        if (!request.hasBrokerCheckSum()) {
            builder.setErrCode(400);
            builder.setErrMsg("Request miss necessary brokerCheckSum field!");
            return builder.build();
        }
        this.checkNodeStatus(producerId, strBuff);
        if (!this.serverAuthHandler.validProducerAuthorizeInfo(certifiedInfo.getUserName(), transTopicSet, rmtAddress, result)) {
            builder.setErrCode(result.getErrCode());
            builder.setErrMsg(result.getErrMsg());
            return builder.build();
        }
        String clientJdkVer = request.hasJdkVersion() ? request.getJdkVersion() : "";
        this.heartbeatManager.regProducerNode(producerId);
        this.producerHolder.setProducerInfo(producerId, new HashSet<String>(transTopicSet), hostName, overtls);
        Tuple2<Long, Map<Integer, String>> brokerStaticInfo = this.brokerRunManager.getBrokerStaticInfo(overtls);
        Tuple3<Long, Integer, Map<String, String>> prodTopicConfigTuple = this.getTopicConfigureInfos(producerId, true);
        builder.setBrokerCheckSum(((Long)brokerStaticInfo.getF0()).longValue());
        builder.addAllBrokerInfos(((Map)brokerStaticInfo.getF1()).values());
        builder.setAuthorizedInfo(this.genAuthorizedInfo(certifiedInfo.getAuthorizedToken(), false).build());
        ClientMaster.ApprovedClientConfig.Builder clientConfigBuilder = this.buildApprovedClientConfig(request.getAppdConfig(), prodTopicConfigTuple);
        if (clientConfigBuilder != null) {
            builder.setAppdConfig(clientConfigBuilder);
        }
        logger.info(strBuff.append("[Producer Register] ").append(producerId).append(", isOverTLS=").append(overtls).append(", clientJDKVer=").append(clientJdkVer).toString());
        builder.setSuccess(true);
        builder.setErrCode(200);
        builder.setErrMsg("OK!");
        return builder.build();
    }

    public ClientMaster.HeartResponseM2P producerHeartbeatP2M(ClientMaster.HeartRequestP2M request, String rmtAddress, boolean overtls) throws Exception {
        ClientMaster.ApprovedClientConfig.Builder clientConfigBuilder;
        ProcessResult result = new ProcessResult();
        StringBuilder strBuff = new StringBuilder(512);
        ClientMaster.HeartResponseM2P.Builder builder = ClientMaster.HeartResponseM2P.newBuilder();
        builder.setSuccess(false);
        builder.setBrokerCheckSum(-1L);
        if (!this.serverAuthHandler.identityValidUserInfo(request.getAuthInfo(), true, result)) {
            builder.setErrCode(result.getErrCode());
            builder.setErrMsg(result.getErrMsg());
            return builder.build();
        }
        CertifiedInfo certifiedInfo = (CertifiedInfo)result.getRetData();
        if (!PBParameterUtils.checkClientId(request.getClientId(), strBuff, result)) {
            builder.setErrCode(result.getErrCode());
            builder.setErrMsg(result.getErrMsg());
            return builder.build();
        }
        String producerId = (String)result.getRetData();
        if (!PBParameterUtils.checkHostName(request.getHostName(), strBuff, result)) {
            builder.setErrCode(result.getErrCode());
            builder.setErrMsg(result.getErrMsg());
            return builder.build();
        }
        String hostName = (String)result.getRetData();
        if (!PBParameterUtils.checkProducerTopicList((List<String>)request.getTopicListList(), strBuff, result)) {
            builder.setErrCode(result.getErrCode());
            builder.setErrMsg(result.getErrMsg());
            return builder.build();
        }
        Set transTopicSet = (Set)result.getRetData();
        if (!request.hasBrokerCheckSum()) {
            builder.setErrCode(400);
            builder.setErrMsg("Request miss necessary brokerCheckSum field!");
            return builder.build();
        }
        long inBrokerCheckSum = request.getBrokerCheckSum();
        this.checkNodeStatus(producerId, strBuff);
        if (!this.serverAuthHandler.validProducerAuthorizeInfo(certifiedInfo.getUserName(), transTopicSet, rmtAddress, result)) {
            builder.setErrCode(result.getErrCode());
            builder.setErrMsg(result.getErrMsg());
            return builder.build();
        }
        try {
            this.heartbeatManager.updProducerNode(producerId);
        }
        catch (HeartbeatException e) {
            builder.setErrCode(411);
            builder.setErrMsg(e.getMessage());
            return builder.build();
        }
        this.topicPSInfoManager.addProducerTopicPubInfo(producerId, transTopicSet);
        this.producerHolder.updateProducerInfo(producerId, transTopicSet, hostName, overtls);
        Tuple2<Long, Map<Integer, String>> brokerStaticInfo = this.brokerRunManager.getBrokerStaticInfo(overtls);
        Tuple3<Long, Integer, Map<String, String>> prodTopicConfigTuple = this.getTopicConfigureInfos(producerId, false);
        builder.setAuthorizedInfo(this.genAuthorizedInfo(certifiedInfo.getAuthorizedToken(), false).build());
        builder.setBrokerCheckSum(((Long)brokerStaticInfo.getF0()).longValue());
        if ((Long)brokerStaticInfo.getF0() != inBrokerCheckSum) {
            builder.addAllBrokerInfos(((Map)brokerStaticInfo.getF1()).values());
        }
        if (prodTopicConfigTuple.getF2() != null) {
            builder.addAllTopicInfos(((Map)prodTopicConfigTuple.getF2()).values());
        }
        if ((clientConfigBuilder = this.buildApprovedClientConfig(request.getAppdConfig(), prodTopicConfigTuple)) != null) {
            builder.setAppdConfig(clientConfigBuilder);
        }
        if (logger.isDebugEnabled()) {
            logger.debug(strBuff.append("[Push Producer's available topic count:]").append(producerId).append(";").append(prodTopicConfigTuple.getF2() == null ? 0 : ((Map)prodTopicConfigTuple.getF2()).size()).toString());
        }
        builder.setSuccess(true);
        builder.setErrCode(200);
        builder.setErrMsg("OK!");
        return builder.build();
    }

    public ClientMaster.CloseResponseM2P producerCloseClientP2M(ClientMaster.CloseRequestP2M request, String rmtAddress, boolean overtls) throws Exception {
        ProcessResult result = new ProcessResult();
        StringBuilder strBuff = new StringBuilder(512);
        ClientMaster.CloseResponseM2P.Builder builder = ClientMaster.CloseResponseM2P.newBuilder();
        builder.setSuccess(false);
        if (!this.serverAuthHandler.identityValidUserInfo(request.getAuthInfo(), true, result)) {
            builder.setErrCode(result.getErrCode());
            builder.setErrMsg(result.getErrMsg());
            return builder.build();
        }
        if (!PBParameterUtils.checkClientId(request.getClientId(), strBuff, result)) {
            builder.setErrCode(result.getErrCode());
            builder.setErrMsg(result.getErrMsg());
            return builder.build();
        }
        String producerId = (String)result.getRetData();
        this.checkNodeStatus(producerId, strBuff);
        new ReleaseProducer().run(producerId, false);
        this.heartbeatManager.unRegProducerNode(producerId);
        logger.info(strBuff.append("[Producer Closed] ").append(producerId).append(", isOverTLS=").append(overtls).toString());
        builder.setSuccess(true);
        builder.setErrCode(200);
        builder.setErrMsg("OK!");
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientMaster.RegisterResponseM2C consumerRegisterC2M(ClientMaster.RegisterRequestC2M request, String rmtAddress, boolean overtls) throws Exception {
        boolean isSelectBig;
        ConsumerInfo inConsumerInfo;
        String clientJdkVer;
        ProcessResult result = new ProcessResult();
        StringBuilder strBuff = new StringBuilder(512);
        ClientMaster.RegisterResponseM2C.Builder builder = ClientMaster.RegisterResponseM2C.newBuilder();
        builder.setSuccess(false);
        if (!this.serverAuthHandler.identityValidUserInfo(request.getAuthInfo(), false, result)) {
            builder.setErrCode(result.getErrCode());
            builder.setErrMsg(result.getErrMsg());
            return builder.build();
        }
        CertifiedInfo certifiedInfo = (CertifiedInfo)result.getRetData();
        if (!PBParameterUtils.checkClientId(request.getClientId(), strBuff, result)) {
            builder.setErrCode(result.getErrCode());
            builder.setErrMsg(result.getErrMsg());
            return builder.build();
        }
        String consumerId = (String)result.getRetData();
        if (!PBParameterUtils.checkHostName(request.getHostName(), strBuff, result)) {
            builder.setErrCode(result.getErrCode());
            builder.setErrMsg(result.getErrMsg());
            return builder.build();
        }
        if (!PBParameterUtils.checkGroupName(request.getGroupName(), strBuff, result)) {
            builder.setErrCode(result.getErrCode());
            builder.setErrMsg(result.getErrMsg());
            return builder.build();
        }
        String groupName = (String)result.getRetData();
        this.checkNodeStatus(consumerId, strBuff);
        if (!PBParameterUtils.checkConsumerTopicList(this.defMetaDataService.getDeployedTopicSet(), (List<String>)request.getTopicListList(), strBuff, result)) {
            builder.setErrCode(result.getErrCode());
            builder.setErrMsg(result.getErrMsg());
            return builder.build();
        }
        Set reqTopicSet = (Set)result.getRetData();
        Map reqTopicConditions = DataConverterUtil.convertTopicConditions((List)request.getTopicConditionList());
        String requiredParts = request.hasRequiredPartition() ? request.getRequiredPartition() : "";
        ConsumeType csmType = request.hasRequireBound() && request.getRequireBound() ? ConsumeType.CONSUME_BAND : ConsumeType.CONSUME_NORMAL;
        String string = clientJdkVer = request.hasJdkVersion() ? request.getJdkVersion() : "";
        if (!PBParameterUtils.checkConsumerOffsetSetInfo(csmType, reqTopicSet, requiredParts, strBuff, result)) {
            builder.setErrCode(result.getErrCode());
            builder.setErrMsg(result.getErrMsg());
            return builder.build();
        }
        Map requiredPartMap = (Map)result.getRetData();
        String sessionKey = request.hasSessionKey() ? request.getSessionKey() : "";
        long sessionTime = request.hasSessionTime() ? request.getSessionTime() : System.currentTimeMillis();
        int sourceCount = request.hasTotalCount() ? request.getTotalCount() : -1;
        int qryPriorityId = request.hasQryPriorityId() ? request.getQryPriorityId() : -2;
        List subscribeList = DataConverterUtil.convertSubInfo((List)request.getSubscribeInfoList());
        boolean isNotAllocated = true;
        if (CollectionUtils.isNotEmpty((Collection)subscribeList) || request.hasNotAllocated() && !request.getNotAllocated()) {
            isNotAllocated = false;
        }
        if (!PBParameterUtils.checkConsumerInputInfo(inConsumerInfo = new ConsumerInfo(consumerId, overtls, groupName, reqTopicSet, reqTopicConditions, csmType, sessionKey, sessionTime, sourceCount, isSelectBig = !request.hasSelectBig() || request.getSelectBig(), requiredPartMap, rmtAddress), this.masterConfig, this.defMetaDataService, this.brokerRunManager, strBuff, result)) {
            builder.setErrCode(result.getErrCode());
            builder.setErrMsg(result.getErrMsg());
            return builder.build();
        }
        ConsumerInfo inConsumerInfo2 = (ConsumerInfo)result.getRetData();
        if (!this.serverAuthHandler.validConsumerAuthorizeInfo(certifiedInfo.getUserName(), groupName, reqTopicSet, reqTopicConditions, rmtAddress, result)) {
            builder.setErrCode(result.getErrCode());
            builder.setErrMsg(result.getErrMsg());
            return builder.build();
        }
        if (!this.defMetaDataService.isConsumeTargetAuthorized(consumerId, groupName, reqTopicSet, reqTopicConditions, strBuff, result)) {
            if (strBuff.length() > 0) {
                logger.warn(strBuff.toString());
            }
            builder.setErrCode(result.getErrCode());
            builder.setErrMsg(result.getErrMsg());
            return builder.build();
        }
        Integer lid = null;
        ConsumeGroupInfo consumeGroupInfo = null;
        try {
            lid = this.masterRowLock.getLock(null, StringUtils.getBytesUtf8((String)consumerId), true);
            if (!this.consumerHolder.addConsumer(inConsumerInfo2, isNotAllocated, strBuff, result)) {
                builder.setErrCode(result.getErrCode());
                builder.setErrMsg(result.getErrMsg());
                ClientMaster.RegisterResponseM2C registerResponseM2C = builder.build();
                return registerResponseM2C;
            }
            consumeGroupInfo = (ConsumeGroupInfo)result.getRetData();
            this.topicPSInfoManager.addGroupSubTopicInfo(groupName, reqTopicSet);
            if (CollectionUtils.isNotEmpty((Collection)subscribeList)) {
                int reportCnt = 0;
                HashMap<String, Map> topicPartSubMap = new HashMap<String, Map>();
                this.currentSubInfo.put(consumerId, topicPartSubMap);
                strBuff.append("[SubInfo Report] client=").append(consumerId).append(", subscribed partitions=[");
                for (SubscribeInfo info : subscribeList) {
                    Map partMap = topicPartSubMap.computeIfAbsent(info.getTopic(), k -> new HashMap());
                    partMap.put(info.getPartition().getPartitionKey(), info.getPartition());
                    if (reportCnt++ > 0) {
                        strBuff.append(",");
                    }
                    strBuff.append(info.getPartitionStr());
                }
                strBuff.append("]");
                logger.info(strBuff.toString());
                strBuff.delete(0, strBuff.length());
            }
            this.heartbeatManager.regConsumerNode(this.getConsumerKey(groupName, consumerId));
        }
        catch (IOException e) {
            logger.warn("Failed to lock.", (Throwable)e);
        }
        finally {
            if (lid != null) {
                this.masterRowLock.releaseRowLock(lid);
            }
        }
        logger.info(strBuff.append("[Consumer Register] ").append(consumerId).append(", isOverTLS=").append(overtls).append(", clientJDKVer=").append(clientJdkVer).toString());
        strBuff.delete(0, strBuff.length());
        if (request.hasDefFlowCheckId() || request.hasGroupFlowCheckId()) {
            builder.setSsdStoreId(-2L);
            builder.setDefFlowCheckId(-2L);
            builder.setGroupFlowCheckId(-2L);
            builder.setQryPriorityId(-2);
            builder.setDefFlowControlInfo(" ");
            builder.setGroupFlowControlInfo(" ");
            ClusterSettingEntity defSetting = this.defMetaDataService.getClusterDefSetting(false);
            GroupResCtrlEntity groupResCtrlConf = this.defMetaDataService.getGroupCtrlConf(groupName);
            if (defSetting.enableFlowCtrl()) {
                builder.setDefFlowCheckId(defSetting.getSerialId());
                if (request.getDefFlowCheckId() != defSetting.getSerialId()) {
                    builder.setDefFlowControlInfo(defSetting.getGloFlowCtrlRuleInfo());
                }
            }
            if (groupResCtrlConf != null && groupResCtrlConf.isFlowCtrlEnable()) {
                builder.setGroupFlowCheckId(groupResCtrlConf.getSerialId());
                builder.setQryPriorityId(groupResCtrlConf.getQryPriorityId());
                if (request.getGroupFlowCheckId() != groupResCtrlConf.getSerialId()) {
                    builder.setGroupFlowControlInfo(groupResCtrlConf.getFlowCtrlInfo());
                }
            }
        }
        builder.setAuthorizedInfo(this.genAuthorizedInfo(certifiedInfo.getAuthorizedToken(), false));
        builder.setNotAllocated(consumeGroupInfo.isNotAllocate());
        builder.setSuccess(true);
        builder.setErrCode(200);
        builder.setErrMsg("OK!");
        return builder.build();
    }

    public ClientMaster.HeartResponseM2C consumerHeartbeatC2M(ClientMaster.HeartRequestC2M request, String rmtAddress, boolean overtls) throws Throwable {
        ConsumerEvent event;
        List infoList;
        Map<String, Map<String, Partition>> tmpTopicPartSubList;
        ProcessResult result = new ProcessResult();
        StringBuilder strBuff = new StringBuilder(512);
        ClientMaster.HeartResponseM2C.Builder builder = ClientMaster.HeartResponseM2C.newBuilder();
        builder.setSuccess(false);
        if (!this.serverAuthHandler.identityValidUserInfo(request.getAuthInfo(), false, result)) {
            builder.setErrCode(result.getErrCode());
            builder.setErrMsg(result.getErrMsg());
            return builder.build();
        }
        CertifiedInfo certifiedInfo = (CertifiedInfo)result.getRetData();
        if (!PBParameterUtils.checkClientId(request.getClientId(), strBuff, result)) {
            builder.setErrCode(result.getErrCode());
            builder.setErrMsg(result.getErrMsg());
            return builder.build();
        }
        String clientId = (String)result.getRetData();
        if (!PBParameterUtils.checkGroupName(request.getGroupName(), strBuff, result)) {
            builder.setErrCode(result.getErrCode());
            builder.setErrMsg(result.getErrMsg());
            return builder.build();
        }
        String groupName = (String)result.getRetData();
        this.checkNodeStatus(clientId, strBuff);
        ConsumeGroupInfo consumeGroupInfo = this.consumerHolder.getConsumeGroupInfo(groupName);
        if (consumeGroupInfo == null) {
            builder.setErrCode(411);
            builder.setErrMsg(strBuff.append("Not found groupName ").append(groupName).append(" in holder!").toString());
            return builder.build();
        }
        if (!this.serverAuthHandler.validConsumerAuthorizeInfo(certifiedInfo.getUserName(), groupName, consumeGroupInfo.getTopicSet(), consumeGroupInfo.getTopicConditions(), rmtAddress, result)) {
            builder.setErrCode(result.getErrCode());
            builder.setErrMsg(result.getErrMsg());
            return builder.build();
        }
        try {
            this.heartbeatManager.updConsumerNode(this.getConsumerKey(groupName, clientId));
        }
        catch (HeartbeatException e) {
            builder.setErrCode(411);
            builder.setErrMsg(strBuff.append("Update consumer node exception:").append(e.getMessage()).toString());
            return builder.build();
        }
        Map<String, Map<String, Partition>> topicPartSubList = this.currentSubInfo.get(clientId);
        if (topicPartSubList == null && (tmpTopicPartSubList = this.currentSubInfo.putIfAbsent(clientId, topicPartSubList = new HashMap<String, Map<String, Partition>>())) != null) {
            topicPartSubList = tmpTopicPartSubList;
        }
        long rebalanceId = request.hasEvent() ? request.getEvent().getRebalanceId() : -2L;
        ProtocolStringList strSubInfoList = request.getSubscribeInfoList();
        if (request.getReportSubscribeInfo() && !this.checkIfConsist(topicPartSubList, infoList = DataConverterUtil.convertSubInfo((List)strSubInfoList))) {
            topicPartSubList.clear();
            for (SubscribeInfo info : infoList) {
                Map<String, Partition> partMap = topicPartSubList.get(info.getTopic());
                if (partMap == null) {
                    partMap = new HashMap<String, Partition>();
                    topicPartSubList.put(info.getTopic(), partMap);
                }
                Partition regPart = new Partition(info.getPartition().getBroker(), info.getTopic(), info.getPartitionId());
                partMap.put(regPart.getPartitionKey(), regPart);
            }
            if (rebalanceId <= 0L) {
                logger.warn(strBuff.append("[Consistent Warn]").append(clientId).append(" sub info is not consistent with master.").toString());
                strBuff.delete(0, strBuff.length());
            }
        }
        if (rebalanceId > 0L) {
            logger.info(strBuff.append("[Event Processed] rebalanceId=").append(request.getEvent().getRebalanceId()).append(", clientId=").append(clientId).toString());
            strBuff.delete(0, strBuff.length());
            try {
                consumeGroupInfo.settAllocated();
                this.consumerEventManager.removeFirst(clientId, strBuff);
            }
            catch (Throwable e) {
                logger.warn("Unknown exception for remove first event:", e);
            }
        }
        if ((event = this.consumerEventManager.peek(clientId)) != null && event.getStatus() != EventStatus.PROCESSING) {
            event.setStatus(EventStatus.PROCESSING);
            strBuff.append("[Push Consumer Event]");
            logger.info(event.toStrBuilder(clientId, strBuff).toString());
            strBuff.delete(0, strBuff.length());
            ClientMaster.EventProto.Builder eventProtoBuilder = ClientMaster.EventProto.newBuilder();
            eventProtoBuilder.setRebalanceId(event.getRebalanceId());
            eventProtoBuilder.setOpType(event.getType().getValue());
            eventProtoBuilder.addAllSubscribeInfo((Iterable)DataConverterUtil.formatSubInfo((List)event.getSubscribeInfoList()));
            ClientMaster.EventProto eventProto = eventProtoBuilder.build();
            builder.setEvent(eventProto);
        }
        if (request.hasDefFlowCheckId() || request.hasGroupFlowCheckId()) {
            builder.setSsdStoreId(-2L);
            builder.setQryPriorityId(-2);
            builder.setDefFlowCheckId(-2L);
            builder.setGroupFlowCheckId(-2L);
            builder.setDefFlowControlInfo(" ");
            builder.setGroupFlowControlInfo(" ");
            ClusterSettingEntity defSetting = this.defMetaDataService.getClusterDefSetting(false);
            GroupResCtrlEntity groupResCtrlConf = this.defMetaDataService.getGroupCtrlConf(groupName);
            if (defSetting.enableFlowCtrl()) {
                builder.setDefFlowCheckId(defSetting.getSerialId());
                if (request.getDefFlowCheckId() != defSetting.getSerialId()) {
                    builder.setDefFlowControlInfo(defSetting.getGloFlowCtrlRuleInfo());
                }
            }
            if (groupResCtrlConf != null && groupResCtrlConf.isFlowCtrlEnable()) {
                builder.setGroupFlowCheckId(groupResCtrlConf.getSerialId());
                builder.setQryPriorityId(groupResCtrlConf.getQryPriorityId());
                if (request.getGroupFlowCheckId() != groupResCtrlConf.getSerialId()) {
                    builder.setGroupFlowControlInfo(groupResCtrlConf.getFlowCtrlInfo());
                }
            }
        }
        builder.setAuthorizedInfo(this.genAuthorizedInfo(certifiedInfo.getAuthorizedToken(), false));
        builder.setNotAllocated(consumeGroupInfo.isNotAllocate());
        builder.setSuccess(true);
        builder.setErrCode(200);
        builder.setErrMsg("OK!");
        return builder.build();
    }

    public ClientMaster.CloseResponseM2C consumerCloseClientC2M(ClientMaster.CloseRequestC2M request, String rmtAddress, boolean overtls) throws Exception {
        ProcessResult result = new ProcessResult();
        StringBuilder strBuff = new StringBuilder(512);
        ClientMaster.CloseResponseM2C.Builder builder = ClientMaster.CloseResponseM2C.newBuilder();
        builder.setSuccess(false);
        if (!this.serverAuthHandler.identityValidUserInfo(request.getAuthInfo(), false, result)) {
            builder.setErrCode(result.getErrCode());
            builder.setErrMsg(result.getErrMsg());
            return builder.build();
        }
        if (!PBParameterUtils.checkClientId(request.getClientId(), strBuff, result)) {
            builder.setErrCode(result.getErrCode());
            builder.setErrMsg(result.getErrMsg());
            return builder.build();
        }
        String clientId = (String)result.getRetData();
        if (!PBParameterUtils.checkGroupName(request.getGroupName(), strBuff, result)) {
            builder.setErrCode(result.getErrCode());
            builder.setErrMsg(result.getErrMsg());
            return builder.build();
        }
        String groupName = (String)result.getRetData();
        this.checkNodeStatus(clientId, strBuff);
        String nodeId = this.getConsumerKey(groupName, clientId);
        logger.info(strBuff.append("[Consumer Closed]").append(nodeId).append(", isOverTLS=").append(overtls).toString());
        new ReleaseConsumer().run(nodeId, false);
        this.heartbeatManager.unRegConsumerNode(nodeId);
        builder.setSuccess(true);
        builder.setErrCode(200);
        builder.setErrMsg("OK!");
        return builder.build();
    }

    public ClientMaster.RegisterResponseM2B brokerRegisterB2M(ClientMaster.RegisterRequestB2M request, String rmtAddress, boolean overtls) throws Exception {
        ProcessResult result = new ProcessResult();
        StringBuilder strBuff = new StringBuilder(512);
        ClientMaster.RegisterResponseM2B.Builder builder = ClientMaster.RegisterResponseM2B.newBuilder();
        builder.setSuccess(false);
        builder.setStopRead(false);
        builder.setStopWrite(false);
        builder.setTakeConfInfo(false);
        if (!this.serverAuthHandler.identityValidBrokerInfo(request.getAuthInfo(), result)) {
            builder.setErrCode(result.getErrCode());
            builder.setErrMsg(result.getErrMsg());
            return builder.build();
        }
        if (!PBParameterUtils.checkClientId(request.getClientId(), strBuff, result)) {
            builder.setErrCode(result.getErrCode());
            builder.setErrMsg(result.getErrMsg());
            return builder.build();
        }
        String clientId = (String)result.getRetData();
        this.checkNodeStatus(clientId, strBuff);
        ClusterSettingEntity defSetting = this.defMetaDataService.getClusterDefSetting(false);
        long reFlowCtrlId = request.hasFlowCheckId() ? request.getFlowCheckId() : -2L;
        int qryPriorityId = request.hasQryPriorityId() ? request.getQryPriorityId() : -2;
        int tlsPort = request.hasTlsPort() ? request.getTlsPort() : defSetting.getBrokerTLSPort();
        BrokerInfo brokerInfo = new BrokerInfo(clientId, request.getEnableTls(), tlsPort);
        if (!this.brokerRunManager.brokerRegister2M(clientId, brokerInfo, request.getCurBrokerConfId(), request.getConfCheckSumId(), true, request.getBrokerDefaultConfInfo(), (List<String>)request.getBrokerTopicSetConfInfoList(), request.getBrokerOnline(), overtls, strBuff, result)) {
            builder.setErrCode(result.getErrCode());
            builder.setErrMsg(result.getErrMsg());
            return builder.build();
        }
        logger.info(strBuff.append("[Broker Register] ").append(clientId).append(" report, configureId=").append(request.getCurBrokerConfId()).append(",readStatusRpt=").append(request.getReadStatusRpt()).append(",writeStatusRpt=").append(request.getWriteStatusRpt()).append(",isTlsEnable=").append(brokerInfo.isEnableTLS()).append(",TLSport=").append(brokerInfo.getTlsPort()).append(",FlowCtrlId=").append(reFlowCtrlId).append(",qryPriorityId=").append(qryPriorityId).append(",checksumId=").append(request.getConfCheckSumId()).toString());
        strBuff.delete(0, strBuff.length());
        builder.setSuccess(true);
        builder.setErrCode(200);
        builder.setErrMsg("OK!");
        builder.setAuthorizedInfo(this.genAuthorizedInfo(null, true));
        builder.setBrokerAuthorizedInfo(this.genBrokerAuthorizedInfo(null));
        ClientMaster.EnableBrokerFunInfo.Builder enableInfo = ClientMaster.EnableBrokerFunInfo.newBuilder();
        enableInfo.setEnableVisitTokenCheck(this.masterConfig.isStartVisitTokenCheck());
        enableInfo.setEnableProduceAuthenticate(this.masterConfig.isStartProduceAuthenticate());
        enableInfo.setEnableProduceAuthorize(this.masterConfig.isStartProduceAuthorize());
        enableInfo.setEnableConsumeAuthenticate(this.masterConfig.isStartConsumeAuthenticate());
        enableInfo.setEnableConsumeAuthorize(this.masterConfig.isStartConsumeAuthorize());
        builder.setEnableBrokerInfo(enableInfo);
        this.brokerRunManager.setRegisterDownConfInfo(brokerInfo.getBrokerId(), strBuff, builder);
        builder.setSsdStoreId(-2L);
        ClientMaster.ClusterConfig.Builder clusterConfigBuilder = this.buildClusterConfig(request.getClsConfig());
        if (clusterConfigBuilder != null) {
            builder.setClsConfig(clusterConfigBuilder);
        }
        if (request.hasFlowCheckId()) {
            builder.setQryPriorityId(defSetting.getQryPriorityId());
            builder.setFlowCheckId(defSetting.getSerialId());
            if (reFlowCtrlId != defSetting.getSerialId()) {
                if (defSetting.enableFlowCtrl()) {
                    builder.setFlowControlInfo(defSetting.getGloFlowCtrlRuleInfo());
                } else {
                    builder.setFlowControlInfo(" ");
                }
            }
        }
        logger.info(strBuff.append("[Broker Register] ").append(clientId).append(", isOverTLS=").append(overtls).toString());
        return builder.build();
    }

    public ClientMaster.HeartResponseM2B brokerHeartbeatB2M(ClientMaster.HeartRequestB2M request, String rmtAddress, boolean overtls) throws Exception {
        ClientMaster.ClusterConfig.Builder clusterConfigBuilder;
        ProcessResult result = new ProcessResult();
        StringBuilder strBuff = new StringBuilder(512);
        ClientMaster.HeartResponseM2B.Builder builder = ClientMaster.HeartResponseM2B.newBuilder();
        builder.setSuccess(false);
        builder.setStopRead(false);
        builder.setStopWrite(false);
        builder.setNeedReportData(true);
        builder.setTakeConfInfo(false);
        builder.setTakeRemoveTopicInfo(false);
        builder.setFlowCheckId(-2L);
        builder.setQryPriorityId(-2);
        builder.setCurBrokerConfId(-2L);
        builder.setConfCheckSumId(-2);
        if (!this.serverAuthHandler.identityValidBrokerInfo(request.getAuthInfo(), result)) {
            builder.setErrCode(result.getErrCode());
            builder.setErrMsg(result.getErrMsg());
            return builder.build();
        }
        if (!PBParameterUtils.checkBrokerId(request.getBrokerId(), strBuff, result)) {
            builder.setErrCode(result.getErrCode());
            builder.setErrMsg(result.getErrMsg());
            return builder.build();
        }
        int brokerId = (Integer)result.getRetData();
        long reFlowCtrlId = request.hasFlowCheckId() ? request.getFlowCheckId() : -2L;
        int qryPriorityId = request.hasQryPriorityId() ? request.getQryPriorityId() : -2;
        this.checkNodeStatus(String.valueOf(brokerId), strBuff);
        if (!this.brokerRunManager.brokerHeartBeat2M(brokerId, request.getCurBrokerConfId(), request.getConfCheckSumId(), request.getTakeConfInfo(), request.getBrokerDefaultConfInfo(), (List<String>)request.getBrokerTopicSetConfInfoList(), request.getTakeRemovedTopicInfo(), (List<String>)request.getRemovedTopicsInfoList(), request.getReadStatusRpt(), request.getWriteStatusRpt(), request.getBrokerOnline(), strBuff, result)) {
            builder.setErrCode(result.getErrCode());
            builder.setErrMsg(result.getErrMsg());
            return builder.build();
        }
        if (request.getTakeConfInfo()) {
            strBuff.append("[Broker Report] heartbeat report: brokerId=").append(request.getBrokerId()).append(", configureId=").append(request.getCurBrokerConfId()).append(",readStatusRpt=").append(request.getReadStatusRpt()).append(",writeStatusRpt=").append(request.getWriteStatusRpt()).append(",checksumId=").append(request.getConfCheckSumId()).append(",hasFlowCheckId=").append(request.hasFlowCheckId()).append(",reFlowCtrlId=").append(reFlowCtrlId).append(",qryPriorityId=").append(qryPriorityId).append(",brokerOnline=").append(request.getBrokerOnline()).append(",default broker configure is ").append(request.getBrokerDefaultConfInfo()).append(",broker topic configure is ").append(request.getBrokerTopicSetConfInfoList());
            strBuff.delete(0, strBuff.length());
        }
        this.brokerRunManager.setHeatBeatDownConfInfo(brokerId, strBuff, builder);
        BrokerConfEntity brokerConfEntity = this.defMetaDataService.getBrokerConfByBrokerId(brokerId);
        builder.setTakeRemoveTopicInfo(true);
        builder.addAllRemoveTopicConfInfo(this.defMetaDataService.getBrokerRemovedTopicStrConfigInfo(brokerConfEntity, strBuff).values());
        builder.setSsdStoreId(-2L);
        if (request.hasFlowCheckId()) {
            ClusterSettingEntity defSetting = this.defMetaDataService.getClusterDefSetting(false);
            builder.setFlowCheckId(defSetting.getSerialId());
            builder.setQryPriorityId(defSetting.getQryPriorityId());
            if (reFlowCtrlId != defSetting.getSerialId()) {
                if (defSetting.enableFlowCtrl()) {
                    builder.setFlowControlInfo(defSetting.getGloFlowCtrlRuleInfo());
                } else {
                    builder.setFlowControlInfo(" ");
                }
            }
        }
        if ((clusterConfigBuilder = this.buildClusterConfig(request.getClsConfig())) != null) {
            builder.setClsConfig(clusterConfigBuilder);
        }
        builder.setAuthorizedInfo(this.genAuthorizedInfo(null, true));
        builder.setBrokerAuthorizedInfo(this.genBrokerAuthorizedInfo(null));
        builder.setSuccess(true);
        builder.setErrCode(200);
        builder.setErrMsg("OK!");
        return builder.build();
    }

    public ClientMaster.CloseResponseM2B brokerCloseClientB2M(ClientMaster.CloseRequestB2M request, String rmtAddress, boolean overtls) throws Throwable {
        ProcessResult result = new ProcessResult();
        StringBuilder strBuff = new StringBuilder(512);
        ClientMaster.CloseResponseM2B.Builder builder = ClientMaster.CloseResponseM2B.newBuilder();
        builder.setSuccess(false);
        if (!this.serverAuthHandler.identityValidBrokerInfo(request.getAuthInfo(), result)) {
            builder.setErrCode(result.getErrCode());
            builder.setErrMsg(result.getErrMsg());
            return builder.build();
        }
        if (!PBParameterUtils.checkBrokerId(request.getBrokerId(), strBuff, result)) {
            builder.setErrCode(result.getErrCode());
            builder.setErrMsg(result.getErrMsg());
            return builder.build();
        }
        int brokerId = (Integer)result.getRetData();
        this.checkNodeStatus(String.valueOf(brokerId), strBuff);
        if (!this.brokerRunManager.brokerClose2M(brokerId, strBuff, result)) {
            builder.setErrCode(result.getErrCode());
            builder.setErrMsg(result.getErrMsg());
            return builder.build();
        }
        builder.setSuccess(true);
        builder.setErrCode(200);
        builder.setErrMsg("OK!");
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientMaster.RegisterResponseM2CV2 consumerRegisterC2MV2(ClientMaster.RegisterRequestC2MV2 request, String rmtAddress, boolean overtls) throws Throwable {
        ProcessResult result = new ProcessResult();
        StringBuilder strBuff = new StringBuilder(512);
        ClientMaster.RegisterResponseM2CV2.Builder builder = ClientMaster.RegisterResponseM2CV2.newBuilder();
        if (!this.serverAuthHandler.identityValidUserInfo(request.getAuthInfo(), false, result)) {
            builder.setErrCode(result.getErrCode());
            builder.setErrMsg(result.getErrMsg());
            return builder.build();
        }
        CertifiedInfo certifiedInfo = (CertifiedInfo)result.getRetData();
        if (!PBParameterUtils.checkClientId(request.getClientId(), strBuff, result)) {
            builder.setErrCode(result.getErrCode());
            builder.setErrMsg(result.getErrMsg());
            return builder.build();
        }
        String consumerId = (String)result.getRetData();
        if (!PBParameterUtils.checkHostName(request.getHostName(), strBuff, result)) {
            builder.setErrCode(result.getErrCode());
            builder.setErrMsg(result.getErrMsg());
            return builder.build();
        }
        if (!PBParameterUtils.checkGroupName(request.getGroupName(), strBuff, result)) {
            builder.setErrCode(result.getErrCode());
            builder.setErrMsg(result.getErrMsg());
            return builder.build();
        }
        String groupName = (String)result.getRetData();
        this.checkNodeStatus(consumerId, strBuff);
        if (!PBParameterUtils.checkConsumerTopicList(this.defMetaDataService.getDeployedTopicSet(), (List<String>)request.getTopicListList(), strBuff, result)) {
            builder.setErrCode(result.getErrCode());
            builder.setErrMsg(result.getErrMsg());
            return builder.build();
        }
        Set reqTopicSet = (Set)result.getRetData();
        Map reqTopicConditions = DataConverterUtil.convertTopicConditions((List)request.getTopicConditionList());
        int sourceCount = request.getSourceCount();
        int nodeId = request.getNodeId();
        if (sourceCount > 0 && (nodeId < 0 || nodeId > sourceCount - 1)) {
            builder.setErrCode(400);
            builder.setErrMsg("Request nodeId value must be between in [0, sourceCount-1]!");
            return builder.build();
        }
        String clientJdkVer = request.hasJdkVersion() ? request.getJdkVersion() : "";
        ConsumeType csmType = ConsumeType.CONSUME_CLIENT_REB;
        OpsSyncInfo opsTaskInfo = new OpsSyncInfo();
        if (request.hasOpsTaskInfo()) {
            opsTaskInfo.updOpsSyncInfo(request.getOpsTaskInfo());
        }
        ClientSyncInfo clientSyncInfo = new ClientSyncInfo();
        if (request.hasSubRepInfo()) {
            clientSyncInfo.updSubRepInfo(this.brokerRunManager, request.getSubRepInfo());
        }
        ConsumerInfo inConsumerInfo = new ConsumerInfo(consumerId, overtls, groupName, csmType, sourceCount, nodeId, reqTopicSet, reqTopicConditions, opsTaskInfo.getCsmFromMaxOffsetCtrlId(), clientSyncInfo, rmtAddress);
        if (!this.defMetaDataService.isConsumeTargetAuthorized(consumerId, groupName, reqTopicSet, reqTopicConditions, strBuff, result)) {
            if (strBuff.length() > 0) {
                logger.warn(strBuff.toString());
            }
            builder.setErrCode(result.getErrCode());
            builder.setErrMsg(result.getErrMsg());
            return builder.build();
        }
        if (!PBParameterUtils.checkConsumerInputInfo(inConsumerInfo, this.masterConfig, this.defMetaDataService, this.brokerRunManager, strBuff, result)) {
            builder.setErrCode(result.getErrCode());
            builder.setErrMsg(result.getErrMsg());
            return builder.build();
        }
        if (!this.serverAuthHandler.validConsumerAuthorizeInfo(certifiedInfo.getUserName(), groupName, reqTopicSet, reqTopicConditions, rmtAddress, result)) {
            builder.setErrCode(result.getErrCode());
            builder.setErrMsg(result.getErrMsg());
            return builder.build();
        }
        Integer lid = null;
        try {
            lid = this.masterRowLock.getLock(null, StringUtils.getBytesUtf8((String)consumerId), true);
            if (!this.consumerHolder.addConsumer(inConsumerInfo, false, strBuff, result)) {
                builder.setErrCode(result.getErrCode());
                builder.setErrMsg(result.getErrMsg());
                ClientMaster.RegisterResponseM2CV2 registerResponseM2CV2 = builder.build();
                return registerResponseM2CV2;
            }
            this.topicPSInfoManager.addGroupSubTopicInfo(groupName, reqTopicSet);
            this.heartbeatManager.regConsumerNode(this.getConsumerKey(groupName, consumerId));
        }
        catch (IOException e) {
            logger.warn("Failed to lock.", (Throwable)e);
        }
        finally {
            if (lid != null) {
                this.masterRowLock.releaseRowLock(lid);
            }
        }
        ConsumeGroupInfo consumeGroupInfo = this.consumerHolder.getConsumeGroupInfo(groupName);
        if (consumeGroupInfo == null) {
            logger.warn(strBuff.append("[Illegal Process] ").append(consumerId).append(" visit consume group(").append(groupName).append(" info failure, null information").toString());
            builder.setErrCode(500);
            builder.setErrMsg(strBuff.toString());
            strBuff.delete(0, strBuff.length());
            return builder.build();
        }
        inConsumerInfo = consumeGroupInfo.getConsumerInfo(consumerId);
        if (inConsumerInfo == null) {
            logger.warn(strBuff.append("[Illegal Process] ").append(consumerId).append(" visit consume info failure, null information").toString());
            builder.setErrCode(500);
            builder.setErrMsg(strBuff.toString());
            strBuff.delete(0, strBuff.length());
            return builder.build();
        }
        HashMap<String, Map<String, Partition>> topicPartSubMap = new HashMap<String, Map<String, Partition>>();
        this.currentSubInfo.put(consumerId, topicPartSubMap);
        Tuple2<Boolean, Set<Partition>> reportInfo = clientSyncInfo.getRepSubInfo();
        if (((Boolean)reportInfo.getF0()).booleanValue()) {
            for (Partition info : (Set)reportInfo.getF1()) {
                Map partMap = topicPartSubMap.computeIfAbsent(info.getTopic(), k -> new HashMap());
                partMap.put(info.getPartitionKey(), info);
            }
            this.printReportInfo(consumerId, null, topicPartSubMap, strBuff);
        }
        logger.info(strBuff.append("[Consumer Register] ").append(consumerId).append(", isOverTLS=").append(overtls).append(", clientJDKVer=").append(clientJdkVer).toString());
        strBuff.delete(0, strBuff.length());
        Tuple2<Long, Map<Integer, String>> brokerStaticInfo = this.brokerRunManager.getBrokerStaticInfo(overtls);
        builder.setBrokerConfigId(((Long)brokerStaticInfo.getF0()).longValue());
        if (clientSyncInfo.getBrokerConfigId() != ((Long)brokerStaticInfo.getF0()).longValue()) {
            builder.addAllBrokerConfigList(((Map)brokerStaticInfo.getF1()).values());
        }
        builder.setOpsTaskInfo(this.buildOpsTaskInfo(consumeGroupInfo, inConsumerInfo, opsTaskInfo));
        builder.setAuthorizedInfo(this.genAuthorizedInfo(certifiedInfo.getAuthorizedToken(), false));
        builder.setErrCode(200);
        builder.setErrMsg("OK!");
        return builder.build();
    }

    public ClientMaster.HeartResponseM2CV2 consumerHeartbeatC2MV2(ClientMaster.HeartRequestC2MV2 request, String rmtAddress, boolean overtls) throws Throwable {
        ConsumeGroupInfo consumeGroupInfo;
        ProcessResult result = new ProcessResult();
        StringBuilder strBuff = new StringBuilder(512);
        ClientMaster.HeartResponseM2CV2.Builder builder = ClientMaster.HeartResponseM2CV2.newBuilder();
        if (!this.serverAuthHandler.identityValidUserInfo(request.getAuthInfo(), false, result)) {
            builder.setErrCode(result.getErrCode());
            builder.setErrMsg(result.getErrMsg());
            return builder.build();
        }
        CertifiedInfo certifiedInfo = (CertifiedInfo)result.getRetData();
        if (!PBParameterUtils.checkClientId(request.getClientId(), strBuff, result)) {
            builder.setErrCode(result.getErrCode());
            builder.setErrMsg(result.getErrMsg());
            return builder.build();
        }
        String clientId = (String)result.getRetData();
        if (!PBParameterUtils.checkGroupName(request.getGroupName(), strBuff, result)) {
            builder.setErrCode(result.getErrCode());
            builder.setErrMsg(result.getErrMsg());
            return builder.build();
        }
        String groupName = (String)result.getRetData();
        OpsSyncInfo opsTaskInfo = new OpsSyncInfo();
        if (request.hasOpsTaskInfo()) {
            opsTaskInfo.updOpsSyncInfo(request.getOpsTaskInfo());
        }
        this.checkNodeStatus(clientId, strBuff);
        ClientSyncInfo clientSyncInfo = new ClientSyncInfo();
        if (request.hasSubRepInfo()) {
            clientSyncInfo.updSubRepInfo(this.brokerRunManager, request.getSubRepInfo());
        }
        if ((consumeGroupInfo = this.consumerHolder.getConsumeGroupInfo(groupName)) == null) {
            builder.setErrCode(411);
            builder.setErrMsg(strBuff.append("Not found groupName ").append(groupName).append(" in holder!").toString());
            return builder.build();
        }
        ConsumerInfo inConsumerInfo = consumeGroupInfo.getConsumerInfo(clientId);
        if (inConsumerInfo == null) {
            builder.setErrCode(411);
            builder.setErrMsg(strBuff.append("Not found client ").append(clientId).append(" in group(").append(groupName).append(")").toString());
            strBuff.delete(0, strBuff.length());
            return builder.build();
        }
        if (!this.serverAuthHandler.validConsumerAuthorizeInfo(certifiedInfo.getUserName(), groupName, consumeGroupInfo.getTopicSet(), consumeGroupInfo.getTopicConditions(), rmtAddress, result)) {
            builder.setErrCode(result.getErrCode());
            builder.setErrMsg(result.getErrMsg());
            return builder.build();
        }
        try {
            this.heartbeatManager.updConsumerNode(this.getConsumerKey(groupName, clientId));
        }
        catch (HeartbeatException e) {
            builder.setErrCode(411);
            builder.setErrMsg(strBuff.append("Update consumer node exception:").append(e.getMessage()).toString());
            return builder.build();
        }
        inConsumerInfo.updClientReportInfo(opsTaskInfo.getCsmFromMaxOffsetCtrlId(), clientSyncInfo.getLstAssignedTime(), clientSyncInfo.getTopicMetaInfoId());
        Tuple2<Boolean, Set<Partition>> reportInfo = clientSyncInfo.getRepSubInfo();
        if (((Boolean)reportInfo.getF0()).booleanValue()) {
            Map<String, Map<String, Partition>> curPartSubMap = this.currentSubInfo.get(clientId);
            HashMap<String, Map<String, Partition>> newPartSubMap = new HashMap<String, Map<String, Partition>>();
            for (Partition info : (Set)reportInfo.getF1()) {
                Map partMap = newPartSubMap.computeIfAbsent(info.getTopic(), k -> new HashMap());
                partMap.put(info.getPartitionKey(), info);
            }
            this.printReportInfo(clientId, curPartSubMap, newPartSubMap, strBuff);
            this.currentSubInfo.put(clientId, newPartSubMap);
        }
        Tuple2<Long, Map<Integer, String>> brokerStaticInfo = this.brokerRunManager.getBrokerStaticInfo(overtls);
        builder.setBrokerConfigId(((Long)brokerStaticInfo.getF0()).longValue());
        if (clientSyncInfo.getBrokerConfigId() != ((Long)brokerStaticInfo.getF0()).longValue()) {
            builder.addAllBrokerConfigList(((Map)brokerStaticInfo.getF1()).values());
        }
        Map<String, Map<String, Partition>> curPartMap = this.currentSubInfo.get(clientId);
        if (inConsumerInfo.getLstAssignedTime() >= 0L && curPartMap != null && !curPartMap.isEmpty() && System.currentTimeMillis() - inConsumerInfo.getLstAssignedTime() > this.masterConfig.getMaxMetaForceUpdatePeriodMs()) {
            Tuple2<Long, List<String>> topicMetaInfoTuple = consumeGroupInfo.getTopicMetaInfo();
            builder.setTopicMetaInfoId(((Long)topicMetaInfoTuple.getF0()).longValue());
            if (((Long)topicMetaInfoTuple.getF0()).longValue() != clientSyncInfo.getTopicMetaInfoId()) {
                builder.addAllTopicMetaInfoList((Iterable)topicMetaInfoTuple.getF1());
            }
        }
        builder.setOpsTaskInfo(this.buildOpsTaskInfo(consumeGroupInfo, inConsumerInfo, opsTaskInfo));
        builder.setAuthorizedInfo(this.genAuthorizedInfo(certifiedInfo.getAuthorizedToken(), false));
        builder.setErrCode(200);
        builder.setErrMsg("OK!");
        return builder.build();
    }

    public ClientMaster.GetPartMetaResponseM2C consumerGetPartMetaInfoC2M(ClientMaster.GetPartMetaRequestC2M request, String rmtAddress, boolean overtls) throws Throwable {
        ProcessResult reslut = new ProcessResult();
        StringBuilder strBuff = new StringBuilder(512);
        ClientMaster.GetPartMetaResponseM2C.Builder builder = ClientMaster.GetPartMetaResponseM2C.newBuilder();
        if (!this.serverAuthHandler.identityValidUserInfo(request.getAuthInfo(), false, reslut)) {
            builder.setErrCode(reslut.getErrCode());
            builder.setErrMsg(reslut.getErrMsg());
            return builder.build();
        }
        if (!PBParameterUtils.checkClientId(request.getClientId(), strBuff, reslut)) {
            builder.setErrCode(reslut.getErrCode());
            builder.setErrMsg(reslut.getErrMsg());
            return builder.build();
        }
        String clientId = (String)reslut.getRetData();
        if (!PBParameterUtils.checkGroupName(request.getGroupName(), strBuff, reslut)) {
            builder.setErrCode(reslut.getErrCode());
            builder.setErrMsg(reslut.getErrMsg());
            return builder.build();
        }
        String groupName = (String)reslut.getRetData();
        long brokerConfigId = request.getBrokerConfigId();
        long topicMetaInfoId = request.getTopicMetaInfoId();
        this.checkNodeStatus(clientId, strBuff);
        ConsumeGroupInfo consumeGroupInfo = this.consumerHolder.getConsumeGroupInfo(groupName);
        if (consumeGroupInfo == null) {
            builder.setErrCode(411);
            builder.setErrMsg(strBuff.append("Not found groupName ").append(groupName).append(" in holder!").toString());
            strBuff.delete(0, strBuff.length());
            return builder.build();
        }
        ConsumerInfo inConsumerInfo = consumeGroupInfo.getConsumerInfo(clientId);
        if (inConsumerInfo == null) {
            builder.setErrCode(411);
            builder.setErrMsg(strBuff.append("Not found client ").append(clientId).append(" in group(").append(groupName).append(")").toString());
            strBuff.delete(0, strBuff.length());
            return builder.build();
        }
        try {
            this.heartbeatManager.updConsumerNode(this.getConsumerKey(groupName, clientId));
        }
        catch (HeartbeatException e) {
            builder.setErrCode(411);
            builder.setErrMsg(strBuff.append("Update consumer node exception:").append(e.getMessage()).toString());
            return builder.build();
        }
        Tuple2<Long, List<String>> topicMetaInfoTuple = consumeGroupInfo.getTopicMetaInfo();
        if ((Long)topicMetaInfoTuple.getF0() == -2L) {
            this.freshTopicMetaInfo(consumeGroupInfo, strBuff);
            topicMetaInfoTuple = consumeGroupInfo.getTopicMetaInfo();
        }
        builder.setTopicMetaInfoId(((Long)topicMetaInfoTuple.getF0()).longValue());
        if ((Long)topicMetaInfoTuple.getF0() != topicMetaInfoId) {
            builder.addAllTopicMetaInfoList((Iterable)topicMetaInfoTuple.getF1());
        }
        Tuple2<Long, Map<Integer, String>> brokerStaticInfo = this.brokerRunManager.getBrokerStaticInfo(overtls);
        builder.setBrokerConfigId(((Long)brokerStaticInfo.getF0()).longValue());
        if (brokerConfigId != (Long)brokerStaticInfo.getF0()) {
            builder.addAllBrokerConfigList(((Map)brokerStaticInfo.getF1()).values());
        }
        builder.setErrCode(200);
        builder.setErrMsg("OK!");
        return builder.build();
    }

    private String getConsumerKey(String group, String consumerId) {
        return new StringBuilder(512).append(consumerId).append("@").append(group).toString();
    }

    private Tuple3<Long, Integer, Map<String, String>> getTopicConfigureInfos(String producerId, boolean onlyMsgSize) {
        Tuple3 result = new Tuple3();
        ClusterSettingEntity clusterEntity = this.defMetaDataService.getClusterDefSetting(false);
        result.setF0AndF1((Object)clusterEntity.getSerialId(), (Object)clusterEntity.getMaxMsgSizeInB());
        if (onlyMsgSize) {
            return result;
        }
        ProducerInfo producerInfo = this.producerHolder.getProducerInfo(producerId);
        if (producerInfo == null) {
            return result;
        }
        Set publishedTopicSet = producerInfo.getTopicSet();
        if (publishedTopicSet == null || publishedTopicSet.isEmpty()) {
            return result;
        }
        Map<String, Integer> topicAndSizeMap = this.defMetaDataService.getMaxMsgSizeInBByTopics((Integer)result.getF1(), publishedTopicSet);
        result.setF2(this.brokerRunManager.getPubBrokerAcceptPubPartInfo(topicAndSizeMap));
        return result;
    }

    @Override
    public void run() {
        try {
            if (!this.stopped) {
                this.balancerChore = this.startBalancerChore(this);
                this.initialized = true;
                while (!this.stopped) {
                    this.stopSleeper.sleep();
                }
            }
        }
        catch (Throwable e) {
            this.stopChores();
        }
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    private void balance(TMaster tMaster) {
        StringBuilder strBuffer = new StringBuilder(512);
        long balanceId = this.idGenerator.incrementAndGet();
        if (this.defMetaDataService != null) {
            logger.info(strBuffer.append("[Balance Status] ").append(balanceId).append(", isMaster=").append(this.defMetaDataService.isSelfMaster()).append(", isPrimaryNodeActive=").append(this.defMetaDataService.isPrimaryNodeActive()).toString());
        } else {
            logger.info(strBuffer.append("[Balance Status] ").append(balanceId).append(", BDB service is null isMaster= false, isPrimaryNodeActive=false").toString());
        }
        strBuffer.delete(0, strBuffer.length());
        this.processClientBalanceMetaInfo(balanceId, strBuffer);
        this.processServerBalance(tMaster, balanceId, strBuffer);
    }

    private void processServerBalance(final TMaster tMaster, final long balanceId, StringBuilder sBuffer) {
        int curDoingTasks = this.curSvrBalanceParal.get();
        if (curDoingTasks > 0) {
            logger.info(sBuffer.append("[Svr-Balance Status] ").append(balanceId).append(" the Server-Balance has ").append(curDoingTasks).append(" task(s) in progress!").toString());
            sBuffer.delete(0, sBuffer.length());
            return;
        }
        final boolean isStartBalance = this.startupBalance;
        List<String> groupsNeedToBalance = isStartBalance ? this.consumerHolder.getAllServerBalanceGroups() : this.getNeedToBalanceGroups(sBuffer);
        sBuffer.delete(0, sBuffer.length());
        int balanceTaskCnt = groupsNeedToBalance.size();
        if (balanceTaskCnt > 0) {
            int unitNum = (balanceTaskCnt + this.masterConfig.getRebalanceParallel() - 1) / this.masterConfig.getRebalanceParallel();
            int startIndex = 0;
            int endIndex = 0;
            final long startBalanceTime = System.currentTimeMillis();
            this.curSvrBalanceParal.set(this.masterConfig.getRebalanceParallel());
            for (int i = 0; i < this.masterConfig.getRebalanceParallel(); ++i) {
                startIndex = Math.min(i * unitNum, balanceTaskCnt);
                final List<String> subGroups = groupsNeedToBalance.subList(startIndex, endIndex = Math.min((i + 1) * unitNum, balanceTaskCnt));
                if (subGroups.isEmpty()) {
                    if (this.curSvrBalanceParal.decrementAndGet() != 0) continue;
                    MasterSrvStatsHolder.updSvrBalanceDurations(System.currentTimeMillis() - startBalanceTime);
                    continue;
                }
                this.svrExecutor.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            if (subGroups.isEmpty()) {
                                return;
                            }
                            StringBuilder strBuffer = new StringBuilder(512);
                            try {
                                tMaster.processResetbalance(balanceId, isStartBalance, subGroups, strBuffer);
                            }
                            catch (Throwable e) {
                                logger.warn(new StringBuilder(1024).append("[Svr-Balance Status] Error during reset-reb,").append("the groups that may be affected are ").append(subGroups).append(",error is ").append(e).toString());
                            }
                            if (tMaster.isStopped()) {
                                return;
                            }
                            try {
                                tMaster.processRebalance(balanceId, isStartBalance, subGroups, strBuffer);
                            }
                            catch (Throwable e) {
                                logger.warn(new StringBuilder(1024).append("[Svr-Balance Status] Error during normal-reb,").append("the groups that may be affected are ").append(subGroups).append(",error is ").append(e).toString());
                            }
                        }
                        catch (Throwable e) {
                            logger.warn("[Svr-Balance Status] Error during process", e);
                        }
                        finally {
                            if (TMaster.this.curSvrBalanceParal.decrementAndGet() == 0) {
                                MasterSrvStatsHolder.updSvrBalanceDurations(System.currentTimeMillis() - startBalanceTime);
                            }
                        }
                    }
                });
            }
        }
        this.startupBalance = false;
    }

    private void processClientBalanceMetaInfo(long balanceId, StringBuilder sBuffer) {
        int curDoingTasks = this.curCltBalanceParal.get();
        if (curDoingTasks > 0) {
            logger.info(sBuffer.append("[Clt-Balance Status] ").append(balanceId).append(" the Client-Balance has ").append(curDoingTasks).append(" task(s) in progress!").toString());
            sBuffer.delete(0, sBuffer.length());
            return;
        }
        List<String> clientGroups = this.consumerHolder.getAllClientBalanceGroups();
        if (!clientGroups.isEmpty()) {
            int balanceTaskCnt = clientGroups.size();
            int unitNum = (balanceTaskCnt + this.masterConfig.getRebalanceParallel() - 1) / this.masterConfig.getRebalanceParallel();
            int startIndex = 0;
            int endIndex = 0;
            this.curCltBalanceParal.set(this.masterConfig.getRebalanceParallel());
            for (int i = 0; i < this.masterConfig.getRebalanceParallel(); ++i) {
                startIndex = Math.min(i * unitNum, balanceTaskCnt);
                final List<String> subGroups = clientGroups.subList(startIndex, endIndex = Math.min((i + 1) * unitNum, balanceTaskCnt));
                if (subGroups.isEmpty()) {
                    this.curCltBalanceParal.decrementAndGet();
                    continue;
                }
                this.cltExecutor.execute(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            if (subGroups.isEmpty()) {
                                return;
                            }
                            StringBuilder sBuffer2 = new StringBuilder(512);
                            for (String groupName : subGroups) {
                                ConsumeGroupInfo consumeGroupInfo = TMaster.this.consumerHolder.getConsumeGroupInfo(groupName);
                                if (consumeGroupInfo == null) continue;
                                TMaster.this.freshTopicMetaInfo(consumeGroupInfo, sBuffer2);
                            }
                        }
                        catch (Throwable e) {
                            logger.warn("[Clt-Balance Status] Error during process", e);
                        }
                        finally {
                            TMaster.this.curCltBalanceParal.decrementAndGet();
                        }
                    }
                });
            }
        }
    }

    public void freshTopicMetaInfo(ConsumeGroupInfo consumeGroupInfo, StringBuilder sBuffer) {
        Map<String, String> topicMetaInfoMap = this.getTopicConfigInfo(consumeGroupInfo, sBuffer);
        consumeGroupInfo.updCsmTopicMetaInfo(topicMetaInfoMap);
    }

    private Map<String, String> getTopicConfigInfo(ConsumeGroupInfo groupInfo, StringBuilder sBuffer) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (groupInfo.getTopicSet() == null || groupInfo.getTopicSet().isEmpty()) {
            return result;
        }
        Map<String, List<TopicDeployEntity>> topicDeployInfoMap = this.defMetaDataService.getTopicConfMapByTopicAndBrokerIds(groupInfo.getTopicSet(), null);
        if (topicDeployInfoMap == null || topicDeployInfoMap.isEmpty()) {
            return result;
        }
        int count = 0;
        int statusId = 0;
        Tuple2 topicSubInfo = new Tuple2();
        Set<String> fbdTopicSet = this.defMetaDataService.getDisableTopicByGroupName(groupInfo.getGroupName());
        for (Map.Entry<String, List<TopicDeployEntity>> entry : topicDeployInfoMap.entrySet()) {
            if (entry == null) continue;
            count = 0;
            for (TopicDeployEntity deployInfo : entry.getValue()) {
                statusId = 0;
                this.brokerRunManager.getSubBrokerTopicInfo(deployInfo.getBrokerId(), deployInfo.getTopicName(), (Tuple2<Boolean, TopicInfo>)topicSubInfo);
                if (((Boolean)topicSubInfo.getF0()).booleanValue() && topicSubInfo.getF1() != null && ((TopicInfo)topicSubInfo.getF1()).isAcceptSubscribe() && !fbdTopicSet.contains(deployInfo.getTopicName())) {
                    statusId = 1;
                }
                if (count++ == 0) {
                    sBuffer.append(entry.getKey()).append("#");
                } else {
                    sBuffer.append(",");
                }
                sBuffer.append(deployInfo.getBrokerId()).append(":").append(deployInfo.getNumTopicStores()).append(":").append(deployInfo.getNumPartitions()).append(":").append(statusId);
            }
            if (count > 0) {
                result.put(entry.getKey(), sBuffer.toString());
            }
            sBuffer.delete(0, sBuffer.length());
        }
        return result;
    }

    public void processRebalance(long rebalanceId, boolean isFirstReb, List<String> groups, StringBuilder strBuffer) {
        Map<String, Map<String, List<Partition>>> finalSubInfoMap = isFirstReb ? this.loadBalancer.bukAssign(this.consumerHolder, this.brokerRunManager, groups, this.defMetaDataService, strBuffer) : this.loadBalancer.balanceCluster(this.currentSubInfo, this.consumerHolder, this.brokerRunManager, groups, this.defMetaDataService, strBuffer);
        for (Map.Entry<String, Map<String, List<Partition>>> entry : finalSubInfoMap.entrySet()) {
            ConsumerInfo consumerInfo;
            String consumerId;
            if (entry == null || (consumerId = entry.getKey()) == null || (consumerInfo = this.consumerHolder.getConsumerInfo(consumerId)) == null) continue;
            ArrayList<SubscribeInfo> addedSubInfoList = new ArrayList<SubscribeInfo>();
            ArrayList<SubscribeInfo> deletedSubInfoList = new ArrayList<SubscribeInfo>();
            Set<String> blackTopicSet = this.defMetaDataService.getDisableTopicByGroupName(consumerInfo.getGroupName());
            for (Map.Entry<String, List<Partition>> topicEntry : entry.getValue().entrySet()) {
                Map<Object, Object> currentPartMap;
                if (topicEntry == null) continue;
                Map<String, Map<String, Partition>> curTopicSubInfoMap = this.currentSubInfo.get(consumerId);
                if (curTopicSubInfoMap == null || curTopicSubInfoMap.get(topicEntry.getKey()) == null) {
                    currentPartMap = new HashMap();
                } else {
                    currentPartMap = curTopicSubInfoMap.get(topicEntry.getKey());
                    if (currentPartMap == null) {
                        currentPartMap = new HashMap();
                    }
                }
                for (Partition currentPart : currentPartMap.values()) {
                    boolean included = false;
                    if (!blackTopicSet.contains(currentPart.getTopic())) {
                        for (Partition newPart : topicEntry.getValue()) {
                            if (newPart == null || !newPart.getPartitionKey().equals(currentPart.getPartitionKey())) continue;
                            included = true;
                            break;
                        }
                    }
                    if (included) continue;
                    deletedSubInfoList.add(new SubscribeInfo(consumerId, consumerInfo.getGroupName(), consumerInfo.isOverTLS(), currentPart));
                }
                for (Partition finalPart : topicEntry.getValue()) {
                    if (currentPartMap.get(finalPart.getPartitionKey()) != null || blackTopicSet.contains(finalPart.getTopic())) continue;
                    addedSubInfoList.add(new SubscribeInfo(consumerId, consumerInfo.getGroupName(), consumerInfo.isOverTLS(), finalPart));
                }
            }
            boolean isDelEmpty = deletedSubInfoList.isEmpty();
            boolean isAddEmtpy = addedSubInfoList.isEmpty();
            if (!isDelEmpty) {
                this.consumerEventManager.addDisconnectEvent(consumerId, new ConsumerEvent(rebalanceId, !isAddEmtpy ? EventType.DISCONNECT : EventType.ONLY_DISCONNECT, deletedSubInfoList, EventStatus.TODO));
                this.printTODOContent(rebalanceId, consumerId, "Disconnect", deletedSubInfoList, strBuffer);
            }
            if (isAddEmtpy) continue;
            this.consumerEventManager.addConnectEvent(consumerId, new ConsumerEvent(rebalanceId, !isDelEmpty ? EventType.CONNECT : EventType.ONLY_CONNECT, addedSubInfoList, EventStatus.TODO));
            this.printTODOContent(rebalanceId, consumerId, "Connect", addedSubInfoList, strBuffer);
        }
    }

    public void processResetbalance(long rebalanceId, boolean isFirstReb, List<String> groups, StringBuilder strBuffer) {
        Map<String, Map<String, Map<String, Partition>>> finalSubInfoMap = isFirstReb ? this.loadBalancer.resetBukAssign(this.consumerHolder, this.brokerRunManager, groups, this.defMetaDataService, strBuffer) : this.loadBalancer.resetBalanceCluster(this.currentSubInfo, this.consumerHolder, this.brokerRunManager, groups, this.defMetaDataService, strBuffer);
        for (Map.Entry<String, Map<String, Map<String, Partition>>> entry : finalSubInfoMap.entrySet()) {
            ConsumerInfo consumerInfo;
            String consumerId;
            if (entry == null || (consumerId = entry.getKey()) == null || (consumerInfo = this.consumerHolder.getConsumerInfo(consumerId)) == null) continue;
            ArrayList<SubscribeInfo> addedSubInfoList = new ArrayList<SubscribeInfo>();
            ArrayList<SubscribeInfo> deletedSubInfoList = new ArrayList<SubscribeInfo>();
            Set<String> blackTopicSet = this.defMetaDataService.getDisableTopicByGroupName(consumerInfo.getGroupName());
            for (Map.Entry<String, Map<String, Partition>> topicEntry : entry.getValue().entrySet()) {
                Map<Object, Object> currentPartMap;
                if (topicEntry == null) continue;
                Map<String, Map<String, Partition>> curTopicSubInfoMap = this.currentSubInfo.get(consumerId);
                if (curTopicSubInfoMap == null || curTopicSubInfoMap.get(topicEntry.getKey()) == null) {
                    currentPartMap = new HashMap();
                } else {
                    currentPartMap = curTopicSubInfoMap.get(topicEntry.getKey());
                    if (currentPartMap == null) {
                        currentPartMap = new HashMap();
                    }
                }
                Map<String, Partition> finalPartMap = topicEntry.getValue();
                for (Partition currentPart : currentPartMap.values()) {
                    if (!blackTopicSet.contains(currentPart.getTopic()) && finalPartMap.get(currentPart.getPartitionKey()) != null) continue;
                    deletedSubInfoList.add(new SubscribeInfo(consumerId, consumerInfo.getGroupName(), consumerInfo.isOverTLS(), currentPart));
                }
                for (Partition finalPart : finalPartMap.values()) {
                    if (currentPartMap.get(finalPart.getPartitionKey()) != null || blackTopicSet.contains(finalPart.getTopic())) continue;
                    addedSubInfoList.add(new SubscribeInfo(consumerId, consumerInfo.getGroupName(), consumerInfo.isOverTLS(), finalPart));
                }
            }
            boolean isDelEmpty = deletedSubInfoList.isEmpty();
            boolean isAddEmtpy = addedSubInfoList.isEmpty();
            if (!isDelEmpty) {
                this.consumerEventManager.addDisconnectEvent(consumerId, new ConsumerEvent(rebalanceId, !isAddEmtpy ? EventType.DISCONNECT : EventType.ONLY_DISCONNECT, deletedSubInfoList, EventStatus.TODO));
                this.printTODOContent(rebalanceId, consumerId, "ResetDisconnect", deletedSubInfoList, strBuffer);
            }
            if (isAddEmtpy) continue;
            this.consumerEventManager.addConnectEvent(consumerId, new ConsumerEvent(rebalanceId, !isDelEmpty ? EventType.CONNECT : EventType.ONLY_CONNECT, addedSubInfoList, EventStatus.TODO));
            this.printTODOContent(rebalanceId, consumerId, "ResetConnect", addedSubInfoList, strBuffer);
        }
    }

    private void printTODOContent(long rebalanceId, String consumerId, String opType, List<SubscribeInfo> subInfoList, StringBuilder strBuffer) {
        int recordCnt = 0;
        strBuffer.append("[").append(opType).append("] TODO, rebalanceId=").append(rebalanceId).append(", client=").append(consumerId).append(", partitions=[");
        for (SubscribeInfo info : subInfoList) {
            if (info == null) continue;
            if (recordCnt++ > 0) {
                strBuffer.append(",");
            }
            strBuffer.append(info.getPartitionStr());
        }
        strBuffer.append("]");
        logger.info(strBuffer.toString());
        strBuffer.delete(0, strBuffer.length());
    }

    private boolean checkIfConsist(Map<String, Map<String, Partition>> masterSubInfoMap, List<SubscribeInfo> consumerSubInfoList) {
        int masterInfoSize = 0;
        for (Map.Entry<String, Map<String, Partition>> entry : masterSubInfoMap.entrySet()) {
            masterInfoSize += entry.getValue().size();
        }
        if (masterInfoSize != consumerSubInfoList.size()) {
            return false;
        }
        for (SubscribeInfo info : consumerSubInfoList) {
            Map<String, Partition> masterInfoMap = masterSubInfoMap.get(info.getTopic());
            if (masterInfoMap == null || masterInfoMap.isEmpty()) {
                return false;
            }
            if (masterInfoMap.get(info.getPartition().getPartitionKey()) != null) continue;
            return false;
        }
        return true;
    }

    private ClientMaster.MasterBrokerAuthorizedInfo.Builder genBrokerAuthorizedInfo(String authAuthorizedToken) {
        ClientMaster.MasterBrokerAuthorizedInfo.Builder authorizedBuilder = ClientMaster.MasterBrokerAuthorizedInfo.newBuilder();
        authorizedBuilder.setVisitAuthorizedToken(this.visitTokenManager.getBrokerVisitTokens());
        if (TStringUtils.isNotBlank((String)authAuthorizedToken)) {
            authorizedBuilder.setAuthAuthorizedToken(authAuthorizedToken);
        }
        return authorizedBuilder;
    }

    private ClientMaster.MasterAuthorizedInfo.Builder genAuthorizedInfo(String authAuthorizedToken, boolean isBroker) {
        ClientMaster.MasterAuthorizedInfo.Builder authorizedBuilder = ClientMaster.MasterAuthorizedInfo.newBuilder();
        if (isBroker) {
            authorizedBuilder.setVisitAuthorizedToken(this.visitTokenManager.getFreshVisitToken());
        } else {
            authorizedBuilder.setVisitAuthorizedToken(this.visitTokenManager.getCurVisitToken());
        }
        if (TStringUtils.isNotBlank((String)authAuthorizedToken)) {
            authorizedBuilder.setAuthAuthorizedToken(authAuthorizedToken);
        }
        return authorizedBuilder;
    }

    private List<String> getNeedToBalanceGroups(StringBuilder strBuffer) {
        ArrayList<String> groupsNeedToBalance = new ArrayList<String>();
        HashSet<String> groupHasUnfinishedEvent = new HashSet<String>();
        if (this.consumerEventManager.hasEvent()) {
            Set<String> consumerIdSet = this.consumerEventManager.getUnProcessedIdSet();
            ConcurrentHashMap<String, TimeoutInfo> heartbeatMap = this.heartbeatManager.getConsumerRegMap();
            for (String consumerId : consumerIdSet) {
                String group;
                if (consumerId == null || (group = this.consumerHolder.getGroupName(consumerId)) == null || heartbeatMap.get(this.getConsumerKey(group, consumerId)) == null) continue;
                if (this.consumerEventManager.getUnfinishedCount(group) >= 10) {
                    this.consumerEventManager.removeAll(consumerId);
                    logger.info(strBuffer.append("Unfinished event for group :").append(group).append(" exceed max balanceDelayTime=").append(10).append(", clear consumer: ").append(consumerId).append(" unProcessed events.").toString());
                    strBuffer.delete(0, strBuffer.length());
                    continue;
                }
                groupHasUnfinishedEvent.add(group);
            }
        }
        this.consumerEventManager.updateUnfinishedCountMap(groupHasUnfinishedEvent);
        List<String> allGroups = this.consumerHolder.getAllServerBalanceGroups();
        if (groupHasUnfinishedEvent.isEmpty()) {
            for (String group : allGroups) {
                if (group == null) continue;
                groupsNeedToBalance.add(group);
            }
        } else {
            for (String group : allGroups) {
                if (group == null || groupHasUnfinishedEvent.contains(group)) continue;
                groupsNeedToBalance.add(group);
            }
        }
        return groupsNeedToBalance;
    }

    private void stopChores() {
        if (this.balancerChore != null) {
            this.balancerChore.interrupt();
        }
    }

    private ClientMaster.ApprovedClientConfig.Builder buildApprovedClientConfig(ClientMaster.ApprovedClientConfig inClientConfig, Tuple3<Long, Integer, Map<String, String>> prodConfigTuple) {
        ClientMaster.ApprovedClientConfig.Builder outClientConfig = null;
        if (inClientConfig == null) {
            return outClientConfig;
        }
        outClientConfig = ClientMaster.ApprovedClientConfig.newBuilder();
        outClientConfig.setConfigId(((Long)prodConfigTuple.getF0()).longValue());
        if (inClientConfig.getConfigId() != ((Long)prodConfigTuple.getF0()).longValue()) {
            outClientConfig.setMaxMsgSize(((Integer)prodConfigTuple.getF1()).intValue());
        }
        return outClientConfig;
    }

    private ClientMaster.OpsTaskInfo.Builder buildOpsTaskInfo(ConsumeGroupInfo groupInfo, ConsumerInfo nodeInfo, OpsSyncInfo opsTaskInfo) {
        ClientMaster.OpsTaskInfo.Builder builder = ClientMaster.OpsTaskInfo.newBuilder();
        long csmFromMaxCtrlId = groupInfo.getCsmFromMaxCtrlId();
        if (csmFromMaxCtrlId != -2L && nodeInfo.getCsmFromMaxOffsetCtrlId() != csmFromMaxCtrlId) {
            builder.setCsmFrmMaxOffsetCtrlId(csmFromMaxCtrlId);
        }
        ClusterSettingEntity defSetting = this.defMetaDataService.getClusterDefSetting(false);
        GroupResCtrlEntity groupResCtrlConf = this.defMetaDataService.getGroupCtrlConf(nodeInfo.getGroupName());
        if (defSetting.enableFlowCtrl()) {
            builder.setDefFlowCheckId(defSetting.getSerialId());
            if (opsTaskInfo.getDefFlowChkId() != defSetting.getSerialId()) {
                builder.setDefFlowControlInfo(defSetting.getGloFlowCtrlRuleInfo());
            }
        }
        if (groupResCtrlConf != null && groupResCtrlConf.isFlowCtrlEnable()) {
            builder.setGroupFlowCheckId(groupResCtrlConf.getSerialId());
            builder.setQryPriorityId(groupResCtrlConf.getQryPriorityId());
            if (opsTaskInfo.getGroupFlowChkId() != groupResCtrlConf.getSerialId()) {
                builder.setGroupFlowControlInfo(groupResCtrlConf.getFlowCtrlInfo());
            }
        }
        return builder;
    }

    private void printReportInfo(String consumerId, Map<String, Map<String, Partition>> curPartSubMa, Map<String, Map<String, Partition>> newPartSubMap, StringBuilder sBuffer) {
        boolean printHeader = true;
        if (curPartSubMa == null || curPartSubMa.isEmpty()) {
            if (newPartSubMap != null && !newPartSubMap.isEmpty()) {
                for (Map<String, Partition> newPartMap : newPartSubMap.values()) {
                    if (newPartMap == null || newPartMap.isEmpty()) continue;
                    for (Partition info : newPartMap.values()) {
                        printHeader = this.printReportItemInfo(consumerId, info, true, printHeader, sBuffer);
                    }
                }
            }
        } else if (newPartSubMap == null || newPartSubMap.isEmpty()) {
            for (Map<String, Partition> curPartMap : curPartSubMa.values()) {
                if (curPartMap == null || curPartMap.isEmpty()) continue;
                for (Partition info : curPartMap.values()) {
                    printHeader = this.printReportItemInfo(consumerId, info, false, printHeader, sBuffer);
                }
            }
        } else {
            Map<String, Partition> newPartMap;
            for (Map.Entry<String, Map<String, Partition>> curEntry : curPartSubMa.entrySet()) {
                Map<String, Partition> curPartMap;
                if (curEntry == null || curEntry.getKey() == null) continue;
                newPartMap = newPartSubMap.get(curEntry.getKey());
                if (newPartMap == null || newPartMap.isEmpty()) {
                    curPartMap = curEntry.getValue();
                    if (curPartMap == null || curPartMap.isEmpty()) continue;
                    for (Partition partition : curPartMap.values()) {
                        printHeader = this.printReportItemInfo(consumerId, partition, false, printHeader, sBuffer);
                    }
                    continue;
                }
                curPartMap = curEntry.getValue();
                if (curPartMap == null || curPartMap.isEmpty()) {
                    for (Partition partition : newPartMap.values()) {
                        printHeader = this.printReportItemInfo(consumerId, partition, true, printHeader, sBuffer);
                    }
                    continue;
                }
                for (Map.Entry entry : curPartMap.entrySet()) {
                    if (entry == null || entry.getKey() == null || entry.getValue() == null || newPartMap.get(entry.getKey()) != null) continue;
                    printHeader = this.printReportItemInfo(consumerId, (Partition)entry.getValue(), false, printHeader, sBuffer);
                }
                for (Map.Entry entry : newPartMap.entrySet()) {
                    if (entry == null || entry.getKey() == null || entry.getValue() == null || curPartMap.get(entry.getKey()) != null) continue;
                    printHeader = this.printReportItemInfo(consumerId, (Partition)entry.getValue(), true, printHeader, sBuffer);
                }
            }
            for (Map.Entry<String, Map<String, Partition>> newEntry : newPartSubMap.entrySet()) {
                if (newEntry == null || newEntry.getKey() == null || curPartSubMa.get(newEntry.getKey()) != null || (newPartMap = newEntry.getValue()) == null || newPartMap.isEmpty()) continue;
                for (Partition info : newPartMap.values()) {
                    printHeader = this.printReportItemInfo(consumerId, info, true, printHeader, sBuffer);
                }
            }
        }
        if (sBuffer.length() > 0) {
            logger.info(sBuffer.append("]").toString());
        }
        sBuffer.delete(0, sBuffer.length());
    }

    private boolean printReportItemInfo(String consumerId, Partition info, boolean isAdd, boolean printHeader, StringBuilder sBuffer) {
        String type;
        if (info == null) {
            return printHeader;
        }
        String string = type = isAdd ? "[added]" : "[deleted]";
        if (printHeader) {
            sBuffer.append("[SubInfo Report] client ").append(consumerId).append(" report the info: [");
            printHeader = false;
        }
        sBuffer.append(type).append(info).append(", ");
        return printHeader;
    }

    private ClientMaster.ClusterConfig.Builder buildClusterConfig(ClientMaster.ClusterConfig inClusterConfig) {
        ClientMaster.ClusterConfig.Builder outClsConfig = null;
        if (inClusterConfig != null) {
            outClsConfig = ClientMaster.ClusterConfig.newBuilder();
            ClusterSettingEntity settingEntity = this.defMetaDataService.getClusterDefSetting(false);
            if (settingEntity == null) {
                outClsConfig.setConfigId(-2L);
            } else {
                outClsConfig.setConfigId(settingEntity.getSerialId());
                if (settingEntity.getSerialId() != inClusterConfig.getConfigId()) {
                    outClsConfig.setMaxMsgSize(settingEntity.getMaxMsgSizeInB());
                }
            }
        }
        return outClsConfig;
    }

    private Thread startBalancerChore(final TMaster master) {
        Chore chore = new Chore("BalancerChore", this.masterConfig.getConsumerBalancePeriodMs(), master){

            @Override
            protected void chore() {
                try {
                    master.balance(master);
                }
                catch (Throwable e) {
                    logger.warn("Rebalance throwable error: ", e);
                }
            }
        };
        return ThreadUtils.setDaemonThreadRunning((Thread)chore.getThread());
    }

    public void stop() {
        this.stop("");
    }

    @Override
    public void stop(String why) {
        logger.info(why);
        this.stopped = true;
        try {
            this.webServer.stop();
            this.rpcServiceFactory.destroy();
            this.svrExecutor.shutdown();
            this.cltExecutor.shutdown();
            this.stopChores();
            this.heartbeatManager.stop();
            this.defMetaDataService.stop();
            this.visitTokenManager.stop();
            if (!this.shutdownHooked.get()) {
                Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
            }
        }
        catch (Exception e) {
            logger.error("Stop master error!", (Throwable)e);
        }
    }

    @Override
    public boolean isStopped() {
        return this.stopped;
    }

    public ConcurrentHashMap<String, Map<String, Map<String, Partition>>> getCurrentSubInfoMap() {
        return this.currentSubInfo;
    }

    public TopicPSInfoManager getTopicPSInfoManager() {
        return this.topicPSInfoManager;
    }

    public BrokerAbnHolder getBrokerAbnHolder() {
        return this.brokerRunManager.getBrokerAbnHolder();
    }

    public ProducerInfoHolder getProducerHolder() {
        return this.producerHolder;
    }

    public ConsumerInfoHolder getConsumerHolder() {
        return this.consumerHolder;
    }

    private void chkAndCreateBdbMetaDataPath() throws Exception {
        String bdbEnvPath = this.masterConfig.getMetaDataPath();
        File dir = new File(bdbEnvPath);
        if (!dir.exists() && !dir.mkdirs()) {
            throw new Exception(new StringBuilder(256).append("Could not make bdb data directory ").append(dir.getAbsolutePath()).toString());
        }
        if (!dir.isDirectory() || !dir.canRead()) {
            throw new Exception(new StringBuilder(256).append("bdb data path ").append(dir.getAbsolutePath()).append(" is not a readable directory").toString());
        }
    }

    private void checkNodeStatus(String clientId, StringBuilder strBuffer) throws Exception {
        if (!this.defMetaDataService.isSelfMaster()) {
            throw new StandbyException(strBuffer.append(this.masterAddInfo.getHostPortStr()).append(" is not master now. the connecting client id is ").append(clientId).toString());
        }
    }

    private final class ShutdownHook
    extends Thread {
        private ShutdownHook() {
        }

        @Override
        public void run() {
            if (TMaster.this.shutdownHooked.compareAndSet(false, true)) {
                TMaster.this.stop("TMaster shutdown hooked.");
            }
        }
    }

    private class ReleaseProducer
    extends AbstractReleaseRunner {
        private ReleaseProducer() {
        }

        @Override
        void run(String clientId, boolean isTimeout) {
            ProducerInfo info;
            if (clientId != null && (info = TMaster.this.producerHolder.removeProducer(clientId, isTimeout)) != null) {
                TMaster.this.topicPSInfoManager.rmvProducerTopicPubInfo(clientId, info.getTopicSet());
            }
        }
    }

    private class ReleaseConsumer
    extends AbstractReleaseRunner {
        private ReleaseConsumer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void run(String arg, boolean isTimeout) {
            String[] nodeStrs = arg.split("@");
            String consumerId = nodeStrs[0];
            String group = nodeStrs[1];
            Integer lid = null;
            try {
                lid = TMaster.this.masterRowLock.getLock(null, StringUtils.getBytesUtf8((String)consumerId), true);
                ConsumerInfo info = TMaster.this.consumerHolder.removeConsumer(group, consumerId, isTimeout);
                TMaster.this.currentSubInfo.remove(consumerId);
                TMaster.this.consumerEventManager.removeAll(consumerId);
                if (info != null && TMaster.this.consumerHolder.isConsumeGroupEmpty(group)) {
                    TMaster.this.topicPSInfoManager.rmvGroupSubTopicInfo(group, info.getTopicSet());
                }
            }
            catch (IOException e) {
                logger.warn("Failed to lock.", (Throwable)e);
            }
            finally {
                if (lid != null) {
                    TMaster.this.masterRowLock.releaseRowLock(lid);
                }
            }
        }
    }

    private static abstract class AbstractReleaseRunner {
        private AbstractReleaseRunner() {
        }

        abstract void run(String var1, boolean var2);
    }
}

