/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.common.utils;

import java.io.IOException;
import java.util.HashMap;

public class WritableComparator {
    private static HashMap<Class, WritableComparator> comparators = new HashMap();

    public static int hashBytes(byte[] bytes, int offset, int length) {
        int hash = 1;
        for (int i = offset; i < offset + length; ++i) {
            hash = 31 * hash + bytes[i];
        }
        return hash;
    }

    public static int hashBytes(byte[] bytes, int length) {
        return WritableComparator.hashBytes(bytes, 0, length);
    }

    public static int readUnsignedShort(byte[] bytes, int start) {
        return ((bytes[start] & 0xFF) << 8) + (bytes[start + 1] & 0xFF);
    }

    public static int readInt(byte[] bytes, int start) {
        return ((bytes[start] & 0xFF) << 24) + ((bytes[start + 1] & 0xFF) << 16) + ((bytes[start + 2] & 0xFF) << 8) + (bytes[start + 3] & 0xFF);
    }

    public static float readFloat(byte[] bytes, int start) {
        return Float.intBitsToFloat(WritableComparator.readInt(bytes, start));
    }

    public static long readLong(byte[] bytes, int start) {
        return ((long)WritableComparator.readInt(bytes, start) << 32) + (long)WritableComparator.readInt(bytes, start + 4) & 0xFFFFFFFFFFFFFFFFL;
    }

    public static double readDouble(byte[] bytes, int start) {
        return Double.longBitsToDouble(WritableComparator.readLong(bytes, start));
    }

    public static long readVLong(byte[] bytes, int start) throws IOException {
        int len = bytes[start];
        if (len >= -112) {
            return len;
        }
        boolean isNegative = len < -120;
        int n = len = isNegative ? -(len + 120) : -(len + 112);
        if (start + 1 + len > bytes.length) {
            throw new IOException("Not enough number of bytes for a zero-compressed integer");
        }
        long i = 0L;
        for (int idx = 0; idx < len; ++idx) {
            i <<= 8;
            i |= (long)(bytes[start + 1 + idx] & 0xFF);
        }
        return isNegative ? i ^ 0xFFFFFFFFFFFFFFFFL : i;
    }

    public static int readVInt(byte[] bytes, int start) throws IOException {
        return (int)WritableComparator.readVLong(bytes, start);
    }
}

