/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.common.aaaserver;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.inlong.tubemq.corebase.protobuf.generated.ClientBroker;
import org.apache.inlong.tubemq.corebase.protobuf.generated.ClientMaster;
import org.apache.inlong.tubemq.corebase.rv.ProcessResult;
import org.apache.inlong.tubemq.corebase.utils.TStringUtils;
import org.apache.inlong.tubemq.server.broker.TubeBroker;
import org.apache.inlong.tubemq.server.common.aaaserver.CertificateBrokerHandler;
import org.apache.inlong.tubemq.server.common.aaaserver.CertifiedInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleCertificateBrokerHandler
implements CertificateBrokerHandler {
    private static final Logger logger = LoggerFactory.getLogger(SimpleCertificateBrokerHandler.class);
    private static final int MAX_VISIT_TOKEN_SIZE = 6;
    private long inValidTokenCheckTimeMs = 120000L;
    private final TubeBroker tubeBroker;
    private final AtomicReference<List<Long>> visitTokenList = new AtomicReference();
    private String lastUpdatedVisitTokens = "";
    private boolean enableVisitTokenCheck = false;
    private boolean enableProduceAuthenticate = false;
    private boolean enableProduceAuthorize = false;
    private boolean enableConsumeAuthenticate = false;
    private boolean enableConsumeAuthorize = false;

    public SimpleCertificateBrokerHandler(TubeBroker tubeBroker) {
        this.tubeBroker = tubeBroker;
        this.visitTokenList.set(new ArrayList());
        this.inValidTokenCheckTimeMs = tubeBroker.getTubeConfig().getVisitTokenCheckInValidTimeMs();
    }

    @Override
    public void configure(ClientMaster.EnableBrokerFunInfo enableFunInfo) {
        if (enableFunInfo != null) {
            if (enableFunInfo.hasEnableVisitTokenCheck()) {
                this.enableVisitTokenCheck = enableFunInfo.getEnableVisitTokenCheck();
            }
            this.enableProduceAuthenticate = enableFunInfo.getEnableProduceAuthenticate();
            this.enableProduceAuthorize = enableFunInfo.getEnableProduceAuthorize();
            this.enableConsumeAuthenticate = enableFunInfo.getEnableConsumeAuthenticate();
            this.enableConsumeAuthorize = enableFunInfo.getEnableConsumeAuthorize();
        }
    }

    @Override
    public void appendVisitToken(ClientMaster.MasterBrokerAuthorizedInfo authorizedInfo) {
        String[] visitTokenItems;
        if (authorizedInfo == null) {
            return;
        }
        String curBrokerVisitTokens = authorizedInfo.getVisitAuthorizedToken();
        if (TStringUtils.isBlank((String)curBrokerVisitTokens) || this.lastUpdatedVisitTokens.equals(curBrokerVisitTokens)) {
            return;
        }
        this.lastUpdatedVisitTokens = curBrokerVisitTokens;
        block2: for (String visitTokenItem : visitTokenItems = curBrokerVisitTokens.split(",")) {
            if (TStringUtils.isBlank((String)visitTokenItem)) continue;
            try {
                long curVisitToken = Long.parseLong(visitTokenItem.trim());
                List<Long> currList = this.visitTokenList.get();
                if (currList.contains(curVisitToken)) continue;
                while (!(currList = this.visitTokenList.get()).contains(curVisitToken)) {
                    ArrayList<Long> updateList = new ArrayList<Long>(currList);
                    while (updateList.size() >= 6) {
                        updateList.remove(0);
                    }
                    updateList.add(curVisitToken);
                    if (!this.visitTokenList.compareAndSet(currList, updateList)) continue;
                    continue block2;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean identityValidUserInfo(ClientBroker.AuthorizedInfo authorizedInfo, boolean isProduce, ProcessResult result) {
        if (authorizedInfo == null) {
            result.setFailResult(415, "Authorized Info is required!");
            return result.isSuccess();
        }
        if (this.enableVisitTokenCheck) {
            long curVisitToken = authorizedInfo.getVisitAuthorizedToken();
            List<Long> currList = this.visitTokenList.get();
            if (this.tubeBroker.isKeepAlive() && !currList.contains(curVisitToken) && System.currentTimeMillis() - this.tubeBroker.getLastRegTime() > this.inValidTokenCheckTimeMs) {
                result.setFailResult(415, "Visit Authorized Token is invalid!");
                return result.isSuccess();
            }
        }
        if (isProduce && !this.enableProduceAuthenticate || !isProduce && !this.enableConsumeAuthenticate) {
            result.setSuccResult((Object)new CertifiedInfo());
            return result.isSuccess();
        }
        if (TStringUtils.isBlank((String)authorizedInfo.getAuthAuthorizedToken())) {
            result.setFailResult(415, "authAuthorizedToken is Blank!");
            return result.isSuccess();
        }
        result.setSuccResult((Object)new CertifiedInfo());
        return result.isSuccess();
    }

    @Override
    public boolean validConsumeAuthorizeInfo(String userName, String groupName, String topicName, Set<String> msgTypeLst, boolean isRegister, String clientIp, ProcessResult result) {
        if (!this.enableConsumeAuthorize) {
            result.setSuccResult((Object)new CertifiedInfo());
            return result.isSuccess();
        }
        result.setSuccResult((Object)new CertifiedInfo());
        return result.isSuccess();
    }

    @Override
    public boolean validProduceAuthorizeInfo(String userName, String topicName, String msgType, String clientIp, ProcessResult result) {
        if (!this.enableProduceAuthorize) {
            result.setSuccResult((Object)new CertifiedInfo());
            return result.isSuccess();
        }
        result.setSuccResult((Object)new CertifiedInfo());
        return result.isSuccess();
    }

    @Override
    public boolean isEnableProduceAuthenticate() {
        return this.enableProduceAuthenticate;
    }

    @Override
    public boolean isEnableProduceAuthorize() {
        return this.enableProduceAuthorize;
    }

    @Override
    public boolean isEnableConsumeAuthenticate() {
        return this.enableConsumeAuthenticate;
    }

    @Override
    public boolean isEnableConsumeAuthorize() {
        return this.enableConsumeAuthorize;
    }

    @Override
    public boolean isEnableVisitTokenCheck() {
        return this.enableVisitTokenCheck;
    }
}

