/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.broker.web;

import java.io.IOException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.inlong.tubemq.server.broker.TubeBroker;
import org.apache.inlong.tubemq.server.common.webbase.WebCallStatsHolder;
import org.apache.inlong.tubemq.server.common.webbase.WebMethodMapper;

public abstract class AbstractWebHandler
extends HttpServlet {
    protected final TubeBroker broker;

    public AbstractWebHandler(TubeBroker broker) {
        this.broker = broker;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.doPost(req, resp);
    }

    public int getSupportedMethod(StringBuilder sBuffer) {
        return WebMethodMapper.getRegisteredWebMethod(sBuffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String method = null;
        StringBuilder sBuffer = new StringBuilder(1024);
        long startTime = System.currentTimeMillis();
        try {
            method = req.getParameter("method");
            if (method == null) {
                sBuffer.append("{\"result\":false,\"errCode\":400,\"errMsg\":\"").append("Please take with method parameter! \"}");
            } else {
                WebMethodMapper.WebApiRegInfo webApiRegInfo = WebMethodMapper.getWebApiRegInfo(method);
                if (webApiRegInfo == null) {
                    sBuffer.append("{\"result\":false,\"errCode\":400,\"errMsg\":\"").append("Unsupported method ").append(method).append("\"}");
                } else {
                    webApiRegInfo.method.invoke(webApiRegInfo.webHandler, req, sBuffer);
                }
            }
        }
        catch (Throwable e) {
            sBuffer.append("{\"result\":false,\"errCode\":400,\"errMsg\":\"").append("Bad request from server: ").append(e.getMessage()).append("\"}");
        }
        finally {
            WebCallStatsHolder.addMethodCall(method, System.currentTimeMillis() - startTime);
        }
        resp.getWriter().write(sBuffer.toString());
        resp.setCharacterEncoding(req.getCharacterEncoding());
        resp.setStatus(200);
        resp.flushBuffer();
    }

    public abstract void registerWebApiMethod();

    protected void innRegisterWebMethod(String webMethodName, String clsMethodName, boolean needAuthToken) {
        WebMethodMapper.registerWebMethod(webMethodName, clsMethodName, false, needAuthToken, (Object)this);
    }
}

