/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.file;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.security.Security;

final class SecurityActions {
    SecurityActions() {
    }

    static <T> T doPrivileged(PrivilegedAction<T> action) {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(action);
        }
        return Security.doPrivileged(action);
    }

    static boolean fileExists(File file) {
        return SecurityActions.doPrivileged(file::exists);
    }

    static FileChannel openFileChannel(File file) throws FileNotFoundException {
        PrivilegedExceptionAction<FileChannel> action = () -> new RandomAccessFile(file, "rw").getChannel();
        try {
            if (System.getSecurityManager() != null) {
                return AccessController.doPrivileged(action);
            }
            return Security.doPrivileged(action);
        }
        catch (PrivilegedActionException e) {
            if (e.getCause() instanceof FileNotFoundException) {
                throw (FileNotFoundException)e.getCause();
            }
            throw new CacheConfigurationException((Exception)e);
        }
    }

    public static boolean createDirectoryIfNeeded(File dir) {
        return SecurityActions.doPrivileged(() -> dir.mkdirs() || dir.exists());
    }
}

