/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.NotSerializableException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import org.infinispan.commands.RemoteCommandsFactory;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.io.ByteBuffer;
import org.infinispan.commons.io.ExposedByteArrayOutputStream;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.commons.marshall.BufferSizePredictor;
import org.infinispan.commons.marshall.Externalizer;
import org.infinispan.commons.marshall.MarshallableTypeHints;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.MarshallingException;
import org.infinispan.commons.marshall.SerializeFunctionWith;
import org.infinispan.commons.marshall.SerializeWith;
import org.infinispan.commons.marshall.StreamAwareMarshaller;
import org.infinispan.commons.marshall.StreamingMarshaller;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.marshall.core.BytesObjectInput;
import org.infinispan.marshall.core.BytesObjectOutput;
import org.infinispan.marshall.core.ClassIdentifiers;
import org.infinispan.marshall.core.InternalExternalizers;
import org.infinispan.marshall.core.LambdaMarshaller;
import org.infinispan.marshall.core.Primitives;
import org.infinispan.marshall.core.StreamBytesObjectOutput;
import org.infinispan.marshall.core.impl.ClassToExternalizerMap;
import org.infinispan.marshall.core.impl.ExternalExternalizers;
import org.infinispan.marshall.exts.ThrowableExternalizer;
import org.infinispan.marshall.persistence.PersistenceMarshaller;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Scope(value=Scopes.GLOBAL)
public class GlobalMarshaller
implements StreamingMarshaller {
    private static final Log log = LogFactory.getLog(GlobalMarshaller.class);
    public static final int NOT_FOUND = -1;
    public static final int ID_NULL = 0;
    public static final int ID_PRIMITIVE = 1;
    public static final int ID_INTERNAL = 2;
    public static final int ID_EXTERNAL = 3;
    public static final int ID_ANNOTATED = 4;
    public static final int ID_UNKNOWN = 5;
    static final int ID_ARRAY = 6;
    static final int ID_CLASS = 7;
    static final int ID_LAMBDA = 8;
    static final int TYPE_MASK = 7;
    static final int ARRAY_SIZE_MASK = 192;
    static final int FLAG_SINGLE_TYPE = 8;
    static final int FLAG_COMPONENT_TYPE_MATCH = 16;
    static final int FLAG_ALL_NULL = 32;
    static final int FLAG_ARRAY_EMPTY = 0;
    static final int FLAG_ARRAY_SMALL = 64;
    static final int FLAG_ARRAY_MEDIUM = 128;
    static final int FLAG_ARRAY_LARGE = 192;
    private final MarshallableTypeHints marshallableTypeHints = new MarshallableTypeHints();
    @Inject
    GlobalComponentRegistry gcr;
    @Inject
    RemoteCommandsFactory cmdFactory;
    @Inject
    @ComponentName(value="org.infinispan.marshaller.persistence")
    PersistenceMarshaller persistenceMarshaller;
    ClassToExternalizerMap internalExts;
    ClassToExternalizerMap.IdToExternalizerMap reverseInternalExts;
    ClassToExternalizerMap externalExts;
    ClassToExternalizerMap.IdToExternalizerMap reverseExternalExts;
    private ClassIdentifiers classIdentifiers;
    private ClassLoader classLoader;

    @Start(priority=8)
    public void start() {
        GlobalConfiguration globalCfg = this.gcr.getGlobalConfiguration();
        this.classLoader = globalCfg.classLoader();
        this.internalExts = InternalExternalizers.load(this.gcr, this.cmdFactory);
        this.reverseInternalExts = this.internalExts.reverseMap(255);
        if (log.isTraceEnabled()) {
            log.tracef("Internal class to externalizer ids: %s", this.internalExts);
            log.tracef("Internal reverse externalizers: %s", this.reverseInternalExts);
        }
        this.externalExts = ExternalExternalizers.load(globalCfg);
        this.reverseExternalExts = this.externalExts.reverseMap();
        if (log.isTraceEnabled()) {
            log.tracef("External class to externalizer ids: %s", this.externalExts);
            log.tracef("External reverse externalizers: %s", this.reverseExternalExts);
        }
        this.classIdentifiers = ClassIdentifiers.load(globalCfg);
    }

    @Stop(priority=130)
    public void stop() {
        this.internalExts = null;
        this.reverseInternalExts = null;
        this.externalExts = null;
        this.reverseExternalExts = null;
        this.classIdentifiers = null;
        this.persistenceMarshaller.stop();
    }

    public PersistenceMarshaller getPersistenceMarshaller() {
        return this.persistenceMarshaller;
    }

    public byte[] objectToByteBuffer(Object obj) throws IOException, InterruptedException {
        try {
            BytesObjectOutput out = this.writeObjectOutput(obj);
            return out.toBytes();
        }
        catch (NotSerializableException nse) {
            if (log.isDebugEnabled()) {
                log.debug("Object is not serializable", nse);
            }
            throw new org.infinispan.commons.marshall.NotSerializableException(nse.getMessage(), nse.getCause());
        }
    }

    private BytesObjectOutput writeObjectOutput(Object obj) throws IOException {
        BufferSizePredictor sizePredictor = this.marshallableTypeHints.getBufferSizePredictor(obj);
        BytesObjectOutput out = this.writeObjectOutput(obj, sizePredictor.nextSize(obj));
        sizePredictor.recordSize(out.pos);
        return out;
    }

    private BytesObjectOutput writeObjectOutput(Object obj, int estimatedSize) throws IOException {
        BytesObjectOutput out = new BytesObjectOutput(estimatedSize, this);
        this.writeNullableObject(obj, out);
        return out;
    }

    public Object objectFromByteBuffer(byte[] buf) throws IOException, ClassNotFoundException {
        BytesObjectInput in = BytesObjectInput.from(buf, this);
        return this.objectFromObjectInput(in);
    }

    private Object objectFromObjectInput(BytesObjectInput in) throws IOException, ClassNotFoundException {
        return this.readNullableObject(in);
    }

    public ObjectOutput startObjectOutput(OutputStream os, boolean isReentrant, int estimatedSize) throws IOException {
        BytesObjectOutput out = new BytesObjectOutput(estimatedSize, this);
        return new StreamBytesObjectOutput(os, out);
    }

    public void objectToObjectStream(Object obj, ObjectOutput out) throws IOException {
        out.writeObject(obj);
    }

    public void finishObjectOutput(ObjectOutput oo) {
        try {
            oo.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Object objectFromByteBuffer(byte[] bytes, int offset, int len) throws IOException, ClassNotFoundException {
        BytesObjectInput in = BytesObjectInput.from(bytes, offset, this);
        return this.objectFromObjectInput(in);
    }

    public Object objectFromInputStream(InputStream is) throws IOException, ClassNotFoundException {
        int bytesRead;
        byte[] buf;
        ExposedByteArrayOutputStream bytes;
        int len = is.available();
        if (len > 0) {
            bytes = new ExposedByteArrayOutputStream(len);
            buf = new byte[Math.min(len, 1024)];
        } else {
            bytes = new ExposedByteArrayOutputStream();
            buf = new byte[1024];
        }
        while ((bytesRead = is.read(buf, 0, buf.length)) != -1) {
            bytes.write(buf, 0, bytesRead);
        }
        return this.objectFromByteBuffer(bytes.getRawBuffer(), 0, bytes.size());
    }

    public boolean isMarshallable(Object o) throws Exception {
        Class<?> clazz = o.getClass();
        boolean containsMarshallable = this.marshallableTypeHints.isKnownMarshallable(clazz);
        if (containsMarshallable) {
            boolean marshallable = this.marshallableTypeHints.isMarshallable(clazz);
            if (log.isTraceEnabled()) {
                log.tracef("Marshallable type '%s' known and is marshallable=%b", clazz.getName(), marshallable);
            }
            return marshallable;
        }
        if (this.isMarshallableCandidate(o)) {
            boolean isMarshallable = true;
            try {
                this.objectToBuffer(o);
            }
            catch (Exception e) {
                isMarshallable = false;
                throw e;
            }
            finally {
                this.marshallableTypeHints.markMarshallable(clazz, isMarshallable);
            }
            return isMarshallable;
        }
        return false;
    }

    private boolean isMarshallableCandidate(Object o) {
        return o instanceof Serializable || this.getExternalizer(this.internalExts, o.getClass()) != null || this.getExternalizer(this.externalExts, o.getClass()) != null || o.getClass().getAnnotation(SerializeWith.class) != null || this.isExternalMarshallable(o);
    }

    private boolean isExternalMarshallable(Object o) {
        try {
            return this.persistenceMarshaller.isMarshallable(o);
        }
        catch (Exception e) {
            throw new MarshallingException("Object of type " + o.getClass() + " expected to be marshallable", (Throwable)e);
        }
    }

    public BufferSizePredictor getBufferSizePredictor(Object o) {
        return this.marshallableTypeHints.getBufferSizePredictor(o.getClass());
    }

    public MediaType mediaType() {
        return MediaType.APPLICATION_INFINISPAN_MARSHALLED;
    }

    public ByteBuffer objectToBuffer(Object o) throws IOException, InterruptedException {
        try {
            BytesObjectOutput out = this.writeObjectOutput(o);
            return out.toByteBuffer();
        }
        catch (NotSerializableException nse) {
            if (log.isDebugEnabled()) {
                log.debug("Object is not serializable", nse);
            }
            throw new org.infinispan.commons.marshall.NotSerializableException(nse.getMessage(), nse.getCause());
        }
    }

    public byte[] objectToByteBuffer(Object obj, int estimatedSize) throws IOException, InterruptedException {
        try {
            BytesObjectOutput out = this.writeObjectOutput(obj, estimatedSize);
            return out.toBytes();
        }
        catch (NotSerializableException nse) {
            if (log.isDebugEnabled()) {
                log.debug("Object is not serializable", nse);
            }
            throw new org.infinispan.commons.marshall.NotSerializableException(nse.getMessage(), nse.getCause());
        }
    }

    public ObjectInput startObjectInput(InputStream is, boolean isReentrant) {
        throw new UnsupportedOperationException("No longer in use");
    }

    public void finishObjectInput(ObjectInput oi) {
        throw new UnsupportedOperationException("No longer in use");
    }

    public Object objectFromObjectStream(ObjectInput in) {
        throw new UnsupportedOperationException("No longer in use");
    }

    public <T> Externalizer<T> findExternalizerFor(Object obj) {
        Class<?> clazz = obj.getClass();
        Externalizer<T> ext = this.getExternalizer(this.internalExts, clazz);
        if (ext == null && (ext = this.getExternalizer(this.externalExts, clazz)) == null) {
            ext = this.findAnnotatedExternalizer(clazz);
        }
        return ext;
    }

    void writeNullableObject(Object obj, BytesObjectOutput out) throws IOException {
        if (obj == null) {
            out.writeByte(0);
        } else {
            this.writeNonNullableObject(obj, out);
        }
    }

    Object readNullableObject(BytesObjectInput in) throws IOException, ClassNotFoundException {
        int type = in.readUnsignedByte();
        return type == 0 ? null : this.readNonNullableObject(type, in);
    }

    private void writeNonNullableObject(Object obj, BytesObjectOutput out) throws IOException {
        Class<?> clazz = obj.getClass();
        int id = Primitives.PRIMITIVES.getOrDefault(clazz, -1);
        if (id != -1) {
            this.writePrimitive(obj, out, id);
        } else if (clazz.isArray()) {
            this.writeArray(clazz, obj, out);
        } else {
            AdvancedExternalizer ext = this.getExternalizer(this.internalExts, clazz, obj);
            if (ext != null) {
                GlobalMarshaller.writeInternal(obj, ext, out);
            } else {
                ext = this.getExternalizer(this.externalExts, clazz);
                if (ext != null) {
                    GlobalMarshaller.writeExternal(obj, ext, out);
                } else {
                    Externalizer annotExt = this.findAnnotatedExternalizer(clazz);
                    if (annotExt != null) {
                        this.writeAnnotated(obj, out, annotExt);
                    } else if (clazz.isSynthetic()) {
                        this.writeUnknownLambda(obj, out);
                    } else {
                        this.writeUnknown(obj, out);
                    }
                }
            }
        }
    }

    public static AdvancedExternalizer getInteralExternalizer(GlobalMarshaller gm, Class<?> clazz) {
        return gm.getExternalizer(gm.internalExts, clazz);
    }

    public static AdvancedExternalizer getExternalExternalizer(GlobalMarshaller gm, Class<?> clazz) {
        return gm.getExternalizer(gm.externalExts, clazz);
    }

    public static Object readObjectFromObjectInput(GlobalMarshaller gm, ObjectInput in) throws IOException, ClassNotFoundException {
        int type = in.readUnsignedByte();
        switch (type) {
            case 2: {
                return gm.getExternalizer(gm.reverseInternalExts, in.readUnsignedByte()).readObject(in);
            }
            case 3: {
                return gm.getExternalizer(gm.reverseExternalExts, in.readInt()).readObject(in);
            }
            case 5: {
                return gm.readUnknown(gm.persistenceMarshaller, in);
            }
        }
        return null;
    }

    AdvancedExternalizer getExternalizer(ClassToExternalizerMap class2ExternalizerMap, Class<?> clazz, Object o) {
        AdvancedExternalizer ext = this.getExternalizer(class2ExternalizerMap, clazz);
        if (ext != null) {
            return ext;
        }
        return o instanceof Throwable ? ThrowableExternalizer.INSTANCE : null;
    }

    AdvancedExternalizer getExternalizer(ClassToExternalizerMap class2ExternalizerMap, Class<?> clazz) {
        if (class2ExternalizerMap == null) {
            throw Log.CONTAINER.cacheManagerIsStopping();
        }
        return class2ExternalizerMap.get(clazz);
    }

    AdvancedExternalizer getExternalizer(ClassToExternalizerMap.IdToExternalizerMap id2ExternalizerMap, int i) {
        if (id2ExternalizerMap == null) {
            throw Log.CONTAINER.cacheManagerIsStopping();
        }
        return id2ExternalizerMap.get(i);
    }

    private void writeArray(Class<?> clazz, Object array, BytesObjectOutput out) throws IOException {
        AdvancedExternalizer ext;
        int flags;
        out.writeByte(6);
        Class<?> componentType = clazz.getComponentType();
        int length = Array.getLength(array);
        boolean singleType = true;
        Class<?> elementType = null;
        if (length == 0) {
            flags = 0;
        } else {
            flags = length <= 256 ? 64 : (length <= 65792 ? 128 : 192);
            Object firstElement = Array.get(array, 0);
            if (firstElement != null) {
                elementType = firstElement.getClass();
            }
            for (int i = 1; i < length; ++i) {
                Object element = Array.get(array, i);
                if (element == null) {
                    if (elementType == null) continue;
                    singleType = false;
                    break;
                }
                if (element.getClass() == elementType) continue;
                singleType = false;
                break;
            }
        }
        boolean componentTypeMatch = false;
        if (singleType) {
            flags |= 8;
            if (elementType == null) {
                flags |= 0x20;
            } else if (elementType == componentType) {
                flags |= 0x10;
                componentTypeMatch = true;
            }
        }
        if ((ext = this.getExternalizer(this.internalExts, componentType)) != null) {
            this.writeFlagsWithExternalizer(out, componentType, componentTypeMatch, ext, flags, 2);
        } else {
            ext = this.getExternalizer(this.externalExts, componentType);
            if (ext != null) {
                this.writeFlagsWithExternalizer(out, componentType, componentTypeMatch, ext, flags, 3);
            } else {
                componentTypeMatch = false;
                flags &= 0xFFFFFFEF;
                int classId = this.classIdentifiers.getId(componentType);
                if (classId != -1) {
                    out.writeByte(flags | 7);
                    if (classId < 255) {
                        out.writeByte(classId);
                    } else {
                        out.writeByte(255);
                        out.writeInt(classId);
                    }
                } else {
                    out.writeByte(flags | 5);
                    out.writeObject(componentType);
                }
            }
        }
        if (length != 0) {
            if (length <= 256) {
                out.writeByte(length - 1);
            } else if (length <= 65792) {
                out.writeShort(length - 257);
            } else {
                out.writeInt(length);
            }
        }
        if (singleType) {
            AdvancedExternalizer elementExt;
            if (elementType == null) {
                return;
            }
            if (componentTypeMatch) {
                elementExt = ext;
            } else {
                elementExt = this.getExternalizer(this.internalExts, elementType);
                if (elementExt != null) {
                    out.writeByte(2);
                    out.writeByte(elementExt.getId());
                } else {
                    elementExt = this.getExternalizer(this.externalExts, elementType);
                    if (elementExt != null) {
                        out.writeByte(3);
                        out.writeInt(((AdvancedExternalizer)elementExt).getId());
                    } else {
                        elementExt = this.findAnnotatedExternalizer(elementType);
                        if (elementExt != null) {
                            out.writeByte(4);
                            out.writeObject(elementExt.getClass());
                        } else {
                            int primitiveId = Primitives.PRIMITIVES.getOrDefault(elementType, -1);
                            if (primitiveId != -1) {
                                out.writeByte(1);
                                out.writeByte(primitiveId);
                                for (int i = 0; i < length; ++i) {
                                    Object element = Array.get(array, i);
                                    assert (element != null);
                                    Primitives.writeRawPrimitive(element, out, primitiveId);
                                }
                                return;
                            }
                            out.writeByte(5);
                        }
                    }
                }
            }
            if (elementExt != null) {
                for (int i = 0; i < length; ++i) {
                    Object element = Array.get(array, i);
                    assert (element != null);
                    elementExt.writeObject((ObjectOutput)out, element);
                }
            } else {
                for (int i = 0; i < length; ++i) {
                    Object element = Array.get(array, i);
                    assert (element != null);
                    this.writeRawUnknown(element, out);
                }
            }
        } else {
            for (int i = 0; i < length; ++i) {
                Object element = Array.get(array, i);
                this.writeNullableObject(element, out);
            }
        }
    }

    private void writeFlagsWithExternalizer(BytesObjectOutput out, Class<?> componentType, boolean componentTypeMatch, AdvancedExternalizer ext, int flags, int externalizerType) throws IOException {
        boolean hasSingleClass = ext.getTypeClasses().size() == 1;
        int classId = -1;
        if (componentTypeMatch || hasSingleClass) {
            out.writeByte(flags | externalizerType);
            switch (externalizerType) {
                case 2: {
                    out.writeByte(ext.getId());
                    break;
                }
                case 3: {
                    out.writeInt(ext.getId());
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            if (!hasSingleClass) {
                classId = this.classIdentifiers.getId(componentType);
            }
        } else {
            classId = this.classIdentifiers.getId(componentType);
            if (classId >= 0) {
                out.writeByte(flags | 7);
            } else {
                out.writeByte(flags | 5);
            }
        }
        if (!hasSingleClass) {
            if (classId < 0) {
                out.writeObject(componentType);
            } else if (classId < 255) {
                out.writeByte(classId);
            } else {
                out.writeByte(255);
                out.writeInt(classId);
            }
        }
    }

    private void writeUnknownLambda(Object obj, ObjectOutput out) throws IOException {
        out.writeByte(8);
        LambdaMarshaller.write(out, obj);
    }

    private void writeUnknown(Object obj, BytesObjectOutput out) throws IOException {
        GlobalMarshaller.writeUnknown(this.persistenceMarshaller, obj, out);
    }

    private void writeRawUnknown(Object obj, ObjectOutput out) throws IOException {
        GlobalMarshaller.writeRawUnknown(this.persistenceMarshaller, obj, out);
    }

    public static void writeUnknown(Marshaller marshaller, Object obj, ObjectOutput out) throws IOException {
        out.writeByte(5);
        GlobalMarshaller.writeRawUnknown(marshaller, obj, out);
    }

    private static void writeRawUnknown(Marshaller marshaller, Object obj, ObjectOutput out) throws IOException {
        if (marshaller instanceof StreamingMarshaller) {
            ((StreamingMarshaller)marshaller).objectToObjectStream(obj, out);
        } else if (marshaller instanceof StreamAwareMarshaller && out instanceof StreamBytesObjectOutput) {
            OutputStream outputStream = ((StreamBytesObjectOutput)out).stream;
            ((StreamAwareMarshaller)marshaller).writeObject(obj, outputStream);
        } else {
            try {
                byte[] bytes = marshaller.objectToByteBuffer(obj);
                out.writeInt(bytes.length);
                out.write(bytes);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private void writeAnnotated(Object obj, BytesObjectOutput out, Externalizer ext) throws IOException {
        out.writeByte(4);
        out.writeObject(ext.getClass());
        ext.writeObject((ObjectOutput)out, obj);
    }

    static void writeInternal(Object obj, AdvancedExternalizer ext, ObjectOutput out) throws IOException {
        out.writeByte(2);
        out.writeByte(ext.getId());
        ext.writeObject(out, obj);
    }

    public static void writeInternalClean(Object obj, AdvancedExternalizer ext, ObjectOutput out) {
        try {
            GlobalMarshaller.writeInternal(obj, ext, out);
        }
        catch (IOException e) {
            throw new CacheException((Throwable)e);
        }
    }

    private static void writeExternal(Object obj, AdvancedExternalizer ext, ObjectOutput out) throws IOException {
        out.writeByte(3);
        out.writeInt(ext.getId());
        ext.writeObject(out, obj);
    }

    public static void writeExternalClean(Object obj, AdvancedExternalizer ext, ObjectOutput out) {
        try {
            GlobalMarshaller.writeExternal(obj, ext, out);
        }
        catch (IOException e) {
            throw new CacheException((Throwable)e);
        }
    }

    private void writePrimitive(Object obj, BytesObjectOutput out, int id) throws IOException {
        out.writeByte(1);
        Primitives.writePrimitive(obj, out, id);
    }

    private <T> Externalizer<T> findAnnotatedExternalizer(Class<?> clazz) {
        try {
            SerializeWith serialAnn = clazz.getAnnotation(SerializeWith.class);
            if (serialAnn != null) {
                return (Externalizer)serialAnn.value().newInstance();
            }
            SerializeFunctionWith funcSerialAnn = clazz.getAnnotation(SerializeFunctionWith.class);
            if (funcSerialAnn != null) {
                return (Externalizer)funcSerialAnn.value().newInstance();
            }
            return null;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("Cannot instantiate externalizer for %s", clazz), e);
        }
    }

    private Object readNonNullableObject(int type, BytesObjectInput in) throws IOException, ClassNotFoundException {
        switch (type) {
            case 1: {
                return Primitives.readPrimitive(in);
            }
            case 2: {
                return this.readWithExternalizer(in.readUnsignedByte(), this.reverseInternalExts, in);
            }
            case 3: {
                return this.readWithExternalizer(in.readInt(), this.reverseExternalExts, in);
            }
            case 4: {
                return this.readAnnotated(in);
            }
            case 5: {
                return this.readUnknown(in);
            }
            case 6: {
                return this.readArray(in);
            }
            case 8: {
                return LambdaMarshaller.read(in, this.classLoader);
            }
        }
        throw new IOException("Unknown type: " + type);
    }

    private Object readWithExternalizer(int id, ClassToExternalizerMap.IdToExternalizerMap reverseMap, BytesObjectInput in) throws IOException, ClassNotFoundException {
        AdvancedExternalizer ext = this.getExternalizer(reverseMap, id);
        return ext.readObject((ObjectInput)in);
    }

    private Object readAnnotated(BytesObjectInput in) throws IOException, ClassNotFoundException {
        Class clazz = (Class)in.readObject();
        try {
            Externalizer ext = (Externalizer)clazz.newInstance();
            return ext.readObject((ObjectInput)in);
        }
        catch (Exception e) {
            throw new CacheException("Error instantiating class: " + clazz, (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private Object readArray(BytesObjectInput in) throws IOException, ClassNotFoundException {
        boolean componentTypeMatch;
        int length;
        Class<?> componentType;
        byte flags = in.readByte();
        int type = flags & 7;
        AdvancedExternalizer componentExt = null;
        Class extClazz = null;
        switch (type) {
            case 0: 
            case 1: 
            case 6: {
                throw new IOException("Unexpected component type: " + type);
            }
            case 2: {
                componentExt = this.getExternalizer(this.reverseInternalExts, in.readByte());
                componentType = this.getOrReadClass(in, componentExt);
                break;
            }
            case 3: {
                componentExt = this.getExternalizer(this.reverseExternalExts, in.readInt());
                componentType = this.getOrReadClass(in, componentExt);
                break;
            }
            case 4: {
                extClazz = (Class)in.readObject();
            }
            case 5: {
                componentType = (Class<?>)in.readObject();
                break;
            }
            case 7: {
                byte classId = in.readByte();
                if (classId < 255) {
                    componentType = this.classIdentifiers.getClass(classId);
                    break;
                }
                componentType = this.classIdentifiers.getClass(in.readInt());
                break;
            }
            default: {
                throw new IOException("Unknown component type: " + type);
            }
        }
        int maskedSize = flags & 0xC0;
        switch (maskedSize) {
            case 0: {
                length = 0;
                break;
            }
            case 64: {
                length = in.readUnsignedByte() + 1;
                break;
            }
            case 128: {
                length = in.readUnsignedShort() + 257;
                break;
            }
            case 192: {
                length = in.readInt();
                break;
            }
            default: {
                throw new IOException("Unknown array size: " + maskedSize);
            }
        }
        Object array = Array.newInstance(componentType, length);
        if ((flags & 0x20) != 0) {
            return array;
        }
        boolean singleType = (flags & 8) != 0;
        boolean bl = componentTypeMatch = (flags & 0x10) != 0;
        assert (!componentTypeMatch || singleType);
        if (singleType) {
            Externalizer<?> ext;
            if (componentTypeMatch) {
                ext = this.getArrayElementExternalizer(type, componentExt, extClazz);
            } else {
                type = in.readByte();
                ext = this.readExternalizer(in, type);
            }
            if (ext != null) {
                for (int i = 0; i < length; ++i) {
                    Array.set(array, i, ext.readObject((ObjectInput)in));
                }
                return array;
            } else {
                switch (type) {
                    case 5: {
                        int i = 0;
                        while (true) {
                            if (i >= length) {
                                return array;
                            }
                            Array.set(array, i, this.readUnknown(in));
                            ++i;
                        }
                    }
                    case 1: {
                        byte primitiveId = in.readByte();
                        int i = 0;
                        while (i < length) {
                            Array.set(array, i, Primitives.readRawPrimitive(in, primitiveId));
                            ++i;
                        }
                        return array;
                    }
                }
                throw new IllegalStateException();
            }
        }
        for (int i = 0; i < length; ++i) {
            Array.set(array, i, this.readNullableObject(in));
        }
        return array;
    }

    private Externalizer<?> getArrayElementExternalizer(int type, AdvancedExternalizer<?> componentExt, Class<?> extClazz) throws IOException {
        switch (type) {
            case 2: 
            case 3: {
                return componentExt;
            }
            case 4: {
                try {
                    return (Externalizer)extClazz.newInstance();
                }
                catch (Exception e) {
                    throw new CacheException("Error instantiating class: " + extClazz, (Throwable)e);
                }
            }
            case 5: {
                return null;
            }
        }
        throw new IOException("Unexpected component type: " + type);
    }

    private Externalizer<?> readExternalizer(BytesObjectInput in, int type) throws ClassNotFoundException, IOException {
        switch (type) {
            case 2: {
                return this.getExternalizer(this.reverseInternalExts, 0xFF & in.readByte());
            }
            case 3: {
                return this.getExternalizer(this.reverseExternalExts, in.readInt());
            }
            case 4: {
                Class extClazz = (Class)in.readObject();
                try {
                    return (Externalizer)extClazz.newInstance();
                }
                catch (Exception e) {
                    throw new CacheException("Error instantiating class: " + extClazz, (Throwable)e);
                }
            }
            case 1: 
            case 5: {
                return null;
            }
        }
        throw new IOException("Unexpected component type: " + type);
    }

    private Class<?> getOrReadClass(BytesObjectInput in, AdvancedExternalizer<?> componentExt) throws ClassNotFoundException, IOException {
        if (componentExt.getTypeClasses().size() == 1) {
            return (Class)componentExt.getTypeClasses().iterator().next();
        }
        return (Class)in.readObject();
    }

    private Object readUnknown(ObjectInput in) throws IOException, ClassNotFoundException {
        return this.readUnknown(this.persistenceMarshaller, in);
    }

    Object readUnknown(Marshaller marshaller, ObjectInput in) throws IOException, ClassNotFoundException {
        if (marshaller instanceof StreamingMarshaller) {
            try {
                return ((StreamingMarshaller)marshaller).objectFromObjectStream(in);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return null;
            }
        }
        int length = in.readInt();
        byte[] bytes = new byte[length];
        in.readFully(bytes);
        return marshaller.objectFromByteBuffer(bytes);
    }
}

