/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.impl;

import java.util.concurrent.CompletionStage;
import org.infinispan.commons.time.TimeService;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.Configurations;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.MVCCEntry;
import org.infinispan.container.entries.NullCacheEntry;
import org.infinispan.container.entries.ReadCommittedEntry;
import org.infinispan.container.entries.RepeatableReadEntry;
import org.infinispan.container.entries.VersionedRepeatableReadEntry;
import org.infinispan.container.impl.EntryFactory;
import org.infinispan.container.impl.InternalDataContainer;
import org.infinispan.container.versioning.VersionGenerator;
import org.infinispan.context.InvocationContext;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.expiration.impl.InternalExpirationManager;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.metadata.Metadata;
import org.infinispan.metadata.impl.PrivateMetadata;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.util.concurrent.CompletionStages;
import org.infinispan.util.concurrent.IsolationLevel;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Scope(value=Scopes.NAMED_CACHE)
public class EntryFactoryImpl
implements EntryFactory {
    private static final Log log = LogFactory.getLog(EntryFactoryImpl.class);
    @Inject
    InternalDataContainer container;
    @Inject
    Configuration configuration;
    @Inject
    TimeService timeService;
    @Inject
    VersionGenerator versionGenerator;
    @Inject
    DistributionManager distributionManager;
    @Inject
    InternalExpirationManager expirationManager;
    private boolean isL1Enabled;
    private boolean useRepeatableRead;
    private boolean useVersioning;
    private PrivateMetadata nonExistingPrivateMetadata;

    @Start(priority=8)
    public void init() {
        this.useRepeatableRead = this.configuration.transaction().transactionMode().isTransactional() && this.configuration.locking().isolationLevel() == IsolationLevel.REPEATABLE_READ || this.configuration.clustering().cacheMode().isScattered();
        this.isL1Enabled = this.configuration.clustering().l1().enabled();
        this.useVersioning = Configurations.isTxVersioned(this.configuration);
        this.nonExistingPrivateMetadata = new PrivateMetadata.Builder().entryVersion(this.versionGenerator.nonExistingVersion()).build();
    }

    @Override
    public final CompletionStage<Void> wrapEntryForReading(InvocationContext ctx, Object key, int segment, boolean isOwner, boolean hasLock) {
        if (!isOwner && !this.isL1Enabled) {
            return CompletableFutures.completedNull();
        }
        CompletionStage<Void> returnedStage = CompletableFutures.completedNull();
        CacheEntry<?, ?> cacheEntry = this.getFromContext(ctx, key);
        if (cacheEntry == null) {
            InternalCacheEntry readEntry = this.getFromContainer(key, segment);
            if (readEntry == null) {
                if (isOwner) {
                    this.addReadEntryToContext(ctx, NullCacheEntry.getInstance(), key);
                }
            } else if (isOwner || readEntry.isL1Entry()) {
                if (readEntry.canExpire()) {
                    CompletionStage<Boolean> expiredStage = this.expirationManager.handlePossibleExpiration(readEntry, segment, hasLock);
                    if (CompletionStages.isCompletedSuccessfully(expiredStage)) {
                        Boolean expired2 = CompletionStages.join(expiredStage);
                        this.handleExpiredEntryContextAddition(expired2, ctx, readEntry, key, isOwner);
                    } else {
                        returnedStage = expiredStage.thenApply(expired -> {
                            this.handleExpiredEntryContextAddition((Boolean)expired, ctx, readEntry, key, isOwner);
                            return null;
                        });
                    }
                } else {
                    this.addReadEntryToContext(ctx, readEntry, key);
                }
            }
        }
        return returnedStage;
    }

    private void handleExpiredEntryContextAddition(Boolean expired, InvocationContext ctx, InternalCacheEntry readEntry, Object key, boolean isOwner) {
        if (expired == Boolean.FALSE) {
            this.addReadEntryToContext(ctx, readEntry, key);
        } else if (isOwner) {
            this.addReadEntryToContext(ctx, NullCacheEntry.getInstance(), key);
        }
    }

    private void addReadEntryToContext(InvocationContext ctx, CacheEntry cacheEntry, Object key) {
        if (this.useRepeatableRead) {
            MVCCEntry<?, ?> mvccEntry = this.createWrappedEntry(key, cacheEntry);
            mvccEntry.setRead();
            cacheEntry = mvccEntry;
        }
        if (log.isTraceEnabled()) {
            log.tracef("Wrap %s for read. Entry=%s", Util.toStr((Object)key), cacheEntry);
        }
        ctx.putLookedUpEntry(key, cacheEntry);
    }

    private void addWriteEntryToContext(InvocationContext ctx, CacheEntry cacheEntry, Object key, boolean isRead) {
        MVCCEntry<?, ?> mvccEntry = this.createWrappedEntry(key, cacheEntry);
        if (cacheEntry.isNull()) {
            mvccEntry.setCreated(true);
        }
        if (isRead) {
            mvccEntry.setRead();
        }
        ctx.putLookedUpEntry(key, mvccEntry);
        if (log.isTraceEnabled()) {
            log.tracef("Added context entry %s", mvccEntry);
        }
    }

    @Override
    public CompletionStage<Void> wrapEntryForWriting(InvocationContext ctx, Object key, int segment, boolean isOwner, boolean isRead) {
        CacheEntry<?, ?> contextEntry = this.getFromContext(ctx, key);
        CompletionStage<Void> returnedStage = CompletableFutures.completedNull();
        if (!(contextEntry instanceof MVCCEntry)) {
            if (contextEntry != null) {
                MVCCEntry<?, ?> mvccEntry = this.createWrappedEntry(key, contextEntry);
                ctx.putLookedUpEntry(key, mvccEntry);
                if (log.isTraceEnabled()) {
                    log.tracef("Updated context entry %s -> %s", contextEntry, mvccEntry);
                }
            } else {
                InternalCacheEntry ice = this.getFromContainer(key, segment);
                if (isOwner) {
                    if (ice == null) {
                        this.addWriteEntryToContext(ctx, NullCacheEntry.getInstance(), key, isRead);
                    } else if (ice.canExpire()) {
                        CompletionStage<Boolean> expiredStage = this.expirationManager.handlePossibleExpiration(ice, segment, true);
                        if (CompletionStages.isCompletedSuccessfully(expiredStage)) {
                            Boolean expired2 = CompletionStages.join(expiredStage);
                            this.handleWriteExpiredEntryContextAddition(expired2, ctx, ice, key, isRead);
                        } else {
                            returnedStage = expiredStage.thenApply(expired -> {
                                this.handleWriteExpiredEntryContextAddition((Boolean)expired, ctx, ice, key, isRead);
                                return null;
                            });
                        }
                    } else {
                        this.addWriteEntryToContext(ctx, ice, key, isRead);
                    }
                } else if (this.isL1Enabled && ice != null && !ice.isL1Entry()) {
                    this.addWriteEntryToContext(ctx, ice, key, isRead);
                }
            }
        }
        return returnedStage;
    }

    private void handleWriteExpiredEntryContextAddition(Boolean expired, InvocationContext ctx, InternalCacheEntry ice, Object key, boolean isRead) {
        if (expired == Boolean.FALSE) {
            this.addWriteEntryToContext(ctx, ice, key, isRead);
        } else {
            if (log.isTraceEnabled()) {
                log.tracef("Entry retrieved for key %s was expired, returning null entry", key);
            }
            this.addWriteEntryToContext(ctx, NullCacheEntry.getInstance(), key, isRead);
        }
    }

    @Override
    public void wrapEntryForWritingSkipExpiration(InvocationContext ctx, Object key, int segment, boolean isOwner) {
        CacheEntry<?, ?> contextEntry = this.getFromContext(ctx, key);
        if (!(contextEntry instanceof MVCCEntry)) {
            if (contextEntry != null) {
                MVCCEntry<?, ?> mvccEntry = this.createWrappedEntry(key, contextEntry);
                ctx.putLookedUpEntry(key, mvccEntry);
                if (log.isTraceEnabled()) {
                    log.tracef("Updated context entry %s -> %s", contextEntry, mvccEntry);
                }
            } else if (isOwner) {
                CacheEntry cacheEntry = this.getFromContainer(key, segment);
                if (cacheEntry == null) {
                    cacheEntry = NullCacheEntry.getInstance();
                }
                MVCCEntry<?, ?> mvccEntry = this.createWrappedEntry(key, cacheEntry);
                mvccEntry.setCreated(cacheEntry.getCreated());
                if (cacheEntry.isNull()) {
                    mvccEntry.setCreated(true);
                }
                mvccEntry.setRead();
                ctx.putLookedUpEntry(key, mvccEntry);
                if (log.isTraceEnabled()) {
                    log.tracef("Updated context entry null -> %s", mvccEntry);
                }
            }
        }
    }

    @Override
    public void wrapExternalEntry(InvocationContext ctx, Object key, CacheEntry externalEntry, boolean isRead, boolean isWrite) {
        CacheEntry<?, ?> contextEntry = this.getFromContext(ctx, key);
        if (contextEntry instanceof MVCCEntry) {
            MVCCEntry mvccEntry = (MVCCEntry)contextEntry;
            if (mvccEntry.skipLookup()) {
                if (log.isTraceEnabled()) {
                    log.tracef("Ignored update for context entry %s", contextEntry);
                }
                return;
            }
            mvccEntry.setValue(externalEntry.getValue());
            mvccEntry.setCreated(externalEntry.getCreated());
            mvccEntry.setLastUsed(externalEntry.getLastUsed());
            mvccEntry.setMetadata(externalEntry.getMetadata());
            mvccEntry.setInternalMetadata(externalEntry.getInternalMetadata());
            mvccEntry.updatePreviousValue();
            if (log.isTraceEnabled()) {
                log.tracef("Updated context entry %s", contextEntry);
            }
        } else if (contextEntry == null || contextEntry.isNull()) {
            if (isWrite || this.useRepeatableRead) {
                MVCCEntry<?, ?> mvccEntry = this.createWrappedEntry(key, externalEntry);
                if (isRead) {
                    mvccEntry.setRead();
                }
                ctx.putLookedUpEntry(key, mvccEntry);
                if (log.isTraceEnabled()) {
                    log.tracef("Updated context entry %s -> %s", contextEntry, mvccEntry);
                }
            } else {
                ctx.putLookedUpEntry(key, externalEntry);
                if (log.isTraceEnabled()) {
                    log.tracef("Updated context entry %s -> %s", contextEntry, externalEntry);
                }
            }
        } else if (this.useRepeatableRead) {
            if (log.isTraceEnabled()) {
                log.tracef("Ignored update %s -> %s as we do repeatable reads", contextEntry, externalEntry);
            }
        } else {
            ctx.putLookedUpEntry(key, externalEntry);
            if (log.isTraceEnabled()) {
                log.tracef("Updated context entry %s -> %s", contextEntry, externalEntry);
            }
        }
    }

    private CacheEntry<?, ?> getFromContext(InvocationContext ctx, Object key) {
        CacheEntry cacheEntry = ctx.lookupEntry(key);
        if (log.isTraceEnabled()) {
            log.tracef("Exists in context? %s ", cacheEntry);
        }
        return cacheEntry;
    }

    private boolean isPrimaryOwner(int segment) {
        return this.distributionManager == null || this.distributionManager.getCacheTopology().getSegmentDistribution(segment).isPrimary();
    }

    private InternalCacheEntry getFromContainer(Object key, int segment) {
        InternalCacheEntry ice = this.container.peek(segment, key);
        if (log.isTraceEnabled()) {
            log.tracef("Retrieved from container %s", ice);
        }
        return ice;
    }

    protected MVCCEntry<?, ?> createWrappedEntry(Object key, CacheEntry<?, ?> cacheEntry) {
        ReadCommittedEntry<Object, Object> mvccEntry;
        Object value = null;
        Metadata metadata = null;
        PrivateMetadata internalMetadata = null;
        if (cacheEntry != null) {
            value = cacheEntry.getValue();
            metadata = cacheEntry.getMetadata();
            internalMetadata = cacheEntry.getInternalMetadata();
        }
        if (log.isTraceEnabled()) {
            log.tracef("Creating new entry for key %s", Util.toStr((Object)key));
        }
        if (this.useRepeatableRead) {
            if (this.useVersioning) {
                if (internalMetadata == null) {
                    internalMetadata = this.nonExistingPrivateMetadata;
                }
                mvccEntry = new VersionedRepeatableReadEntry<Object, Object>(key, value, metadata);
            } else {
                mvccEntry = new RepeatableReadEntry<Object, Object>(key, value, metadata);
            }
        } else {
            mvccEntry = new ReadCommittedEntry<Object, Object>(key, value, metadata);
        }
        mvccEntry.setInternalMetadata(internalMetadata);
        if (cacheEntry != null) {
            mvccEntry.setCreated(cacheEntry.getCreated());
            mvccEntry.setLastUsed(cacheEntry.getLastUsed());
        }
        return mvccEntry;
    }
}

