/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.irac;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.concurrent.CompletionStage;
import org.infinispan.commands.irac.IracUpdateKeyCommand;
import org.infinispan.metadata.Metadata;
import org.infinispan.metadata.impl.IracMetadata;
import org.infinispan.util.ByteString;
import org.infinispan.xsite.BackupReceiver;

public class IracPutKeyCommand
extends IracUpdateKeyCommand {
    public static final byte COMMAND_ID = 123;
    private Object key;
    private Object value;
    private Metadata metadata;
    private IracMetadata iracMetadata;

    public IracPutKeyCommand() {
        super((byte)123, null);
    }

    public IracPutKeyCommand(ByteString cacheName) {
        super((byte)123, cacheName);
    }

    public IracPutKeyCommand(ByteString cacheName, Object key, Object value, Metadata metadata, IracMetadata iracMetadata) {
        super((byte)123, cacheName);
        this.key = key;
        this.value = value;
        this.metadata = metadata;
        this.iracMetadata = iracMetadata;
    }

    @Override
    public CompletionStage<Void> executeOperation(BackupReceiver receiver) {
        return receiver.putKeyValue(this.key, this.value, this.metadata, this.iracMetadata);
    }

    @Override
    public byte getCommandId() {
        return 123;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        output.writeObject(this.key);
        output.writeObject(this.value);
        output.writeObject(this.metadata);
        this.iracMetadata.writeTo(output);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.key = input.readObject();
        this.value = input.readObject();
        this.metadata = (Metadata)input.readObject();
        this.iracMetadata = IracMetadata.readFrom(input);
    }

    @Override
    public String toString() {
        return "IracPutKeyCommand{key=" + this.key + ", value=" + this.value + ", metadata=" + this.metadata + ", iracMetadata=" + this.iracMetadata + ", originSite='" + this.originSite + '\'' + ", cacheName=" + this.cacheName + '}';
    }
}

