/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.dgiwg;

import com.j256.ormlite.stmt.PreparedQuery;
import com.j256.ormlite.stmt.QueryBuilder;
import java.sql.SQLException;
import java.util.List;
import mil.nga.geopackage.GeoPackageCore;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.extension.metadata.Metadata;
import mil.nga.geopackage.extension.metadata.MetadataDao;
import mil.nga.geopackage.extension.metadata.MetadataExtension;
import mil.nga.geopackage.extension.metadata.MetadataScopeType;
import mil.nga.geopackage.extension.metadata.reference.MetadataReference;
import mil.nga.geopackage.extension.metadata.reference.MetadataReferenceDao;
import mil.nga.geopackage.extension.metadata.reference.ReferenceScopeType;

public class DGIWGMetadata {
    public static Metadata createSeriesMetadata(String uri, String metadata) {
        return DGIWGMetadata.createMetadata(MetadataScopeType.SERIES, uri, metadata);
    }

    public static Metadata createDatasetMetadata(String uri, String metadata) {
        return DGIWGMetadata.createMetadata(MetadataScopeType.DATASET, uri, metadata);
    }

    public static Metadata createMetadata(MetadataScopeType scope, String uri, String metadata) {
        Metadata md = new Metadata();
        md.setMetadataScope(scope);
        md.setStandardUri(uri);
        md.setMimeType("text/xml");
        md.setMetadata(metadata);
        return md;
    }

    public static MetadataReference createGeoPackageMetadataReference() {
        return DGIWGMetadata.createMetadataReference(ReferenceScopeType.GEOPACKAGE);
    }

    public static MetadataReference createMetadataReference(ReferenceScopeType scope) {
        MetadataReference reference = new MetadataReference();
        reference.setReferenceScope(scope);
        return reference;
    }

    public static List<MetadataReference> queryGeoPackageDMFMetadata(GeoPackageCore geoPackage) {
        return DGIWGMetadata.queryGeoPackageMetadata(geoPackage, "https://dgiwg.org/std/dmf/");
    }

    public static List<MetadataReference> queryGeoPackageNASMetadata(GeoPackageCore geoPackage) {
        return DGIWGMetadata.queryGeoPackageMetadata(geoPackage, "https://nsgreg-api.nga.mil/schema/nas/");
    }

    public static List<MetadataReference> queryGeoPackageMetadata(GeoPackageCore geoPackage, String baseURI) {
        List results = null;
        MetadataExtension metadataExtension = new MetadataExtension(geoPackage);
        if (metadataExtension.has()) {
            MetadataDao metadataDao = metadataExtension.getMetadataDao();
            MetadataReferenceDao referenceDao = metadataExtension.getMetadataReferenceDao();
            try {
                if (metadataDao.isTableExists() && referenceDao.isTableExists()) {
                    QueryBuilder metadataBuilder = metadataDao.queryBuilder();
                    QueryBuilder referenceBuilder = referenceDao.queryBuilder();
                    metadataBuilder.where().like("md_standard_uri", (Object)(baseURI + "%"));
                    referenceBuilder.where().like("reference_scope", (Object)ReferenceScopeType.GEOPACKAGE.getValue());
                    referenceBuilder.leftJoin(metadataBuilder);
                    PreparedQuery preparedQuery = referenceBuilder.prepare();
                    results = referenceDao.query(preparedQuery);
                }
            }
            catch (SQLException e) {
                throw new GeoPackageException("Failed to query for metadata", e);
            }
        }
        return results;
    }
}

