/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.db;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mil.nga.geopackage.GeoPackageException;

public class Pagination {
    private static final String LIMIT = "LIMIT";
    private static final String OFFSET = "OFFSET";
    private static final String EXPRESSION1 = "expr1";
    private static final String SEPARATOR = "separator";
    private static final String EXPRESSION2 = "expr2";
    private static final Pattern limitPattern = Pattern.compile("\\sLIMIT\\s+(?<expr1>-?+\\d+)(\\s*(?<separator>(OFFSET|,))\\s*(?<expr2>-?\\d+))?", 2);
    private int limit;
    private Long offset;

    public static Pagination find(String sql) {
        Pagination pagination = null;
        Matcher matcher = limitPattern.matcher(sql);
        if (matcher.find()) {
            int limit;
            Long offset = null;
            String expr1 = matcher.group(EXPRESSION1);
            String separator = matcher.group(SEPARATOR);
            if (separator != null) {
                String expr2 = matcher.group(EXPRESSION2);
                if (separator.equalsIgnoreCase(OFFSET)) {
                    limit = Integer.valueOf(expr1);
                    offset = Long.valueOf(expr2);
                } else {
                    limit = Integer.valueOf(expr2);
                    offset = Long.valueOf(expr1);
                }
            } else {
                limit = Integer.valueOf(expr1);
            }
            pagination = new Pagination(limit, offset);
        }
        return pagination;
    }

    public static String replace(Pagination pagination, String sql) {
        String replaced = null;
        Matcher matcher = limitPattern.matcher(sql);
        if (!matcher.find()) {
            throw new GeoPackageException("SQL statement is not a paginated query: " + sql);
        }
        replaced = matcher.replaceFirst(" " + pagination.toString());
        return replaced;
    }

    public Pagination(int limit) {
        this(limit, null);
    }

    public Pagination(int limit, long offset) {
        this(limit, (Long)offset);
    }

    public Pagination(int limit, Long offset) {
        this.setLimit(limit);
        this.setOffset(offset);
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public boolean hasLimit() {
        return this.limit > 0;
    }

    public Long getOffset() {
        return this.offset;
    }

    public boolean hasOffset() {
        return this.offset != null;
    }

    public void setOffset(Long offset) {
        if (offset != null && offset < 0L) {
            offset = 0L;
        }
        this.offset = offset;
    }

    public void incrementOffset() {
        if (this.limit > 0) {
            this.incrementOffset(this.limit);
        }
    }

    public void incrementOffset(long count) {
        if (this.offset == null) {
            this.offset = 0L;
        }
        this.offset = this.offset + count;
    }

    public String replace(String sql) {
        return Pagination.replace(this, sql);
    }

    public String toString() {
        StringBuilder sql = new StringBuilder();
        sql.append(LIMIT);
        sql.append(" ");
        sql.append(this.limit);
        if (this.hasOffset()) {
            sql.append(" ");
            sql.append(OFFSET);
            sql.append(" ");
            sql.append(this.offset);
        }
        return sql.toString();
    }
}

