/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.extension.nga.style;

import java.util.regex.Pattern;
import mil.nga.color.Color;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.attributes.AttributesColumn;
import mil.nga.geopackage.attributes.AttributesRow;
import mil.nga.geopackage.attributes.AttributesTable;
import mil.nga.geopackage.extension.nga.style.StyleTable;

public class StyleRow
extends AttributesRow {
    private static final Pattern colorPattern = Pattern.compile("^#([0-9a-fA-F]{3}){1,2}$");
    private boolean tableStyle;

    public StyleRow() {
        this(new StyleTable());
    }

    public StyleRow(StyleTable table) {
        super((AttributesTable)table);
    }

    public StyleRow(AttributesRow attributesRow) {
        super(attributesRow);
    }

    public StyleRow(StyleRow styleRow) {
        super(styleRow);
    }

    public StyleTable getTable() {
        return (StyleTable)super.getTable();
    }

    public boolean isTableStyle() {
        return this.tableStyle;
    }

    public void setTableStyle(boolean tableStyle) {
        this.tableStyle = tableStyle;
    }

    public int getNameColumnIndex() {
        return this.getColumns().getColumnIndex("name");
    }

    public AttributesColumn getNameColumn() {
        return (AttributesColumn)this.getColumns().getColumn("name");
    }

    public String getName() {
        return this.getValueString(this.getNameColumnIndex());
    }

    public void setName(String name) {
        this.setValue(this.getNameColumnIndex(), name);
    }

    public int getDescriptionColumnIndex() {
        return this.getColumns().getColumnIndex("description");
    }

    public AttributesColumn getDescriptionColumn() {
        return (AttributesColumn)this.getColumns().getColumn("description");
    }

    public String getDescription() {
        return this.getValueString(this.getDescriptionColumnIndex());
    }

    public void setDescription(String description) {
        this.setValue(this.getDescriptionColumnIndex(), description);
    }

    public int getColorColumnIndex() {
        return this.getColumns().getColumnIndex("color");
    }

    public AttributesColumn getColorColumn() {
        return (AttributesColumn)this.getColumns().getColumn("color");
    }

    public Color getColor() {
        return this.createColor(this.getHexColor(), this.getOpacity());
    }

    public boolean hasColor() {
        return this.hasColor(this.getHexColor(), this.getOpacity());
    }

    public String getHexColor() {
        return this.getValueString(this.getColorColumnIndex());
    }

    public void setColor(Color color) {
        String hex = null;
        Double opacity = null;
        if (color != null) {
            hex = color.getColorHexShorthand();
            opacity = color.getOpacity();
        }
        this.setColor(hex);
        this.setOpacity(opacity);
    }

    public void setColor(String color) {
        color = this.validateColor(color);
        this.setValue(this.getColorColumnIndex(), color);
    }

    public Color getColorOrDefault() {
        Color color = this.getColor();
        if (color == null) {
            color = new Color();
        }
        return color;
    }

    public String getHexColorOrDefault() {
        String color = this.getHexColor();
        if (color == null) {
            color = "#000000";
        }
        return color;
    }

    public int getOpacityColumnIndex() {
        return this.getColumns().getColumnIndex("opacity");
    }

    public AttributesColumn getOpacityColumn() {
        return (AttributesColumn)this.getColumns().getColumn("opacity");
    }

    public Double getOpacity() {
        return (Double)this.getValue(this.getOpacityColumnIndex());
    }

    public void setOpacity(Double opacity) {
        this.validateOpacity(opacity);
        this.setValue(this.getOpacityColumnIndex(), opacity);
    }

    public double getOpacityOrDefault() {
        Double opacity = this.getOpacity();
        if (opacity == null) {
            opacity = 1.0;
        }
        return opacity;
    }

    public int getWidthColumnIndex() {
        return this.getColumns().getColumnIndex("width");
    }

    public AttributesColumn getWidthColumn() {
        return (AttributesColumn)this.getColumns().getColumn("width");
    }

    public Double getWidth() {
        return (Double)this.getValue(this.getWidthColumnIndex());
    }

    public void setWidth(Double width) {
        if (width != null && width < 0.0) {
            throw new GeoPackageException("Width must be greater than or equal to 0.0, invalid value: " + width);
        }
        this.setValue(this.getWidthColumnIndex(), width);
    }

    public double getWidthOrDefault() {
        Double width = this.getWidth();
        if (width == null) {
            width = 1.0;
        }
        return width;
    }

    public int getFillColorColumnIndex() {
        return this.getColumns().getColumnIndex("fill_color");
    }

    public AttributesColumn getFillColorColumn() {
        return (AttributesColumn)this.getColumns().getColumn("fill_color");
    }

    public Color getFillColor() {
        return this.createColor(this.getFillHexColor(), this.getFillOpacity());
    }

    public boolean hasFillColor() {
        return this.hasColor(this.getFillHexColor(), this.getFillOpacity());
    }

    public String getFillHexColor() {
        return this.getValueString(this.getFillColorColumnIndex());
    }

    public void setFillColor(Color color) {
        String hex = null;
        Double opacity = null;
        if (color != null) {
            hex = color.getColorHexShorthand();
            opacity = color.getOpacity();
        }
        this.setFillColor(hex);
        this.setFillOpacity(opacity);
    }

    public void setFillColor(String fillColor) {
        fillColor = this.validateColor(fillColor);
        this.setValue(this.getFillColorColumnIndex(), fillColor);
    }

    public int getFillOpacityColumnIndex() {
        return this.getColumns().getColumnIndex("fill_opacity");
    }

    public AttributesColumn getFillOpacityColumn() {
        return (AttributesColumn)this.getColumns().getColumn("fill_opacity");
    }

    public Double getFillOpacity() {
        return (Double)this.getValue(this.getFillOpacityColumnIndex());
    }

    public void setFillOpacity(Double fillOpacity) {
        this.validateOpacity(fillOpacity);
        this.setValue(this.getFillOpacityColumnIndex(), fillOpacity);
    }

    public double getFillOpacityOrDefault() {
        Double fillOpacity = this.getFillOpacity();
        if (fillOpacity == null) {
            fillOpacity = 1.0;
        }
        return fillOpacity;
    }

    private String validateColor(String color) {
        Object validated = color;
        if (color != null) {
            if (!color.startsWith("#")) {
                validated = "#" + color;
            }
            if (!colorPattern.matcher((CharSequence)validated).matches()) {
                throw new GeoPackageException("Color must be in hex format #RRGGBB or #RGB, invalid value: " + color);
            }
            validated = ((String)validated).toUpperCase();
        }
        return validated;
    }

    private void validateOpacity(Double opacity) {
        if (opacity != null && (opacity < 0.0 || opacity > 1.0)) {
            throw new GeoPackageException("Opacity must be set inclusively between 0.0 and 1.0, invalid value: " + opacity);
        }
    }

    private Color createColor(String hexColor, Double opacity) {
        Color color = null;
        if (hexColor != null || opacity != null) {
            color = new Color();
            if (hexColor != null) {
                color.setColor(hexColor);
            }
            if (opacity != null) {
                color.setOpacity(opacity.floatValue());
            }
        }
        return color;
    }

    private boolean hasColor(String hexColor, Double opacity) {
        return hexColor != null || opacity != null;
    }

    @Override
    public StyleRow copy() {
        return new StyleRow(this);
    }
}

